/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.configurations;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.configurations.NewConfigurationPanel;
import org.netbeans.modules.maven.customizer.ActionMappings;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ConfigurationsPanel
extends JPanel {
    private NbMavenProjectImpl project;
    private ModelHandle2 handle;
    List<ModelHandle2.Configuration> lastNonProfileList = new ArrayList<ModelHandle2.Configuration>();
    private JButton btnActivate;
    private JButton btnAdd;
    private JButton btnEdit;
    private JButton btnRemove;
    private JScrollPane jScrollPane1;
    private JLabel lblConfigurations;
    private JList lstConfigurations;

    private ConfigurationsPanel() {
        this.initComponents();
    }

    ConfigurationsPanel(ModelHandle2 handle, NbMavenProjectImpl project) {
        this();
        this.handle = handle;
        this.project = project;
        this.initListUI();
        this.checkButtonEnablement();
        this.lstConfigurations.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component supers = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                ModelHandle2.Configuration conf = (ModelHandle2.Configuration)value;
                if (conf == ConfigurationsPanel.this.handle.getActiveConfiguration()) {
                    supers.setFont(supers.getFont().deriveFont(1));
                }
                return supers;
            }
        });
        this.lstConfigurations.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ConfigurationsPanel.this.checkButtonEnablement();
            }
        });
        this.createListModel();
    }

    private void checkButtonEnablement() {
        ModelHandle2.Configuration conf = (ModelHandle2.Configuration)this.lstConfigurations.getSelectedValue();
        if (conf == null || conf.isProfileBased() || conf.isDefault()) {
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
        } else {
            this.btnEdit.setEnabled(true);
            this.btnRemove.setEnabled(true);
        }
    }

    private void createListModel() {
        DefaultListModel<ModelHandle2.Configuration> model = new DefaultListModel<ModelHandle2.Configuration>();
        if (this.handle.getConfigurations() != null) {
            for (ModelHandle2.Configuration hndl : this.handle.getConfigurations()) {
                model.addElement(hndl);
            }
        }
        this.lstConfigurations.setModel(model);
        this.lstConfigurations.setSelectedValue(this.handle.getActiveConfiguration(), true);
    }

    private void initComponents() {
        this.lblConfigurations = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstConfigurations = new JList();
        this.btnAdd = new JButton();
        this.btnEdit = new JButton();
        this.btnRemove = new JButton();
        this.btnActivate = new JButton();
        this.lblConfigurations.setLabelFor(this.lstConfigurations);
        Mnemonics.setLocalizedText((JLabel)this.lblConfigurations, (String)NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.lblConfigurations.text"));
        this.lstConfigurations.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.lstConfigurations.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.lstConfigurations);
        this.lstConfigurations.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.lstConfigurations.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAdd, (String)NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.btnAdd.text"));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationsPanel.this.btnAddActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnEdit, (String)NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.btnEdit.text"));
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationsPanel.this.btnEditActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.btnRemove.text"));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationsPanel.this.btnRemoveActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnActivate, (String)NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.btnActivate.text"));
        this.btnActivate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationsPanel.this.btnActivateActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblConfigurations).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnAdd).addComponent(this.btnActivate).addComponent(this.btnEdit)).addComponent(this.btnRemove)).addContainerGap()));
        layout.linkSize(0, this.btnActivate, this.btnAdd, this.btnEdit, this.btnRemove);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblConfigurations).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.btnActivate).addGap(18, 18, 18).addComponent(this.btnAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnEdit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRemove).addContainerGap(81, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 211, Short.MAX_VALUE))));
        this.btnAdd.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.btnAdd.AccessibleContext.accessibleDescription"));
        this.btnEdit.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.btnEdit.AccessibleContext.accessibleDescription"));
        this.btnRemove.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.btnRemove.AccessibleContext.accessibleDescription"));
        this.btnActivate.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.btnActivate.AccessibleContext.accessibleDescription"));
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        NewConfigurationPanel pnl = new NewConfigurationPanel();
        pnl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigurationsPanel.class, (String)"ACSD_Add_Config"));
        DialogDescriptor dd = new DialogDescriptor((Object)pnl, NbBundle.getMessage(ConfigurationsPanel.class, (String)"TIT_Add_Config"));
        pnl.attachDescriptor(dd);
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (ret == DialogDescriptor.OK_OPTION) {
            ModelHandle2.Configuration conf = ModelHandle2.createCustomConfiguration(pnl.getConfigurationId());
            conf.setShared(pnl.isShared());
            conf.setActivatedProfiles(pnl.getProfiles());
            conf.setProperties(ActionMappings.convertStringToActionProperties(pnl.getProperties()));
            this.handle.addConfiguration(conf);
            this.handle.markConfigurationsAsModified();
            this.createListModel();
            this.lstConfigurations.setSelectedValue(conf, true);
        }
    }

    private void btnEditActionPerformed(ActionEvent evt) {
        ModelHandle2.Configuration conf = (ModelHandle2.Configuration)this.lstConfigurations.getSelectedValue();
        if (conf != null) {
            NewConfigurationPanel pnl = new NewConfigurationPanel();
            pnl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigurationsPanel.class, (String)"ACSD_Edit_Config"));
            pnl.setConfigurationId(conf.getId());
            pnl.setProfiles(conf.getActivatedProfiles());
            pnl.setProperties(ActionMappings.createPropertiesList(conf.getProperties()));
            pnl.setShared(conf.isShared());
            DialogDescriptor dd = new DialogDescriptor((Object)pnl, NbBundle.getMessage(ConfigurationsPanel.class, (String)"TIT_Edit_Config"));
            Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (ret == DialogDescriptor.OK_OPTION) {
                conf.setShared(pnl.isShared());
                conf.setActivatedProfiles(pnl.getProfiles());
                conf.setProperties(ActionMappings.convertStringToActionProperties(pnl.getProperties()));
                this.handle.markConfigurationsAsModified();
                this.createListModel();
                this.lstConfigurations.setSelectedValue(conf, true);
            }
        }
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        ModelHandle2.Configuration conf = (ModelHandle2.Configuration)this.lstConfigurations.getSelectedValue();
        if (conf != null) {
            this.handle.removeConfiguration(conf);
            this.createListModel();
        }
    }

    private void btnActivateActionPerformed(ActionEvent evt) {
        ModelHandle2.Configuration conf = (ModelHandle2.Configuration)this.lstConfigurations.getSelectedValue();
        if (conf != null) {
            this.handle.setActiveConfiguration(conf);
        }
        this.lstConfigurations.repaint();
    }

    private void initListUI() {
        this.lstConfigurations.setEnabled(true);
        this.btnActivate.setEnabled(true);
        this.btnAdd.setEnabled(true);
        this.btnEdit.setEnabled(true);
        this.btnRemove.setEnabled(true);
    }
}

