/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api.output;

import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.maven.api.output.Bundle;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public final class OutputUtils {
    private static final Pattern linePattern = Pattern.compile("(?:\\[catch\\])?\\sat (.*)\\((.*)\\.java\\:(\\d+)\\)");

    private OutputUtils() {
    }

    public static OutputListener matchStackTraceLine(String line, ClassPath classPath) {
        Matcher match = linePattern.matcher(line);
        OutputListener list = null;
        if (match.matches()) {
            String method = match.group(1);
            String file = match.group(2);
            String lineNum = match.group(3);
            int index = method.indexOf(file);
            if (index > -1) {
                return new StacktraceOutputListener(method, file, lineNum, classPath);
            }
        }
        return list;
    }

    private static class StacktraceOutputListener
    implements OutputListener {
        private final String method;
        private final String file;
        private final String lineNum;
        private final ClassPath classPath;

        private StacktraceOutputListener(String method, String file, String lineNum, ClassPath classPath) {
            this.method = method;
            this.file = file;
            this.lineNum = lineNum;
            this.classPath = classPath;
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            int index = this.method.indexOf(this.file);
            String packageName = this.method.substring(0, index).replace('.', '/');
            String resourceName = packageName + this.file + ".class";
            FileObject resource = this.classPath.findResource(resourceName);
            if (resource != null) {
                FileObject root = this.classPath.findOwnerRoot(resource);
                if (root != null) {
                    URL url = URLMapper.findURL((FileObject)root, (int)0);
                    SourceForBinaryQuery.Result res = SourceForBinaryQuery.findSourceRoots((URL)url);
                    FileObject[] rootz = res.getRoots();
                    for (int i = 0; i < rootz.length; ++i) {
                        String path = packageName + this.file + ".java";
                        FileObject javaFo = rootz[i].getFileObject(path);
                        if (javaFo == null) continue;
                        try {
                            DataObject obj = DataObject.find((FileObject)javaFo);
                            EditorCookie cookie = (EditorCookie)obj.getLookup().lookup(EditorCookie.class);
                            int lineInt = Integer.parseInt(this.lineNum);
                            try {
                                cookie.getLineSet().getCurrent(lineInt - 1).show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                            }
                            catch (IndexOutOfBoundsException x) {
                                cookie.open();
                            }
                            return;
                        }
                        catch (DataObjectNotFoundException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    StatusDisplayer.getDefault().setStatusText(Bundle.OutputUtils_NoSource(this.file));
                }
            } else {
                StatusDisplayer.getDefault().setStatusText(Bundle.OutputUtils_NotFound(this.file));
            }
        }

        public void outputLineCleared(OutputEvent ev) {
        }
    }
}

