/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.NBPluginParameterExpressionEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class PluginPropertyUtils {
    private static final String CONTEXT_EXPRESSION_EVALUATOR = "NB_EVALUATOR";
    private static final List<String> LIFECYCLE_PLUGINS = Arrays.asList("maven-compiler-plugin", "maven-surefire-plugin", "maven-ear-plugin", "maven-jar-plugin", "maven-war-plugin", "maven-resources-plugin");

    private PluginPropertyUtils() {
    }

    @Deprecated
    @CheckForNull
    public static String getPluginProperty(@NonNull Project prj, @NonNull String groupId, @NonNull String artifactId, @NonNull String parameter, @NullAllowed String goal) {
        return PluginPropertyUtils.getPluginProperty(prj, groupId, artifactId, parameter, goal, null);
    }

    @CheckForNull
    public static String getPluginProperty(@NonNull Project prj, @NonNull String groupId, @NonNull String artifactId, @NonNull String parameter, @NullAllowed String goal, @NullAllowed String expressionProperty) {
        NbMavenProjectImpl project = (NbMavenProjectImpl)prj.getLookup().lookup(NbMavenProjectImpl.class);
        assert (project != null) : "Requires a maven project instance";
        return PluginPropertyUtils.getPluginPropertyImpl(project.getOriginalMavenProject(), PluginPropertyUtils.createEvaluator(project), groupId, artifactId, parameter, goal, expressionProperty);
    }

    @Deprecated
    @CheckForNull
    public static String getPluginProperty(@NonNull MavenProject prj, @NonNull String groupId, @NonNull String artifactId, @NonNull String parameter, @NullAllowed String goal) {
        return PluginPropertyUtils.getPluginProperty(prj, groupId, artifactId, parameter, goal, null);
    }

    @CheckForNull
    public static String getPluginProperty(@NonNull MavenProject prj, @NonNull String groupId, @NonNull String artifactId, @NonNull String parameter, @NullAllowed String goal, @NullAllowed String expressionProperty) {
        return PluginPropertyUtils.getPluginPropertyImpl(prj, PluginPropertyUtils.createEvaluator(prj), groupId, artifactId, parameter, goal, expressionProperty);
    }

    @CheckForNull
    private static String getPluginPropertyImpl(@NonNull MavenProject prj, @NonNull ExpressionEvaluator eval, @NonNull String groupId, @NonNull String artifactId, @NonNull String parameter, @NullAllowed String goal, @NullAllowed String expressionProperty) {
        Properties prop;
        String toRet = null;
        if (prj.getBuildPlugins() == null) {
            return toRet;
        }
        for (Plugin plug : prj.getBuildPlugins()) {
            PluginExecution exe;
            if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
            Iterator<PluginExecution> i$ = PluginPropertyUtils.getPluginExecutions(plug, goal).iterator();
            while (i$.hasNext() && (toRet = PluginPropertyUtils.checkConfiguration(eval, (exe = i$.next()).getConfiguration(), parameter)) == null) {
            }
            if (toRet != null) continue;
            toRet = PluginPropertyUtils.checkConfiguration(eval, plug.getConfiguration(), parameter);
        }
        if (toRet == null && LIFECYCLE_PLUGINS.contains(artifactId) && prj.getPluginManagement() != null) {
            for (Plugin plug : prj.getPluginManagement().getPlugins()) {
                if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
                toRet = PluginPropertyUtils.checkConfiguration(eval, plug.getConfiguration(), parameter);
                break;
            }
        }
        if (toRet == null && expressionProperty != null && (prop = prj.getProperties()) != null) {
            toRet = prop.getProperty(expressionProperty);
        }
        return toRet;
    }

    @CheckForNull
    public static String getReportPluginProperty(@NonNull Project prj, @NonNull String groupId, @NonNull String artifactId, @NonNull String property, @NullAllowed String report) {
        NbMavenProjectImpl project = (NbMavenProjectImpl)prj.getLookup().lookup(NbMavenProjectImpl.class);
        assert (project != null) : "Requires a maven project instance";
        return PluginPropertyUtils.getReportPluginPropertyImpl(project.getOriginalMavenProject(), PluginPropertyUtils.createEvaluator(project), groupId, artifactId, property, report);
    }

    @CheckForNull
    public static String getReportPluginProperty(@NonNull MavenProject prj, @NonNull String groupId, @NonNull String artifactId, @NonNull String property, @NullAllowed String report) {
        return PluginPropertyUtils.getReportPluginPropertyImpl(prj, PluginPropertyUtils.createEvaluator(prj), groupId, artifactId, property, report);
    }

    @CheckForNull
    private static String getReportPluginPropertyImpl(@NonNull MavenProject prj, @NonNull ExpressionEvaluator eval, @NonNull String groupId, @NonNull String artifactId, @NonNull String property, @NullAllowed String report) {
        String toRet = null;
        for (ReportPlugin plug : PluginPropertyUtils.getEffectiveReportPlugins(prj)) {
            if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
            if (plug.getReportSets() != null) {
                ReportSet exe;
                Iterator i$ = plug.getReportSets().iterator();
                while (i$.hasNext() && (!(exe = (ReportSet)i$.next()).getReports().contains(report) || (toRet = PluginPropertyUtils.checkConfiguration(eval, exe.getConfiguration(), property)) == null)) {
                }
            }
            if (toRet != null) continue;
            toRet = PluginPropertyUtils.checkConfiguration(eval, plug.getConfiguration(), property);
        }
        return toRet;
    }

    @CheckForNull
    public static String getPluginVersion(@NonNull MavenProject prj, @NonNull String groupId, @NonNull String artifactId) {
        String toRet = null;
        if (prj.getBuildPlugins() == null) {
            return toRet;
        }
        for (Plugin plug : prj.getBuildPlugins()) {
            if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
            toRet = plug.getVersion();
        }
        if (toRet == null && LIFECYCLE_PLUGINS.contains(artifactId) && prj.getPluginManagement() != null) {
            for (Plugin plug : prj.getPluginManagement().getPlugins()) {
                if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
                toRet = plug.getVersion();
                break;
            }
        }
        return toRet;
    }

    @CheckForNull
    public static String getReportPluginVersion(@NonNull MavenProject prj, @NonNull String groupId, @NonNull String artifactId) {
        for (ReportPlugin plug : PluginPropertyUtils.getEffectiveReportPlugins(prj)) {
            if (!groupId.equals(plug.getGroupId()) || !artifactId.equals(plug.getArtifactId())) continue;
            return plug.getVersion();
        }
        return null;
    }

    @CheckForNull
    private static String checkConfiguration(@NonNull ExpressionEvaluator eval, @NullAllowed Object conf, @NonNull String property) {
        Xpp3Dom dom;
        Xpp3Dom source;
        if (conf != null && (source = (dom = (Xpp3Dom)conf).getChild(property)) != null) {
            String value = source.getValue();
            if (value == null) {
                return null;
            }
            String valueT = value.trim();
            try {
                Object evaluated = eval.evaluate(valueT);
                return evaluated != null ? evaluated.toString() : valueT;
            }
            catch (ExpressionEvaluationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return valueT;
            }
        }
        return null;
    }

    @CheckForNull
    public static String[] getPluginPropertyList(@NonNull Project prj, @NonNull String groupId, @NonNull String artifactId, @NonNull String multiproperty, @NonNull String singleproperty, @NullAllowed String goal) {
        NbMavenProjectImpl project = (NbMavenProjectImpl)prj.getLookup().lookup(NbMavenProjectImpl.class);
        assert (project != null) : "Requires a maven project instance";
        return PluginPropertyUtils.getPluginPropertyListImpl(project.getOriginalMavenProject(), PluginPropertyUtils.createEvaluator(project), groupId, artifactId, multiproperty, singleproperty, goal);
    }

    @CheckForNull
    public static String[] getPluginPropertyList(@NonNull MavenProject prj, @NonNull String groupId, @NonNull String artifactId, @NonNull String multiproperty, @NonNull String singleproperty, @NullAllowed String goal) {
        return PluginPropertyUtils.getPluginPropertyListImpl(prj, PluginPropertyUtils.createEvaluator(prj), groupId, artifactId, multiproperty, singleproperty, goal);
    }

    @CheckForNull
    private static String[] getPluginPropertyListImpl(@NonNull MavenProject prj, @NonNull ExpressionEvaluator eval, @NonNull String groupId, @NonNull String artifactId, @NonNull String multiproperty, @NonNull String singleproperty, @NullAllowed String goal) {
        String[] toRet = null;
        if (prj.getBuildPlugins() == null) {
            return toRet;
        }
        for (Plugin plug : prj.getBuildPlugins()) {
            PluginExecution exe;
            if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
            Iterator<PluginExecution> i$ = PluginPropertyUtils.getPluginExecutions(plug, goal).iterator();
            while (i$.hasNext() && (toRet = PluginPropertyUtils.checkListConfiguration(eval, (exe = i$.next()).getConfiguration(), multiproperty, singleproperty)) == null) {
            }
            if (toRet != null) continue;
            toRet = PluginPropertyUtils.checkListConfiguration(eval, plug.getConfiguration(), multiproperty, singleproperty);
        }
        if (toRet == null && LIFECYCLE_PLUGINS.contains(artifactId) && prj.getPluginManagement() != null) {
            for (Plugin plug : prj.getPluginManagement().getPlugins()) {
                if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
                toRet = PluginPropertyUtils.checkListConfiguration(eval, plug.getConfiguration(), multiproperty, singleproperty);
                break;
            }
        }
        return toRet;
    }

    @CheckForNull
    public static String[] getReportPluginPropertyList(@NonNull Project prj, @NonNull String groupId, @NonNull String artifactId, @NonNull String multiproperty, @NonNull String singleproperty, @NullAllowed String goal) {
        NbMavenProjectImpl project = (NbMavenProjectImpl)prj.getLookup().lookup(NbMavenProjectImpl.class);
        assert (project != null) : "Requires a maven project instance";
        return PluginPropertyUtils.getReportPluginPropertyListImpl(project.getOriginalMavenProject(), PluginPropertyUtils.createEvaluator(project), groupId, artifactId, multiproperty, singleproperty, goal);
    }

    @CheckForNull
    public static String[] getReportPluginPropertyList(@NonNull MavenProject prj, @NonNull String groupId, @NonNull String artifactId, @NonNull String multiproperty, @NonNull String singleproperty, @NullAllowed String goal) {
        return PluginPropertyUtils.getReportPluginPropertyListImpl(prj, PluginPropertyUtils.createEvaluator(prj), groupId, artifactId, multiproperty, singleproperty, goal);
    }

    @CheckForNull
    private static String[] getReportPluginPropertyListImpl(@NonNull MavenProject prj, @NonNull ExpressionEvaluator eval, @NonNull String groupId, @NonNull String artifactId, @NonNull String multiproperty, @NonNull String singleproperty, @NullAllowed String goal) {
        String[] toRet = null;
        for (ReportPlugin plug : PluginPropertyUtils.getEffectiveReportPlugins(prj)) {
            if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
            if (plug.getReportSets() != null) {
                ReportSet exe;
                Iterator i$ = plug.getReportSets().iterator();
                while (i$.hasNext() && (!(exe = (ReportSet)i$.next()).getReports().contains(goal) || (toRet = PluginPropertyUtils.checkListConfiguration(eval, exe.getConfiguration(), multiproperty, singleproperty)) == null)) {
                }
            }
            if (toRet != null) continue;
            toRet = PluginPropertyUtils.checkListConfiguration(eval, plug.getConfiguration(), multiproperty, singleproperty);
        }
        if (toRet == null && prj.getPluginManagement() != null) {
            for (ReportPlugin plug : prj.getPluginManagement().getPlugins()) {
                if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
                toRet = PluginPropertyUtils.checkListConfiguration(eval, plug.getConfiguration(), multiproperty, singleproperty);
                break;
            }
        }
        return toRet;
    }

    @CheckForNull
    private static String[] checkListConfiguration(ExpressionEvaluator eval, @NullAllowed Object conf, @NonNull String multiproperty, @NonNull String singleproperty) {
        Xpp3Dom dom;
        Xpp3Dom source;
        if (conf != null && (source = (dom = (Xpp3Dom)conf).getChild(multiproperty)) != null) {
            Xpp3Dom[] childs;
            ArrayList<String> toRet = new ArrayList<String>();
            for (Xpp3Dom ch : childs = source.getChildren(singleproperty)) {
                try {
                    String chvalue = ch.getValue() == null ? "" : ch.getValue().trim();
                    Object evaluated = eval.evaluate(chvalue);
                    toRet.add(evaluated != null ? "" + evaluated : chvalue);
                }
                catch (ExpressionEvaluationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return toRet.toArray(new String[toRet.size()]);
        }
        return null;
    }

    @CheckForNull
    public static Properties getPluginPropertyParameter(@NonNull Project prj, @NonNull String groupId, @NonNull String artifactId, @NonNull String propertyParameter, @NullAllowed String goal) {
        NbMavenProjectImpl project = (NbMavenProjectImpl)prj.getLookup().lookup(NbMavenProjectImpl.class);
        assert (project != null) : "Requires a maven project instance";
        return PluginPropertyUtils.getPluginPropertyParameterImpl(project.getOriginalMavenProject(), PluginPropertyUtils.createEvaluator(project), groupId, artifactId, propertyParameter, goal);
    }

    @CheckForNull
    public static Properties getPluginPropertyParameter(@NonNull MavenProject prj, @NonNull String groupId, @NonNull String artifactId, @NonNull String propertyParameter, @NullAllowed String goal) {
        return PluginPropertyUtils.getPluginPropertyParameterImpl(prj, PluginPropertyUtils.createEvaluator(prj), groupId, artifactId, propertyParameter, goal);
    }

    @CheckForNull
    private static Properties getPluginPropertyParameterImpl(@NonNull MavenProject prj, @NonNull ExpressionEvaluator eval, @NonNull String groupId, @NonNull String artifactId, @NonNull String propertyParameter, @NullAllowed String goal) {
        Properties toRet = null;
        if (prj.getBuildPlugins() == null) {
            return toRet;
        }
        for (Plugin plug : prj.getBuildPlugins()) {
            PluginExecution exe;
            if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
            Iterator<PluginExecution> i$ = PluginPropertyUtils.getPluginExecutions(plug, goal).iterator();
            while (i$.hasNext() && (toRet = PluginPropertyUtils.checkPropertiesConfiguration(eval, (exe = i$.next()).getConfiguration(), propertyParameter)) == null) {
            }
            if (toRet != null) continue;
            toRet = PluginPropertyUtils.checkPropertiesConfiguration(eval, plug.getConfiguration(), propertyParameter);
        }
        if (toRet == null && LIFECYCLE_PLUGINS.contains(artifactId) && prj.getPluginManagement() != null) {
            for (Plugin plug : prj.getPluginManagement().getPlugins()) {
                if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
                toRet = PluginPropertyUtils.checkPropertiesConfiguration(eval, plug.getConfiguration(), propertyParameter);
                break;
            }
        }
        return toRet;
    }

    @CheckForNull
    private static Properties checkPropertiesConfiguration(@NonNull ExpressionEvaluator eval, @NullAllowed Object conf, @NonNull String propertyParameter) {
        Xpp3Dom dom;
        Xpp3Dom source;
        if (conf != null && (source = (dom = (Xpp3Dom)conf).getChild(propertyParameter)) != null) {
            Xpp3Dom[] childs;
            Properties toRet = new Properties();
            for (Xpp3Dom ch : childs = source.getChildren()) {
                try {
                    String val = ch.getValue();
                    if (val == null) {
                        if (ch.getChildCount() == 2) {
                            Xpp3Dom nameDom = ch.getChild("name");
                            Xpp3Dom valueDom = ch.getChild("value");
                            if (nameDom != null && valueDom != null) {
                                String name = nameDom.getValue();
                                String value = valueDom.getValue();
                                Object evaluated = eval.evaluate(value);
                                if (name != null && value != null) {
                                    toRet.put(name, evaluated != null ? "" + evaluated : value);
                                }
                            }
                        }
                        toRet.put(ch.getName(), "");
                        continue;
                    }
                    Object evaluated = eval.evaluate(val.trim());
                    toRet.put(ch.getName(), evaluated != null ? "" + evaluated : ch.getValue().trim());
                }
                catch (ExpressionEvaluationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return toRet;
        }
        return null;
    }

    @NonNull
    private static Iterable<ReportPlugin> getEffectiveReportPlugins(@NonNull MavenProject prj) {
        ArrayList<ReportPlugin> plugins = new ArrayList<ReportPlugin>();
        for (Plugin plug : prj.getBuildPlugins()) {
            Xpp3Dom reportPlugins;
            Xpp3Dom cfg;
            if (!"org.apache.maven.plugins".equals(plug.getGroupId()) || !"maven-site-plugin".equals(plug.getArtifactId()) || (cfg = (Xpp3Dom)plug.getConfiguration()) == null || (reportPlugins = cfg.getChild("reportPlugins")) == null) continue;
            for (Xpp3Dom plugin : reportPlugins.getChildren("plugin")) {
                Xpp3Dom version;
                Xpp3Dom artifactId;
                ReportPlugin p = new ReportPlugin();
                Xpp3Dom groupId = plugin.getChild("groupId");
                if (groupId != null) {
                    p.setGroupId(groupId.getValue());
                }
                if ((artifactId = plugin.getChild("artifactId")) != null) {
                    p.setArtifactId(artifactId.getValue());
                }
                if ((version = plugin.getChild("version")) != null) {
                    p.setVersion(version.getValue());
                }
                p.setConfiguration((Object)plugin.getChild("configuration"));
                plugins.add(p);
            }
        }
        List m2Plugins = prj.getReportPlugins();
        plugins.addAll(m2Plugins);
        return plugins;
    }

    @NonNull
    public static ExpressionEvaluator createEvaluator(@NonNull Project project) {
        NbMavenProjectImpl prj = (NbMavenProjectImpl)project.getLookup().lookup(NbMavenProjectImpl.class);
        assert (prj != null);
        MavenProject mvnprj = prj.getOriginalMavenProject();
        ExpressionEvaluator eval = (ExpressionEvaluator)mvnprj.getContextValue(CONTEXT_EXPRESSION_EVALUATOR);
        if (eval == null) {
            Settings ss = EmbedderFactory.getProjectEmbedder().getSettings();
            ss.setLocalRepository(EmbedderFactory.getProjectEmbedder().getLocalRepository().getBasedir());
            eval = new NBPluginParameterExpressionEvaluator(mvnprj, ss, prj.createSystemPropsForPropertyExpressions());
            mvnprj.setContextValue(CONTEXT_EXPRESSION_EVALUATOR, (Object)eval);
        }
        return eval;
    }

    @NonNull
    public static ExpressionEvaluator createEvaluator(@NonNull MavenProject prj) {
        NbMavenProjectImpl project;
        Project p;
        FileObject bsd;
        ExpressionEvaluator eval = (ExpressionEvaluator)prj.getContextValue(CONTEXT_EXPRESSION_EVALUATOR);
        if (eval != null) {
            return eval;
        }
        Map<Object, Object> props = Collections.emptyMap();
        File basedir = prj.getBasedir();
        if (basedir != null && (bsd = FileUtil.toFileObject((File)basedir)) != null && (p = FileOwnerQuery.getOwner((FileObject)bsd)) != null && (project = (NbMavenProjectImpl)p.getLookup().lookup(NbMavenProjectImpl.class)) != null) {
            props = project.createSystemPropsForPropertyExpressions();
        }
        Settings ss = EmbedderFactory.getProjectEmbedder().getSettings();
        ss.setLocalRepository(EmbedderFactory.getProjectEmbedder().getLocalRepository().getBasedir());
        eval = new NBPluginParameterExpressionEvaluator(prj, ss, props);
        prj.setContextValue(CONTEXT_EXPRESSION_EVALUATOR, (Object)eval);
        return eval;
    }

    @NonNull
    private static List<PluginExecution> getPluginExecutions(@NonNull Plugin plug, @NullAllowed String goal) {
        if (goal == null) {
            return Collections.emptyList();
        }
        ArrayList<PluginExecution> exes = new ArrayList<PluginExecution>();
        for (PluginExecution exe : plug.getExecutions()) {
            if (!exe.getGoals().contains(goal) && !("default-" + goal).equals(exe.getId())) continue;
            exes.add(exe);
        }
        Collections.sort(exes, new Comparator<PluginExecution>(){

            @Override
            public int compare(PluginExecution e1, PluginExecution e2) {
                return e2.getPriority() - e1.getPriority();
            }
        });
        return exes;
    }
}

