/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidArtifactRTException;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.model.Build;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.progress.aggregate.AggregateProgressFactory;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.Bundle;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.embedder.exec.ProgressTransferListener;
import org.netbeans.modules.maven.modelcache.MavenProjectCache;
import org.netbeans.modules.maven.options.MavenSettings;
import org.netbeans.modules.maven.spi.PackagingProvider;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.sonatype.aether.transfer.TransferListener;

public final class NbMavenProject {
    public static final String PROP_PROJECT = "MavenProject";
    public static final String PROP_RESOURCE = "RESOURCES";
    private NbMavenProjectImpl project;
    private PropertyChangeSupport support;
    private FCHSL listener = new FCHSL();
    private final List<File> files = new ArrayList<File>();
    private final RequestProcessor.Task task;
    private static RequestProcessor BINARYRP;
    private static RequestProcessor NONBINARYRP;
    public static final String TYPE_JAR = "jar";
    public static final String TYPE_WAR = "war";
    public static final String TYPE_EAR = "ear";
    public static final String TYPE_EJB = "ejb";
    public static final String TYPE_APPCLIENT = "app-client";
    public static final String TYPE_NBM = "nbm";
    public static final String TYPE_NBM_APPLICATION = "nbm-application";
    public static final String TYPE_OSGI = "bundle";
    public static final String TYPE_POM = "pom";

    private NbMavenProject(NbMavenProjectImpl proj) {
        this.project = proj;
        this.support = new PropertyChangeSupport(proj);
        this.task = this.createBinaryDownloadTask(BINARYRP);
    }

    public boolean isUnloadable() {
        return MavenProjectCache.isFallbackproject(this.getMavenProject());
    }

    private RequestProcessor.Task createBinaryDownloadTask(RequestProcessor rp) {
        return rp.create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean ok;
                block16: {
                    FileObject fo = NbMavenProject.this.project.getProjectDirectory();
                    if (fo == null || !fo.isValid()) {
                        return;
                    }
                    if ((fo = fo.getFileObject("pom.xml")) == null) {
                        return;
                    }
                    File pomFile = FileUtil.toFile((FileObject)fo);
                    if (pomFile == null) {
                        return;
                    }
                    MavenEmbedder online = EmbedderFactory.getOnlineEmbedder();
                    AggregateProgressHandle hndl = AggregateProgressFactory.createHandle((String)Bundle.Progress_Download(), (ProgressContributor[])new ProgressContributor[]{AggregateProgressFactory.createProgressContributor((String)"zaloha")}, (Cancellable)ProgressTransferListener.cancellable(), null);
                    ok = true;
                    try {
                        ProgressTransferListener.setAggregateHandle((AggregateProgressHandle)hndl);
                        hndl.start();
                        MavenExecutionRequest req = online.createMavenExecutionRequest();
                        req.setPom(pomFile);
                        req.setTransferListener((TransferListener)ProgressTransferListener.activeListener());
                        MavenExecutionResult res = online.readProjectWithDependencies(req, false);
                        if (res.hasExceptions()) {
                            ok = false;
                            Exception ex = (Exception)res.getExceptions().get(0);
                            StatusDisplayer.getDefault().setStatusText(Bundle.MSG_Failed(ex.getLocalizedMessage()));
                        }
                    }
                    catch (ThreadDeath d) {
                    }
                    catch (IllegalStateException x) {
                        if (x.getCause() instanceof ThreadDeath) {
                            break block16;
                        }
                        throw x;
                    }
                    catch (RuntimeException exc) {
                        StatusDisplayer.getDefault().setStatusText(Bundle.MSG_Failed(exc.getLocalizedMessage()));
                    }
                    finally {
                        hndl.finish();
                        ProgressTransferListener.clearAggregateHandle();
                    }
                }
                if (ok) {
                    StatusDisplayer.getDefault().setStatusText(Bundle.MSG_Done());
                }
                if (NbMavenProject.this.support.hasListeners(NbMavenProject.PROP_PROJECT)) {
                    NbMavenProject.fireMavenProjectReload(NbMavenProject.this.project);
                }
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    @NonNull
    public MavenProject getMavenProject() {
        return this.project.getOriginalMavenProject();
    }

    public boolean isMavenProjectLoaded() {
        return this.project.isMavenProjectLoaded();
    }

    @NonNull
    public MavenProject loadAlternateMavenProject(MavenEmbedder embedder, List<String> activeProfiles, Properties properties) {
        return this.project.loadMavenProject(embedder, activeProfiles, properties);
    }

    public URI[] getResources(boolean test) {
        return this.project.getResources(test);
    }

    public File getOutputDirectory(boolean test) {
        String path;
        Build build = this.getMavenProject().getBuild();
        String string = build != null ? (test ? build.getTestOutputDirectory() : build.getOutputDirectory()) : (path = null);
        File toRet = path != null ? FileUtil.normalizeFile((File)new File(path)) : new File(new File(this.getMavenProject().getBasedir(), "target"), test ? "test-classes" : "classes");
        return toRet;
    }

    public URI getWebAppDirectory() {
        return this.project.getWebAppDirectory();
    }

    public URI getEarAppDirectory() {
        return this.project.getEarAppDirectory();
    }

    public String getPackagingType() {
        for (PackagingProvider pp : Lookup.getDefault().lookupAll(PackagingProvider.class)) {
            String p = pp.packaging(this.project);
            if (p == null) continue;
            return p;
        }
        return this.getMavenProject().getPackaging();
    }

    public void addWatchedPath(String relPath) {
        this.addWatchedPath(FileUtilities.getDirURI(this.project.getProjectDirectory(), relPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWatchedPath(URI uri) {
        boolean addListener = false;
        File fil = Utilities.toFile((URI)uri);
        List<File> list = this.files;
        synchronized (list) {
            if (!this.files.contains(fil)) {
                addListener = true;
            }
            this.files.add(fil);
        }
        if (addListener) {
            FileUtil.addFileChangeListener((FileChangeListener)this.listener, (File)fil);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerDependencyDownload() {
        RequestProcessor.Task task = this.task;
        synchronized (task) {
            this.task.schedule(1000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronousDependencyDownload() {
        assert (!SwingUtilities.isEventDispatchThread()) : " Not to be called from AWT, can take significant amount ot time to download dependencies from the network.";
        RequestProcessor.Task task = this.task;
        synchronized (task) {
            this.task.schedule(0);
            this.task.waitFinished();
        }
    }

    @Deprecated
    public void downloadDependencyAndJavadocSource() {
        this.downloadDependencyAndJavadocSource(true);
    }

    public void downloadDependencyAndJavadocSource(boolean synch) {
        if (synch) {
            this.synchronousDependencyDownload();
        } else {
            this.triggerDependencyDownload();
        }
        if (MavenSettings.getDefault().getJavadocDownloadStrategy() != MavenSettings.DownloadStrategy.NEVER) {
            this.triggerSourceJavadocDownload(true);
        }
        if (MavenSettings.getDefault().getSourceDownloadStrategy() != MavenSettings.DownloadStrategy.NEVER) {
            this.triggerSourceJavadocDownload(false);
        }
    }

    public void triggerSourceJavadocDownload(final boolean javadoc) {
        NONBINARYRP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Set arts = NbMavenProject.this.project.getOriginalMavenProject().getArtifacts();
                ProgressContributor[] contribs = new ProgressContributor[arts.size()];
                for (int i = 0; i < arts.size(); ++i) {
                    contribs[i] = AggregateProgressFactory.createProgressContributor((String)("multi-" + i));
                }
                String label = javadoc ? Bundle.Progress_Javadoc() : Bundle.Progress_Source();
                AggregateProgressHandle handle = AggregateProgressFactory.createHandle((String)label, (ProgressContributor[])contribs, (Cancellable)ProgressTransferListener.cancellable(), null);
                handle.start();
                try {
                    ProgressTransferListener.setAggregateHandle((AggregateProgressHandle)handle);
                    int index = 0;
                    for (Artifact a : arts) {
                        NbMavenProject.downloadOneJavadocSources(contribs[index], NbMavenProject.this.project, a, javadoc);
                        ++index;
                    }
                }
                catch (ThreadDeath d) {
                }
                finally {
                    handle.finish();
                    ProgressTransferListener.clearAggregateHandle();
                    NbMavenProject.this.fireProjectReload();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadOneJavadocSources(ProgressContributor progress, NbMavenProjectImpl project, Artifact art, boolean isjavadoc) {
        MavenEmbedder online = EmbedderFactory.getOnlineEmbedder();
        progress.start(2);
        if ("system".equals(art.getScope())) {
            progress.finish();
            return;
        }
        try {
            if (isjavadoc) {
                Artifact javadoc = project.getEmbedder().createArtifactWithClassifier(art.getGroupId(), art.getArtifactId(), art.getVersion(), art.getType(), "javadoc");
                progress.progress(Bundle.MSG_Checking_Javadoc(art.getId()), 1);
                online.resolve(javadoc, project.getOriginalMavenProject().getRemoteArtifactRepositories(), project.getEmbedder().getLocalRepository());
            } else {
                Artifact sources = project.getEmbedder().createArtifactWithClassifier(art.getGroupId(), art.getArtifactId(), art.getVersion(), art.getType(), "sources");
                progress.progress(Bundle.MSG_Checking_Sources(art.getId()), 1);
                online.resolve(sources, project.getOriginalMavenProject().getRemoteArtifactRepositories(), project.getEmbedder().getLocalRepository());
            }
        }
        catch (ThreadDeath td) {
        }
        catch (IllegalStateException ise) {
            if (!(ise.getCause() instanceof ThreadDeath)) {
                throw ise;
            }
        }
        catch (ArtifactNotFoundException ex) {
        }
        catch (ArtifactResolutionException ex) {
        }
        catch (InvalidArtifactRTException ex) {
        }
        finally {
            progress.finish();
        }
    }

    public void removeWatchedPath(String relPath) {
        this.removeWatchedPath(FileUtilities.getDirURI(this.project.getProjectDirectory(), relPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWatchedPath(URI uri) {
        boolean removeListener = false;
        File fil = Utilities.toFile((URI)uri);
        List<File> list = this.files;
        synchronized (list) {
            boolean rem = this.files.remove(fil);
            if (rem && !this.files.contains(fil)) {
                removeListener = true;
            }
        }
        if (removeListener) {
            FileUtil.removeFileChangeListener((FileChangeListener)this.listener, (File)fil);
        }
    }

    private void fireChange(URI uri) {
        this.support.firePropertyChange(PROP_RESOURCE, null, uri);
    }

    private void fireProjectReload() {
        this.project.fireProjectReload();
    }

    private void doFireReload() {
        FileUtil.refreshFor((File[])new File[]{FileUtil.toFile((FileObject)this.project.getProjectDirectory())});
        NbMavenProjectImpl.refreshLocalRepository(this.project);
        this.support.firePropertyChange(PROP_PROJECT, null, null);
    }

    public static void fireMavenProjectReload(Project prj) {
        NbMavenProject watcher;
        if (prj != null && (watcher = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class)) != null) {
            watcher.fireProjectReload();
        }
    }

    public static void addPropertyChangeListener(Project prj, PropertyChangeListener listener) {
        if (prj != null && prj instanceof NbMavenProjectImpl) {
            NbMavenProject watcher = ((NbMavenProjectImpl)prj).getProjectWatcher();
            watcher.addPropertyChangeListener(listener);
        } else assert (false) : "Attempted to add PropertyChangeListener to project " + prj;
    }

    public static void removePropertyChangeListener(Project prj, PropertyChangeListener listener) {
        if (prj != null && prj instanceof NbMavenProjectImpl) {
            NbMavenProject watcher = ((NbMavenProjectImpl)prj).getProjectWatcher();
            watcher.removePropertyChangeListener(listener);
        } else assert (false) : "Attempted to remove PropertyChangeListener from project " + prj;
    }

    public static boolean isErrorPlaceholder(@NonNull MavenProject project) {
        return project.getId().equals("error:error:pom:0");
    }

    public String toString() {
        return this.project.toString();
    }

    static {
        AccessorImpl impl = new AccessorImpl();
        impl.assign();
        BINARYRP = new RequestProcessor("Maven projects Binary Downloads", 1);
        NONBINARYRP = new RequestProcessor("Maven projects Source/Javadoc Downloads", 1);
    }

    private class FCHSL
    implements FileChangeListener {
        private FCHSL() {
        }

        public void fileFolderCreated(FileEvent fe) {
            NbMavenProject.this.fireChange(Utilities.toURI((File)FileUtil.toFile((FileObject)fe.getFile())));
        }

        public void fileDataCreated(FileEvent fe) {
            NbMavenProject.this.fireChange(Utilities.toURI((File)FileUtil.toFile((FileObject)fe.getFile())));
        }

        public void fileChanged(FileEvent fe) {
            NbMavenProject.this.fireChange(Utilities.toURI((File)FileUtil.toFile((FileObject)fe.getFile())));
        }

        public void fileDeleted(FileEvent fe) {
            NbMavenProject.this.fireChange(Utilities.toURI((File)FileUtil.toFile((FileObject)fe.getFile())));
        }

        public void fileRenamed(FileRenameEvent fe) {
            NbMavenProject.this.fireChange(Utilities.toURI((File)FileUtil.toFile((FileObject)fe.getFile())));
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }

    static class AccessorImpl
    extends NbMavenProjectImpl.WatcherAccessor {
        AccessorImpl() {
        }

        public void assign() {
            if (NbMavenProjectImpl.ACCESSOR == null) {
                NbMavenProjectImpl.ACCESSOR = this;
            }
        }

        @Override
        public NbMavenProject createWatcher(NbMavenProjectImpl proj) {
            return new NbMavenProject(proj);
        }

        @Override
        public void doFireReload(NbMavenProject watcher) {
            watcher.doFireReload();
        }
    }
}

