/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.apache.maven.DefaultMaven;
import org.apache.maven.Maven;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.maven.M2AuxilaryConfigImpl;
import org.netbeans.modules.maven.MavenProjectPropsImpl;
import org.netbeans.modules.maven.ProjectOpenedHookImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.execute.ActiveJ2SEPlatformProvider;
import org.netbeans.modules.maven.configurations.M2ConfigProvider;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.configurations.ProjectProfileHandlerImpl;
import org.netbeans.modules.maven.cos.CopyResourcesOnSave;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.modelcache.MavenProjectCache;
import org.netbeans.modules.maven.problems.ProblemReporterImpl;
import org.netbeans.modules.maven.spi.queries.JavaLikeRootProvider;
import org.netbeans.spi.java.project.support.LookupMergerSupport;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.project.support.LookupProviderSupport;
import org.netbeans.spi.project.ui.support.UILookupMergerSupport;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class NbMavenProjectImpl
implements Project {
    public static final String PROP_PROJECT = "MavenProject";
    public static final String PROP_RESOURCE = "RESOURCES";
    private static final Logger LOG = Logger.getLogger(NbMavenProjectImpl.class.getName());
    public static final RequestProcessor RELOAD_RP = new RequestProcessor("Maven project reloading", 1);
    private FileObject fileObject;
    private FileObject folderFileObject;
    private final File projectFile;
    private final Lookup basicLookup;
    private final Lookup completeLookup;
    private final Lookup lookup;
    private final Updater projectFolderUpdater;
    private final Updater userFolderUpdater;
    private Reference<MavenProject> project;
    private boolean hardReferencingMavenProject = false;
    private MavenProject hardRefProject;
    private ProblemReporterImpl problemReporter;
    @NonNull
    private final NbMavenProject watcher;
    private final M2ConfigProvider configProvider;
    @NonNull
    private final MavenProjectPropsImpl auxprops;
    private ProjectProfileHandlerImpl profileHandler;
    private CopyResourcesOnSave copyResourcesOnSave;
    private final Object COPYRESOURCES_LOCK = new Object();
    @SuppressWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static WatcherAccessor ACCESSOR = null;
    private ProjectOpenedHookImpl hookImpl;
    private Exception ex;
    private final Object LOCK_224012 = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setIssue224012(ProjectOpenedHookImpl hook, Exception exception) {
        Object object = this.LOCK_224012;
        synchronized (object) {
            if (this.hookImpl == null) {
                this.hookImpl = hook;
                this.ex = exception;
                return true;
            }
            LOG.log(Level.INFO, "    first creation stacktrace", this.ex);
            LOG.log(Level.INFO, "    second creation stacktrace", exception);
            LOG.log(Level.WARNING, "Spotted issue 224012 (https://netbeans.org/bugzilla/show_bug.cgi?id=224012). Please report the incident.");
            return false;
        }
    }

    NbMavenProjectImpl(FileObject folder, FileObject projectFO, ProjectState projectState) {
        this.projectFile = FileUtil.normalizeFile((File)FileUtil.toFile((FileObject)projectFO));
        this.fileObject = projectFO;
        this.folderFileObject = folder;
        this.lookup = Lookups.proxy((Lookup.Provider)new Lookup.Provider(){

            public Lookup getLookup() {
                if (NbMavenProjectImpl.this.completeLookup == null) {
                    LOG.log(Level.FINE, "accessing project's lookup before the instance is fully initialized at " + NbMavenProjectImpl.this.projectFile, new Exception());
                    assert (NbMavenProjectImpl.this.basicLookup != null);
                    return NbMavenProjectImpl.this.basicLookup;
                }
                return NbMavenProjectImpl.this.completeLookup;
            }
        });
        this.watcher = ACCESSOR.createWatcher(this);
        this.projectFolderUpdater = new Updater("nb-configuration.xml", "pom.xml");
        this.userFolderUpdater = new Updater("settings.xml");
        this.problemReporter = new ProblemReporterImpl(this);
        M2AuxilaryConfigImpl auxiliary = new M2AuxilaryConfigImpl(folder, true);
        this.auxprops = new MavenProjectPropsImpl(auxiliary, this);
        this.profileHandler = new ProjectProfileHandlerImpl(this, auxiliary);
        this.configProvider = new M2ConfigProvider(this, auxiliary, this.profileHandler);
        this.basicLookup = this.createBasicLookup(projectState, auxiliary);
        this.completeLookup = LookupProviderSupport.createCompositeLookup((Lookup)this.basicLookup, (Lookup)new PackagingTypeDependentLookup(this.watcher));
    }

    public File getPOMFile() {
        return this.projectFile;
    }

    @NonNull
    public NbMavenProject getProjectWatcher() {
        return this.watcher;
    }

    public ProblemReporterImpl getProblemReporter() {
        return this.problemReporter;
    }

    @NonNull
    public MavenProject loadMavenProject(MavenEmbedder embedder, List<String> activeProfiles, Properties properties) {
        try {
            MavenExecutionRequest req = embedder.createMavenExecutionRequest();
            req.addActiveProfiles(activeProfiles);
            req.setPom(this.projectFile);
            req.setNoSnapshotUpdates(true);
            req.setUpdateSnapshots(false);
            Properties props = MavenProjectCache.createSystemPropsForProjectLoading(null);
            if (properties != null) {
                props.putAll((Map<?, ?>)properties);
            }
            req.setUserProperties(props);
            req.setInteractiveMode(false);
            req.setOffline(true);
            req.setRecursive(false);
            MavenExecutionResult res = embedder.readProjectWithDependencies(req, true);
            if (!res.hasExceptions()) {
                res.getProject().setProjectBuildingRequest(null);
                return res.getProject();
            }
            List exc = res.getExceptions();
            for (Throwable ex : exc) {
                LOG.log(Level.FINE, "Exception thrown while loading maven project at " + this.getProjectDirectory(), ex);
            }
        }
        catch (RuntimeException exc) {
            LOG.log(Level.INFO, "Runtime exception thrown while loading maven project at " + this.getProjectDirectory(), exc);
        }
        return MavenProjectCache.getFallbackProject(this.getPOMFile());
    }

    public MavenProject loadParentOf(MavenEmbedder embedder, MavenProject project) throws ProjectBuildingException {
        MavenProject parent = null;
        ProjectBuilder builder = (ProjectBuilder)embedder.lookupComponent(ProjectBuilder.class);
        MavenExecutionRequest req = embedder.createMavenExecutionRequest();
        M2Configuration active = this.configProvider.getActiveConfiguration();
        req.addActiveProfiles(active.getActivatedProfiles());
        req.setNoSnapshotUpdates(true);
        req.setUpdateSnapshots(false);
        req.setInteractiveMode(false);
        req.setRecursive(false);
        req.setOffline(true);
        req.setUserProperties(MavenProjectCache.createSystemPropsForProjectLoading(active.getProperties()));
        ProjectBuildingRequest request = req.getProjectBuildingRequest();
        request.setRemoteRepositories(project.getRemoteArtifactRepositories());
        DefaultMaven maven = (DefaultMaven)embedder.lookupComponent(Maven.class);
        request.setRepositorySession(maven.newRepositorySession(req));
        if (project.getParentFile() != null) {
            parent = builder.build(project.getParentFile(), request).getProject();
        } else if (project.getModel().getParent() != null) {
            parent = builder.build(project.getParentArtifact(), request).getProject();
        }
        if (parent != null) {
            parent.setProjectBuildingRequest(null);
        }
        MavenEmbedder.normalizePaths((MavenProject)parent);
        return parent;
    }

    public List<String> getCurrentActiveProfiles() {
        ArrayList<String> toRet = new ArrayList<String>();
        toRet.addAll(this.configProvider.getActiveConfiguration().getActivatedProfiles());
        return toRet;
    }

    public Map<? extends String, ? extends String> createSystemPropsForPropertyExpressions() {
        Map props = NbCollections.checkedMapByCopy((Map)MavenProjectCache.cloneStaticProps(), String.class, String.class, (boolean)true);
        ActiveJ2SEPlatformProvider platformProvider = (ActiveJ2SEPlatformProvider)this.getLookup().lookup(ActiveJ2SEPlatformProvider.class);
        if (platformProvider != null) {
            props.putAll(platformProvider.getJavaPlatform().getSystemProperties());
        }
        props.putAll(this.configProvider.getActiveConfiguration().getProperties());
        return props;
    }

    @NonNull
    public synchronized MavenProject getOriginalMavenProject() {
        MavenProject mp;
        MavenProject mavenProject = mp = this.project == null ? null : this.project.get();
        if (mp == null) {
            mp = this.loadOriginalMavenProject(false);
            this.project = new SoftReference<MavenProject>(mp);
            if (this.hardReferencingMavenProject) {
                this.hardRefProject = mp;
            }
        }
        return mp;
    }

    public boolean isMavenProjectLoaded() {
        Reference<MavenProject> prj = this.project;
        if (prj != null) {
            return prj.get() != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startHardReferencingMavenPoject() {
        NbMavenProjectImpl nbMavenProjectImpl = this;
        synchronized (nbMavenProjectImpl) {
            MavenProject mp;
            this.hardReferencingMavenProject = true;
            this.hardRefProject = mp = this.project == null ? null : this.project.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopHardReferencingMavenPoject() {
        NbMavenProjectImpl nbMavenProjectImpl = this;
        synchronized (nbMavenProjectImpl) {
            this.hardReferencingMavenProject = false;
            this.hardRefProject = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private MavenProject loadOriginalMavenProject(boolean reload) {
        MavenProject newproject;
        try {
            newproject = MavenProjectCache.getMavenProject(this.folderFileObject, reload);
            if (newproject == null) {
                newproject = MavenProjectCache.getFallbackProject(this.projectFile);
            }
            final MavenExecutionResult res = MavenProjectCache.getExecutionResult(newproject);
            final MavenProject np = newproject;
            ProblemReporterImpl.RP.post(new Runnable(){

                @Override
                public void run() {
                    if (res != null && res.hasExceptions()) {
                        NbMavenProjectImpl.this.problemReporter.reportExceptions(res);
                    } else {
                        NbMavenProjectImpl.this.problemReporter.doArtifactChecks(np);
                    }
                }
            });
        }
        finally {
            if (LOG.isLoggable(Level.FINE) && SwingUtilities.isEventDispatchThread()) {
                LOG.log(Level.FINE, "Project " + this.getProjectDirectory().getPath() + " loaded in AWT event dispatching thread!", new RuntimeException());
            }
        }
        assert (newproject != null);
        return newproject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireProjectReload() {
        if (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess() || SwingUtilities.isEventDispatchThread()) {
            RELOAD_RP.post(new Runnable(){

                @Override
                public void run() {
                    NbMavenProjectImpl.this.fireProjectReload();
                }
            });
            return;
        }
        this.problemReporter.clearReports();
        MavenProject prj = this.loadOriginalMavenProject(true);
        NbMavenProjectImpl nbMavenProjectImpl = this;
        synchronized (nbMavenProjectImpl) {
            this.project = new SoftReference<MavenProject>(prj);
            if (this.hardReferencingMavenProject) {
                this.hardRefProject = prj;
            }
        }
        ACCESSOR.doFireReload(this.watcher);
        this.problemReporter.doIDEConfigChecks();
    }

    public static void refreshLocalRepository(NbMavenProjectImpl project) {
        File file = project.getEmbedder().getLocalRepositoryFile();
        FileUtil.refreshFor((File[])new File[]{file});
    }

    void attachUpdater() {
        this.projectFolderUpdater.attachAll(this.getProjectDirectory());
        this.userFolderUpdater.attachAll(this.getHomeDirectory());
    }

    void detachUpdater() {
        this.projectFolderUpdater.detachAll();
        this.userFolderUpdater.detachAll();
    }

    public FileObject getProjectDirectory() {
        return this.folderFileObject;
    }

    public FileObject getHomeDirectory() {
        File homeFile = MavenCli.userMavenConfigurationHome;
        FileObject home = null;
        try {
            home = FileUtil.createFolder((File)homeFile);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (home == null) {
            LOG.log(Level.WARNING, "Cannot convert home dir to FileObject, some functionality won''t work. It''s usually the case on Windows and UNC paths. The path is {0}", homeFile);
        }
        return home;
    }

    @CheckForNull
    public String getArtifactRelativeRepositoryPath() {
        Artifact artifact = this.getOriginalMavenProject().getArtifact();
        if (artifact == null) {
            return null;
        }
        return this.getArtifactRelativeRepositoryPath(artifact);
    }

    @CheckForNull
    public String getTestArtifactRelativeRepositoryPath() {
        Artifact main = this.getOriginalMavenProject().getArtifact();
        if (main == null) {
            return null;
        }
        ArtifactHandlerManager artifactHandlerManager = (ArtifactHandlerManager)this.getEmbedder().lookupComponent(ArtifactHandlerManager.class);
        assert (artifactHandlerManager != null) : "ArtifactHandlerManager component not found in maven";
        DefaultArtifact test = new DefaultArtifact(main.getGroupId(), main.getArtifactId(), main.getVersionRange(), "test", "test-jar", "tests", artifactHandlerManager.getArtifactHandler("test-jar"));
        return this.getArtifactRelativeRepositoryPath((Artifact)test);
    }

    public String getArtifactRelativeRepositoryPath(@NonNull Artifact artifact) {
        return this.getEmbedder().getLocalRepository().pathOf(artifact);
    }

    public MavenEmbedder getEmbedder() {
        return EmbedderFactory.getProjectEmbedder();
    }

    @NonNull
    public MavenProjectPropsImpl getAuxProps() {
        return this.auxprops;
    }

    public URI[] getSourceRoots(boolean test) {
        ArrayList<URI> uris = new ArrayList<URI>();
        for (String root : test ? this.getOriginalMavenProject().getTestCompileSourceRoots() : this.getOriginalMavenProject().getCompileSourceRoots()) {
            uris.add(FileUtilities.convertStringToUri(root));
        }
        for (JavaLikeRootProvider rp : this.getLookup().lookupAll(JavaLikeRootProvider.class)) {
            FileObject root = this.getProjectDirectory().getFileObject("src/" + (test ? "test" : "main") + "/" + rp.kind());
            if (root == null || !root.isFolder()) continue;
            uris.add(root.toURI());
        }
        return uris.toArray(new URI[uris.size()]);
    }

    public URI[] getGeneratedSourceRoots(boolean test) {
        String[] buildHelpers;
        File[] kids;
        URI uri = FileUtilities.getDirURI(this.getProjectDirectory(), test ? "target/generated-test-sources" : "target/generated-sources");
        HashSet<URI> uris = new HashSet<URI>();
        File[] roots = Utilities.toFile((URI)uri).listFiles();
        if (roots != null) {
            for (File root : roots) {
                if (!VisibilityQuery.getDefault().isVisible(root) || !test && root.getName().startsWith("test-")) continue;
                kids = root.listFiles();
                if (kids != null && kids.length > 0) {
                    uris.add(Utilities.toURI((File)root));
                    continue;
                }
                this.watcher.addWatchedPath(Utilities.toURI((File)root));
            }
        }
        if (test && (roots = Utilities.toFile((URI)FileUtilities.getDirURI(this.getProjectDirectory(), "target/generated-sources")).listFiles()) != null) {
            for (File root : roots) {
                if (!VisibilityQuery.getDefault().isVisible(root) || !root.getName().startsWith("test-")) continue;
                kids = root.listFiles();
                if (kids != null && kids.length > 0) {
                    uris.add(Utilities.toURI((File)root));
                    continue;
                }
                this.watcher.addWatchedPath(Utilities.toURI((File)root));
            }
        }
        if ((buildHelpers = PluginPropertyUtils.getPluginPropertyList(this, "org.codehaus.mojo", "build-helper-maven-plugin", "sources", "source", test ? "add-test-source" : "add-source")) != null && buildHelpers.length > 0) {
            File root = FileUtil.toFile((FileObject)this.getProjectDirectory());
            for (String helper : buildHelpers) {
                uris.add(FileUtilities.getDirURI(root, helper));
            }
        }
        return uris.toArray(new URI[uris.size()]);
    }

    public URI getWebAppDirectory() {
        String prop = PluginPropertyUtils.getPluginProperty(this, "org.apache.maven.plugins", "maven-war-plugin", "warSourceDirectory", "war", null);
        prop = prop == null ? "src/main/webapp" : prop;
        return FileUtilities.getDirURI(this.getProjectDirectory(), prop);
    }

    public URI getSiteDirectory() {
        String prop = PluginPropertyUtils.getPluginProperty(this, "org.apache.maven.plugins", "maven-site-plugin", "siteDirectory", "site", null);
        prop = prop == null ? "src/site" : prop;
        return FileUtilities.getDirURI(this.getProjectDirectory(), prop);
    }

    public URI getEarAppDirectory() {
        String prop = PluginPropertyUtils.getPluginProperty(this, "org.apache.maven.plugins", "maven-ear-plugin", "earSourceDirectory", "ear", null);
        prop = prop == null ? "src/main/application" : prop;
        return FileUtilities.getDirURI(this.getProjectDirectory(), prop);
    }

    public URI[] getResources(boolean test) {
        ArrayList<URI> toRet = new ArrayList<URI>();
        List res = test ? this.getOriginalMavenProject().getTestResources() : this.getOriginalMavenProject().getResources();
        for (Resource elem : res) {
            String dir = elem.getDirectory();
            if (dir == null || elem.getTargetPath() != null) continue;
            URI uri = FileUtilities.getDirURI(this.getProjectDirectory(), dir);
            toRet.add(uri);
        }
        return toRet.toArray(new URI[toRet.size()]);
    }

    public File[] getOtherRoots(boolean test) {
        URI[] res;
        File[] fls;
        URI uri = FileUtilities.getDirURI(this.getProjectDirectory(), test ? "src/test" : "src/main");
        HashSet<File> toRet = new HashSet<File>();
        File fil = Utilities.toFile((URI)uri);
        if (fil.exists() && (fls = fil.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if ("java".equalsIgnoreCase(name) || "webapp".equalsIgnoreCase(name)) {
                    return false;
                }
                for (JavaLikeRootProvider rp : NbMavenProjectImpl.this.getLookup().lookupAll(JavaLikeRootProvider.class)) {
                    if (!rp.kind().equalsIgnoreCase(name)) continue;
                    return false;
                }
                return VisibilityQuery.getDefault().isVisible(new File(dir, name));
            }
        })) != null) {
            toRet.addAll(Arrays.asList(fls));
        }
        for (URI rs : res = this.getResources(test)) {
            File fl = Utilities.toFile((URI)rs);
            if (!fl.exists()) continue;
            toRet.add(fl);
        }
        return toRet.toArray(new File[0]);
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CopyResourcesOnSave getCopyOnSaveResources() {
        Object object = this.COPYRESOURCES_LOCK;
        synchronized (object) {
            if (this.copyResourcesOnSave == null) {
                this.copyResourcesOnSave = new CopyResourcesOnSave(this.watcher, this);
            }
            return this.copyResourcesOnSave;
        }
    }

    private Lookup createBasicLookup(ProjectState state, M2AuxilaryConfigImpl auxiliary) {
        return Lookups.fixed((Object[])new Object[]{this, this.fileObject, auxiliary, auxiliary.getProblemProvider(), this.auxprops, new MavenProjectPropsImpl.Merger(this.auxprops), this.profileHandler, this.configProvider, this.problemReporter, this.watcher, state, UILookupMergerSupport.createProjectOpenHookMerger(null), UILookupMergerSupport.createPrivilegedTemplatesMerger(), UILookupMergerSupport.createRecommendedTemplatesMerger(), UILookupMergerSupport.createProjectProblemsProviderMerger(), LookupProviderSupport.createSourcesMerger(), ProjectClassPathModifier.extenderForModifier((Project)this), LookupMergerSupport.createClassPathModifierMerger()});
    }

    public int hashCode() {
        return this.getProjectDirectory().hashCode() * 13;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Project) {
            return this.getProjectDirectory().equals(((Project)obj).getProjectDirectory());
        }
        return false;
    }

    public String toString() {
        return "Maven[" + this.fileObject.getPath() + "]";
    }

    static {
        Class<NbMavenProject> c = NbMavenProject.class;
        try {
            Class.forName(c.getName(), true, c.getClassLoader());
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "very wrong, very wrong, yes indeed", ex);
        }
    }

    private class Updater
    implements FileChangeListener {
        private String[] filesToWatch;
        private long lastTime = 0L;
        private FileObject folder;
        private final FileChangeListener listener = FileUtil.weakFileChangeListener((FileChangeListener)this, null);

        Updater(String ... toWatch) {
            Arrays.sort(toWatch);
            this.filesToWatch = toWatch;
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
            String nameExt;
            if (!fileEvent.getFile().isFolder() && Arrays.binarySearch(this.filesToWatch, nameExt = fileEvent.getFile().getNameExt()) != -1 && this.lastTime < fileEvent.getTime()) {
                this.lastTime = System.currentTimeMillis();
                NbMavenProject.fireMavenProjectReload(NbMavenProjectImpl.this);
            }
        }

        public void fileDataCreated(FileEvent fileEvent) {
            String nameExt;
            if (fileEvent.getFile().isFolder() && Arrays.binarySearch(this.filesToWatch, nameExt = fileEvent.getFile().getNameExt()) != -1 && this.lastTime < fileEvent.getTime()) {
                this.lastTime = System.currentTimeMillis();
                fileEvent.getFile().addFileChangeListener((FileChangeListener)this);
                NbMavenProject.fireMavenProjectReload(NbMavenProjectImpl.this);
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
            if (!fileEvent.getFile().isFolder()) {
                this.lastTime = System.currentTimeMillis();
                fileEvent.getFile().removeFileChangeListener((FileChangeListener)this);
                NbMavenProject.fireMavenProjectReload(NbMavenProjectImpl.this);
            }
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
        }

        void attachAll(FileObject fo) {
            if (fo != null) {
                this.folder = fo;
                fo.addFileChangeListener(this.listener);
                for (String file : this.filesToWatch) {
                    FileObject fobj = fo.getFileObject(file);
                    if (fobj == null) continue;
                    fobj.addFileChangeListener(this.listener);
                }
            }
        }

        void detachAll() {
            if (this.folder != null) {
                this.folder.removeFileChangeListener(this.listener);
                for (String file : this.filesToWatch) {
                    FileObject fobj = this.folder.getFileObject(file);
                    if (fobj == null) continue;
                    fobj.removeFileChangeListener(this.listener);
                }
                this.folder = null;
            }
        }
    }

    private static class PackagingTypeDependentLookup
    extends ProxyLookup
    implements PropertyChangeListener {
        private final NbMavenProject watcher;
        private String packaging;
        private final Lookup general;

        PackagingTypeDependentLookup(NbMavenProject watcher) {
            this.watcher = watcher;
            this.general = Lookups.forPath((String)"Projects/org-netbeans-modules-maven/Lookup");
            this.check();
            watcher.addPropertyChangeListener(this);
        }

        private void check() {
            String newPackaging = this.watcher.getPackagingType();
            if (newPackaging == null) {
                newPackaging = "jar";
            }
            if (!newPackaging.equals(this.packaging)) {
                this.packaging = newPackaging;
                Lookup pack = Lookups.forPath((String)("Projects/org-netbeans-modules-maven/" + this.packaging + "/Lookup"));
                this.setLookups(new Lookup[]{this.general, pack});
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (NbMavenProjectImpl.PROP_PROJECT.equals(evt.getPropertyName())) {
                this.check();
            }
        }
    }

    public static abstract class WatcherAccessor {
        public abstract NbMavenProject createWatcher(NbMavenProjectImpl var1);

        public abstract void doFireReload(NbMavenProject var1);
    }
}

