/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.scenebuilder.impl;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.netbeans.modules.javafx2.scenebuilder.Home;
import org.netbeans.modules.javafx2.scenebuilder.HomeFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public class SBHomeFactory {
    private static final String PATH_DELIMITER = ";";
    private static final String VER_DELIMITER = "$ver$";
    private static final String EMPTY_STRING = "$empty$";
    private static final String DEFAULT_VERSION = "1.0";
    private static final List<String> VER_CURRENT = SBHomeFactory.tokenize(NbBundle.getMessage(SBHomeFactory.class, (String)"SB_Version"), ";");
    private static HomeFactory WINDOWS_HOME_LOCATOR = null;
    private static HomeFactory MAC_HOME_LOCATOR = null;
    private static HomeFactory UX_HOME_LOCATOR = null;

    public static HomeFactory getDefault() {
        if (Utilities.isWindows()) {
            return SBHomeFactory.getDefaultWindows();
        }
        if (Utilities.isMac()) {
            return SBHomeFactory.getDefaultMac();
        }
        return SBHomeFactory.getDefaultUx();
    }

    private static HomeFactory getDefaultWindows() {
        if (WINDOWS_HOME_LOCATOR == null) {
            WINDOWS_HOME_LOCATOR = new HomeFactoryCommon(SBHomeFactory.tokenize(NbBundle.getMessage(SBHomeFactory.class, (String)"WIN_WKIP"), PATH_DELIMITER), SBHomeFactory.tokenize(NbBundle.getMessage(SBHomeFactory.class, (String)"WIN_LAUNCHER"), PATH_DELIMITER), SBHomeFactory.tokenize(NbBundle.getMessage(SBHomeFactory.class, (String)"WIN_PROPERTIES"), PATH_DELIMITER));
        }
        return WINDOWS_HOME_LOCATOR;
    }

    private static HomeFactory getDefaultMac() {
        if (MAC_HOME_LOCATOR == null) {
            MAC_HOME_LOCATOR = new HomeFactoryCommon(SBHomeFactory.tokenize(NbBundle.getMessage(SBHomeFactory.class, (String)"MAC_WKIP"), PATH_DELIMITER), SBHomeFactory.tokenize(NbBundle.getMessage(SBHomeFactory.class, (String)"MAC_LAUNCHER"), PATH_DELIMITER), SBHomeFactory.tokenize(NbBundle.getMessage(SBHomeFactory.class, (String)"MAC_PROPERTIES"), PATH_DELIMITER));
        }
        return MAC_HOME_LOCATOR;
    }

    private static HomeFactory getDefaultUx() {
        if (UX_HOME_LOCATOR == null) {
            UX_HOME_LOCATOR = new HomeFactoryCommon(SBHomeFactory.tokenize(NbBundle.getMessage(SBHomeFactory.class, (String)"UX_WKIP"), PATH_DELIMITER), SBHomeFactory.tokenize(NbBundle.getMessage(SBHomeFactory.class, (String)"UX_LAUNCHER"), PATH_DELIMITER), SBHomeFactory.tokenize(NbBundle.getMessage(SBHomeFactory.class, (String)"UX_PROPERTIES"), PATH_DELIMITER));
        }
        return UX_HOME_LOCATOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Home getHomeForPath(String path, String launcherPath, String propertiesPath, String defaultVersion) throws PathDoesNotExist {
        File installDir;
        Parameters.notNull((CharSequence)"path", (Object)path);
        Parameters.notNull((CharSequence)"launcherPath", (Object)launcherPath);
        Parameters.notNull((CharSequence)"propertiesPath", (Object)propertiesPath);
        String homePath = path;
        if (path.startsWith("~")) {
            String userHome = System.getProperty("user.home");
            homePath = userHome + path.substring(1);
        }
        if ((installDir = new File(homePath)) != null && installDir.exists() && installDir.isDirectory()) {
            FileObject propertiesFO;
            FileObject installDirFO = FileUtil.toFileObject((File)installDir);
            File launcher = new File(homePath + File.separator + launcherPath);
            if (launcher != null && launcher.exists() && launcher.isFile() && (propertiesFO = installDirFO.getFileObject(propertiesPath)) != null && propertiesFO.isValid() && propertiesFO.isData()) {
                try {
                    Properties props = new Properties();
                    FileReader reader = new FileReader(FileUtil.toFile((FileObject)propertiesFO));
                    try {
                        props.load(reader);
                    }
                    finally {
                        reader.close();
                    }
                    String version = props.getProperty("version");
                    return new Home(homePath, launcherPath, propertiesPath, version == null ? defaultVersion : version);
                }
                catch (IOException e) {}
            }
        } else {
            throw new PathDoesNotExist();
        }
        return null;
    }

    private static List<String> tokenize(String sequence, String delimiter) {
        StringTokenizer st = new StringTokenizer(sequence, delimiter);
        ArrayList<String> r = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String next = st.nextToken();
            r.add(next.equals(EMPTY_STRING) ? "" : next);
        }
        return r;
    }

    private static final class PathDoesNotExist
    extends IOException {
        int code;

        PathDoesNotExist(int code) {
            this.code = code;
        }

        PathDoesNotExist() {
            this.code = 0;
        }

        int getCode() {
            return this.code;
        }
    }

    private static final class HomeFactoryCommon
    implements HomeFactory {
        private final List<String> WKIP;
        private final List<String> LAUNCHER_PATH;
        private final List<String> PROPERTIES_PATH;

        HomeFactoryCommon(List<String> WKIP, List<String> LAUNCHER_PATH, List<String> PROPERTIES_PATH) {
            Parameters.notNull((CharSequence)"WKIP", WKIP);
            Parameters.notNull((CharSequence)"LAUNCHER_PATH", LAUNCHER_PATH);
            Parameters.notNull((CharSequence)"PROPERTIES_PATH", PROPERTIES_PATH);
            this.WKIP = WKIP;
            this.LAUNCHER_PATH = LAUNCHER_PATH;
            this.PROPERTIES_PATH = PROPERTIES_PATH;
        }

        @Override
        public Home defaultHome() {
            Home h = null;
            for (String ver : VER_CURRENT) {
                for (String path : this.WKIP) {
                    h = this.loadHome(path.replace(SBHomeFactory.VER_DELIMITER, ver), ver);
                    if (h == null) continue;
                    return h;
                }
            }
            return h;
        }

        @Override
        public Home loadHome(String customPath) {
            return this.loadHome(customPath, SBHomeFactory.DEFAULT_VERSION);
        }

        private Home loadHome(String customPath, String defaultVersion) {
            Home h = null;
            for (String ver : VER_CURRENT) {
                for (String launcher : this.LAUNCHER_PATH) {
                    for (String props : this.PROPERTIES_PATH) {
                        try {
                            h = SBHomeFactory.getHomeForPath(customPath, launcher.replace(SBHomeFactory.VER_DELIMITER, ver), props.replace(SBHomeFactory.VER_DELIMITER, ver), defaultVersion.isEmpty() ? (ver.isEmpty() ? SBHomeFactory.DEFAULT_VERSION : ver) : defaultVersion);
                            if (h == null) continue;
                            return h;
                        }
                        catch (PathDoesNotExist e) {
                            return null;
                        }
                    }
                }
            }
            return null;
        }
    }
}

