/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.io.IOException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.core.api.support.classpath.ContainerClassPathModifier;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigUtilities;
import org.netbeans.modules.web.jsf.JSFFrameworkProvider;
import org.netbeans.modules.web.jsf.JSFUtils;
import org.netbeans.modules.web.jsf.wizards.Bundle;
import org.netbeans.modules.web.jsf.wizards.JSFValidationPanel;
import org.netbeans.modules.web.wizards.Utilities;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class FacesConfigIterator
implements TemplateWizard.Iterator {
    private static final Logger LOG = Logger.getLogger(FacesConfigIterator.class.getName());
    private static final String defaultName = "faces-config";
    private static final String FACES_CONFIG_PARAM = "javax.faces.CONFIG_FILES";
    private static final String INIT_PARAM = "InitParam";
    private static String RESOURCE_FOLDER = "org/netbeans/modules/web/jsf/resources/";
    private int index;
    private transient WizardDescriptor.Panel[] panels;

    public Set<DataObject> instantiate(TemplateWizard wizard) throws IOException {
        Project project = Templates.getProject((WizardDescriptor)wizard);
        String targetName = Templates.getTargetName((WizardDescriptor)wizard);
        FileObject targetDir = Templates.getTargetFolder((WizardDescriptor)wizard);
        FileObject fo = FacesConfigIterator.createFacesConfig(project, targetDir, targetName, true);
        if (fo != null) {
            return Collections.singleton(DataObject.find((FileObject)fo));
        }
        return Collections.EMPTY_SET;
    }

    public static FileObject createFacesConfig(Project project, FileObject targetDir, String targetName, boolean addJSFFrameworkIfNecessary) throws IOException {
        FileObject result = null;
        WebModule wm = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (wm != null) {
            boolean isDefaultLocation;
            FileObject docBase = wm.getDocumentBase();
            if (addJSFFrameworkIfNecessary) {
                ContainerClassPathModifier modifier;
                if (!JSFConfigUtilities.hasJsfFramework(docBase)) {
                    JSFConfigUtilities.extendJsfFramework(docBase, false);
                }
                if ((modifier = (ContainerClassPathModifier)project.getLookup().lookup(ContainerClassPathModifier.class)) != null) {
                    modifier.extendClasspath(targetDir, new String[]{"jsf-api"});
                }
            }
            String facesConfigTemplate = FacesConfigIterator.findFacesConfigTemplate(wm);
            String content = JSFFrameworkProvider.readResource(Thread.currentThread().getContextClassLoader().getResourceAsStream(RESOURCE_FOLDER + facesConfigTemplate), "UTF-8");
            result = FileUtil.createData((FileObject)targetDir, (String)(targetName + ".xml"));
            JSFFrameworkProvider.createFile(result, content, "UTF-8");
            FileObject dd = wm.getDeploymentDescriptor();
            FileObject webInf = wm.getWebInf();
            WebApp ddRoot = dd == null ? null : DDProvider.getDefault().getDDRoot(dd);
            boolean bl = isDefaultLocation = defaultName.equals(targetName) && targetDir == webInf;
            if (!isDefaultLocation && ddRoot != null) {
                try {
                    InitParam[] parameters = ddRoot.getContextParam();
                    boolean found = false;
                    int i = 0;
                    for (InitParam param : parameters) {
                        if (param.getParamName().equals(FACES_CONFIG_PARAM)) {
                            found = true;
                            String value = param.getParamValue() + ",\n            /" + FileUtil.getRelativePath((FileObject)wm.getDocumentBase(), (FileObject)targetDir) + "/" + targetName + ".xml";
                            ddRoot.removeContextParam(param);
                            InitParam newParameter = (InitParam)ddRoot.createBean(INIT_PARAM);
                            newParameter.setParamName(FACES_CONFIG_PARAM);
                            newParameter.setParamValue(value);
                            ddRoot.addContextParam(newParameter);
                            break;
                        }
                        ++i;
                    }
                    if (!found) {
                        InitParam contextParam = (InitParam)ddRoot.createBean(INIT_PARAM);
                        contextParam.setParamName(FACES_CONFIG_PARAM);
                        contextParam.setParamValue("/" + FileUtil.getRelativePath((FileObject)wm.getDocumentBase(), (FileObject)targetDir) + "/" + targetName + ".xml");
                        ddRoot.addContextParam(contextParam);
                    }
                    ddRoot.write(dd);
                }
                catch (ClassNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return result;
    }

    private static String findFacesConfigTemplate(WebModule wm) {
        Profile profile = wm.getJ2eeProfile();
        if (profile.equals(Profile.JAVA_EE_5) || profile.equals(Profile.JAVA_EE_6_FULL) || profile.equals(Profile.JAVA_EE_6_WEB)) {
            Library jsf20lib = LibraryManager.getDefault().getLibrary(JSFUtils.DEFAULT_JSF_2_0_NAME);
            Library jsf12lib = LibraryManager.getDefault().getLibrary(JSFUtils.DEFAULT_JSF_1_2_NAME);
            if (JSFUtils.isJSF21Plus(wm)) {
                return "faces-config_2_1.xml";
            }
            if (JSFUtils.isJSF20Plus(wm) || jsf20lib != null) {
                return "faces-config_2_0.xml";
            }
            if (JSFUtils.isJSF12Plus(wm) || jsf12lib != null) {
                return "faces-config_1_2.xml";
            }
        }
        return "faces-config.xml";
    }

    public void initialize(TemplateWizard wizard) {
        Project project = Templates.getProject((WizardDescriptor)wizard);
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        SourceGroup[] sourceGroups = sources.getSourceGroups("web_inf");
        if (sourceGroups == null || sourceGroups.length == 0) {
            sourceGroups = sources.getSourceGroups("doc_root");
        }
        if (sourceGroups == null || sourceGroups.length == 0) {
            sourceGroups = sources.getSourceGroups("generic");
        }
        FacesConfigValidationPanel folderPanel = new FacesConfigValidationPanel(Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroups));
        this.panels = new WizardDescriptor.Panel[]{folderPanel};
        Object prop = wizard.getProperty("WizardPanel_contentData");
        String[] beforeSteps = null;
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = Utilities.createSteps(beforeSteps, (WizardDescriptor.Panel[])this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            JComponent jc = (JComponent)this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = jc.getName();
            }
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
        WebModule wm = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (wm != null) {
            FileObject targetFolder;
            String relativePath;
            FileObject webInf = wm.getWebInf();
            if (webInf == null) {
                try {
                    FileObject documentBase = wm.getDocumentBase();
                    if (documentBase == null) {
                        LOG.log(Level.INFO, "WebModule does not have valid documentBase");
                        return;
                    }
                    webInf = FileUtil.createFolder((FileObject)documentBase, (String)"WEB-INF");
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            String string = relativePath = (targetFolder = Templates.getTargetFolder((WizardDescriptor)wizard)) == null ? null : FileUtil.getRelativePath((FileObject)webInf, (FileObject)targetFolder);
            if (relativePath == null) {
                Templates.setTargetFolder((WizardDescriptor)wizard, (FileObject)webInf);
            }
        }
        Templates.setTargetName((WizardDescriptor)wizard, (String)defaultName);
    }

    public void uninitialize(TemplateWizard wiz) {
        this.panels = null;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panels[this.index];
    }

    public String name() {
        return NbBundle.getMessage(FacesConfigIterator.class, (String)"TITLE_x_of_y", (Object)(this.index + 1), (Object)this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private static class FacesConfigValidationPanel
    extends JSFValidationPanel {
        public FacesConfigValidationPanel(WizardDescriptor.Panel delegate) {
            super(delegate);
        }

        @Override
        public boolean isValid() {
            if (!super.isValid()) {
                return false;
            }
            Project project = this.getProject();
            WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
            if (webModule != null && webModule.getDocumentBase() == null) {
                this.getWizardDescriptor().putProperty("WizardPanel_warningMessage", (Object)Bundle.FacesConfigIterator_err_no_document_base());
                return true;
            }
            return true;
        }
    }
}

