/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.refactoring;

import java.util.List;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.web.jsf.refactoring.JSFRefactoringUtils;
import org.netbeans.modules.web.jsf.refactoring.Occurrences;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class JSFSafeDeletePlugin
implements RefactoringPlugin {
    private static ThreadLocal semafor = new ThreadLocal();
    private TreePathHandle treePathHandle = null;
    private static final Logger LOGGER = Logger.getLogger(JSFSafeDeletePlugin.class.getName());
    private final SafeDeleteRefactoring refactoring;

    public JSFSafeDeletePlugin(SafeDeleteRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        if (semafor.get() == null) {
            FileObject folder;
            Project project;
            semafor.set(new Object());
            NonRecursiveFolder nonRecursivefolder = (NonRecursiveFolder)this.refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class);
            this.treePathHandle = (TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class);
            if (nonRecursivefolder != null && (project = FileOwnerQuery.getOwner((FileObject)(folder = nonRecursivefolder.getFolder()))) != null) {
                String packageName = JSFRefactoringUtils.getPackageName(folder);
                List<Occurrences.OccurrenceItem> items = Occurrences.getPackageOccurrences(project, packageName, packageName, false);
                for (Occurrences.OccurrenceItem item : items) {
                    refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new JSFSafeDeleteClassElement(item));
                }
            }
            if (this.treePathHandle != null && TreeUtilities.CLASS_TREE_KINDS.contains((Object)this.treePathHandle.getKind()) && (project = FileOwnerQuery.getOwner((FileObject)this.treePathHandle.getFileObject())) != null) {
                Element resElement = JSFRefactoringUtils.resolveElement((AbstractRefactoring)this.refactoring, this.treePathHandle);
                TypeElement type = (TypeElement)resElement;
                String fqcn = type.getQualifiedName().toString();
                List<Occurrences.OccurrenceItem> items = Occurrences.getAllOccurrences(project, fqcn, null);
                for (Occurrences.OccurrenceItem item : items) {
                    refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new JSFSafeDeleteClassElement(item));
                }
            }
            semafor.set(null);
        }
        return null;
    }

    public static class JSFSafeDeleteClassElement
    extends SimpleRefactoringElementImplementation {
        private final Occurrences.OccurrenceItem item;

        JSFSafeDeleteClassElement(Occurrences.OccurrenceItem item) {
            this.item = item;
        }

        public String getText() {
            return this.getDisplayText();
        }

        public String getDisplayText() {
            return this.item.getSafeDeleteMessage();
        }

        public void performChange() {
            try {
                this.item.performSafeDelete();
            }
            catch (IllegalStateException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public Lookup getLookup() {
            return Lookups.singleton((Object)this.item.getFacesConfig());
        }

        public FileObject getParentFile() {
            return this.item.getFacesConfig();
        }

        public PositionBounds getPosition() {
            return this.item.getChangePosition();
        }

        public void undoChange() {
            try {
                this.item.undoSafeDelete();
            }
            catch (IllegalStateException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

