/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.palette.items;

import java.awt.Dialog;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.j2ee.persistence.wizard.jpacontroller.JpaControllerUtil;
import org.netbeans.modules.web.jsf.palette.JSFPaletteUtilities;
import org.netbeans.modules.web.jsf.palette.items.EntityClass;
import org.netbeans.modules.web.jsf.palette.items.JsfLibrariesSupport;
import org.netbeans.modules.web.jsf.palette.items.ManagedBeanCustomizer;
import org.netbeans.modules.web.jsf.palette.items.PaletteUtils;
import org.netbeans.modules.web.jsfapi.api.DefaultLibraryInfo;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public abstract class FromEntityBase {
    private static final String ITEM_VAR = "item";
    private boolean readOnly = false;
    protected JsfLibrariesSupport jsfLibrariesSupport;
    private static final String INDENT = "            ";

    protected abstract boolean isCollectionComponent();

    protected abstract boolean showReadOnlyFormFlag();

    protected abstract String getDialogTitle();

    protected abstract String getTemplate();

    protected final boolean isReadOnlyForm() {
        return this.readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleTransfer(JTextComponent targetComponent) {
        Project p = null;
        FileObject fo = JSFPaletteUtilities.getFileObject(targetComponent);
        this.jsfLibrariesSupport = JsfLibrariesSupport.get(targetComponent);
        if (fo != null) {
            p = FileOwnerQuery.getOwner((FileObject)fo);
        }
        if (p == null) {
            return false;
        }
        ManagedBeanCustomizer mbc = new ManagedBeanCustomizer(p, this.isCollectionComponent(), this.showReadOnlyFormFlag());
        DialogDescriptor dd = new DialogDescriptor((Object)mbc, this.getDialogTitle(), true, 2, DialogDescriptor.OK_OPTION, 0, null, null);
        Dialog dlg = null;
        try {
            dlg = DialogDisplayer.getDefault().createDialog(dd);
            mbc.setDialog(dlg, dd);
            dlg.setVisible(true);
        }
        finally {
            if (dlg != null) {
                dlg.dispose();
            }
        }
        boolean accept = dd.getValue() == DialogDescriptor.OK_OPTION && !mbc.isCancelled();
        this.readOnly = mbc.isReadOnly();
        if (accept) {
            try {
                boolean containsFView = FromEntityBase.isInViewTag(targetComponent);
                String managedBean = mbc.getManagedBeanProperty();
                if (managedBean != null && managedBean.lastIndexOf(".") != -1) {
                    managedBean = managedBean.substring(0, managedBean.lastIndexOf("."));
                }
                String body = this.expandTemplate(targetComponent, !containsFView, FileEncodingQuery.getEncoding((FileObject)fo), mbc.getBeanClass(), managedBean, mbc.getManagedBeanProperty());
                JSFPaletteUtilities.insert(body, targetComponent);
                this.jsfLibrariesSupport.importLibraries(DefaultLibraryInfo.HTML);
                this.jsfLibrariesSupport.importLibraries(DefaultLibraryInfo.JSF_CORE);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
                accept = false;
            }
            catch (BadLocationException ble) {
                Exceptions.printStackTrace((Throwable)ble);
                accept = false;
            }
        }
        return accept;
    }

    public static boolean isInViewTag(JTextComponent targetComponent) {
        try {
            Caret caret = targetComponent.getCaret();
            int position0 = Math.min(caret.getDot(), caret.getMark());
            int position1 = Math.max(caret.getDot(), caret.getMark());
            int len = targetComponent.getDocument().getLength() - position1;
            return targetComponent.getText(0, position0).contains(PaletteUtils.createViewTag(targetComponent, false)) && targetComponent.getText(position1, len).contains(PaletteUtils.createViewTag(targetComponent, true));
        }
        catch (BadLocationException ble) {
            Exceptions.printStackTrace((Throwable)ble);
            return true;
        }
    }

    public void insert(JTextComponent component) {
        this.handleTransfer(component);
    }

    private String expandTemplate(JTextComponent target, boolean surroundWithFView, Charset encoding, String entityClass, String managedBean, String managedBeanProperty) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        if (surroundWithFView) {
            stringBuffer.append(PaletteUtils.createViewTag(target, false)).append("\n");
        }
        FileObject targetJspFO = EntityClass.getFO(target);
        Map<String, Object> params = FromEntityBase.createFieldParameters(targetJspFO, entityClass, managedBean, managedBeanProperty, this.isCollectionComponent(), false, this.jsfLibrariesSupport);
        FileObject tableTemplate = FileUtil.getConfigRoot().getFileObject(this.getTemplate());
        StringWriter w = new StringWriter();
        JSFPaletteUtilities.expandJSFTemplate(tableTemplate, params, encoding, w);
        stringBuffer.append(w.toString());
        if (surroundWithFView) {
            stringBuffer.append(PaletteUtils.createViewTag(target, true)).append("\n");
        }
        return stringBuffer.toString();
    }

    public static Map<String, Object> createFieldParameters(FileObject targetJspFO, final String entityClass, String managedBean, final String managedBeanProperty, final boolean collectionComponent, final boolean initValueGetters, JsfLibrariesSupport jls) throws IOException {
        final HashMap<String, Object> params = new HashMap<String, Object>();
        JavaSource javaSource = JavaSource.create((ClasspathInfo)EntityClass.createClasspathInfo(targetJspFO), (FileObject[])new FileObject[0]);
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController controller) throws IOException {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = controller.getElements().getTypeElement(entityClass);
                FromEntityBase.enumerateEntityFields(params, controller, typeElement, managedBeanProperty, collectionComponent, initValueGetters);
            }
        }, true);
        params.put("managedBean", managedBean);
        params.put("managedBeanProperty", managedBeanProperty);
        String entityName = entityClass;
        if (entityName.lastIndexOf(".") != -1) {
            entityName = entityName.substring(entityClass.lastIndexOf(".") + 1);
        }
        params.put("entityName", entityName);
        if (jls != null) {
            params.put("htmlTagPrefix", jls.getLibraryPrefix(DefaultLibraryInfo.HTML));
            params.put("coreTagPrefix", jls.getLibraryPrefix(DefaultLibraryInfo.JSF_CORE));
        }
        return params;
    }

    private static void enumerateEntityFields(Map<String, Object> params, CompilationController controller, TypeElement bean, String managedBeanProperty, boolean collectionComponent, boolean initValueGetters) {
        ArrayList<TemplateData> templateData = new ArrayList<TemplateData>();
        ArrayList<FieldDesc> fields = new ArrayList<FieldDesc>();
        if (bean != null) {
            ExecutableElement[] methods = JpaControllerUtil.getEntityMethods((TypeElement)bean);
            JpaControllerUtil.EmbeddedPkSupport embeddedPkSupport = null;
            for (ExecutableElement method : methods) {
                FieldDesc fd;
                if (JpaControllerUtil.findAnnotation((Element)method, (String)"javax.persistence.Transient") != null || !(fd = new FieldDesc(controller, method, bean, initValueGetters)).isValid()) continue;
                int relationship = fd.getRelationship();
                if (EntityClass.isId(method, fd.isFieldAccess())) {
                    fd.setPrimaryKey();
                    TypeMirror rType = method.getReturnType();
                    if (TypeKind.DECLARED == rType.getKind()) {
                        DeclaredType rTypeDeclared = (DeclaredType)rType;
                        TypeElement rTypeElement = (TypeElement)rTypeDeclared.asElement();
                        if (JpaControllerUtil.isEmbeddableClass((TypeElement)rTypeElement)) {
                            if (embeddedPkSupport == null) {
                                embeddedPkSupport = new JpaControllerUtil.EmbeddedPkSupport();
                            }
                            String propName = fd.getPropertyName();
                            for (ExecutableElement pkMethod : embeddedPkSupport.getPkAccessorMethods(bean)) {
                                if (embeddedPkSupport.isRedundantWithRelationshipField(bean, pkMethod)) continue;
                                String pkMethodName = pkMethod.getSimpleName().toString();
                                fd = new FieldDesc(controller, pkMethod, bean);
                                fd.setLabel(pkMethodName.substring(3));
                                fd.setPropertyName(propName + "." + JpaControllerUtil.getPropNameFromMethod((String)pkMethodName));
                                fields.add(fd);
                            }
                            continue;
                        }
                        fields.add(fd);
                        continue;
                    }
                    fields.add(fd);
                    continue;
                }
                if (fd.getDateTimeFormat().length() > 0) {
                    fields.add(fd);
                    continue;
                }
                if (relationship != 0 && relationship != 1) continue;
                fields.add(fd);
            }
        }
        FromEntityBase.processFields(params, templateData, controller, bean, fields, managedBeanProperty, collectionComponent);
        params.put("entityDescriptors", templateData);
        params.put(ITEM_VAR, ITEM_VAR);
        params.put("comment", Boolean.FALSE);
    }

    private static ExecutableElement findPrimaryKeyGetter(CompilationController controller, TypeElement bean) {
        ExecutableElement[] methods;
        for (ExecutableElement method : methods = JpaControllerUtil.getEntityMethods((TypeElement)bean)) {
            FieldDesc fd = new FieldDesc(controller, method, bean, false);
            if (!fd.isValid() || !EntityClass.isId(method, fd.isFieldAccess())) continue;
            return method;
        }
        return null;
    }

    private static void processFields(Map<String, Object> params, List<TemplateData> templateData, CompilationController controller, TypeElement bean, List<FieldDesc> fields, String managedBeanProperty, boolean collectionComponent) {
        for (FieldDesc fd : fields) {
            templateData.add(new TemplateData(fd, (collectionComponent ? ITEM_VAR : managedBeanProperty) + "."));
        }
    }

    public static void createParamsForConverterTemplate(final Map<String, Object> params, FileObject targetJspFO, final String entityClass, final JpaControllerUtil.EmbeddedPkSupport embeddedPkSupport) throws IOException {
        JavaSource javaSource = JavaSource.create((ClasspathInfo)EntityClass.createClasspathInfo(targetJspFO), (FileObject[])new FileObject[0]);
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController controller) throws IOException {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = controller.getElements().getTypeElement(entityClass);
                FromEntityBase.createParamsForConverterTemplate((Map<String, Object>)params, controller, typeElement, embeddedPkSupport);
            }
        }, true);
    }

    private static void createParamsForConverterTemplate(Map<String, Object> params, CompilationController controller, TypeElement bean, JpaControllerUtil.EmbeddedPkSupport embeddedPkSupport) throws IOException {
        ExecutableElement primaryGetter = FromEntityBase.findPrimaryKeyGetter(controller, bean);
        StringBuffer key = new StringBuffer();
        StringBuffer stringKey = new StringBuffer();
        String keyBodyValue = null;
        String keyStringBodyValue = null;
        String keyGetterValue = "UNDEFINED_PK_GETTER";
        String keyTypeValue = "UNDEFINED_PK_TYPE";
        Boolean keyEmbeddedValue = Boolean.FALSE;
        Boolean keyDerivedValue = Boolean.FALSE;
        EmbeddedDesc embeddedField = null;
        if (primaryGetter != null) {
            String keyTypeFQN;
            TypeMirror idType = primaryGetter.getReturnType();
            ExecutableElement primaryGetterDerived = null;
            if (TypeKind.DECLARED == idType.getKind()) {
                DeclaredType declaredType = (DeclaredType)idType;
                TypeElement idClass = (TypeElement)declaredType.asElement();
                boolean embeddable = idClass != null && JpaControllerUtil.isEmbeddableClass((TypeElement)idClass);
                boolean isDirevideId = false;
                if (!embeddable && JpaControllerUtil.haveId((TypeElement)idClass)) {
                    boolean bl = isDirevideId = JpaControllerUtil.isRelationship((ExecutableElement)primaryGetter, (boolean)JpaControllerUtil.isFieldAccess((TypeElement)idClass)) != 0;
                }
                if (isDirevideId) {
                    primaryGetterDerived = FromEntityBase.findPrimaryKeyGetter(controller, idClass);
                    if (primaryGetterDerived != null) {
                        idType = primaryGetterDerived.getReturnType();
                        if (TypeKind.DECLARED == idType.getKind()) {
                            declaredType = (DeclaredType)idType;
                            idClass = (TypeElement)declaredType.asElement();
                            embeddable = idClass != null && JpaControllerUtil.isEmbeddableClass((TypeElement)idClass);
                        }
                    } else {
                        idClass = null;
                    }
                }
                if (idClass != null) {
                    String keyType = idClass.getSimpleName().toString();
                    keyTypeFQN = idClass.getQualifiedName().toString();
                    if (embeddable) {
                        keyEmbeddedValue = Boolean.TRUE;
                        int index = 0;
                        Set methods = embeddedPkSupport.getPkAccessorMethods(bean);
                        for (ExecutableElement pkMethod : methods) {
                            if (!embeddedPkSupport.isRedundantWithRelationshipField(bean, pkMethod)) continue;
                            embeddedField = new EmbeddedDesc("s" + pkMethod.getSimpleName().toString().substring(1), embeddedPkSupport.getCodeToPopulatePkField(bean, pkMethod));
                        }
                        for (ExecutableElement method : ElementFilter.methodsIn(idClass.getEnclosedElements())) {
                            if (!method.getSimpleName().toString().startsWith("set")) continue;
                            FromEntityBase.addParam(key, stringKey, method.getSimpleName().toString(), index, keyType, keyTypeFQN, method.getParameters().get(0).asType());
                            ++index;
                        }
                        if (index == 0) {
                            key.append(NbBundle.getMessage(FromEntityBase.class, (String)"ERR_NO_SETTERS", (Object[])new String[]{INDENT, keyTypeFQN, "Converter.getKey()"}));
                            stringKey.append(NbBundle.getMessage(FromEntityBase.class, (String)"ERR_NO_SETTERS", (Object[])new String[]{INDENT, keyTypeFQN, "Converter.getKey()"}));
                        }
                    } else {
                        FromEntityBase.addParam(key, stringKey, null, -1, keyType, keyTypeFQN, idType);
                    }
                } else {
                    keyTypeFQN = null;
                }
            } else {
                String keyType;
                keyTypeFQN = keyType = ((Object)idType).toString();
                FromEntityBase.addParam(key, stringKey, null, -1, keyType, keyTypeFQN, idType);
            }
            if (keyTypeFQN != null) {
                keyTypeValue = keyTypeFQN;
                if (key.toString().endsWith("\n")) {
                    key.setLength(key.length() - 1);
                }
                keyBodyValue = key.toString();
                if (stringKey.toString().endsWith("\n")) {
                    stringKey.setLength(stringKey.length() - 1);
                }
                keyStringBodyValue = stringKey.toString();
                keyGetterValue = primaryGetter.getSimpleName().toString() + (primaryGetterDerived != null ? "()." + primaryGetterDerived.getSimpleName().toString() : "");
            }
        }
        params.put("keyBody", keyBodyValue != null ? keyBodyValue : NbBundle.getMessage(FromEntityBase.class, (String)"ERR_NO_GETTERS", (Object[])new String[]{INDENT, bean.getQualifiedName().toString(), "Converter.getKey()"}));
        params.put("keyStringBody", keyStringBodyValue != null ? keyStringBodyValue : NbBundle.getMessage(FromEntityBase.class, (String)"ERR_NO_GETTERS", (Object[])new String[]{INDENT, bean.getQualifiedName().toString(), "Converter.getKey()"}));
        params.put("keyGetter", keyGetterValue);
        params.put("keySetter", "s" + keyGetterValue.substring(1));
        params.put("keyType", keyTypeValue);
        params.put("keyEmbedded", keyEmbeddedValue);
        params.put("keyDerived", keyDerivedValue);
        params.put("embeddedIdField", embeddedField);
    }

    private static void addParam(StringBuffer key, StringBuffer stringKey, String setter, int index, String keyType, String keyTypeFQN, TypeMirror idType) {
        if (index == 0) {
            key.append("            String values[] = value.split(SEPARATOR_ESCAPED);\n");
            key.append("            key = new " + keyTypeFQN + "();\n");
        }
        if (index > 0) {
            stringKey.append("            sb.append(SEPARATOR);\n");
        }
        String conversion = FromEntityBase.getConversionFromString(idType, index, keyType);
        if (setter != null) {
            key.append("            key." + setter + "(" + conversion + ");\n");
            stringKey.append("            sb.append(value.g" + setter.substring(1) + "());\n");
        } else {
            key.append("            key = " + conversion + ";\n");
            stringKey.append("            sb.append(value);\n");
        }
    }

    private static String getConversionFromString(TypeMirror idType, int index, String keyType) {
        String param;
        String string = param = index == -1 ? "value" : "values[" + index + "]";
        if (TypeKind.BOOLEAN == idType.getKind()) {
            return "Boolean.parseBoolean(" + param + ")";
        }
        if (TypeKind.BYTE == idType.getKind()) {
            return "Byte.parseByte(" + param + ")";
        }
        if (TypeKind.CHAR == idType.getKind()) {
            return param + ".charAt(0)";
        }
        if (TypeKind.DOUBLE == idType.getKind()) {
            return "Double.parseDouble(" + param + ")";
        }
        if (TypeKind.FLOAT == idType.getKind()) {
            return "Float.parseFloat(" + param + ")";
        }
        if (TypeKind.INT == idType.getKind()) {
            return "Integer.parseInt(" + param + ")";
        }
        if (TypeKind.LONG == idType.getKind()) {
            return "Long.parseLong(" + param + ")";
        }
        if (TypeKind.SHORT == idType.getKind()) {
            return "Short.parseShort(" + param + ")";
        }
        if (TypeKind.DECLARED == idType.getKind()) {
            if ("Boolean".equals(((Object)idType).toString()) || "java.lang.Boolean".equals(((Object)idType).toString())) {
                return "Boolean.valueOf(" + param + ")";
            }
            if ("Byte".equals(((Object)idType).toString()) || "java.lang.Byte".equals(((Object)idType).toString())) {
                return "Byte.valueOf(" + param + ")";
            }
            if ("Character".equals(((Object)idType).toString()) || "java.lang.Character".equals(((Object)idType).toString())) {
                return "new Character(" + param + ".charAt(0))";
            }
            if ("Double".equals(((Object)idType).toString()) || "java.lang.Double".equals(((Object)idType).toString())) {
                return "Double.valueOf(" + param + ")";
            }
            if ("Float".equals(((Object)idType).toString()) || "java.lang.Float".equals(((Object)idType).toString())) {
                return "Float.valueOf(" + param + ")";
            }
            if ("Integer".equals(((Object)idType).toString()) || "java.lang.Integer".equals(((Object)idType).toString())) {
                return "Integer.valueOf(" + param + ")";
            }
            if ("Long".equals(((Object)idType).toString()) || "java.lang.Long".equals(((Object)idType).toString())) {
                return "Long.valueOf(" + param + ")";
            }
            if ("Short".equals(((Object)idType).toString()) || "java.lang.Short".equals(((Object)idType).toString())) {
                return "Short.valueOf(" + param + ")";
            }
            if ("BigDecimal".equals(((Object)idType).toString()) || "java.math.BigDecimal".equals(((Object)idType).toString())) {
                return "new java.math.BigDecimal(" + param + ")";
            }
            if ("Date".equals(((Object)idType).toString()) || "java.util.Date".equals(((Object)idType).toString())) {
                return "java.sql.Date.valueOf(" + param + ")";
            }
        }
        return param;
    }

    public static final class EmbeddedDesc {
        private final String embeddedSetter;
        private final String codeToPopulate;

        public EmbeddedDesc(String embeddedSetter, String codeToPopulate) {
            this.embeddedSetter = embeddedSetter;
            this.codeToPopulate = codeToPopulate;
        }

        public String getEmbeddedSetter() {
            return this.embeddedSetter;
        }

        public String getCodeToPopulate() {
            return this.codeToPopulate;
        }
    }

    public static final class TemplateData {
        private FieldDesc fd;
        private String prefix;

        private TemplateData(FieldDesc fd, String prefix) {
            this.fd = fd;
            this.prefix = prefix;
        }

        public String getLabel() {
            return this.fd.getLabel();
        }

        public String getName() {
            return this.prefix + this.fd.getPropertyName();
        }

        public String getDateTimeFormat() {
            return this.fd.getDateTimeFormat();
        }

        public boolean isBlob() {
            return this.fd.isBlob();
        }

        public boolean isRelationshipOne() {
            return this.fd.getRelationship() == 1;
        }

        public boolean isRelationshipMany() {
            return this.fd.getRelationship() == 2;
        }

        public String getId() {
            return this.fd.getPropertyName();
        }

        public boolean isRequired() {
            return this.fd.isRequired();
        }

        public String getValuesGetter() {
            return this.fd.getValuesGetter();
        }

        public String toString() {
            return "TemplateData[fd=" + this.fd + ",prefix=" + this.prefix + "]";
        }
    }

    public static final class FieldDesc {
        private ExecutableElement method;
        private String methodName;
        private String propertyName;
        private String label;
        private Boolean fieldAccess = null;
        private Integer relationship = null;
        private TypeElement bean;
        private CompilationController controller;
        private String dateTimeFormat = null;
        private String valuesGetter = "fixme";
        private boolean primaryKey;

        private FieldDesc(CompilationController controller, ExecutableElement method, TypeElement bean, boolean enableValueGetters) {
            this(controller, method, bean);
            if (enableValueGetters) {
                this.valuesGetter = null;
            }
        }

        private FieldDesc(CompilationController controller, ExecutableElement method, TypeElement bean) {
            this.controller = controller;
            this.method = method;
            this.bean = bean;
            this.methodName = method.getSimpleName().toString();
            this.label = this.methodName.substring(3);
            this.propertyName = JpaControllerUtil.getPropNameFromMethod((String)this.getMethodName());
        }

        public boolean isPrimaryKey() {
            return this.primaryKey;
        }

        public void setPrimaryKey() {
            this.primaryKey = true;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        private boolean isFieldAccess() {
            if (this.fieldAccess == null) {
                this.fieldAccess = JpaControllerUtil.isFieldAccess((TypeElement)this.bean);
            }
            return this.fieldAccess;
        }

        public boolean isValid() {
            return this.getMethodName().startsWith("get");
        }

        public int getRelationship() {
            if (this.relationship == null) {
                this.relationship = JpaControllerUtil.isRelationship((ExecutableElement)this.method, (boolean)this.isFieldAccess());
            }
            return this.relationship;
        }

        public String getDateTimeFormat() {
            if (this.dateTimeFormat == null) {
                String temporal;
                this.dateTimeFormat = "";
                TypeMirror dateTypeMirror = this.controller.getElements().getTypeElement("java.util.Date").asType();
                if (this.controller.getTypes().isSameType(dateTypeMirror, this.method.getReturnType()) && (temporal = EntityClass.getTemporal(this.method, this.isFieldAccess())) != null) {
                    this.dateTimeFormat = EntityClass.getDateTimeFormat(temporal);
                }
            }
            return this.dateTimeFormat;
        }

        private boolean isBlob() {
            Element fieldElement;
            Element element = fieldElement = this.isFieldAccess() ? JpaControllerUtil.guessField((ExecutableElement)this.method) : this.method;
            if (fieldElement == null) {
                fieldElement = this.method;
            }
            return JpaControllerUtil.isAnnotatedWith((Element)fieldElement, (String)"javax.persistence.Lob");
        }

        public String toString() {
            return "Field[methodName=" + this.getMethodName() + ",propertyName=" + this.getPropertyName() + ",label=" + this.label + ",valid=" + this.isValid() + ",field=" + this.isFieldAccess() + ",relationship=" + this.getRelationship() + ",datetime=" + this.getDateTimeFormat() + ",valuesGetter=" + this.getValuesGetter() + "]";
        }

        private String getRelationClassName(CompilationController controller, ExecutableElement executableElement, boolean isFieldAccess) {
            TypeMirror passedReturnType = executableElement.getReturnType();
            if (TypeKind.DECLARED != passedReturnType.getKind() || !(passedReturnType instanceof DeclaredType)) {
                return null;
            }
            Types types = controller.getTypes();
            TypeMirror passedReturnTypeStripped = JpaControllerUtil.stripCollection((TypeMirror)((DeclaredType)passedReturnType), (Types)types);
            if (passedReturnTypeStripped == null) {
                return null;
            }
            TypeElement passedReturnTypeStrippedElement = (TypeElement)types.asElement(passedReturnTypeStripped);
            return passedReturnTypeStrippedElement.getSimpleName().toString();
        }

        public String getValuesGetter() {
            if (this.getRelationship() == 0) {
                return null;
            }
            if (this.valuesGetter == null) {
                String name = this.getRelationClassName(this.controller, this.method, this.isFieldAccess());
                if (name == null) {
                    this.valuesGetter = "";
                } else {
                    name = name.substring(0, 1).toLowerCase() + name.substring(1);
                    this.valuesGetter = name + "Controller." + (this.getRelationship() == 1 ? "itemsAvailableSelectOne" : "itemsAvailableSelectMany");
                }
            }
            return this.valuesGetter;
        }

        private boolean isRequired() {
            return !JpaControllerUtil.isFieldOptionalAndNullable((ExecutableElement)this.method, (boolean)this.isFieldAccess());
        }
    }
}

