/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class JSFUtils {
    private static final String LIB_FOLDER = "lib";
    public static String DEFAULT_JSF_1_1_NAME = "jsf1102";
    public static String DEFAULT_JSF_1_2_NAME = "jsf12";
    public static String DEFAULT_JSF_2_0_NAME = "jsf20";
    public static String DEFAULT_JSF_1_2_RI_NAME = "jsf12ri";
    public static String DEFAULT_JSF_2_0_RI_NAME = "jsf20ri";
    public static String DEFAULT_JSTL_1_1_NAME = "jstl11";
    public static final String FACES_EXCEPTION = "javax.faces.FacesException";
    public static final String JSF_1_2__API_SPECIFIC_CLASS = "javax.faces.application.StateManagerWrapper";
    public static final String JSF_2_0__API_SPECIFIC_CLASS = "javax.faces.application.ProjectStage";
    public static final String JSF_2_1__API_SPECIFIC_CLASS = "javax.faces.component.TransientStateHelper";
    public static final String JSF_2_0__IMPL_SPECIFIC_CLASS = "com.sun.faces.facelets.Facelet";
    public static final String MYFACES_SPECIFIC_CLASS = "org.apache.myfaces.webapp.StartupServletContextListener";
    protected static final String FACELETS_SKIPCOMMNETS = "javax.faces.FACELETS_SKIP_COMMENTS";
    protected static final String FACELETS_DEVELOPMENT = "facelets.DEVELOPMENT";
    protected static final String FACELETS_DEFAULT_SUFFIX = "javax.faces.DEFAULT_SUFFIX";
    public static final String FACES_PROJECT_STAGE = "javax.faces.PROJECT_STAGE";
    private static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.web.jsf");

    public static String isJSFLibraryResource(File resource) {
        String result = null;
        boolean isJSF = false;
        if (!resource.exists()) {
            result = NbBundle.getMessage(JSFUtils.class, (String)"ERROR_IS_NOT_VALID_PATH", (Object)resource.getPath());
        }
        if (resource.isDirectory()) {
            File libFolder = new File(resource, LIB_FOLDER);
            if (libFolder.exists()) {
                File[] files = libFolder.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        boolean accepted = false;
                        if (pathname.getName().endsWith(".jar")) {
                            accepted = true;
                        }
                        return accepted;
                    }
                });
                try {
                    List<File> list = Arrays.asList(files);
                    isJSF = Util.containsClass(list, (String)FACES_EXCEPTION);
                }
                catch (IOException exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            } else {
                result = NbBundle.getMessage(JSFUtils.class, (String)"ERROR_THERE_IS_NOT_LIB_FOLDER", (Object)resource.getPath());
            }
        } else {
            try {
                isJSF = Util.containsClass(Collections.singletonList(resource), (String)FACES_EXCEPTION);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (!isJSF) {
            result = NbBundle.getMessage(JSFUtils.class, (String)"ERROR_IS_NOT_JSF_API", (Object)resource.getPath());
        }
        return result;
    }

    public static boolean createJSFUserLibrary(File resource, String libraryName) throws IOException {
        if (!resource.exists()) {
            return false;
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        if (resource.isDirectory()) {
            File libFolder = new File(resource, LIB_FOLDER);
            if (libFolder.isDirectory()) {
                File[] jars = libFolder.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.getName().endsWith(".jar");
                    }
                });
                for (int i = 0; i < jars.length; ++i) {
                    URL url = FileUtil.urlForArchiveOrDir((File)jars[i]);
                    if (url == null) continue;
                    urls.add(url);
                }
            }
        } else {
            urls.add(FileUtil.urlForArchiveOrDir((File)resource));
        }
        HashMap<String, ArrayList<URL>> content = new HashMap<String, ArrayList<URL>>();
        content.put("classpath", urls);
        LibraryManager.getDefault().createLibrary("j2se", libraryName, libraryName, libraryName, content);
        return true;
    }

    public static boolean debugFacelets(FileObject dd) {
        boolean value = false;
        if (dd != null) {
            try {
                WebApp webApp = DDProvider.getDefault().getDDRoot(dd);
                InitParam param = null;
                if (webApp != null) {
                    param = (InitParam)webApp.findBeanByName("InitParam", "ParamName", FACELETS_DEVELOPMENT);
                }
                if (param != null) {
                    value = "true".equals(param.getParamValue().trim());
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return value;
    }

    public static boolean skipCommnets(FileObject dd) {
        boolean value = false;
        if (dd != null) {
            try {
                WebApp webApp = DDProvider.getDefault().getDDRoot(dd);
                InitParam param = null;
                if (webApp != null) {
                    param = (InitParam)webApp.findBeanByName("InitParam", "ParamName", "facelets.SKIP_COMMENTS");
                }
                if (param != null) {
                    value = "true".equals(param.getParamValue().trim());
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return value;
    }

    public static String getRelativePath(FileObject fromFO, FileObject toFO) {
        String path = "./";
        String tmpPath = null;
        for (FileObject parent = fromFO.getParent(); parent != null && (tmpPath = FileUtil.getRelativePath((FileObject)parent, (FileObject)toFO)) == null; parent = parent.getParent()) {
            path = path + "../";
        }
        return tmpPath != null ? path + tmpPath : null;
    }

    public static boolean isJSF12Plus(WebModule webModule) {
        return JSFUtils.isJSFPlus(webModule, JSF_1_2__API_SPECIFIC_CLASS);
    }

    public static boolean isJSF20Plus(WebModule webModule) {
        return JSFUtils.isJSFPlus(webModule, JSF_2_0__API_SPECIFIC_CLASS);
    }

    public static boolean isJSF21Plus(WebModule webModule) {
        return JSFUtils.isJSFPlus(webModule, JSF_2_1__API_SPECIFIC_CLASS);
    }

    private static boolean isJSFPlus(WebModule webModule, String versionSpecificClass) {
        if (webModule == null) {
            return false;
        }
        ClassPath compileCP = ClassPath.getClassPath((FileObject)webModule.getDocumentBase(), (String)"classpath/compile");
        if (compileCP != null) {
            return compileCP.findResource(versionSpecificClass.replace('.', '/') + ".class") != null;
        }
        return false;
    }

    public static boolean isJavaEE5(TemplateWizard wizard) {
        Project project = Templates.getProject((WizardDescriptor)wizard);
        WebModule wm = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (wm != null) {
            Profile profile = wm.getJ2eeProfile();
            return profile == Profile.JAVA_EE_5;
        }
        return false;
    }

    public static boolean isCDIEnabled(WebModule wm) {
        FileObject confRoot;
        return wm != null && (confRoot = wm.getWebInf()) != null && confRoot.getFileObject("beans.xml") != null;
    }

    public static void logUsage(Class srcClass, String message, Object[] params) {
        Parameters.notNull((CharSequence)"message", (Object)message);
        LogRecord logRecord = new LogRecord(Level.INFO, message);
        logRecord.setLoggerName(USG_LOGGER.getName());
        logRecord.setResourceBundle(NbBundle.getBundle((Class)srcClass));
        logRecord.setResourceBundleName(srcClass.getPackage().getName() + ".Bundle");
        if (params != null) {
            logRecord.setParameters(params);
        }
        USG_LOGGER.log(logRecord);
    }

    public static FileObject getFileObject(WebModule module) {
        FileObject fileObject = module.getDocumentBase();
        if (fileObject != null) {
            return fileObject;
        }
        fileObject = module.getDeploymentDescriptor();
        if (fileObject != null) {
            return fileObject;
        }
        fileObject = module.getWebInf();
        if (fileObject != null) {
            return fileObject;
        }
        FileObject[] facesConfigFiles = ConfigurationUtils.getFacesConfigFiles(module);
        if (facesConfigFiles != null && facesConfigFiles.length > 0) {
            return facesConfigFiles[0];
        }
        FileObject[] fileObjects = module.getJavaSources();
        if (fileObjects != null) {
            for (FileObject source : fileObjects) {
                if (source == null) continue;
                return source;
            }
        }
        return null;
    }
}

