/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.dfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.storage.dfs.DfsOutputStream;
import org.eclipse.jgit.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.storage.dfs.DfsPackFile;
import org.eclipse.jgit.storage.dfs.DfsReader;
import org.eclipse.jgit.storage.dfs.DfsRepository;
import org.eclipse.jgit.storage.file.PackIndex;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.storage.pack.PackWriter;
import org.eclipse.jgit.util.BlockList;
import org.eclipse.jgit.util.io.CountingOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfsPackCompactor {
    private final DfsRepository repo;
    private final List<DfsPackFile> srcPacks;
    private final List<DfsPackDescription> newPacks;
    private final List<PackWriter.Statistics> newStats;
    private int autoAddSize;

    public DfsPackCompactor(DfsRepository repository) {
        this.repo = repository;
        this.autoAddSize = 0x500000;
        this.srcPacks = new ArrayList<DfsPackFile>();
        this.newPacks = new ArrayList<DfsPackDescription>(1);
        this.newStats = new ArrayList<PackWriter.Statistics>(1);
    }

    public DfsPackCompactor add(DfsPackFile pack) {
        this.srcPacks.add(pack);
        return this;
    }

    public DfsPackCompactor autoAdd() throws IOException {
        DfsObjDatabase objdb = this.repo.getObjectDatabase();
        for (DfsPackFile pack : objdb.getPacks()) {
            DfsPackDescription d = pack.getPackDescription();
            if (d.getPackSize() >= (long)this.autoAddSize) continue;
            this.add(pack);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compact(ProgressMonitor pm) throws IOException {
        if (pm == null) {
            pm = NullProgressMonitor.INSTANCE;
        }
        DfsObjDatabase objdb = this.repo.getObjectDatabase();
        DfsReader ctx = (DfsReader)objdb.newReader();
        try {
            PackWriter pw;
            block12: {
                block13: {
                    PackConfig pc = new PackConfig(this.repo);
                    pc.setIndexVersion(2);
                    pc.setDeltaCompress(false);
                    pc.setReuseDeltas(true);
                    pc.setReuseObjects(true);
                    pw = new PackWriter(pc, (ObjectReader)ctx);
                    try {
                        pw.setDeltaBaseAsOffset(true);
                        pw.setReuseDeltaCommits(false);
                        this.addObjectsToPack(pw, ctx, pm);
                        if (pw.getObjectCount() != 0L) break block12;
                        Object var12_6 = null;
                        if (pw == null) break block13;
                        pw.release();
                    }
                    catch (Throwable throwable) {
                        Object var12_8 = null;
                        if (pw != null) {
                            pw.release();
                        }
                        throw throwable;
                    }
                }
                Object var14_9 = null;
                ctx.release();
                return;
            }
            boolean rollback = true;
            DfsPackDescription pack = objdb.newPack(DfsObjDatabase.PackSource.COMPACT);
            try {
                this.writePack(objdb, pack, pw, pm);
                this.writeIndex(objdb, pack, pw);
                PackWriter.Statistics stats = pw.getStatistics();
                pw.release();
                pw = null;
                pack.setPackStats(stats);
                objdb.commitPack(Collections.singletonList(pack), this.toPrune());
                this.newPacks.add(pack);
                this.newStats.add(stats);
                rollback = false;
                Object var10_15 = null;
                if (rollback) {
                    objdb.rollbackPack(Collections.singletonList(pack));
                }
            }
            catch (Throwable throwable) {
                Object var10_16 = null;
                if (rollback) {
                    objdb.rollbackPack(Collections.singletonList(pack));
                }
                throw throwable;
            }
            Object var12_7 = null;
            if (pw != null) {
                pw.release();
            }
        }
        catch (Throwable throwable) {
            Object var14_11 = null;
            ctx.release();
            throw throwable;
        }
        Object var14_10 = null;
        ctx.release();
    }

    public List<DfsPackDescription> getSourcePacks() {
        return this.toPrune();
    }

    public List<DfsPackDescription> getNewPacks() {
        return this.newPacks;
    }

    public List<PackWriter.Statistics> getNewPackStatistics() {
        return this.newStats;
    }

    private List<DfsPackDescription> toPrune() {
        int cnt = this.srcPacks.size();
        ArrayList<DfsPackDescription> all = new ArrayList<DfsPackDescription>(cnt);
        for (DfsPackFile pack : this.srcPacks) {
            all.add(pack.getPackDescription());
        }
        return all;
    }

    private void addObjectsToPack(PackWriter pw, DfsReader ctx, ProgressMonitor pm) throws IOException, IncorrectObjectTypeException {
        Collections.sort(this.srcPacks, new Comparator<DfsPackFile>(){

            @Override
            public int compare(DfsPackFile a, DfsPackFile b) {
                return a.getPackDescription().compareTo(b.getPackDescription());
            }
        });
        RevWalk rw = new RevWalk(ctx);
        RevFlag added = rw.newFlag("ADDED");
        pm.beginTask(JGitText.get().countingObjects, 0);
        for (DfsPackFile src : this.srcPacks) {
            RevObject obj;
            BlockList want = new BlockList();
            for (PackIndex.MutableEntry ent : src.getPackIndex(ctx)) {
                ObjectId id = ent.toObjectId();
                obj = rw.lookupOrNull(id);
                if (obj != null && obj.has(added)) continue;
                want.add(new ObjectIdWithOffset(id, ent.getOffset()));
            }
            Collections.sort(want, new Comparator<ObjectIdWithOffset>(){

                @Override
                public int compare(ObjectIdWithOffset a, ObjectIdWithOffset b) {
                    return Long.signum(a.offset - b.offset);
                }
            });
            for (ObjectIdWithOffset id : want) {
                int type;
                obj = rw.lookupAny(id, type = src.getObjectType(ctx, id.offset));
                if (obj.has(added)) continue;
                pm.update(1);
                pw.addObject(obj);
                obj.add(added);
            }
        }
        pm.endTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePack(DfsObjDatabase objdb, DfsPackDescription pack, PackWriter pw, ProgressMonitor pm) throws IOException {
        DfsOutputStream out = objdb.writePackFile(pack);
        try {
            CountingOutputStream cnt = new CountingOutputStream(out);
            pw.writePack(pm, pm, cnt);
            pack.setObjectCount(pw.getObjectCount());
            pack.setPackSize(cnt.getCount());
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            out.close();
            throw throwable;
        }
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIndex(DfsObjDatabase objdb, DfsPackDescription pack, PackWriter pw) throws IOException {
        DfsOutputStream out = objdb.writePackIndex(pack);
        try {
            CountingOutputStream cnt = new CountingOutputStream(out);
            pw.writeIndex(cnt);
            pack.setIndexSize(cnt.getCount());
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            out.close();
            throw throwable;
        }
        out.close();
    }

    private static class ObjectIdWithOffset
    extends ObjectId {
        final long offset;

        ObjectIdWithOffset(AnyObjectId id, long ofs) {
            super(id);
            this.offset = ofs;
        }
    }
}

