/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.refactoring;

import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.ProgressProviderAdapter;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.wsitconf.refactoring.WSITRenamePackagePlugin;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.WSITModelSupport;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

abstract class WSITRefactoringPlugin<T extends AbstractRefactoring>
extends ProgressProviderAdapter
implements RefactoringPlugin {
    protected static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.websvc.wsitconf.refactoring");
    protected static final String WS_ANNOTATION = "javax.xml.ws.WebService";
    protected static final String WSDL_LOCATION_ELEMENT = "wsdlLocation";
    protected final T refactoring;
    protected final TreePathHandle[] treePathHandle;

    public WSITRefactoringPlugin(T refactoring) {
        this.refactoring = refactoring;
        this.treePathHandle = refactoring.getRefactoringSource().lookupAll(TreePathHandle.class).toArray(new TreePathHandle[0]);
        LOGGER.log(Level.FINE, "refactoring: " + refactoring.getClass().getName() + "; refactoring sources: " + Arrays.asList(this.treePathHandle));
    }

    public void cancelRequest() {
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem prepare(final RefactoringElementsBag refactoringElements) {
        LOGGER.log(Level.FINE, "prepare()");
        Problem result = null;
        ClasspathInfo cpInfo = this.getClasspathInfo();
        JavaSource source = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{this.treePathHandle[0].getFileObject()});
        this.fireProgressListenerStart(3, 5);
        try {
            source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public void run(CompilationController info) throws Exception {
                    info.toPhase(JavaSource.Phase.RESOLVED);
                    block10: for (TreePathHandle tph : WSITRefactoringPlugin.this.treePathHandle) {
                        Element el = tph.resolveElement((CompilationInfo)info);
                        if (el == null) {
                            return;
                        }
                        switch (el.getKind()) {
                            case METHOD: {
                                ElementHandle elh = ElementHandle.create((Element)el);
                                FileObject file = SourceUtils.getFile((ElementHandle)elh, (ClasspathInfo)info.getClasspathInfo());
                                if (file == null) {
                                    ErrorManager.getDefault().log(1, "WSIT: Null instance returned from SourceUtils.getFile; element not found " + el);
                                    return;
                                }
                                WSITRefactoringPlugin.this.fireProgressListenerStep();
                                Element javaClass = el.getEnclosingElement();
                                if (WSITRefactoringPlugin.isWebSvcFromWsdl(javaClass)) {
                                    return;
                                }
                                WSITRefactoringPlugin.this.fireProgressListenerStep();
                                JAXWSSupport supp = JAXWSSupport.getJAXWSSupport((FileObject)file);
                                if (supp == null) {
                                    return;
                                }
                                WSITRefactoringPlugin.this.fireProgressListenerStep();
                                Project p = FileOwnerQuery.getOwner((FileObject)file);
                                if (p == null) {
                                    return;
                                }
                                WSDLModel model = null;
                                try {
                                    model = WSITModelSupport.getModelForServiceFromJava(file, p, false, null);
                                }
                                catch (IOException ex) {
                                    ex.printStackTrace();
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                                WSITRefactoringPlugin.this.fireProgressListenerStep();
                                if (model == null) {
                                    return;
                                }
                                refactoringElements.add(WSITRefactoringPlugin.this.refactoring, WSITRefactoringPlugin.this.createMethodRE(el.getSimpleName().toString(), model));
                                WSITRefactoringPlugin.this.fireProgressListenerStep();
                                continue block10;
                            }
                            case CLASS: 
                            case INTERFACE: 
                            case ANNOTATION_TYPE: 
                            case ENUM: {
                                ElementHandle elh = ElementHandle.create((Element)el);
                                FileObject file = SourceUtils.getFile((ElementHandle)elh, (ClasspathInfo)info.getClasspathInfo());
                                if (file == null) {
                                    ErrorManager.getDefault().log(1, "WSIT: Null instance returned from SourceUtils.getFile; element not found " + el);
                                    return;
                                }
                                WSITRefactoringPlugin.this.fireProgressListenerStep();
                                if (WSITRefactoringPlugin.isWebSvcFromWsdl(el)) {
                                    return;
                                }
                                WSITRefactoringPlugin.this.fireProgressListenerStep();
                                JAXWSSupport supp = JAXWSSupport.getJAXWSSupport((FileObject)file);
                                if (supp == null) {
                                    return;
                                }
                                WSDLModel model = null;
                                WSITRefactoringPlugin.this.fireProgressListenerStep();
                                Project p = FileOwnerQuery.getOwner((FileObject)file);
                                if (p == null) {
                                    return;
                                }
                                try {
                                    model = WSITModelSupport.getModelForServiceFromJava(file, p, false, null);
                                }
                                catch (IOException ex) {
                                    ex.printStackTrace();
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                                WSITRefactoringPlugin.this.fireProgressListenerStep();
                                if (model == null) {
                                    return;
                                }
                                refactoringElements.addFileChange(WSITRefactoringPlugin.this.refactoring, WSITRefactoringPlugin.this.createClassRE(model));
                                WSITRefactoringPlugin.this.fireProgressListenerStep();
                                continue block10;
                            }
                        }
                    }
                }
            }, true);
        }
        catch (IOException ioe) {
            throw (RuntimeException)new RuntimeException().initCause(ioe);
        }
        finally {
            this.fireProgressListenerStop();
        }
        return result;
    }

    protected abstract RefactoringElementImplementation createMethodRE(String var1, WSDLModel var2);

    protected abstract RefactoringElementImplementation createClassRE(WSDLModel var1);

    protected final ClasspathInfo getClasspathInfo() {
        return (ClasspathInfo)this.refactoring.getContext().lookup(ClasspathInfo.class);
    }

    protected static boolean isWebSvcFromWsdl(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!WS_ANNOTATION.equals(((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName())) continue;
            for (ExecutableElement executableElement : annotationMirror.getElementValues().keySet()) {
                if (!WSDL_LOCATION_ELEMENT.equals(executableElement.getSimpleName().toString())) continue;
                return true;
            }
        }
        return false;
    }

    protected static Problem createProblem(Problem result, boolean isFatal, String message) {
        Problem problem = new Problem(isFatal, message);
        if (result == null) {
            return problem;
        }
        if (isFatal) {
            problem.setNext(result);
            return problem;
        }
        Problem p = result;
        while (p.getNext() != null) {
            p = p.getNext();
        }
        p.setNext(problem);
        return result;
    }

    protected static class AbstractRenameConfigElement
    extends AbstractRefactoringElement {
        private String oldConfigName;
        private String newConfigName;

        AbstractRenameConfigElement(String oldName, String newName, WSDLModel model) {
            super(model);
            this.setOldConfigName(oldName);
            this.setNewConfigName(newName);
        }

        AbstractRenameConfigElement(WSDLModel model) {
            super(model);
        }

        public String getDisplayText() {
            return NbBundle.getMessage(WSITRenamePackagePlugin.class, (String)"TXT_WsitXmlClassRename", (Object)this.oldConfigName, (Object)this.newConfigName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void performChange() {
            FileLock lock = null;
            FileObject parentFile = this.getParentFile();
            try {
                lock = parentFile.lock();
                parentFile.rename(lock, this.newConfigName, this.getParentFile().getExt());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void undoChange() {
            FileLock lock = null;
            FileObject parentFile = this.getParentFile();
            try {
                lock = parentFile.lock();
                parentFile.rename(lock, this.oldConfigName, this.getParentFile().getExt());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        }

        protected void setOldConfigName(String oldName) {
            this.oldConfigName = oldName;
        }

        protected void setNewConfigName(String newName) {
            this.newConfigName = newName;
        }
    }

    protected static abstract class AbstractRefactoringElement
    extends SimpleRefactoringElementImplementation {
        protected final WSDLModel model;
        protected final FileObject file;

        public AbstractRefactoringElement(WSDLModel model) {
            this.model = model;
            this.file = Util.getFOForModel(model);
        }

        public String getText() {
            return this.getDisplayText();
        }

        public FileObject getParentFile() {
            return this.file;
        }

        public PositionBounds getPosition() {
            return null;
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }
    }
}

