/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.design;

import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.design.configuration.WSConfiguration;
import org.netbeans.modules.websvc.wsitconf.api.DesignerListenerProvider;
import org.netbeans.modules.websvc.wsitconf.design.ConfigRunnable;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.WSITModelSupport;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RMConfiguration
implements WSConfiguration {
    private Service service;
    private DataObject implementationFile;
    private Project project;
    private ArrayList<PropertyChangeListener> listeners = new ArrayList();
    private Collection<FileObject> createdFiles = new LinkedList<FileObject>();
    private Binding binding;
    private ComponentListener cl;
    private boolean clAdded = false;
    private PropertyChangeListener configCreationListener = null;

    public RMConfiguration(final Service service, final FileObject implementationFile) {
        try {
            this.service = service;
            this.implementationFile = DataObject.find((FileObject)implementationFile);
            this.project = FileOwnerQuery.getOwner((FileObject)implementationFile);
            this.binding = WSITModelSupport.getBinding(service, implementationFile, this.project, false, this.createdFiles);
            this.cl = new ComponentListener(){

                private void update() {
                    boolean enabled = RMModelHelper.getInstance(PolicyModelHelper.getConfigVersion((WSDLComponent)RMConfiguration.this.binding)).isRMEnabled((WSDLComponent)RMConfiguration.this.binding);
                    for (PropertyChangeListener pcl : RMConfiguration.this.listeners) {
                        PropertyChangeEvent pce = new PropertyChangeEvent(RMConfiguration.this, "value", null, enabled);
                        pcl.propertyChange(pce);
                    }
                }

                public void valueChanged(ComponentEvent evt) {
                    this.update();
                }

                public void childrenAdded(ComponentEvent evt) {
                    this.update();
                }

                public void childrenDeleted(ComponentEvent evt) {
                    this.update();
                }
            };
            if (this.binding != null) {
                this.addCListener(this.binding);
            } else {
                this.configCreationListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        RMConfiguration.this.binding = WSITModelSupport.getBinding(service, implementationFile, RMConfiguration.this.project, false, RMConfiguration.this.createdFiles);
                        RMConfiguration.this.addCListener(RMConfiguration.this.binding);
                        RMConfiguration.this.cl.valueChanged(null);
                    }
                };
                DesignerListenerProvider.registerListener(this.configCreationListener);
            }
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private synchronized void addCListener(Binding binding) {
        if (!this.clAdded && binding != null) {
            binding.getModel().addComponentListener(this.cl);
            this.clAdded = true;
        }
    }

    public Component getComponent() {
        return null;
    }

    public String getDescription() {
        return NbBundle.getMessage(RMConfiguration.class, (String)"DesignConfigPanel.rmCB.text");
    }

    public Image getIcon() {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/websvc/wsitconf/resources/designer-rm.gif");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(RMConfiguration.class, (String)"DesignConfigPanel.rmCB.text");
    }

    public boolean isSet() {
        if (this.binding != null) {
            boolean enabled = RMModelHelper.getInstance(PolicyModelHelper.getConfigVersion((WSDLComponent)this.binding)).isRMEnabled((WSDLComponent)this.binding);
            return enabled;
        }
        return false;
    }

    public void set() {
        this.switchIt(true);
    }

    public void unset() {
        this.switchIt(false);
    }

    private void switchIt(final boolean enable) {
        final ConfigRunnable r = new ConfigRunnable();
        SwingUtilities.invokeLater(r);
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    RMConfiguration.this.binding = WSITModelSupport.getBinding(RMConfiguration.this.service, RMConfiguration.this.implementationFile.getPrimaryFile(), RMConfiguration.this.project, true, RMConfiguration.this.createdFiles);
                    if (RMConfiguration.this.binding == null) {
                        return;
                    }
                    RMConfiguration.this.binding.getModel().addComponentListener(RMConfiguration.this.cl);
                    ConfigVersion cfgVersion = PolicyModelHelper.getConfigVersion((WSDLComponent)RMConfiguration.this.binding);
                    RMModelHelper rmh = RMModelHelper.getInstance(cfgVersion);
                    boolean rmStatus = rmh.isRMEnabled((WSDLComponent)RMConfiguration.this.binding);
                    if (rmStatus != enable) {
                        rmh.enableRM(RMConfiguration.this.binding, enable);
                        WSITModelSupport.save((WSDLComponent)RMConfiguration.this.binding);
                    }
                }
                finally {
                    r.stop();
                }
            }
        });
    }

    public void registerListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void finalize() {
        if (this.binding != null) {
            this.binding.getModel().removeComponentListener(this.cl);
        }
    }

    public boolean isEnabled() {
        return true;
    }
}

