/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.undo.UndoManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.websvc.api.wseditor.WSEditor;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.wsitconf.spi.WsitProvider;
import org.netbeans.modules.websvc.wsitconf.ui.ErrorTopComponent;
import org.netbeans.modules.websvc.wsitconf.ui.client.ClientTopComponent;
import org.netbeans.modules.websvc.wsitconf.ui.service.ServiceTopComponent;
import org.netbeans.modules.websvc.wsitconf.util.UndoManagerHolder;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.MavenWSITModelSupport;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.WSITModelSupport;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class MavenWSITEditor
implements WSEditor,
UndoManagerHolder {
    private static final Logger logger = Logger.getLogger(MavenWSITEditor.class.getName());
    private JAXWSLightSupport jaxWsSupport;
    private JaxWsService jaxWsService;
    private Project project;
    private UndoManager undoManager;
    private Collection<FileObject> createdFiles = new LinkedList<FileObject>();
    boolean isClient = false;

    public MavenWSITEditor(JAXWSLightSupport jaxWsSupport, JaxWsService jaxService, Project project) {
        this.jaxWsSupport = jaxWsSupport;
        this.jaxWsService = jaxService;
        this.project = project;
    }

    public String getTitle() {
        return NbBundle.getMessage(MavenWSITEditor.class, (String)"QOS_EDITOR_TITLE");
    }

    public JComponent createWSEditorComponent(Node node) {
        boolean bl = this.isClient = !this.jaxWsService.isServiceProvider();
        if (this.project != null) {
            try {
                WSDLModel wsdlModel = MavenWSITModelSupport.getModel(node, this.project, this.jaxWsSupport, this.jaxWsService, this, true, this.createdFiles);
                if (this.isClient) {
                    WSDLModel clientWsdlModel = MavenWSITModelSupport.getModel(node, this.project, this.jaxWsSupport, this.jaxWsService, this, true, this.createdFiles);
                    wsdlModel = MavenWSITModelSupport.getServiceModelForClient(this.jaxWsSupport, this.jaxWsService);
                    return new ClientTopComponent(this.jaxWsSupport, this.jaxWsService, clientWsdlModel, wsdlModel, node);
                }
                return new ServiceTopComponent(node, this.jaxWsService, wsdlModel, this.getUndoManager());
            }
            catch (Exception e) {
                logger.log(Level.INFO, null, e);
            }
        }
        return new ErrorTopComponent(NbBundle.getMessage(MavenWSITEditor.class, (String)"TXT_WSIT_NotSupported"));
    }

    public void save(Node node) {
        if (node == null) {
            return;
        }
        try {
            WSDLModel model = MavenWSITModelSupport.getModel(node, this.project, this.jaxWsSupport, this.jaxWsService, this, false, this.createdFiles);
            if (model != null) {
                WSITModelSupport.save(model);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, null, e);
        }
    }

    public void cancel(Node node) {
        FileObject clientConfigFolder;
        WSDLModel mainModel;
        Project p;
        FileObject srcRoot;
        if (node == null) {
            return;
        }
        WSDLModel model = null;
        if (this.isClient && (srcRoot = (FileObject)node.getLookup().lookup(FileObject.class)) != null && (p = FileOwnerQuery.getOwner((FileObject)srcRoot)) != null && (mainModel = WSITModelSupport.getMainClientModel(clientConfigFolder = MavenWSITEditor.getClientConfigFolder(p))) != null) {
            Collection imports = mainModel.getDefinitions().getImports();
            for (Import i : imports) {
                try {
                    WSDLModel importedModel = i.getImportedWSDLModel();
                    ModelSource importedms = importedModel.getModelSource();
                    FileObject importedfo = Utilities.getFileObject((ModelSource)importedms);
                    mainModel.startTransaction();
                    if (this.createdFiles.contains(importedfo)) {
                        mainModel.getDefinitions().removeImport(i);
                    }
                    mainModel.endTransaction();
                    FileObject mainFO = Utilities.getFileObject((ModelSource)mainModel.getModelSource());
                    if (mainFO == null) {
                        logger.log(Level.INFO, "Cannot find fileobject in lookup for: " + mainModel.getModelSource());
                    }
                    try {
                        DataObject mainDO = DataObject.find((FileObject)mainFO);
                        if (mainDO == null || !mainDO.isModified()) continue;
                        SaveCookie wsdlSaveCookie = (SaveCookie)mainDO.getCookie(SaveCookie.class);
                        if (wsdlSaveCookie != null) {
                            wsdlSaveCookie.save();
                        }
                        mainDO.setModified(false);
                    }
                    catch (IOException ioe) {
                    }
                }
                catch (IllegalStateException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
                catch (CatalogModelException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
        }
        try {
            model = MavenWSITModelSupport.getModel(node, this.project, this.jaxWsSupport, this.jaxWsService, this, false, this.createdFiles);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (model != null) {
            try {
                if (this.getUndoManager() != null) {
                    while (this.getUndoManager().canUndo()) {
                        this.getUndoManager().undo();
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.INFO, null, e);
            }
            FileObject fo = Utilities.getFileObject((ModelSource)model.getModelSource());
            DataObject dO = null;
            try {
                dO = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            if (dO != null) {
                try {
                    model.sync();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
                dO.setModified(false);
                dO.setModified(true);
                dO.setModified(false);
            }
        }
        if (this.createdFiles != null && this.createdFiles.size() > 0) {
            for (FileObject fo : this.createdFiles) {
                if (fo == null) continue;
                try {
                    DataObject dO = DataObject.find((FileObject)fo);
                    if (dO == null) continue;
                    dO.delete();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static FileObject getClientConfigFolder(Project p) {
        WsitProvider wsitProvider = (WsitProvider)p.getLookup().lookup(WsitProvider.class);
        if (wsitProvider != null) {
            return wsitProvider.getConfigFilesFolder(true);
        }
        FileObject folder = null;
        Sources sources = ProjectUtils.getSources((Project)p);
        if (sources == null) {
            return null;
        }
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        if (sourceGroups != null && sourceGroups.length > 0) {
            folder = sourceGroups[0].getRootFolder();
            if (folder != null) {
                folder = folder.getFileObject("META-INF");
            }
            if (folder == null || !folder.isValid()) {
                try {
                    folder = sourceGroups[0].getRootFolder().createFolder("META-INF");
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
        }
        return folder;
    }

    @Override
    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public void setUndoManager(UndoManager undoManager) {
        this.undoManager = undoManager;
    }

    public String getDescription() {
        return NbBundle.getMessage(MavenWSITEditor.class, (String)"WSIT_CONFIG_DESC");
    }
}

