/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.utils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.debugger.common2.utils.Catalog;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.windows.WindowManager;

public class IpeUtils {
    private static Document errorDoc = null;
    private static Dialog errorDialog = null;

    public static String getMime(DataObject dob) {
        FileObject primaryFile = dob == null ? null : dob.getPrimaryFile();
        String mime = primaryFile == null ? "" : primaryFile.getMIMEType();
        return mime;
    }

    public static String normalizePath(String path, FileSystem fs) {
        if (path == null) {
            return null;
        }
        try {
            return FileSystemProvider.getCanonicalPath((FileSystem)fs, (String)path);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String stripSuffix(String path) {
        int dotx = path.lastIndexOf(46);
        if (dotx == -1) {
            return path;
        }
        if (dotx == 0) {
            return "";
        }
        return path.substring(0, dotx);
    }

    public static String quoteIfNecessary(String s) {
        int n = s.length();
        if (n == 0) {
            return s;
        }
        if (s.charAt(0) == '\"' || s.charAt(n - 1) == '\"') {
            return s;
        }
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c != ' ' && c != '\t' && c != '*' && c != '[' && c != ']' && c != '.' && c != '(' && c != ')') continue;
            return '\"' + s + '\"';
        }
        return s;
    }

    public static String unquoteIfNecessary(String s) {
        if (s.charAt(0) == '\"') {
            s = s.substring(1);
        }
        if (s.charAt(s.length() - 1) == '\"') {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static int boolCompare(boolean x, boolean y) {
        if (x == y) {
            return 0;
        }
        if (x) {
            return 1;
        }
        return -1;
    }

    public static boolean sameString(String a, String b, int size) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        String c = new String(a);
        String d = new String(b);
        if (a.length() > size) {
            c = c.substring(0, size);
        }
        if (b.length() > size) {
            d = d.substring(0, size);
        }
        return c.equals(d);
    }

    public static boolean sameString(String a, String b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean sameStringArray(String[] a, String[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int x = 0; x < a.length; ++x) {
            if (IpeUtils.sameString(a[x], b[x])) continue;
            return false;
        }
        return true;
    }

    public static String[] cloneStringArray(String[] array) {
        if (array == null) {
            return null;
        }
        String[] clone = new String[array.length];
        System.arraycopy(array, 0, clone, 0, array.length);
        return clone;
    }

    public static void requestFocus(final Component c) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (c != null && c.getParent() != null) {
                    try {
                        c.requestFocus();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public static Window getWindowForComponent(Component parent) {
        if (parent == null) {
            return WindowManager.getDefault().getMainWindow();
        }
        if (parent instanceof Frame || parent instanceof Dialog) {
            return (Window)parent;
        }
        return IpeUtils.getWindowForComponent(parent.getParent());
    }

    public static JDialog createDialog(Component parent, String title, JComponent content) {
        Window window = IpeUtils.getWindowForComponent(parent);
        JDialog dialog = window instanceof Frame ? new JDialog((Frame)window, title, true) : new JDialog((Dialog)window, title, true);
        Container contentPane = dialog.getContentPane();
        contentPane.add((Component)content, "Center");
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        return dialog;
    }

    public static void postError(String error) {
        JTextArea textArea = null;
        if (errorDoc == null) {
            textArea = new JTextArea();
            errorDoc = textArea.getDocument();
        }
        try {
            errorDoc.insertString(errorDoc.getLength(), error, null);
        }
        catch (BadLocationException x) {
            // empty catch block
        }
        assert (SwingUtilities.isEventDispatchThread());
        if (errorDialog == null) {
            JPanel ev = new JPanel();
            ev.setLayout(new BorderLayout());
            textArea.setEditable(false);
            textArea.setWrapStyleWord(true);
            textArea.setLineWrap(true);
            textArea.setBackground((Color)UIManager.getDefaults().get("Label.background"));
            textArea.setBorder(BorderFactory.createEmptyBorder());
            JScrollPane scrollPane = new JScrollPane(textArea);
            scrollPane.setVerticalScrollBarPolicy(20);
            scrollPane.setHorizontalScrollBarPolicy(30);
            ev.setPreferredSize(new Dimension(500, 100));
            ev.add((Component)scrollPane, "Center");
            Catalog.setAccessibleName(textArea, "ACSN_DebuggerErrorDialogTxt");
            Catalog.setAccessibleDescription(textArea, "ACSD_DebuggerErrorDialogTxt");
            DialogDescriptor descriptor = new DialogDescriptor((Object)ev, Catalog.get("DebuggerError"));
            descriptor.setOptionsAlign(0);
            descriptor.setModal(false);
            descriptor.setMessageType(0);
            descriptor.setOptions(new Object[]{DialogDescriptor.OK_OPTION});
            ActionListener errorListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (event.getSource() == DialogDescriptor.OK_OPTION || event.getSource() == NotifyDescriptor.CLOSED_OPTION) {
                        errorDialog.dispose();
                        errorDialog = null;
                        errorDoc = null;
                        return;
                    }
                }
            };
            descriptor.setButtonListener(errorListener);
            errorDialog = DialogDisplayer.getDefault().createDialog(descriptor);
            Catalog.setAccessibleDescription(errorDialog, "ACSD_DebuggerErrorDialog");
            errorDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent p1) {
                    errorDialog = null;
                    errorDoc = null;
                }
            });
            errorDialog.setVisible(true);
        }
    }
}

