/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.remote;

import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineType;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineTypeManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Host;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public final class CndRemote {
    private static final RequestProcessor validatorRP = new RequestProcessor("validator");

    private CndRemote() {
    }

    public static void validate(String name, Runnable continuation) {
        CndRemote.validate(name, continuation, null);
    }

    public static void validate(final String name, final Runnable continuation, final Runnable onError) {
        if (name != null && name.equals("localhost")) {
            continuation.run();
            return;
        }
        Runnable validator = new Runnable(){

            @Override
            public void run() {
                Host host = Host.byName(name);
                ServerRecord serverRecord = ServerList.get((ExecutionEnvironment)host.executionEnvironment());
                serverRecord.validate(true);
                if (!serverRecord.isOnline()) {
                    this.showErrorDialog(serverRecord);
                    if (onError != null) {
                        try {
                            SwingUtilities.invokeAndWait(onError);
                        }
                        catch (Exception x) {
                            ErrorManager.getDefault().notify((Throwable)x);
                        }
                    }
                    return;
                }
                ExecutionEnvironment exEnv = serverRecord.getExecutionEnvironment();
                CompilerSetManager csm = CompilerSetManager.get((ExecutionEnvironment)exEnv);
                csm.initialize(true, true, null);
                PlatformInfo.getDefault((ExecutionEnvironment)exEnv);
                try {
                    SwingUtilities.invokeAndWait(continuation);
                }
                catch (Exception x) {
                    ErrorManager.getDefault().notify((Throwable)x);
                    this.showErrorDialog(serverRecord);
                }
            }

            private void showErrorDialog(ServerRecord serverRecord) {
                final String message = MessageFormat.format(Catalog.get("ERR_Cant_Cnnect"), serverRecord.getDisplayName());
                final String title = Catalog.get("DLG_TITLE_Cant_Connect");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), message, title, 0);
                    }
                });
            }
        };
        RequestProcessor.Task task = validatorRP.post(validator);
    }

    public static String[] getServerListIDs() {
        ArrayList<String> l = new ArrayList<String>();
        for (ExecutionEnvironment env : ServerList.getEnvironments()) {
            l.add(ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env));
        }
        return l.toArray(new String[l.size()]);
    }

    public static String userhostFromConfiguration(Configuration conf) {
        if (!(conf instanceof MakeConfiguration)) {
            return "localhost";
        }
        MakeConfiguration makeConfiguration = (MakeConfiguration)conf;
        DevelopmentHostConfiguration hostConfig = makeConfiguration.getDevelopmentHost();
        return ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)hostConfig.getExecutionEnvironment());
    }

    private static EngineType getDebuggerType(CompilerSet cs) {
        Tool debuggerTool = cs.getTool((ToolKind)PredefinedToolKind.DebuggerTool);
        if (debuggerTool != null) {
            ToolchainManager.DebuggerDescriptor descriptor = (ToolchainManager.DebuggerDescriptor)debuggerTool.getDescriptor();
            return EngineTypeManager.getEngineTypeForDebuggerDescriptor(descriptor);
        }
        return null;
    }

    public static void fillConfigurationFromHost(Configuration conf, EngineType engine, Host host) {
        MakeConfiguration makeConfiguration = (MakeConfiguration)conf;
        if (!makeConfiguration.isMakefileConfiguration()) {
            return;
        }
        DevelopmentHostConfiguration hostConfig = makeConfiguration.getDevelopmentHost();
        ExecutionEnvironment exEnv = host.executionEnvironment();
        hostConfig.setHost(exEnv);
        CompilerSetManager csm = CompilerSetManager.get((ExecutionEnvironment)exEnv);
        CompilerSet2Configuration csconf = makeConfiguration.getCompilerSet();
        if (csm == null || !csconf.isValid()) {
            return;
        }
        CompilerSet compilerSet = csconf.getCompilerSet();
        if (engine != CndRemote.getDebuggerType(compilerSet)) {
            for (CompilerSet cs : csm.getCompilerSets()) {
                if (engine != CndRemote.getDebuggerType(cs)) continue;
                csconf.setValue(cs.getName());
                break;
            }
        }
    }
}

