/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.options;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineType;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineTypeManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.DbgProfile;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.EngineProfile;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CustomizerNodeProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.CustomizerNode;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.DebuggerCustomizerNode;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DbgProfileNodeProvider
implements CustomizerNodeProvider {
    private static final String DEBUGGER_NODE_ID = "Debug";
    private static final String DEBUGGER_BUNDLE_ID = "Debug";
    private CustomizerNode customizerNode = null;
    private ResourceBundle bundle;

    public CustomizerNode factoryCreate(Lookup lookup) {
        if (this.customizerNode == null) {
            this.customizerNode = this.createDebugNode(lookup);
        }
        return this.customizerNode;
    }

    private CustomizerNode createDebugNode(Lookup lookup) {
        if (NativeDebuggerManager.isChoosableEngine()) {
            Collection<EngineType> engineTypes = EngineTypeManager.getEngineTypes(false);
            ArrayList<DebugProfileGeneralCustomizerNode> childrenNodes = new ArrayList<DebugProfileGeneralCustomizerNode>(engineTypes.size());
            for (EngineType engineType : engineTypes) {
                DebugProfileGeneralCustomizerNode node = new DebugProfileGeneralCustomizerNode(engineType.getDebuggerID(), engineType, engineType.getDisplayName(), null, lookup);
                childrenNodes.add(node);
            }
            DebugProfileChoosableElementsCustomizerNode debugRootNode = new DebugProfileChoosableElementsCustomizerNode("Debug", this.getString("Debug"), childrenNodes.toArray(new CustomizerNode[childrenNodes.size()]), lookup);
            return debugRootNode;
        }
        DebugProfileGeneralCustomizerNode dbxRootNode = new DebugProfileGeneralCustomizerNode("Debug", null, this.getString("Debug"), null, lookup);
        return dbxRootNode;
    }

    private String getString(String s) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(DbgProfileNodeProvider.class);
        }
        return this.bundle.getString(s);
    }

    private static final class DebugProfileChoosableElementsCustomizerNode
    extends CustomizerNode
    implements DebuggerCustomizerNode {
        public DebugProfileChoosableElementsCustomizerNode(String name, String displayName, CustomizerNode[] children, Lookup lookup) {
            super(name, displayName, children, lookup);
        }

        public Sheet getSheet(Configuration configuration) {
            EngineProfile profile = (EngineProfile)configuration.getAuxObject("nativedebugger");
            return profile.getSheet();
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("DebuggerOptions");
        }

        public String getFamily() {
            return "SunStudio";
        }
    }

    private static final class DebugProfileGeneralCustomizerNode
    extends CustomizerNode
    implements DebuggerCustomizerNode {
        private final EngineType engineType;

        public DebugProfileGeneralCustomizerNode(String name, EngineType engineType, String displayName, CustomizerNode[] children, Lookup lookup) {
            super(name, displayName, children, lookup);
            this.engineType = engineType;
        }

        public Sheet getSheet(Configuration configuration) {
            EngineType engine = this.engineType;
            if (this.engineType == null) {
                engine = NativeDebuggerManager.debuggerType(configuration);
            }
            String profileID = EngineTypeManager.engine2DebugProfileID(engine);
            DbgProfile dbgProfile = (DbgProfile)configuration.getAuxObject(profileID);
            return dbgProfile.getSheet();
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("DebuggerOptions");
        }

        public String getFamily() {
            return "SunStudio";
        }
    }
}

