/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.debugtarget;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.debugger.common2.capture.CaptureInfo;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerSettingsBridge;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.ProjectSupport;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineDescriptor;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineType;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineTypeManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.debugtarget.NativeDebuggerAuxObjectFactory;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.DbgProfile;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.EngineProfile;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.Record;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.Env;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.openide.util.Lookup;

public final class DebugTarget
implements Record {
    private String name;
    private String hostName = null;
    private String corefile = null;
    private long pid = -1L;
    private CaptureInfo captureInfo = null;
    private EngineType engine;
    private String redirection = null;
    private String argsUnparsed = null;
    private MakeConfiguration configuration = null;
    private ProjectMode projectMode = ProjectMode.OLD_PROJECT;
    private boolean needSave = true;
    private transient PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    public static final String PROP_RUNARGS_CHANGED = "runargs-ch";
    public static final String PROP_RUNDIR_CHANGED = "rundir-ch";
    public static final String PROP_ENVVARS_CHANGED = "envvars-ch";
    public static final String PROP_PATHMAP_CHANGED = "pathmap-ch";
    public static final String PROP_SIGNAL_CHANGED = "signal-ch";
    public static final String PROP_SIGNALS_CHANGED = "signals-ch";
    public static final String PROP_OPTION_CHANGED = "option-ch";
    public static final String PROP_ENGINE_CHANGED = "engine";
    public static final String PROP_INTERCEPTLIST_CHANGED = "intrcpt-ch";
    public static final String PROP_INTERCEPTEXLIST_CHANGED = "exintrcpt-ch";
    private static final String baseDir = "/";

    public DebugTarget(String name) {
        this.engine = EngineTypeManager.getFallbackEnineType();
        this.name = name;
        this.configuration = new MakeConfiguration(baseDir, "Default", 0);
        this.configuration.getMakefileConfiguration().getOutput().setValue(name);
    }

    public DebugTarget() {
        this.engine = EngineTypeManager.getFallbackEnineType();
        this.configuration = new MakeConfiguration(baseDir, "Default", 0);
    }

    public DebugTarget(MakeConfiguration f) {
        this.engine = EngineTypeManager.getFallbackEnineType();
        this.configuration = f;
    }

    public String name() {
        return this.name;
    }

    public DbgProfile getDbgProfile() {
        return this.getDbgProfile(this.engine);
    }

    public DbgProfile getDbgProfile(EngineType e) {
        String id = EngineTypeManager.engine2DebugProfileID(e);
        return (DbgProfile)this.configuration.getAuxObject(id);
    }

    public RunProfile getRunProfile() {
        return this.configuration.getProfile();
    }

    public EngineProfile getEngineProfile() {
        return (EngineProfile)this.configuration.getAuxObject("nativedebugger");
    }

    public ConfigurationAuxObject getAuxProfile(String id) {
        return this.configuration.getAuxObject(id);
    }

    public StringConfiguration getOutput() {
        return this.configuration.getMakefileConfiguration().getOutput();
    }

    public static String makeKey(String exec, String flattennedArgs, String hostName) {
        return exec + " " + flattennedArgs + " " + "[" + hostName + "]";
    }

    @Override
    public String getKey() {
        return this.displayName();
    }

    @Override
    public void setKey(String newKey) {
    }

    @Override
    public boolean matches(String key) {
        return IpeUtils.sameString(this.getKey(), key, 120);
    }

    @Override
    public boolean isArchetype() {
        return false;
    }

    public boolean assignProject(Project project) {
        MakeConfiguration conf = ConfigurationSupport.getProjectActiveConfiguration((Project)project);
        if (conf == null) {
            return false;
        }
        this.configuration = conf.clone();
        this.setProjectMode(ProjectMode.OLD_PROJECT);
        return true;
    }

    public Project createProject() throws IOException {
        ProjectSupport.ProjectSeed seed = new ProjectSupport.ProjectSeed(null, this.getEngine(), false, this.getExecutable(), ProjectSupport.Model.DONTCARE, null, 0L, null, null, null, this.getHostName());
        seed.setConfiguration(this.configuration);
        ProjectSupport.getProject(seed);
        return seed.project();
    }

    @Override
    public DebugTarget cloneRecord() {
        MakeConfiguration configClone = (MakeConfiguration)this.configuration.copy();
        DebugTarget clone = new DebugTarget(configClone);
        clone.setHostName(this.getHostName());
        clone.setCorefile(this.getCorefile());
        clone.setEngine(this.getEngine());
        return clone;
    }

    public void assign(DebugTarget that) {
        this.configuration.assign((Configuration)that.configuration);
        this.setExecutable(that.getExecutable());
        this.setHostName(that.getHostName());
        this.setEngine(that.getEngine());
        this.setCorefile(that.getCorefile());
        this.setProjectMode(that.getProjectMode());
    }

    @Override
    public String displayName() {
        String exec = this.configuration.getMakefileConfiguration().getOutput().getValue();
        String args = this.getRunProfile().getArgsFlat();
        String corename = this.corefile == null ? "" : this.corefile;
        String display_name = exec + " " + args + " " + "[" + this.hostName + "]";
        String engine = System.getProperty("debug.engine");
        if (engine != null && engine.equals("on")) {
            display_name = display_name + " [" + this.getEngine().getDisplayName() + "]";
        }
        if (this.corefile != null) {
            display_name = exec + " " + corename + " " + args + " " + "[" + this.hostName + "]";
            if (engine != null && engine.equals("on")) {
                display_name = display_name + " [" + this.getEngine().getDisplayName() + "]";
            }
        }
        if (display_name.length() > 120) {
            display_name = display_name.substring(0, 120);
        }
        return display_name;
    }

    public String programName() {
        String fullpath = this.configuration.getMakefileConfiguration().getOutput().getValue();
        int idx = fullpath.lastIndexOf(File.separatorChar);
        if (idx >= 0) {
            return fullpath.substring(idx + 1);
        }
        return fullpath;
    }

    public String getExecutable() {
        if (this.configuration.getMakefileConfiguration().getOutput() == null) {
            return " ";
        }
        return this.configuration.getMakefileConfiguration().getOutput().getValue();
    }

    public void setBuildFirst(boolean b) {
        this.getRunProfile().setBuildFirst(b);
    }

    public long getPid() {
        return this.pid;
    }

    public void setPid(long pid) {
        this.pid = pid;
    }

    public CaptureInfo getCaptureInfo() {
        return this.captureInfo;
    }

    public void setCaptureInfo(CaptureInfo captureInfo) {
        this.captureInfo = captureInfo;
    }

    public String getCorefile() {
        return this.corefile;
    }

    public void setCorefile(String corefile) {
        this.corefile = corefile;
    }

    public void setExecutable(String exec) {
        this.configuration.getMakefileConfiguration().getOutput().setValue(exec);
    }

    public Env getEnvs() {
        return this.getRunProfile().getEnvironment();
    }

    public void setEnvs(String e) {
        this.getRunProfile().getEnvironment().putenv(e);
    }

    public void setConfig(MakeConfiguration conf) {
        this.configuration = conf;
    }

    public MakeConfiguration getConfig() {
        return this.configuration;
    }

    public String getRunDir() {
        return DebuggerSettingsBridge.getRunDir(this.getDbgProfile(), this.getRunProfile());
    }

    public void setRunDir(String newdir) {
        String executable;
        String rundir = this.getRunDir();
        if (newdir == null && (executable = this.getExecutable()) != null) {
            newdir = CndPathUtilitities.getDirName((String)executable);
        }
        if (IpeUtils.sameString(rundir, newdir)) {
            return;
        }
        this.getDbgProfile().setDebugDir(newdir);
        this.pcs.firePropertyChange(PROP_RUNDIR_CHANGED, null, this);
        this.needSave = true;
    }

    public String[] getArgs() {
        return this.getRunProfile().getArgsArray();
    }

    public void setArgsOnly(String[] newargs) {
        this.getRunProfile().setArgs(newargs);
        this.updateFlattenedArgs();
        this.needSave = true;
    }

    public void setHostName(String h) {
        if (NativeDebuggerManager.isStandalone() ? !$assertionsDisabled && !IpeUtils.isEmpty(h) && h.indexOf(64) != -1 : !$assertionsDisabled && !IpeUtils.isEmpty(h) && !h.equals("localhost") && !h.equals("127.0.0.1") && h.indexOf(64) == -1) {
            throw new AssertionError();
        }
        this.hostName = "127.0.0.1".equals(h) ? "localhost" : h;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    public EngineDescriptor getEngineDescriptor() {
        assert (this.engine != null);
        return new EngineDescriptor(this.engine);
    }

    public EngineType getEngine() {
        assert (this.engine != null);
        return this.engine;
    }

    public void setEngine(EngineType e) {
        if (e == null) {
            e = EngineTypeManager.getFallbackEnineType();
        }
        this.engine = e;
        this.getEngineProfile().setEngineType(this.engine);
    }

    public void setCompilerSet(CompilerSet cs) {
        this.configuration.getCompilerSet().assign(new CompilerSet2Configuration(new DevelopmentHostConfiguration(this.configuration.getFileSystemHost()), cs));
    }

    public void setEngineByID(String id) {
        this.engine = this.getEngineProfile().setEngineByID(id);
    }

    private void updateFlattenedArgs() {
        String[] args = this.getArgs();
        StringBuilder sb = new StringBuilder();
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                if (i > 0) {
                    sb.append(' ');
                }
                if (args[i].length() == 0) {
                    sb.append('\"');
                    sb.append('\"');
                    continue;
                }
                sb.append(IpeUtils.quoteIfNecessary(args[i]));
            }
            sb.append(' ');
        }
        if (this.redirection != null) {
            sb.append(this.redirection);
        }
        this.setUnparsedArgs(sb.toString());
    }

    public String getUnparsedArgs() {
        return this.argsUnparsed;
    }

    public void setProjectMode(ProjectMode b) {
        this.projectMode = b;
    }

    public ProjectMode getProjectMode() {
        return this.projectMode;
    }

    public void setUnparsedArgs(String newargs) {
        if (IpeUtils.sameString(this.argsUnparsed, newargs)) {
            return;
        }
        this.argsUnparsed = newargs.trim();
        this.pcs.firePropertyChange(PROP_RUNARGS_CHANGED, null, this);
        this.needSave = true;
    }

    public boolean isDirty() {
        boolean dirty = this.getRunProfile().hasChanged();
        for (ConfigurationAuxObject profile : this.getAuxProfiles()) {
            dirty |= profile.hasChanged();
        }
        return dirty;
    }

    public Collection<ConfigurationAuxObject> getAuxProfiles() {
        ArrayList<ConfigurationAuxObject> confObjs = new ArrayList<ConfigurationAuxObject>();
        Collection factories = Lookup.getDefault().lookupAll(NativeDebuggerAuxObjectFactory.class);
        for (NativeDebuggerAuxObjectFactory dbgFactory : factories) {
            ConfigurationAuxObject auxProfile = this.getAuxProfile(dbgFactory.getAuxObjectID());
            if (auxProfile == null) continue;
            confObjs.add(auxProfile);
        }
        return confObjs;
    }

    public void clearDirty() {
        this.getRunProfile().clearChanged();
        for (ConfigurationAuxObject profile : this.getAuxProfiles()) {
            profile.clearChanged();
        }
    }

    public void propertyChange(PropertyChangeEvent ev) {
    }

    public static enum ProjectMode {
        NO_PROJECT,
        NEW_PROJECT,
        OLD_PROJECT;

    }
}

