/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.RoutingToken;
import org.netbeans.modules.cnd.debugger.common2.debugger.State;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.Log;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.NativeActionsProvider;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.Disassembly;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.DisassemblyUtils;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.BreakpointBag;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.Handler;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.InstructionBreakpoint;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class ToggleBreakpointActionProvider
extends NativeActionsProvider
implements PropertyChangeListener {
    private static boolean ignoreJava = false;
    private static final String jpdaModuleName = "org.netbeans.modules.debugger.jpda";

    public ToggleBreakpointActionProvider() {
        super(null);
        EditorContextBridge.addPropertyChangeListener(this);
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
    }

    private boolean checkTarget() {
        if (!NativeDebuggerManager.isPerTargetBpts()) {
            return true;
        }
        NativeDebugger debugger = this.getDebugger();
        if (debugger == null || !debugger.state().isLoaded) {
            NativeDebuggerManager.errorLoadBeforeBpt();
            return false;
        }
        return true;
    }

    public void doAction(Object action) {
        FileObject currentFileObject = EditorContextBridge.getCurrentFileObject();
        String fileName = currentFileObject.getPath();
        if (fileName.trim().equals("")) {
            return;
        }
        int lineNo = EditorContextBridge.getCurrentLineNumber();
        if (ignoreJava && fileName.endsWith(".java")) {
            return;
        }
        if (!this.checkTarget()) {
            return;
        }
        String currentURL = EditorContextBridge.getCurrentURL();
        String address = null;
        NativeBreakpoint bpt = null;
        BreakpointBag bb = NativeDebuggerManager.get().breakpointBag();
        NativeDebugger debugger = this.getDebugger();
        if (Disassembly.isDisasm(currentURL)) {
            address = DisassemblyUtils.getLineAddress(lineNo);
            if (address == null) {
                return;
            }
            for (NativeBreakpoint breakpoint : bb.getBreakpoints()) {
                if (!(breakpoint instanceof InstructionBreakpoint) || !address.equals(((InstructionBreakpoint)breakpoint).getAddress())) continue;
                bpt = breakpoint;
                break;
            }
        } else {
            bpt = bb.locateBreakpointAt(fileName, lineNo, debugger);
        }
        if (bpt != null) {
            bpt.dispose();
            return;
        }
        if (address != null) {
            bpt = NativeBreakpoint.newInstructionBreakpoint(address);
        } else {
            try {
                bpt = NativeBreakpoint.newLineBreakpoint(fileName, lineNo, currentFileObject.getFileSystem());
            }
            catch (FileStateInvalidException ex) {
                // empty catch block
            }
        }
        if (bpt != null) {
            int routingToken = RoutingToken.BREAKPOINTS.getUniqueRoutingTokenInt();
            Handler.postNewHandler(debugger, bpt, routingToken);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        int lnum = EditorContextBridge.getCurrentLineNumber();
        String mimeType = EditorContextBridge.getCurrentMIMEType();
        boolean isValid = (MIMENames.isFortranOrHeaderOrCppOrC((String)mimeType) || mimeType.equals("text/x-asm")) && lnum > 0;
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, isValid);
    }

    @Override
    public void update(State state) {
    }

    private static void checkForJpdaDebugger() {
        if (Log.Action.jpdaWatcher) {
            System.out.printf("checkForJpdaDebugger #######################\n", new Object[0]);
        }
        Collection moduleInfos = Lookup.getDefault().lookupAll(ModuleInfo.class);
        ignoreJava = false;
        String jdbx = System.getProperty("spro.jdbx");
        for (ModuleInfo moduleInfo : moduleInfos) {
            if (!moduleInfo.getCodeNameBase().equals(jpdaModuleName)) continue;
            if (moduleInfo.isEnabled() && jdbx != null && !jdbx.equals("on")) {
                ignoreJava = true;
            }
            moduleInfo.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("enabled")) {
                        if (((Boolean)evt.getNewValue()).booleanValue()) {
                            ignoreJava = true;
                        } else {
                            ignoreJava = false;
                        }
                        if (Log.Action.jpdaWatcher) {
                            System.out.printf("\tignoreJava -> %s\n", ignoreJava);
                        }
                    }
                }
            });
        }
        if (Log.Action.jpdaWatcher) {
            System.out.printf("\tignoreJava = %s\n", ignoreJava);
        }
    }

    static {
        ToggleBreakpointActionProvider.checkForJpdaDebugger();
        Lookup.Result result = Lookup.getDefault().lookupResult(ModuleInfo.class);
        result.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent event) {
                ToggleBreakpointActionProvider.checkForJpdaDebugger();
            }
        });
    }
}

