/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.actions;

import java.io.File;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineType;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineTypeManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.DbgProfile;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.DebuggerOption;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.CndRemote;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Host;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionSet;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionValue;
import org.netbeans.modules.cnd.makeproject.api.ProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.spi.FileSystemProvider;

public final class ProjectSupport {
    private ProjectSupport() {
    }

    private static boolean isAuto(String executable) {
        return Catalog.get("FromProcess").equals(executable) || Catalog.get("AutoCoreExe").equals(executable) || "-".equals(executable);
    }

    private static void populateConfiguration(ProjectSeed seed) {
        if (!ProjectSupport.isAuto(seed.executable) && CndPathUtilitities.isPathAbsolute((CharSequence)seed.executable)) {
            seed.conf.getMakefileConfiguration().getOutput().setValue(CndPathUtilitities.normalizeSlashes((String)seed.executable));
        }
        String currentDebuggerProfileID = EngineTypeManager.engine2DebugProfileID(seed.engineType);
        DbgProfile dbgProfile = (DbgProfile)seed.conf.getAuxObject(currentDebuggerProfileID);
        OptionSet options = dbgProfile.getOptions();
        OptionValue optionExec32 = options.byName(DebuggerOption.OPTION_EXEC32.getName());
        switch (seed.model) {
            case DONTCARE: {
                break;
            }
            case IS32: {
                optionExec32.setEnabled(true);
                break;
            }
            case IS64: {
                optionExec32.setEnabled(false);
            }
        }
        options.save();
        if (seed.workingdir != null) {
            seed.conf.getProfile().setRunDirectory(seed.workingdir);
        }
        if (seed.args != null) {
            seed.conf.getProfile().setArgs(seed.args);
        }
        if (seed.envs != null) {
            seed.conf.getProfile().getEnvironment().putenv(seed.envs);
        }
        ProjectSeed static_seed = seed;
        if (!NativeDebuggerManager.isStandalone()) {
            ProjectSupport.fillCndConfiguration(static_seed);
        }
    }

    private static void fillCndConfiguration(final ProjectSeed seed) {
        final String hostName = seed.getHostName();
        CndRemote.validate(hostName, new Runnable(){

            @Override
            public void run() {
                Host host = Host.byName(hostName);
                seed.setHost(host);
                if (host.isRemote()) {
                    seed.conf.setBaseFSPath(new FSPath(FileSystemProvider.getFileSystem((ExecutionEnvironment)host.executionEnvironment()), seed.conf.getBaseDir()));
                }
                CndRemote.fillConfigurationFromHost((Configuration)seed.conf, seed.engineType, host);
            }
        });
    }

    public static void getProject(ProjectSeed seed) {
        if (seed.workingdir == null) {
            seed.workingdir = seed.directory;
        }
        if (seed.workingdir == null) {
            seed.workingdir = "";
        }
        switch (seed.projectMode) {
            case NO_PROJECT: {
                String baseDir;
                if (seed.directory != null) {
                    baseDir = seed.directory;
                    assert (!IpeUtils.isEmpty(baseDir));
                    assert (CndPathUtilitities.isPathAbsolute((CharSequence)baseDir));
                } else {
                    baseDir = "/";
                }
                if (seed.conf != null) {
                    seed.conf.setBaseDir(baseDir);
                } else {
                    seed.conf = new MakeConfiguration(baseDir, "Default", 0);
                }
                ProjectSupport.populateConfiguration(seed);
                break;
            }
            case NEW_PROJECT: {
                String projectParentFolder = ProjectGenerator.getDefaultProjectFolder();
                String projectName = ProjectGenerator.getValidProjectName((String)projectParentFolder, (String)seed.projectName);
                String baseDir = seed.directory != null ? seed.directory : projectParentFolder + File.separator + projectName;
                assert (!IpeUtils.isEmpty(baseDir));
                assert (CndPathUtilitities.isPathAbsolute((CharSequence)baseDir));
                if (seed.conf != null) {
                    seed.conf.setBaseDir(baseDir);
                } else {
                    seed.conf = new MakeConfiguration(baseDir, "Default", 0);
                }
                ProjectSupport.populateConfiguration(seed);
                try {
                    boolean open = true;
                    ProjectGenerator.ProjectParameters prjParams = new ProjectGenerator.ProjectParameters(projectName, CndFileUtils.createLocalFile((String)projectParentFolder, (String)projectName));
                    prjParams.setOpenFlag(true).setConfiguration(seed.conf);
                    seed.project = ProjectGenerator.createBlankProject((ProjectGenerator.ProjectParameters)prjParams);
                }
                catch (Exception e) {
                    seed.project = null;
                }
                seed.conf = ConfigurationSupport.getProjectActiveConfiguration((Project)seed.project);
                break;
            }
            case OLD_PROJECT: {
                assert (seed.conf == null);
                seed.conf = ConfigurationSupport.getProjectActiveConfiguration((Project)seed.project).clone();
            }
        }
    }

    public static Project matchProject(String projectFolder, String pName) {
        OpenProjects op = OpenProjects.getDefault();
        Project[] openedProjects = null;
        try {
            openedProjects = (Project[])op.openProjects().get();
        }
        catch (Exception e) {
            return null;
        }
        for (int i = 0; i < openedProjects.length; ++i) {
            String projectName = ProjectUtils.getInformation((Project)openedProjects[i]).getName();
            if (!pName.equals(projectName)) continue;
            return openedProjects[i];
        }
        return null;
    }

    public static final class ProjectSeed {
        private Project project;
        private final EngineType engineType;
        private String executable;
        private final Model model;
        private File file;
        private final String corefile;
        private final long pid;
        private final String hostName;
        private String workingdir;
        private String args;
        private String envs;
        private Host host;
        private MakeConfiguration conf;
        private String directory;
        private final ProjectMode projectMode;
        private String projectName;

        public ProjectSeed(Project project, EngineType engineType, boolean noproject, String executable, Model model, String corefile, long pid, String workingdir, String args, String envs, String hostName) {
            this.project = project;
            this.engineType = engineType;
            this.executable = executable;
            this.hostName = hostName;
            this.model = model;
            this.corefile = corefile;
            this.pid = pid;
            this.workingdir = workingdir;
            this.args = args;
            this.envs = envs;
            if (project == null) {
                this.projectMode = noproject ? ProjectMode.NO_PROJECT : ProjectMode.NEW_PROJECT;
            } else {
                assert (!noproject);
                this.projectMode = ProjectMode.OLD_PROJECT;
            }
            this.prepare();
        }

        private void prepare() {
            MakeConfiguration conf2;
            this.projectName = IpeUtils.isEmpty(this.executable) || ProjectSupport.isAuto(this.executable) ? "Project" : CndPathUtilitities.getBaseName((String)this.executable);
            if (this.executable != null) {
                this.file = new File(this.executable);
                if (!IpeUtils.isEmpty(this.executable) && this.executable.charAt(0) != '/' && this.file.exists()) {
                    this.executable = this.file.getAbsolutePath();
                }
            }
            this.directory = this.workingdir;
            if (this.directory == null && this.projectMode == ProjectMode.OLD_PROJECT && (conf2 = ConfigurationSupport.getProjectActiveConfiguration((Project)this.project)) != null) {
                this.directory = conf2.getProfile().getRunDirectory();
            }
            if (this.directory == null && CndPathUtilitities.isPathAbsolute((CharSequence)this.executable)) {
                this.directory = CndPathUtilitities.getDirName((String)this.executable);
            }
            if (this.directory == null && CndPathUtilitities.isPathAbsolute((CharSequence)this.corefile)) {
                this.directory = CndPathUtilitities.getDirName((String)this.corefile);
            }
        }

        public void setConfiguration(MakeConfiguration conf) {
            this.conf = conf;
        }

        public void setHost(Host host) {
            this.host = host;
        }

        public Host getHost() {
            return this.host;
        }

        public String getHostName() {
            return this.hostName;
        }

        public Project project() {
            return this.project;
        }

        public String projectName() {
            return this.projectName;
        }

        public MakeConfiguration conf() {
            return this.conf;
        }

        public String executable() {
            return this.executable;
        }

        public String executableNoSentinel() {
            if (ProjectSupport.isAuto(this.executable)) {
                return "-";
            }
            return this.executable;
        }

        public File file() {
            return this.file;
        }

        public String corefile() {
            return this.corefile;
        }

        public long pid() {
            return this.pid;
        }

        public String workingdir() {
            return this.workingdir;
        }

        public String args() {
            return this.args;
        }

        public String envs() {
            return this.envs;
        }

        private static enum ProjectMode {
            NO_PROJECT,
            NEW_PROJECT,
            OLD_PROJECT;

        }
    }

    public static enum Model {
        DONTCARE,
        IS32,
        IS64;

    }
}

