/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.picklist.DefaultPicklistModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.DebugCorePanel;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.ProjectSupport;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineType;
import org.netbeans.modules.cnd.debugger.common2.debugger.debugtarget.DebugTarget;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Host;
import org.netbeans.modules.cnd.debugger.common2.debugger.spi.UserDebugCoreAction;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

public class DebugCoreAction
extends SystemAction {
    private String lastCorefilePath = null;
    private DefaultPicklistModel executablePickList = new DefaultPicklistModel(6);

    public String getName() {
        return Catalog.get("LOADCOREDIALOGACTION_NAME");
    }

    public void actionPerformed(ActionEvent ev) {
        Node[] activeNodes = WindowManager.getDefault().getRegistry().getActivatedNodes();
        this.performAction(activeNodes, false);
    }

    public void performAction(Node[] activeNodes, boolean ro) {
        File exeFile;
        UserDebugCoreAction action;
        Node node;
        DataNode corefileNode = null;
        String corefilePath = null;
        String host = null;
        DataObject dataObject = null;
        if (activeNodes.length == 1 && "application/x-core+elf".equals(IpeUtils.getMime(dataObject = (DataObject)activeNodes[0].getCookie(DataObject.class))) && (node = dataObject.getNodeDelegate()) instanceof DataNode) {
            corefileNode = (DataNode)node;
        }
        if (corefileNode != null && corefileNode.getDataObject() != null) {
            FileObject coreFile = corefileNode.getDataObject().getPrimaryFile();
            ExecutionEnvironment exEnv = FileSystemProvider.getExecutionEnvironment((FileObject)coreFile);
            host = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)exEnv);
            corefilePath = coreFile.getPath();
        } else {
            corefilePath = this.lastCorefilePath;
        }
        JButton debugButton = new JButton(Catalog.get("DEBUG_BUTTON_TXT"));
        Catalog.setAccessibleDescription(debugButton, "ACSD_Debug");
        Object[] options = new Object[]{debugButton, DialogDescriptor.CANCEL_OPTION};
        DebugCorePanel coreDialogPanel = new DebugCorePanel(corefilePath, this.executablePickList.getElementsDisplayName(), debugButton, ro, host);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)coreDialogPanel, Catalog.get("LBL_DebugCorefile"), true, options, (Object)debugButton, 0, null, null);
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (ret != debugButton) {
            return;
        }
        String corefile = coreDialogPanel.getCorefilePath();
        String executable = coreDialogPanel.getExecutablePath().trim();
        Project project = coreDialogPanel.getSelectedProject();
        boolean noproject = coreDialogPanel.getNoProject();
        String hostName = coreDialogPanel.getHostName();
        EngineType engineType = coreDialogPanel.getEngine();
        if (noproject && (action = (UserDebugCoreAction)Lookup.getDefault().lookup(UserDebugCoreAction.class)) != null) {
            if (Catalog.get("AutoCoreExe").equals(executable)) {
                executable = null;
            }
            action.debugCore(corefile, executable, engineType);
            return;
        }
        ProjectSupport.ProjectSeed seed = new ProjectSupport.ProjectSeed(project, engineType, noproject, executable, ProjectSupport.Model.DONTCARE, corefile, 0L, null, null, null, hostName);
        ProjectSupport.getProject(seed);
        coreDialogPanel.setLastSelectedProject(seed.project());
        this.lastCorefilePath = seed.corefile();
        this.executablePickList.addElement(seed.executable());
        corefile = seed.corefile();
        executable = seed.executableNoSentinel();
        MakeConfiguration conf = seed.conf();
        if (!Host.isRemote(hostName) && corefileNode == null && (corefileNode = DebugCoreAction.findCorefileNode(corefile)) == null) {
            String msg = NbBundle.getMessage(DebugCoreAction.class, (String)"ERROR_NOTACOREFILE", (Object)corefile);
            this.errorDialog(msg);
            return;
        }
        if (executable == null || executable.equals(Catalog.get("AutoCoreExe")) || executable.equals("") || executable.equals("-")) {
            executable = "-";
        } else if (!(Host.isRemote(hostName) || (exeFile = new File(executable)).exists() && !exeFile.isDirectory())) {
            StatusDisplayer.getDefault().setStatusText(Catalog.get("MSG_BadExecutable"));
            this.errorDialog(Catalog.get("MSG_BadExecutable"));
            return;
        }
        DebugTarget dt = new DebugTarget(conf);
        dt.setExecutable(executable);
        dt.setCorefile(corefile);
        dt.setHostName(seed.getHostName());
        dt.setEngine(engineType);
        NativeDebuggerManager.get().debugCore(dt);
    }

    private void errorDialog(String txt) {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)txt, 0));
    }

    protected String iconResource() {
        return "org/netbeans/modules/cnd/debugger/common2/icons/debug_core_file.png";
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(DebugCoreAction.class);
    }

    private static DataNode findCorefileNode(String filePath) {
        if (filePath == null) {
            return null;
        }
        FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(filePath)));
        if (fo == null) {
            return null;
        }
        if (!"application/x-core+elf".equals(fo.getMIMEType())) {
            return null;
        }
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fo);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (dataObject == null) {
            return null;
        }
        Node node = dataObject.getNodeDelegate();
        if (!(node instanceof DataNode)) {
            return null;
        }
        return (DataNode)node;
    }
}

