/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.actions;

import java.io.IOException;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.actions.CompileRunActionBase;
import org.netbeans.modules.cnd.builds.ImportUtils;
import org.netbeans.modules.cnd.debugger.common2.DbgActionHandler;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.execution.CompileExecSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.openide.nodes.Node;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class CompileDebugAction
extends CompileRunActionBase {
    public CompileDebugAction() {
        super.putValue("key", (Object)"CndCompileDebugAction");
    }

    public String getName() {
        return CompileDebugAction.getString((String)"BTN_CompileDebug_File");
    }

    protected String getTabName(Node node, ExecutionEnvironment execEnv) {
        return execEnv.isLocal() ? CompileDebugAction.getString((String)"COMPILE_DEBUG_LABEL", (String[])new String[]{node.getName()}) : CompileDebugAction.getString((String)"COMPILE_DEBUG_REMOTE_LABEL", (String[])new String[]{node.getName(), execEnv.getDisplayName()});
    }

    protected Runnable getRunnable(String tabName, InputOutput tab, ExecutionEnvironment execEnv, String buildDir, String executable, CompileExecSupport ces) {
        return new DebugContext(tabName, tab, execEnv, buildDir, executable, ces);
    }

    private static final class DebugContext
    implements Runnable {
        private InputOutput tab;
        private final ExecutionEnvironment execEnv;
        private final String buildDir;
        private final String executable;
        private final CompileExecSupport ces;
        private final String tabName;

        private DebugContext(String tabName, InputOutput tab, ExecutionEnvironment execEnv, String buildDir, String executable, CompileExecSupport ces) {
            this.tabName = tabName;
            this.tab = tab;
            this.execEnv = execEnv;
            this.buildDir = buildDir;
            this.executable = executable;
            this.ces = ces;
        }

        @Override
        public void run() {
            final MakeConfiguration configuration = new MakeConfiguration(this.buildDir, "Default", 0);
            configuration.getMakefileConfiguration().getOutput().setValue(this.buildDir + "/" + this.executable);
            final RunProfile profile = new RunProfile(configuration, null);
            StringBuilder buf = new StringBuilder();
            for (String arg : this.ces.getArguments()) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append(arg);
            }
            List list = ImportUtils.parseArgs((String)buf.toString());
            list = ImportUtils.normalizeParameters((List)list);
            profile.setArgs(list.toArray(new String[list.size()]));
            profile.setBaseDir(this.buildDir);
            profile.setRunDir(this.buildDir);
            this.tab.closeInputOutput();
            this.tab = IOProvider.get((String)"Terminal").getIO(this.tabName, false);
            try {
                this.tab.getOut().reset();
            }
            catch (IOException ex) {
                // empty catch block
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DbgActionHandler handler = new DbgActionHandler();
                    handler.addExecutionListener(new ExecutionListener(){

                        public void executionStarted(int pid) {
                        }

                        public void executionFinished(int rc) {
                            DebugContext.this.tab.getOut().close();
                        }
                    });
                    NativeDebuggerManager.get().debug(DebugContext.this.buildDir + "/" + DebugContext.this.executable, (Configuration)configuration, ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)DebugContext.this.execEnv), DebugContext.this.tab, handler, profile);
                }
            });
        }
    }
}

