/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import java.util.ArrayList;
import org.netbeans.modules.cnd.debugger.common2.debugger.ModelChangeDelegator;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeWatch;
import org.netbeans.modules.cnd.debugger.common2.debugger.WatchVariable;

public class WatchBag {
    private ArrayList<NativeWatch> watches = new ArrayList();

    private ModelChangeDelegator watchUpdater() {
        return NativeDebuggerManager.get().watchUpdater();
    }

    public NativeWatch[] getWatches() {
        NativeWatch[] wa = new NativeWatch[this.watches.size()];
        return this.watches.toArray(wa);
    }

    public WatchVariable[] watchesFor(NativeDebugger debugger) {
        ArrayList<WatchVariable> ws = new ArrayList<WatchVariable>();
        for (NativeWatch w : this.watches) {
            WatchVariable dw = w.findByDebugger(debugger);
            if (dw == null) continue;
            ws.add(dw);
        }
        return ws.toArray(new WatchVariable[ws.size()]);
    }

    public void postDeleteAllWatches() {
        NativeDebugger debugger = NativeDebuggerManager.get().currentNativeDebugger();
        for (NativeWatch w : this.getWatches()) {
            WatchVariable dw = w.findByDebugger(debugger);
            if (dw == null) continue;
            w.postDelete(false);
        }
    }

    public final void restore(NativeWatch newWatch) {
        assert (!this.watches.contains(newWatch)) : "WB.restore(): watch added redundantly";
        this.watches.add(newWatch);
        newWatch.setUpdater(this.watchUpdater());
    }

    public void add(NativeWatch newWatch) {
        assert (!this.watches.contains(newWatch)) : "WB.add(): watch added redundantly";
        this.watches.add(newWatch);
        newWatch.setUpdater(this.watchUpdater());
        this.watchUpdater().treeChanged();
    }

    public void remove(NativeWatch oldWatch) {
        if (oldWatch == null) {
            return;
        }
        oldWatch.cleanup();
        boolean removed = this.watches.remove(oldWatch);
        assert (removed) : "WB.remove(): watch to be removed not in bag";
        assert (!this.watches.contains(oldWatch)) : "WB.remove(): watch still there after removal";
        this.watchUpdater().treeChanged();
    }
}

