/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.cnd.debugger.common2.debugger.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.Constants;
import org.netbeans.modules.cnd.debugger.common2.debugger.Frame;
import org.netbeans.modules.cnd.debugger.common2.debugger.ModelListenerSupport;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.MaxFrameAction;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.PopLastDebuggerCallAction;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.PopToCurrentFrameAction;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineCapability;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineDescriptor;
import org.netbeans.modules.cnd.debugger.common2.values.VariableValue;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.HelpCtx;
import org.openide.util.actions.BooleanStateAction;
import org.openide.util.actions.SystemAction;

public final class StackModel
extends ModelListenerSupport
implements TreeModel,
NodeModel,
NodeActionsProvider,
TableModel,
Constants {
    private NativeDebugger debugger;
    private static String ICON_PATH = "org/netbeans/modules/debugger/resources";
    private static String ICON_BASE = ICON_PATH + "/callStackView/NonCurrentFrame";
    private static String ICON_BASE_CURRENT = ICON_PATH + "/callStackView/CurrentFrame";
    private static String ICON_EMPTY = "org/netbeans/modules/cnd/debugger/common2/icons/empty";
    private static String ICON_SIGNAL_HANDLER = "org/netbeans/modules/cnd/debugger/common2/icons/signal_handler_frame";
    private static String ICON_USER_CALL = "org/netbeans/modules/cnd/debugger/common2/icons/user_call_frame";
    private static final Action Action_VERBOSE = new VerboseAction();

    public StackModel(ContextProvider ctx) {
        super("stack");
        this.debugger = (NativeDebugger)ctx.lookupFirst(null, NativeDebugger.class);
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) {
        if (parent == "Root") {
            return this.debugger.getStack();
        }
        return null;
    }

    public int getChildrenCount(Object parent) {
        if (parent == "Root") {
            return this.debugger.getStack().length;
        }
        return 0;
    }

    public boolean isLeaf(Object node) {
        return node != "Root";
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (!(node instanceof Frame)) {
            return Catalog.get("LBL_FunctionCol");
        }
        Frame frame = (Frame)node;
        if (frame.isCurrent()) {
            return VariableValue.bold(frame.getLocationName());
        }
        return frame.getLocationName();
    }

    public String getIconBase(Object node) {
        if (node instanceof Frame) {
            Frame f = (Frame)node;
            if (f.isCurrent()) {
                return ICON_BASE_CURRENT;
            }
            if (f.isSignalHandler()) {
                return ICON_SIGNAL_HANDLER;
            }
            if (f.isUserCall()) {
                return ICON_USER_CALL;
            }
            if (f.isSpecial()) {
                return ICON_EMPTY;
            }
            return ICON_BASE;
        }
        return null;
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node instanceof Frame) {
            Frame frame = (Frame)node;
            return frame.getLoadObj();
        }
        return this.getDisplayName(node);
    }

    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (!(node instanceof Frame)) {
            throw new UnknownTypeException(node);
        }
        Frame frame = (Frame)node;
        if (columnID == "CallStackFrameLocation") {
            return frame.getLocation();
        }
        if (columnID == "PROP_FRAME_NUMBER") {
            return frame.getNumber();
        }
        if (columnID == "PROP_FRAME_OPTIMIZED") {
            return frame.getOptimized();
        }
        if (columnID == "PROP_FRAME_CURRENT_PC") {
            return frame.getCurrentPC();
        }
        if (columnID == "PROP_FRAME_LOADOBJ") {
            return frame.getLoadObjBase();
        }
        return "?" + columnID + "?";
    }

    public boolean isReadOnly(Object node, String columnID) {
        return true;
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        if (!(node instanceof Frame)) {
            throw new UnknownTypeException(node);
        }
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        EngineDescriptor desp = this.debugger.getNDI().getEngineDescriptor();
        boolean canDoMaxFrame = desp.hasCapability(EngineCapability.STACK_MAXFRAME);
        boolean canDoVerbose = desp.hasCapability(EngineCapability.STACK_VERBOSE);
        if (node == "Root") {
            return new Action[]{new PopTopmostCallAction(this.debugger), SystemAction.get(PopToCurrentFrameAction.class), SystemAction.get(PopLastDebuggerCallAction.class), new CopyStackAction(this.debugger), null, canDoMaxFrame ? (MaxFrameAction)SystemAction.get(MaxFrameAction.class) : null, canDoVerbose ? Action_VERBOSE : null};
        }
        if (node instanceof Frame) {
            Frame frame = (Frame)node;
            return new Action[]{new MakeCurrentAction(this.debugger, frame), null, new PopTopmostCallAction(this.debugger), new PopToHereAction(this.debugger, frame), SystemAction.get(PopLastDebuggerCallAction.class), new CopyStackAction(this.debugger), null, canDoMaxFrame ? (MaxFrameAction)SystemAction.get(MaxFrameAction.class) : null, canDoVerbose ? Action_VERBOSE : null};
        }
        throw new UnknownTypeException(node);
    }

    public void performDefaultAction(Object node) {
        Frame frame = (Frame)node;
        if (frame.more) {
            this.debugger.moreFrame();
        } else {
            this.debugger.makeFrameCurrent(frame);
        }
    }

    public void addModelListener(ModelListener l) {
        if (super.addModelListenerHelp(l)) {
            this.debugger.registerStackModel(this);
        }
    }

    public void removeModelListener(ModelListener l) {
        if (super.removeModelListenerHelp(l)) {
            this.debugger.registerStackModel(null);
        }
    }

    private static class CopyStackAction
    extends AbstractAction {
        private NativeDebugger debugger;

        CopyStackAction(NativeDebugger debugger) {
            super(Catalog.get("ACT_Copy_Stack"));
            this.debugger = debugger;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.debugger.copyStack();
        }
    }

    private static class VerboseAction
    extends BooleanStateAction {
        private VerboseAction() {
        }

        public boolean getBooleanState() {
            NativeDebugger debugger = NativeDebuggerManager.get().currentNativeDebugger();
            return debugger.getVerboseStack();
        }

        public String getName() {
            return Catalog.get("LBL_Verbose");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("Debugging_stack_verbose");
        }

        public void actionPerformed(ActionEvent e) {
            NativeDebugger debugger = NativeDebuggerManager.get().currentNativeDebugger();
            debugger.postVerboseStack(!this.getBooleanState());
        }
    }

    private static class PopTopmostCallAction
    extends AbstractAction {
        private NativeDebugger debugger;

        PopTopmostCallAction(NativeDebugger debugger) {
            super(Catalog.get("ACT_Pop_Caller"));
            this.debugger = debugger;
            this.setEnabled(!debugger.state().isCore);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.debugger.popTopmostCall();
        }
    }

    private static class PopToHereAction
    extends AbstractAction {
        private NativeDebugger debugger;
        private Frame frame;

        PopToHereAction(NativeDebugger debugger, Frame frame) {
            super(Catalog.get("ACT_PopTo_Here"));
            this.debugger = debugger;
            this.frame = frame;
            this.setEnabled(!frame.isCurrent() && !frame.isSpecial());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.debugger.popToHere(this.frame);
        }
    }

    private static class MakeCurrentAction
    extends AbstractAction {
        private NativeDebugger debugger;
        private Frame frame;

        MakeCurrentAction(NativeDebugger debugger, Frame frame) {
            super(Catalog.get("ACT_Make_Current"));
            this.debugger = debugger;
            this.frame = frame;
            this.setEnabled(!frame.isCurrent() && !frame.isSpecial());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.debugger.makeFrameCurrent(this.frame);
        }
    }
}

