/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import org.netbeans.api.debugger.Session;
import org.netbeans.modules.cnd.debugger.common2.debugger.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerInfo;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.State;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineType;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;

public final class NativeSession {
    private ContextProvider ctx;
    private Session coreSession;
    private NativeDebugger debugger;
    private static int nextSerialNumber = 0;
    private int serialNumber = 0;
    private ModelListener updater;
    private EngineType engine = null;
    private State state = null;
    private long pid = -1L;
    private String target;
    private String shortName = null;
    private String corefile;
    private String hostName;

    public NativeSession(ContextProvider ctx) {
        this.ctx = ctx;
        this.coreSession = (Session)ctx.lookupFirst(null, Session.class);
        this.serialNumber = nextSerialNumber++;
        this.setUpdater(NativeDebuggerManager.get().sessionUpdater());
    }

    public void setDebugger(NativeDebugger nd) {
        this.debugger = nd;
    }

    public Session coreSession() {
        return this.coreSession;
    }

    public static NativeSession map(Session coreSession) {
        return (NativeSession)coreSession.lookupFirst(null, NativeSession.class);
    }

    private void setUpdater(ModelListener updater) {
        this.updater = updater;
    }

    public void update() {
        this.updater.modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)this.coreSession));
    }

    public void makeCurrent() {
        NativeDebuggerManager.get().setCurrentSession(this.coreSession);
    }

    public void kill() {
        this.coreSession.kill();
    }

    private boolean isUnique() {
        NativeSession[] sessions = NativeDebuggerManager.get().getSessions();
        String thisName = this.getShortName();
        boolean programUnique = true;
        for (int sx = 0; sx < sessions.length; ++sx) {
            NativeSession thatSession = sessions[sx];
            if (thatSession == this || !IpeUtils.sameString(thisName, thatSession.getShortName())) continue;
            programUnique = false;
            break;
        }
        return programUnique;
    }

    public String getName() {
        String name = this.getShortName();
        if (!this.isUnique()) {
            name = name + " # " + this.serialNumber;
        }
        return name;
    }

    public String toString() {
        String s = "";
        s = this.target != null ? s + this.target : s + "-";
        if (this.corefile != null) {
            s = s + " " + this.corefile + " ";
        }
        if (this.pid != -1L) {
            s = s + " (" + this.pid + ")";
        }
        return s;
    }

    public final void setSessionEngine(EngineType s) {
        this.engine = s;
    }

    public final EngineType getSessionEngine() {
        return this.engine;
    }

    public void setSessionState(State s) {
        this.state = s;
    }

    public String getSessionState() {
        if (this.state == null) {
            return Catalog.get("MSG_session_paused");
        }
        if (!this.state.isProcess) {
            return Catalog.get("MSG_session_exited");
        }
        if (this.state.isRunning) {
            return Catalog.get("MSG_session_running");
        }
        if (!this.state.isRunning && !this.state.isCore) {
            return Catalog.get("MSG_session_paused");
        }
        if (this.state.isCore) {
            return Catalog.get("MSG_session_core_file");
        }
        return Catalog.get("MSG_session_paused");
    }

    public String getSessionCore() {
        NativeDebuggerInfo ddi = this.debugger.getNDI();
        if (ddi != null) {
            return ddi.getCorefile();
        }
        return "";
    }

    public String getSessionLocation() {
        return this.getTarget();
    }

    public String getSessionArgs() {
        NativeDebuggerInfo ddi = this.debugger.getNDI();
        if (ddi != null) {
            return ddi.getArgsFlat();
        }
        return "";
    }

    public String getSessionMode() {
        StringBuffer mode = new StringBuffer();
        if (this.debugger.isMultiThreading()) {
            mode.append(" MT");
        }
        return mode.toString().trim();
    }

    public long getPid() {
        return this.pid;
    }

    public void setPid(long pid) {
        this.pid = pid;
        this.update();
    }

    public String getTarget() {
        if (this.target == null) {
            return "-";
        }
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
        this.shortName = null;
        if (this.updater != null) {
            this.updater.modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    public String getShortName() {
        if (this.target == null) {
            return "";
        }
        if (this.shortName == null) {
            this.shortName = CndPathUtilitities.getBaseName((String)this.target);
        }
        return this.shortName;
    }

    public String getCorefile() {
        return this.corefile;
    }

    public void setCorefile(String corefile) {
        this.corefile = corefile;
    }

    public void setSessionHost(String h) {
        this.hostName = h;
    }

    public String getSessionHost() {
        if (IpeUtils.isEmpty(this.hostName)) {
            return "localhost";
        }
        return this.hostName;
    }
}

