/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import org.netbeans.modules.cnd.debugger.common2.DbgActionHandler;
import org.netbeans.modules.cnd.debugger.common2.capture.CaptureInfo;
import org.netbeans.modules.cnd.debugger.common2.debugger.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerSettingsBridge;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineDescriptor;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineType;
import org.netbeans.modules.cnd.debugger.common2.debugger.debugtarget.DebugTarget;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.DbgProfile;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Host;
import org.netbeans.modules.cnd.debugger.common2.utils.Executor;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakefileConfiguration;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.openide.windows.InputOutput;

public abstract class NativeDebuggerInfo {
    private final EngineType debuggerType;
    private DbgProfile dbgProfile = null;
    private String target;
    private String corefile;
    private String hostName;
    private long pid = -1L;
    private String argsFlat = null;
    private Configuration configuration;
    private DebugTarget debugtarget;
    private boolean loadsucceed;
    private RunProfile profile = null;
    private InputOutput io = null;
    private DbgActionHandler dah = null;
    private MakefileConfiguration makefileConfiguration = null;
    private int action = 0;
    private boolean clone;
    private CaptureInfo captureInfo;
    private boolean is32bitEngine = false;

    protected NativeDebuggerInfo(EngineType debuggerType) {
        this.debuggerType = debuggerType;
    }

    public abstract String getID();

    public final String getTarget() {
        if (this.debugtarget != null) {
            return this.debugtarget.getExecutable();
        }
        return this.target;
    }

    public final void setTarget(String target) {
        if (this.debugtarget != null) {
            this.debugtarget.setExecutable(target);
        }
        this.target = target;
    }

    public final String getCorefile() {
        return this.corefile;
    }

    public final void setCorefile(String corefile) {
        this.corefile = corefile;
    }

    public final String getHostName() {
        return this.hostName;
    }

    public final void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public final long getPid() {
        return this.pid;
    }

    public final void setPid(long pid) {
        this.pid = pid;
    }

    public String getRunDir() {
        return DebuggerSettingsBridge.getRunDir(this.getDbgProfile(), this.profile);
    }

    public final String[] getArguments() {
        if (this.profile != null) {
            return this.profile.getArgsArray();
        }
        return null;
    }

    public final String getArgsFlat() {
        if (this.profile != null) {
            return this.profile.getArgsFlat();
        }
        return null;
    }

    public final Configuration getConfiguration() {
        return this.configuration;
    }

    public final void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public final void setDebugTarget(DebugTarget dt) {
        this.debugtarget = dt;
    }

    public final DebugTarget getDebugTarget() {
        return this.debugtarget;
    }

    public final void setLoadSuccess(boolean s) {
        this.loadsucceed = s;
    }

    public final boolean loadSucceed() {
        return this.loadsucceed;
    }

    public final RunProfile getProfile() {
        if (this.profile == null) {
            this.profile = (RunProfile)this.configuration.getAuxObject("runprofile");
        }
        return this.profile;
    }

    public int getConsoleType(boolean remote) {
        RunProfile _profile = this.getProfile();
        if (_profile != null) {
            int value = _profile.getConsoleType().getValue();
            if (remote && value == 1) {
                value = 3;
            }
            return value;
        }
        return 3;
    }

    public final void setProfile(RunProfile profile) {
        this.profile = profile;
    }

    public InputOutput getInputOutput() {
        return this.io;
    }

    public void setInputOutput(InputOutput io) {
        this.io = io;
    }

    public DbgActionHandler getDah() {
        return this.dah;
    }

    public void setDah(DbgActionHandler dah) {
        this.dah = dah;
    }

    public final EngineType debuggerType() {
        return this.debuggerType;
    }

    public final EngineDescriptor getEngineDescriptor() {
        assert (this.debuggerType != null);
        return new EngineDescriptor(this.debuggerType);
    }

    protected abstract String getDbgProfileId();

    public final DbgProfile getDbgProfile() {
        if (this.dbgProfile == null) {
            this.dbgProfile = (DbgProfile)this.getConfiguration().getAuxObject(this.getDbgProfileId());
        }
        return this.dbgProfile;
    }

    public final void setDbgProfile(DbgProfile profile) {
        this.dbgProfile = profile;
    }

    public final MakefileConfiguration getMakefileConfiguration() {
        MakeConfiguration makeConfiguration;
        if (this.makefileConfiguration == null && this.configuration instanceof MakeConfiguration && (makeConfiguration = (MakeConfiguration)this.configuration).isMakefileConfiguration()) {
            this.makefileConfiguration = makeConfiguration.getMakefileConfiguration();
        }
        return this.makefileConfiguration;
    }

    public final void setAction(int i) {
        this.action |= i;
    }

    public final void removeAction(int i) {
        this.action &= ~i;
    }

    public final int getAction() {
        return this.action;
    }

    public final void setClone() {
        this.clone = true;
    }

    public final boolean isClone() {
        return this.clone;
    }

    public final CaptureInfo getCaptureInfo() {
        return this.captureInfo;
    }

    public final void setCaptureInfo(CaptureInfo captureInfo) {
        this.captureInfo = captureInfo;
    }

    public final boolean isCaptured() {
        return this.captureInfo != null;
    }

    public final boolean is32bitEngine() {
        return this.is32bitEngine;
    }

    public final void set32bitEngine(boolean p) {
        this.is32bitEngine = p;
    }

    public final boolean is64bitDebuggee(Host host) {
        int act = this.getAction();
        String debuggee = null;
        Executor executor = Executor.getDefault(Catalog.get("File"), host, 0);
        if ((act & 8) != 0) {
            debuggee = this.getCorefile();
        } else if ((act & 4) != 0) {
            debuggee = executor.readlink(this.getPid());
            if (debuggee == null) {
                return false;
            }
        } else {
            debuggee = this.getTarget();
        }
        if (debuggee == null || debuggee.length() == 0) {
            return host.isLinux64();
        }
        return executor.is_64(debuggee);
    }

    public static interface Factory {
        public NativeDebuggerInfo create(EngineType var1);
    }
}

