/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ui.BuildToolsAction;
import org.netbeans.modules.cnd.api.toolchain.ui.LocalToolsPanelModel;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsPanelModel;
import org.netbeans.modules.cnd.debugger.common2.DbgActionHandler;
import org.netbeans.modules.cnd.debugger.common2.capture.CaptureInfo;
import org.netbeans.modules.cnd.debugger.common2.capture.ExternalStart;
import org.netbeans.modules.cnd.debugger.common2.capture.ExternalStartManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.ActionEnabler;
import org.netbeans.modules.cnd.debugger.common2.debugger.Address;
import org.netbeans.modules.cnd.debugger.common2.debugger.Autos;
import org.netbeans.modules.cnd.debugger.common2.debugger.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerAnnotation;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerSettingsBridge;
import org.netbeans.modules.cnd.debugger.common2.debugger.EditorBridge;
import org.netbeans.modules.cnd.debugger.common2.debugger.Frame;
import org.netbeans.modules.cnd.debugger.common2.debugger.Location;
import org.netbeans.modules.cnd.debugger.common2.debugger.Log;
import org.netbeans.modules.cnd.debugger.common2.debugger.ModelChangeDelegator;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerInfo;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeSession;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeWatch;
import org.netbeans.modules.cnd.debugger.common2.debugger.RoutingToken;
import org.netbeans.modules.cnd.debugger.common2.debugger.State;
import org.netbeans.modules.cnd.debugger.common2.debugger.StateListener;
import org.netbeans.modules.cnd.debugger.common2.debugger.VarContinuation;
import org.netbeans.modules.cnd.debugger.common2.debugger.Variable;
import org.netbeans.modules.cnd.debugger.common2.debugger.WatchBag;
import org.netbeans.modules.cnd.debugger.common2.debugger.WatchVariable;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.BreakpointModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.Controller;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.DisFragModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.Disassembly;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.DisassemblyUtils;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.MemoryWindow;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.RegistersWindow;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.StateModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.BreakpointManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.BreakpointProvider;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.Context;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.Gen;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.Handler;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.InstructionBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.io.IOPack;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.DebuggerOption;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Host;
import org.netbeans.modules.cnd.debugger.common2.utils.Executor;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.debugger.common2.utils.ListMap;
import org.netbeans.modules.cnd.debugger.common2.utils.ListMapItem;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionLayers;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionSet;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.spi.toolchain.CompilerSetFactory;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.text.Line;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;

public abstract class NativeDebuggerImpl
implements NativeDebugger,
BreakpointProvider {
    private final BreakpointManager bm;
    protected ContextProvider ctxProvider;
    protected DebuggerEngine debuggerEngine;
    protected NativeSession session;
    protected DebuggerSettingsBridge profileBridge;
    protected boolean postedKill = false;
    protected boolean postedKillEngine = false;
    protected Location visitedLocation = null;
    protected final DebuggerAnnotation visitMarker;
    protected final DebuggerAnnotation visitDisMarker;
    protected final DebuggerAnnotation currentPCMarker;
    protected final DebuggerAnnotation currentDisPCMarker;
    private boolean srcOOD;
    private String srcOODMessage = null;
    protected ListMap<WatchVariable> watches = new ListMap();
    protected final ModelChangeDelegator localUpdater = new ModelChangeDelegator();
    private boolean showAutos = false;
    protected final List<Variable> autos = Collections.synchronizedList(new ArrayList());
    protected Frame[] guiStackFrames = null;
    protected Frame currentFrame;
    protected final ModelChangeDelegator stackUpdater = new ModelChangeDelegator();
    protected final ModelChangeDelegator threadUpdater = new ModelChangeDelegator();
    private boolean disActive = false;
    protected boolean disRequested = false;
    private StateModelAdaptor disStateModel = new StateModelAdaptor();
    private InstBreakpointModel breakpointModel = new InstBreakpointModel();
    protected Executor executor;
    private IOPack ioPack;
    private Host host = null;
    private PathMap cachedPathMap;
    private boolean lookedPathMap;
    protected final List<StateListener> actions = new LinkedList<StateListener>();
    protected Timer runTimer;
    protected int runDelay = -1;
    private final State state = new State();
    WatchJobs watchJobs = new WatchJobs();
    private VarContinuations varContinuations = new VarContinuations();
    protected volatile boolean viaShowLocation = false;
    protected int deliverSignal = -1;
    protected OptionLayers optionLayers = null;
    private boolean asmVisible;
    private CaptureState captureState = CaptureState.NONE;
    private CaptureInfo captureInfo;

    protected NativeDebuggerImpl(ContextProvider ctxProvider) {
        this.ctxProvider = ctxProvider;
        this.bm = new BreakpointManager(this, this);
        this.debuggerEngine = (DebuggerEngine)ctxProvider.lookupFirst(null, DebuggerEngine.class);
        this.session = (NativeSession)ctxProvider.lookupFirst(null, NativeSession.class);
        assert (this.session != null) : "NativeDebuggerImpl created session";
        this.session.setDebugger(this);
        this.currentPCMarker = new DebuggerAnnotation(null, "CurrentPC", null, true);
        this.currentDisPCMarker = new DebuggerAnnotation(null, "CurrentPC", null, true);
        this.visitMarker = new DebuggerAnnotation(null, "CallSite", null, true);
        this.visitDisMarker = new DebuggerAnnotation(null, "CallSite", null, true);
    }

    @Override
    public final NativeSession session() {
        return this.session;
    }

    @Override
    public final NativeDebuggerManager manager() {
        return NativeDebuggerManager.get();
    }

    @Override
    public final BreakpointManager bm() {
        return this.bm;
    }

    @Override
    public boolean isCurrent() {
        return this.manager().currentNativeDebugger() == this;
    }

    @Override
    public DebuggerSettingsBridge profileBridge() {
        return this.profileBridge;
    }

    @Override
    public Context context() {
        String executable = this.session().getTarget();
        String hostname = this.session().getSessionHost();
        return new Context(executable, hostname);
    }

    protected void setIOPack(IOPack ioPack) {
        this.ioPack = ioPack;
    }

    public IOPack getIOPack() {
        return this.ioPack;
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.executor.getExecutionEnvironment();
    }

    @Override
    public Host getHost() {
        if (this.host == null) {
            this.host = Host.byName(this.getNDI().getHostName());
        }
        return this.host;
    }

    private PathMap getPathMap() {
        if (!this.lookedPathMap) {
            this.lookedPathMap = true;
            Configuration conf = this.getNDI().getConfiguration();
            this.cachedPathMap = !(conf instanceof MakeConfiguration) ? null : NativeDebuggerImpl.getPathMapFromConfig(conf);
        }
        return this.cachedPathMap;
    }

    public static PathMap getPathMapFromConfig(Configuration conf) {
        MakeConfiguration mc = (MakeConfiguration)conf;
        ExecutionEnvironment ee = mc.getDevelopmentHost().getExecutionEnvironment();
        RemoteSyncFactory syncFactory = mc.getRemoteSyncFactory();
        return syncFactory == null ? null : syncFactory.getPathMap(ee);
    }

    @Override
    public final String localToRemote(String who, String path) {
        String mapped;
        if (path == null) {
            mapped = path;
        } else if (NativeDebuggerManager.isStandalone()) {
            mapped = path;
        } else {
            PathMap pm = this.getPathMap();
            if (pm == null) {
                mapped = path;
            } else {
                mapped = pm.getRemotePath(path);
                if (mapped == null) {
                    mapped = path;
                }
            }
        }
        if (Log.PathMap.debug) {
            System.out.printf("localToRemote - %s\n", who);
            System.out.printf("    from: %s\n", path);
            System.out.printf("      to: %s\n", mapped);
        }
        return mapped;
    }

    @Override
    public final String remoteToLocal(String who, String path) {
        String mapped;
        if (path == null) {
            mapped = path;
        } else if (NativeDebuggerManager.isStandalone()) {
            mapped = path;
        } else {
            PathMap pm = this.getPathMap();
            if (pm == null) {
                mapped = path;
            } else {
                mapped = pm.getLocalPath(path);
                if (mapped == null) {
                    mapped = path;
                }
            }
        }
        if (Log.PathMap.debug) {
            System.out.printf("remoteToLocal - %s\n", who);
            System.out.printf("    from: %s\n", path);
            System.out.printf("      to: %s\n", mapped);
        }
        return mapped;
    }

    public final boolean willBeLoading() {
        if (this.getNDI() == null) {
            return false;
        }
        return !IpeUtils.isEmpty(this.getNDI().getTarget()) || !IpeUtils.isEmpty(this.getNDI().getCorefile()) || this.getNDI().getPid() != -1L;
    }

    @Override
    public void invalidateSessionData() {
        if (this.session != null) {
            this.session.update();
        }
    }

    public void setStatusText(String text) {
        this.manager().setStatusText(text);
    }

    private ActionEnabler actionEnabler() {
        return NativeDebuggerManager.actionEnabler();
    }

    @Override
    public State state() {
        return this.state;
    }

    @Override
    public void addStateListener(StateListener sl) {
        this.actions.add(sl);
    }

    protected void removeStateListener(StateListener sl) {
        this.actions.remove(sl);
    }

    public final void stateChanged() {
        if (this.isCurrent()) {
            this.updateActions();
            this.invalidateSessionData();
        }
    }

    public final void pidChanged() {
        NativeBreakpoint[] bpts;
        for (NativeBreakpoint b : bpts = this.bm().breakpointBag().getBreakpoints()) {
            b.updateFor(this);
        }
    }

    protected void updateActions() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (StateListener action : NativeDebuggerImpl.this.actions) {
                    action.update(NativeDebuggerImpl.this.state);
                }
                NativeDebuggerImpl.this.actionEnabler().update(NativeDebuggerImpl.this.state);
            }
        });
    }

    private int getRunDelay() {
        if (this.runDelay == -1) {
            this.runDelay = 250;
            String delay = System.getProperty("spro.rundelay");
            if (delay != null) {
                try {
                    this.runDelay = Integer.parseInt(delay);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return this.runDelay;
    }

    public final void stateSetRunning(boolean running) {
        if (!running) {
            if (this.runTimer != null) {
                this.runTimer.stop();
            }
            this.state.isRunning = false;
            this.updateActions();
        } else if (this.runTimer == null) {
            this.runTimer = new Timer(this.getRunDelay(), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ((NativeDebuggerImpl)NativeDebuggerImpl.this).state.isRunning = true;
                    NativeDebuggerImpl.this.updateActions();
                }
            });
            this.runTimer.setRepeats(false);
            this.runTimer.setCoalesce(true);
            this.runTimer.start();
        } else {
            this.runTimer.restart();
        }
    }

    protected final boolean stateFromProg() {
        return !this.state.isCore && !this.state.isAttach;
    }

    @Override
    public abstract String debuggerType();

    protected WatchJob getWatchJob(int rt) {
        return this.watchJobs.get(rt);
    }

    protected void noteNewWatch(NativeWatch template, int rt) {
        if (Log.Watch.pathway) {
            System.out.printf("noteNewWatch(%d)\n", rt);
        }
        WatchJob wj = new WatchJob(WatchJob.Kind.NEW, null, template);
        wj.setRoutingToken(rt);
        wj.setPrimaryChange(true);
        this.watchJobs.put(rt, wj);
    }

    protected void noteDeletedWatch(WatchVariable target, boolean spread) {
        int rt = target.getRoutingToken();
        WatchJob wj = new WatchJob(WatchJob.Kind.DELETE, target, null);
        wj.setPrimaryChange(spread);
        wj.setRoutingToken(rt);
        this.watchJobs.put(rt, wj);
    }

    protected void noteRestoredWatch(NativeWatch template, int rt) {
        WatchJob wj = new WatchJob(WatchJob.Kind.RESTORE, null, template);
        wj.setRoutingToken(rt);
        this.watchJobs.put(rt, wj);
    }

    @Override
    public WatchVariable[] getWatches() {
        return (WatchVariable[])this.watches.toArray(new WatchVariable[this.watches.size()]);
    }

    protected WatchBag watchBag() {
        return this.manager().watchBag();
    }

    protected ModelChangeDelegator watchUpdater() {
        return this.manager().watchUpdater();
    }

    @Override
    public void restoreWatches(WatchBag wb) {
        NativeWatch[] watchesToRestore = wb.getWatches();
        for (int i = 0; i < watchesToRestore.length; ++i) {
            NativeWatch template = watchesToRestore[i];
            if (template == null || !template.isEnabled()) continue;
            this.restoreWatch(template);
        }
    }

    protected void deleteWatch(WatchVariable w, boolean spreading) {
        this.watches.remove(w);
        w.removeAllDescendantFromOpenList(false);
        this.watchUpdater().treeChanged();
        NativeWatch parent = w.getNativeWatch();
        if (!this.postedKill) {
            parent.removeSubWatch(w, this);
            if (parent.nChildren() == 0) {
                parent.delete();
            } else if (!spreading) {
                parent.postDelete(true);
            }
        } else {
            parent.removeSubWatch(w, this);
        }
    }

    public final void deleteWatchById(int rt, int id) {
        WatchVariable w = this.watches.byKey(id);
        if (w != null) {
            WatchJob wj = this.getWatchJob(rt);
            this.deleteWatch(w, wj.isPrimaryChange());
        }
    }

    @Override
    public void spreadWatchCreation(NativeWatch w) {
        this.restoreWatch(w);
    }

    @Override
    public abstract void replaceWatch(NativeWatch var1, String var2);

    protected abstract void restoreWatch(NativeWatch var1);

    protected final void clearFiredEvents() {
        for (Handler h : this.bm().getHandlers()) {
            h.setFired(false);
        }
    }

    protected abstract void postVarContinuation(int var1, VarContinuation var2);

    @Override
    public void postVarContinuation(VarContinuation vc) {
        int rt = RoutingToken.VAR.getUniqueRoutingTokenInt();
        this.varContinuations.put(rt, vc);
        this.postVarContinuation(rt, vc);
    }

    public void handleVarContinuation(int rt, String result) {
        VarContinuation vc = this.varContinuations.get(rt);
        if (vc != null) {
            vc.run(result);
        }
    }

    @Override
    public void setShowAutos(boolean showAutos) {
        this.showAutos = showAutos;
    }

    protected final boolean isShowAutos() {
        return this.showAutos;
    }

    protected final void deleteMarkLocations() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NativeDebuggerImpl.this.setCurrentLine(null, false, false, ShowMode.NONE, false);
            }
        });
    }

    protected final void resetCurrentLine() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NativeDebuggerImpl.this.setCurrentLine(null, false, false, ShowMode.NONE, false);
            }
        });
    }

    @Override
    public Location getVisitedLocation() {
        return this.visitedLocation;
    }

    public void annotateDis(boolean andShow) {
        if (this.visitedLocation != null) {
            DebuggerAnnotation marker;
            if (this.visitedLocation.visited()) {
                marker = this.visitDisMarker;
                this.currentDisPCMarker.setLine(null, this.isCurrent());
            } else {
                marker = this.currentDisPCMarker;
                this.visitDisMarker.setLine(null, this.isCurrent());
            }
            DisassemblyUtils.annotatePC(this.visitedLocation, marker, andShow);
        } else {
            this.currentDisPCMarker.setLine(null, this.isCurrent());
            this.visitDisMarker.setLine(null, this.isCurrent());
        }
    }

    private boolean inDisMode() {
        return Disassembly.isInDisasm() && this.disRequested;
    }

    protected void setCurrentLine(Line l, boolean visited, boolean srcOOD, ShowMode showMode, boolean focus) {
        if (l != null) {
            if (showMode == ShowMode.SOURCE || showMode == ShowMode.AUTO && !this.inDisMode()) {
                EditorBridge.showInEditor(l, focus);
            }
            if (visited) {
                this.visitMarker.setLine(l, this.isCurrent());
                this.currentPCMarker.setLine(null, this.isCurrent());
            } else {
                this.visitMarker.setLine(null, this.isCurrent());
                if (!this.state.isRunning) {
                    this.currentPCMarker.setLine(l, this.isCurrent());
                }
            }
            this.annotateDis(showMode == ShowMode.DIS || showMode == ShowMode.AUTO && this.inDisMode());
        } else {
            this.visitMarker.setLine(null, this.isCurrent());
            this.visitDisMarker.setLine(null, this.isCurrent());
            this.currentPCMarker.setLine(null, this.isCurrent());
            this.currentDisPCMarker.setLine(null, this.isCurrent());
        }
        this.srcOOD = srcOOD;
        if (srcOOD) {
            this.setSrcOODMessage(Catalog.get("SourceOODWarn"));
        } else {
            this.setSrcOODMessage(null);
        }
    }

    private void updateLocation(final boolean andShow, final ShowMode showModeOverride, final boolean focus) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (NativeDebuggerImpl.this.haveSource()) {
                    String mFileName = NativeDebuggerImpl.this.fmap().engineToWorld(NativeDebuggerImpl.this.getVisitedLocation().src());
                    Line l = EditorBridge.getLine(mFileName, NativeDebuggerImpl.this.getVisitedLocation().line(), NativeDebuggerImpl.this);
                    if (l != null) {
                        ShowMode showMode = ShowMode.NONE;
                        if (andShow) {
                            showMode = showModeOverride;
                            NativeBreakpoint breakpoint = NativeDebuggerImpl.this.getVisitedLocation().getBreakpoint();
                            if (breakpoint != null) {
                                showMode = breakpoint instanceof InstructionBreakpoint ? ShowMode.DIS : ShowMode.SOURCE;
                            }
                        }
                        NativeDebuggerImpl.this.setCurrentLine(l, NativeDebuggerImpl.this.getVisitedLocation().visited(), NativeDebuggerImpl.this.getVisitedLocation().srcOutOfdate(), showMode, focus);
                    }
                } else if (NativeDebuggerImpl.this.getVisitedLocation() != null && NativeDebuggerImpl.this.getVisitedLocation().pc() != 0L) {
                    Disassembly.open();
                    NativeDebuggerImpl.this.annotateDis(andShow);
                }
            }
        });
    }

    private boolean haveSource() {
        return this.getVisitedLocation() != null && this.getVisitedLocation().hasSource();
    }

    @Override
    public void requestDisassembly() {
        this.disRequested = true;
        this.showCurrentDis();
    }

    public void showCurrentSource() {
        if (!this.haveSource()) {
            NativeDebuggerManager.warning(Catalog.get("Dis_MSG_NoSource"));
            return;
        }
        this.disRequested = false;
        this.updateLocation(true, ShowMode.SOURCE, false);
    }

    public void showCurrentDis() {
        Disassembly.open();
        this.updateLocation(true, ShowMode.DIS, false);
    }

    @Override
    public final void setVisitedLocation(Location loc) {
        this.visitedLocation = loc;
        this.requestAutos();
        this.getDisassembly().stateUpdated();
        this.updateLocation(true, ShowMode.AUTO, false);
    }

    @Override
    public void setSrcOODMessage(String msg) {
        if (msg != null && !this.srcOOD) {
            return;
        }
        this.srcOODMessage = msg;
        EditorBridge.setStatus(msg);
    }

    @Override
    public OptionLayers optionLayersInit() {
        return this.optionLayers;
    }

    protected void addExtraOptions(OptionLayers optionLayers) {
    }

    @Override
    public final OptionLayers optionLayers() {
        if (this.optionLayers == null) {
            OptionSet globalOptions = this.manager().globalOptions();
            this.optionLayers = new OptionLayers(globalOptions);
            OptionSet profileOptions = null;
            if (this.profileBridge.currentDbgProfile() != null) {
                profileOptions = this.profileBridge.currentDbgProfile().getOptions();
                assert (profileOptions != null) : "debug profile must have options";
                this.optionLayers.push(profileOptions);
            }
            this.addExtraOptions(this.optionLayers);
        }
        return this.optionLayers;
    }

    @Override
    public void optionLayersReset() {
        this.optionLayers = null;
    }

    @Override
    public void activate(boolean redundant) {
        this.ioPack.switchTo();
        this.updateLocation(true, this.disActive ? ShowMode.DIS : ShowMode.SOURCE, true);
        if (this.disActive) {
            Disassembly.open();
        }
        this.visitMarker.attach(true);
        this.visitDisMarker.attach(true);
        this.currentPCMarker.attach(true);
        this.currentDisPCMarker.attach(true);
        EditorBridge.setStatus(this.srcOODMessage);
        this.updateActions();
        if (redundant) {
            return;
        }
        this.bm().breakpointUpdater().treeChanged();
        for (NativeBreakpoint bpt : this.bm().breakpointBag().getBreakpoints()) {
            bpt.showAnnotationsFor(true, this);
        }
        this.registerRegistersWindow(RegistersWindow.getDefault().isShowing() ? RegistersWindow.getDefault() : null);
        if (MemoryWindow.getDefault().isShowing()) {
            this.registerMemoryWindow(MemoryWindow.getDefault());
            MemoryWindow.getDefault().setDebugger(this);
        } else {
            this.registerMemoryWindow(null);
        }
        if (Disassembly.isOpened()) {
            this.registerDisassembly(this.getDisassembly());
            this.getDisassembly().stateUpdated();
        } else {
            this.registerDisassembly(null);
        }
    }

    @Override
    public void deactivate(boolean redundant) {
        if (redundant) {
            return;
        }
        this.bm().breakpointUpdater().treeChanged();
        for (NativeBreakpoint bpt : this.bm().breakpointBag().getBreakpoints()) {
            bpt.showAnnotationsFor(false, this);
        }
        this.disActive = Disassembly.isInDisasm();
        this.getDisassembly().reset();
        this.visitMarker.detach();
        this.visitDisMarker.detach();
        this.currentPCMarker.detach();
        this.currentDisPCMarker.detach();
        EditorBridge.setStatus(null);
    }

    @Override
    public boolean getVerboseStack() {
        return "on".equals(DebuggerOption.STACK_VERBOSE.getCurrValue(this.optionLayers()));
    }

    protected final void preKill() {
        DbgActionHandler dah;
        NativeSession[] sessions;
        this.postedKill = true;
        if (this.getIOPack() != null && this.getIOPack().console().getTerm() != null) {
            String warn = this.debuggerType() + " terminated";
            char[] warnArray = warn.toCharArray();
            this.getIOPack().console().getTerm().putChars(warnArray, 0, warnArray.length);
        }
        if ((sessions = NativeDebuggerManager.get().getSessions()).length <= 1) {
            Disassembly.close();
        }
        for (Handler handler : this.bm().getHandlers()) {
            this.bm().deleteHandler(handler, Gen.secondary(null), true);
        }
        for (ListMapItem listMapItem : this.getWatches()) {
            this.deleteWatch((WatchVariable)listMapItem, false);
        }
        if (NativeDebuggerManager.isPerTargetBpts()) {
            this.bm().breakpointBag().cleanupBpts();
        }
        if ((dah = this.getNDI().getDah()) != null) {
            dah.executionFinished(0);
        }
    }

    protected final boolean isAsmVisible() {
        return this.asmVisible;
    }

    protected final void setAsmVisible(boolean asmVisible) {
        this.asmVisible = asmVisible;
    }

    protected abstract void stopUpdates();

    protected abstract void startUpdates();

    protected final void setCaptureState(CaptureState captureState) {
        if (Log.Capture.state) {
            System.out.printf("setCaptureState(): %s -> %s\n", new Object[]{this.captureState, captureState});
        }
        this.captureState = captureState;
    }

    protected final CaptureState getCaptureState() {
        return this.captureState;
    }

    protected final void setCaptureInfo(CaptureInfo captureInfo) {
        if (Log.Capture.info) {
            System.out.printf("setCaptureInfo(): %s\n", captureInfo);
        }
        this.captureInfo = captureInfo;
    }

    protected final CaptureInfo getCaptureInfo() {
        return this.captureInfo;
    }

    protected final void captureFailed() {
        ExternalStart xstart = ExternalStartManager.getXstart(this.getHost());
        if (this.captureState != CaptureState.NONE) {
            this.captureState = CaptureState.NONE;
            this.startUpdates();
            if (this.captureState == CaptureState.FINAL) {
                NativeDebuggerManager.warning(String.format("ss_attach failed to exec %s", this.captureInfo.executable));
            } else {
                if (xstart != null) {
                    xstart.fail();
                }
                NativeDebuggerManager.warning(String.format("%s failed during capture", this.debuggerType()));
            }
        } else {
            NativeDebuggerInfo ndi = this.getNDI();
            if (xstart != null && ndi.isCaptured()) {
                xstart.fail();
            }
        }
    }

    protected abstract DisFragModel disModel();

    public abstract Controller disController();

    protected InstBreakpointModel breakpointModel() {
        return this.breakpointModel;
    }

    protected final StateModelAdaptor disStateModel() {
        return this.disStateModel;
    }

    @Override
    public final void InstBptEnabled(long addr, NativeBreakpoint bpt) {
        this.disController().enableBreakpoint(addr, bpt, true);
    }

    @Override
    public final void InstBptDisabled(long addr, NativeBreakpoint bpt) {
        this.disController().enableBreakpoint(addr, bpt, false);
    }

    @Override
    public final void InstBptAdded(long addr, NativeBreakpoint bpt) {
        this.disController().updateBreakpoint(addr, bpt, true);
    }

    @Override
    public final void InstBptRemoved(long addr, NativeBreakpoint bpt) {
        this.disController().updateBreakpoint(addr, bpt, false);
    }

    public static String getDebuggerString(MakeConfiguration conf) {
        String path;
        Tool debuggerTool;
        CompilerSet2Configuration csconf = conf.getCompilerSet();
        CompilerSet cs = csconf.getCompilerSet();
        ExecutionEnvironment exEnv = conf.getDevelopmentHost().getExecutionEnvironment();
        String csname = csconf.getOption();
        if (cs == null) {
            int platform = conf.getPlatformInfo().getPlatform();
            CompilerFlavor flavor = CompilerFlavor.toFlavor((String)csname, (int)platform);
            flavor = flavor == null ? CompilerFlavor.getUnknown((int)platform) : flavor;
            cs = CompilerSetFactory.getCompilerSet((ExecutionEnvironment)exEnv, (CompilerFlavor)flavor, (String)csname);
        }
        if ((debuggerTool = cs.getTool((ToolKind)PredefinedToolKind.DebuggerTool)) != null && (path = debuggerTool.getPath()) != null && !path.isEmpty()) {
            return path;
        }
        LocalToolsPanelModel model = new LocalToolsPanelModel();
        model.setCRequired(false);
        model.setCppRequired(false);
        model.setFortranRequired(false);
        model.setMakeRequired(false);
        model.setDebuggerRequired(true);
        model.setShowRequiredBuildTools(false);
        model.setShowRequiredDebugTools(true);
        model.setCompilerSetName(null);
        model.setSelectedCompilerSetName(csname);
        model.setSelectedDevelopmentHost(exEnv);
        model.setEnableDevelopmentHostChange(false);
        BuildToolsAction bt = (BuildToolsAction)SystemAction.get(BuildToolsAction.class);
        bt.setTitle(Catalog.get("LBL_ResolveMissingDebugger_Title"));
        if (bt.initBuildTools((ToolsPanelModel)model, new ArrayList(), cs)) {
            conf.getCompilerSet().setValue(model.getSelectedCompilerSetName());
            cs = CompilerSetManager.get((ExecutionEnvironment)exEnv).getCompilerSet(model.getSelectedCompilerSetName());
            return cs.getTool((ToolKind)PredefinedToolKind.DebuggerTool).getPath();
        }
        return null;
    }

    @Override
    public void registerMemoryWindow(MemoryWindow w) {
    }

    @Override
    public Set<String> requestAutos() {
        this.autos.clear();
        if (!this.isShowAutos()) {
            return Collections.emptySet();
        }
        Location location = this.getVisitedLocation();
        if (location == null || !location.hasSource()) {
            this.localUpdater.batchOffForce();
            return Collections.emptySet();
        }
        return Autos.get(EditorBridge.documentFor(location.src(), this), location.line() - 1);
    }

    @Override
    public int getAutosCount() {
        return this.autos.size();
    }

    @Override
    public Variable[] getAutos() {
        Variable[] array = this.autos.toArray(new Variable[this.autos.size()]);
        return array;
    }

    @Override
    public void copyStack() {
        if (this.guiStackFrames == null) {
            return;
        }
        StringBuilder frameStr = new StringBuilder(this.guiStackFrames.length);
        for (int fx = 0; fx < this.guiStackFrames.length; ++fx) {
            frameStr.append(this.guiStackFrames[fx].getLocationName());
            frameStr.append('\n');
        }
        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        StringSelection transferableText = new StringSelection(frameStr.toString());
        clipboard.setContents(transferableText, null);
    }

    protected final class StateModelAdaptor
    implements StateModel {
        private Location location = Location.EMPTY;
        private HashMap<Long, Integer> addrHashMap;
        private final ArrayList<StateModel.Listener> listeners = new ArrayList();

        @Override
        public void addListener(StateModel.Listener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removeListener(StateModel.Listener listener) {
            this.listeners.remove(listener);
        }

        @Override
        public void setAddrHashMap(HashMap<Long, Integer> hashmap) {
            this.addrHashMap = hashmap;
        }

        @Override
        public boolean isVisited() {
            return this.location.visited();
        }

        @Override
        public long getPC() {
            return this.location.pc();
        }

        @Override
        public String getFunction() {
            return this.location.func();
        }

        @Override
        public String getFile() {
            return this.location.src();
        }

        @Override
        public int getLine() {
            return this.location.line();
        }

        private boolean inRange(long addr) {
            if (this.addrHashMap == null) {
                return false;
            }
            Integer pos = this.addrHashMap.get(addr);
            return pos != null;
        }

        public void updateStateModel(Location location, boolean retrieve) {
            this.location = location;
            if (retrieve && !this.inRange(location.pc())) {
                NativeDebuggerImpl.this.disController().requestDis(true);
            } else {
                for (StateModel.Listener l : this.listeners) {
                    l.stateUpdated();
                }
            }
        }
    }

    protected final class InstBreakpointModel
    implements BreakpointModel {
        private ArrayList<Bpt> breakpoints_List = new ArrayList();
        private ArrayList<BreakpointModel.Listener> listeners = new ArrayList();

        @Override
        public void addListener(BreakpointModel.Listener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removeListener(BreakpointModel.Listener listener) {
            this.listeners.remove(listener);
        }

        public Bpt findBptByAddr(long address) {
            for (Bpt bpt : this.breakpoints_List) {
                if (address != bpt.addr) continue;
                return bpt;
            }
            return null;
        }

        @Override
        public int findDisabled(long address) {
            int count = 0;
            for (Bpt bpt : this.breakpoints_List) {
                if (address != bpt.addr || bpt.bpt.isEnabled()) continue;
                ++count;
            }
            return count;
        }

        @Override
        public int find(long address) {
            int count = 0;
            for (Bpt bpt : this.breakpoints_List) {
                if (address != bpt.addr) continue;
                ++count;
            }
            return count;
        }

        public void enable(long address, NativeBreakpoint bpt) {
            for (BreakpointModel.Listener l : this.listeners) {
                l.bptUpdated();
            }
        }

        public void disable(Bpt bpt) {
            for (BreakpointModel.Listener l : this.listeners) {
                l.bptUpdated();
            }
        }

        public void add(long address, NativeBreakpoint bpt) {
            this.breakpoints_List.add(new Bpt(address, bpt));
            for (BreakpointModel.Listener l : this.listeners) {
                l.bptUpdated();
            }
        }

        public void remove(Bpt bpt) {
            this.breakpoints_List.remove(bpt);
            for (BreakpointModel.Listener l : this.listeners) {
                l.bptUpdated();
            }
        }

        @Override
        public NativeBreakpoint[] getBreakpoints() {
            NativeBreakpoint[] res = new NativeBreakpoint[this.breakpoints_List.size()];
            int idx = 0;
            for (Bpt bpt : this.breakpoints_List) {
                res[idx++] = bpt.bpt;
            }
            return res;
        }

        public class Bpt {
            public long addr;
            public NativeBreakpoint bpt;

            Bpt(long a, NativeBreakpoint b) {
                this.addr = a;
                this.bpt = b;
            }
        }
    }

    protected abstract class ControllerSupport
    implements Controller {
        private StateListener runToCursorListener = null;

        protected ControllerSupport() {
        }

        @Override
        public abstract void requestDis(boolean var1);

        @Override
        public abstract void requestDis(String var1, int var2, boolean var3);

        protected abstract void setBreakpointHelp(String var1);

        @Override
        public void setBreakpoint(String address, boolean add) {
            if (add) {
                this.setBreakpointHelp(address);
            } else {
                long addr = Address.parseAddr(address);
                InstBreakpointModel.Bpt foundBpt = NativeDebuggerImpl.this.breakpointModel().findBptByAddr(addr);
                if (foundBpt != null && foundBpt.bpt != null) {
                    foundBpt.bpt.dispose();
                }
            }
        }

        @Override
        public void toggleBreakpoint(String address) {
            long addr = Address.parseAddr(address);
            InstBreakpointModel.Bpt foundBpt = NativeDebuggerImpl.this.breakpointModel().findBptByAddr(addr);
            if (foundBpt == null) {
                this.setBreakpointHelp(address);
            } else if (foundBpt.bpt != null) {
                foundBpt.bpt.dispose();
            }
        }

        @Override
        public final void enableBreakpoint(long address, NativeBreakpoint bpt, boolean enable) {
            if (enable) {
                NativeDebuggerImpl.this.breakpointModel().enable(address, bpt);
            } else {
                InstBreakpointModel.Bpt foundBpt = NativeDebuggerImpl.this.breakpointModel().findBptByAddr(address);
                NativeDebuggerImpl.this.breakpointModel().disable(foundBpt);
            }
        }

        @Override
        public final void updateBreakpoint(long address, NativeBreakpoint bpt, boolean add) {
            if (add) {
                NativeDebuggerImpl.this.breakpointModel().add(address, bpt);
            } else {
                InstBreakpointModel.Bpt foundBpt = NativeDebuggerImpl.this.breakpointModel().findBptByAddr(address);
                NativeDebuggerImpl.this.breakpointModel().remove(foundBpt);
            }
        }

        public final void runToCursor(String addr) {
            NativeDebuggerImpl.this.runToCursorInst(addr);
        }

        @Override
        public final void addStateListenerInst(StateListener sl) {
            if (this.runToCursorListener == null) {
                this.runToCursorListener = sl;
                NativeDebuggerImpl.this.addStateListener(sl);
            }
        }

        @Override
        public final void removeStateListenerInst(StateListener sl) {
            if (this.runToCursorListener != null) {
                this.runToCursorListener = null;
                NativeDebuggerImpl.this.removeStateListener(sl);
            }
        }
    }

    protected class DisModelSupport
    implements DisFragModel {
        private ArrayList<DisFragModel.Line> current_addrs = new ArrayList();
        private ArrayList<DisFragModel.Listener> listeners = new ArrayList();

        protected DisModelSupport() {
        }

        @Override
        public void clear() {
            this.current_addrs.clear();
        }

        @Override
        public DisFragModel.Line getItem(int i) {
            return this.current_addrs.get(i);
        }

        @Override
        public int size() {
            return this.current_addrs.size();
        }

        @Override
        public void addListener(DisFragModel.Listener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removeListener(DisFragModel.Listener listener) {
            this.listeners.remove(listener);
        }

        protected final void add(String memaddr, String memvalue) {
            this.current_addrs.add(new DisFragModel.Line(memaddr, memvalue));
        }

        protected final void update() {
            for (DisFragModel.Listener listener : this.listeners) {
                listener.fragUpdated();
            }
        }

        @Override
        public Iterator<DisFragModel.Line> iterator() {
            return this.current_addrs.iterator();
        }
    }

    protected static enum CaptureState {
        NONE,
        INITIAL,
        FINAL;

    }

    protected static enum ShowMode {
        SOURCE,
        DIS,
        AUTO,
        NONE;

    }

    private static class VarContinuations
    extends HashMap<Integer, VarContinuation> {
        private VarContinuations() {
        }

        @Override
        public void put(int rt, VarContinuation vc) {
            vc.print();
            super.put(rt, vc);
        }

        public VarContinuation get(int rt) {
            VarContinuation vc = (VarContinuation)super.remove(rt);
            return vc;
        }
    }

    private static class WatchJobs
    extends HashMap<Integer, WatchJob> {
        private WatchJobs() {
        }

        @Override
        public void put(int rt, WatchJob wj) {
            wj.print();
            super.put(rt, wj);
        }

        public WatchJob get(int rt) {
            if (rt == 0) {
                if (Log.Watch.pathway) {
                    System.out.printf("WatchJobs.get(): rt == 0\n", new Object[0]);
                }
                WatchJob wj = new WatchJob(WatchJob.Kind.SPONTANEOUS, null, null);
                return wj;
            }
            WatchJob wj = (WatchJob)super.get(rt);
            assert (wj != null) : "WatchJobs.get(): no watch for rt " + rt;
            this.remove(rt);
            return wj;
        }
    }

    protected static class WatchJob {
        private Kind kind;
        private int routingToken;
        private WatchVariable target;
        private NativeWatch template;
        private boolean primaryChange;

        public WatchJob(Kind kind, WatchVariable target, NativeWatch template) {
            this.kind = kind;
            this.target = target;
            this.template = template;
        }

        public void print() {
            if (!Log.Watch.pathway) {
                return;
            }
            System.out.printf("WatchJob %d %s: [%s]<[%s]\nspread %b\n", new Object[]{this.routingToken, this.kind, this.target, this.template, this.primaryChange});
        }

        public Kind kind() {
            return this.kind;
        }

        public void setKind(Kind k) {
            this.kind = k;
        }

        public WatchVariable target() {
            return this.target;
        }

        public NativeWatch template() {
            return this.template;
        }

        public void setPrimaryChange(boolean primaryChange) {
            this.primaryChange = primaryChange;
        }

        public boolean isPrimaryChange() {
            return this.primaryChange;
        }

        public void setRoutingToken(int routingToken) {
            this.routingToken = routingToken;
        }

        public int getRoutingToken() {
            return this.routingToken;
        }

        public static enum Kind {
            NEW,
            RESTORE,
            REPLACE,
            SPONTANEOUS,
            DELETE;

        }
    }
}

