/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.nbjavac.services;

import com.sun.tools.javac.parser.EndPosParser;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.Lexer;
import com.sun.tools.javac.parser.Parser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.parser.Scanner;
import com.sun.tools.javac.parser.ScannerFactory;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.netbeans.lib.nbjavac.services.CancelService;
import org.netbeans.lib.nbjavac.services.NBTreeMaker;

public class NBParserFactory
extends ParserFactory {
    private final ScannerFactory scannerFactory;
    private final Names names;
    private final CancelService cancelService;

    public static void preRegister(Context context) {
        context.put(parserFactoryKey, new Context.Factory<ParserFactory>(){

            @Override
            public ParserFactory make(Context c) {
                return new NBParserFactory(c);
            }
        });
    }

    protected NBParserFactory(Context context) {
        super(context);
        this.scannerFactory = ScannerFactory.instance(context);
        this.names = Names.instance(context);
        this.cancelService = CancelService.instance(context);
    }

    public Parser newParser(CharSequence input, boolean keepDocComments, boolean keepEndPos, boolean keepLineMap) {
        return this.newParser(input, keepDocComments, keepEndPos, keepLineMap, false);
    }

    public Parser newParser(CharSequence input, int startPos, Map<JCTree, Integer> endPos) {
        Scanner lexer = this.scannerFactory.newScanner(input, true);
        lexer.seek(startPos);
        NBEndPosParser p = new NBEndPosParser(this, lexer, true, false, endPos, this.cancelService);
        return p;
    }

    public Parser newParser(CharSequence input, boolean keepDocComments, boolean keepEndPos, boolean keepLineMap, boolean partial) {
        Scanner lexer = this.scannerFactory.newScanner(input, keepDocComments);
        Object p = keepEndPos ? new NBEndPosParser(this, lexer, keepDocComments, keepLineMap, this.cancelService) : new NBJavacParser(this, (Lexer)lexer, keepDocComments, keepLineMap, this.cancelService);
        return p;
    }

    public static void assignAnonymousClassIndices(Names names, JCTree tree, Name name, int startNumber) {
        AssignAnonymousIndices aai = new AssignAnonymousIndices(names);
        if (name != null) {
            aai.newAnonScope(name, startNumber);
        }
        aai.scan(tree);
    }

    private static final class AssignAnonymousIndices
    extends TreeScanner {
        private final Names names;
        private final Map<Name, AnonScope> anonScopeMap = new HashMap<Name, AnonScope>();
        private final Stack<AnonScope> anonScopes = new Stack();

        public AssignAnonymousIndices(Names names) {
            this.names = names;
        }

        void newAnonScope(Name name) {
            this.newAnonScope(name, 1);
        }

        public void newAnonScope(Name name, int startNumber) {
            AnonScope parent = this.anonScopes.isEmpty() ? null : this.anonScopes.peek();
            Name fqn = parent != null && parent.parentDecl != this.names.empty ? parent.parentDecl.append('.', name) : name;
            AnonScope scope = this.anonScopeMap.get(fqn);
            if (scope == null) {
                scope = new AnonScope(name, startNumber);
                this.anonScopeMap.put(fqn, scope);
            }
            this.anonScopes.push(scope);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            if (tree.name == this.names.empty) {
                ((NBTreeMaker.IndexedClassDecl)tree).index = this.anonScopes.peek().assignNumber();
            }
            this.newAnonScope(tree.name);
            try {
                super.visitClassDef(tree);
            }
            finally {
                this.anonScopes.pop();
            }
            if (!this.anonScopes.isEmpty() && this.anonScopes.peek().localClass && tree.name != this.names.empty) {
                ((NBTreeMaker.IndexedClassDecl)tree).index = this.anonScopes.peek().assignLocalNumber(tree.name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitBlock(JCTree.JCBlock tree) {
            AnonScope as = this.anonScopes.peek();
            boolean old = as.localClass;
            as.localClass = true;
            try {
                super.visitBlock(tree);
            }
            finally {
                as.localClass = old;
            }
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation tree) {
            this.scan(tree.args);
            this.scan(tree.meth);
        }

        private static class AnonScope {
            public boolean localClass;
            private final Name parentDecl;
            private int currentNumber;
            private Map<Name, Integer> localClasses;

            private AnonScope(Name name, int startNumber) {
                assert (name != null);
                this.parentDecl = name;
                this.currentNumber = startNumber;
            }

            public int assignNumber() {
                int ret = this.currentNumber;
                if (this.currentNumber != -1) {
                    ++this.currentNumber;
                }
                return ret;
            }

            public int assignLocalNumber(Name name) {
                Integer num;
                if (this.localClasses == null) {
                    this.localClasses = new HashMap<Name, Integer>();
                }
                num = (num = this.localClasses.get(name)) == null ? Integer.valueOf(1) : Integer.valueOf(num + 1);
                this.localClasses.put(name, num);
                return num;
            }

            public String toString() {
                return String.format("%s : %d", this.parentDecl.toString(), this.currentNumber);
            }
        }
    }

    public static class NBEndPosParser
    extends EndPosParser {
        private final Names names;
        private final CancelService cancelService;

        public NBEndPosParser(NBParserFactory fac, Lexer S, boolean keepDocComments, boolean keepLineMap, CancelService cancelService) {
            super((ParserFactory)fac, S, keepDocComments, keepLineMap);
            this.names = fac.names;
            this.cancelService = cancelService;
        }

        public NBEndPosParser(NBParserFactory fac, Lexer S, boolean keepDocComments, boolean keepLineMap, Map<JCTree, Integer> endPositions, CancelService cancelService) {
            super((ParserFactory)fac, S, keepDocComments, keepLineMap, endPositions);
            this.names = fac.names;
            this.cancelService = cancelService;
        }

        protected JCTree.JCClassDecl classDeclaration(JCTree.JCModifiers mods, String dc) {
            if (this.cancelService != null) {
                this.cancelService.abortIfCanceled();
            }
            return super.classDeclaration(mods, dc);
        }

        protected JCTree.JCClassDecl interfaceDeclaration(JCTree.JCModifiers mods, String dc) {
            if (this.cancelService != null) {
                this.cancelService.abortIfCanceled();
            }
            return super.interfaceDeclaration(mods, dc);
        }

        protected JCTree.JCClassDecl enumDeclaration(JCTree.JCModifiers mods, String dc) {
            if (this.cancelService != null) {
                this.cancelService.abortIfCanceled();
            }
            return super.enumDeclaration(mods, dc);
        }

        protected JCTree methodDeclaratorRest(int pos, JCTree.JCModifiers mods, JCTree.JCExpression type, Name name, List<JCTree.JCTypeParameter> typarams, boolean isInterface, boolean isVoid, String dc) {
            if (this.cancelService != null) {
                this.cancelService.abortIfCanceled();
            }
            return super.methodDeclaratorRest(pos, mods, type, name, typarams, isInterface, isVoid, dc);
        }

        public JCTree.JCCompilationUnit parseCompilationUnit() {
            JCTree.JCCompilationUnit toplevel = super.parseCompilationUnit();
            NBParserFactory.assignAnonymousClassIndices(this.names, toplevel, null, -1);
            return toplevel;
        }
    }

    protected static class NBJavacParser
    extends JavacParser {
        private final Names names;
        private final CancelService cancelService;

        public NBJavacParser(NBParserFactory fac, Lexer S, boolean keepDocComments, boolean keepLineMap, CancelService cancelService) {
            super((ParserFactory)fac, S, keepDocComments, keepLineMap);
            this.names = fac.names;
            this.cancelService = cancelService;
        }

        protected JCTree.JCClassDecl classDeclaration(JCTree.JCModifiers mods, String dc) {
            if (this.cancelService != null) {
                this.cancelService.abortIfCanceled();
            }
            return super.classDeclaration(mods, dc);
        }

        protected JCTree.JCClassDecl interfaceDeclaration(JCTree.JCModifiers mods, String dc) {
            if (this.cancelService != null) {
                this.cancelService.abortIfCanceled();
            }
            return super.interfaceDeclaration(mods, dc);
        }

        protected JCTree.JCClassDecl enumDeclaration(JCTree.JCModifiers mods, String dc) {
            if (this.cancelService != null) {
                this.cancelService.abortIfCanceled();
            }
            return super.enumDeclaration(mods, dc);
        }

        protected JCTree methodDeclaratorRest(int pos, JCTree.JCModifiers mods, JCTree.JCExpression type, Name name, List<JCTree.JCTypeParameter> typarams, boolean isInterface, boolean isVoid, String dc) {
            if (this.cancelService != null) {
                this.cancelService.abortIfCanceled();
            }
            return super.methodDeclaratorRest(pos, mods, type, name, typarams, isInterface, isVoid, dc);
        }

        @Override
        public JCTree.JCCompilationUnit parseCompilationUnit() {
            JCTree.JCCompilationUnit toplevel = super.parseCompilationUnit();
            NBParserFactory.assignAnonymousClassIndices(this.names, toplevel, null, -1);
            return toplevel;
        }
    }
}

