/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fileoperations.spi.FilesystemInterceptorProvider;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemotePlainFile;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class WritingQueue {
    private static final Map<ExecutionEnvironment, WritingQueue> instances = new HashMap<ExecutionEnvironment, WritingQueue>();
    private static final Logger LOGGER = Logger.getLogger("cnd.remote.writing.queue.logger");
    private final ExecutionEnvironment execEnv;
    private final Progress progress;
    private final Map<String, Entry> entries = new HashMap<String, Entry>();
    private final Object lock = new Object();
    private final Set<String> failed = new HashSet<String>();
    private final Object monitor = new Object();

    public WritingQueue(ExecutionEnvironment env) {
        this.execEnv = env;
        this.progress = new Progress(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WritingQueue getInstance(ExecutionEnvironment env) {
        Class<WritingQueue> clazz = WritingQueue.class;
        synchronized (WritingQueue.class) {
            WritingQueue instance = instances.get(env);
            if (instance == null) {
                instance = new WritingQueue(env);
                instances.put(env, instance);
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(RemotePlainFile fo) {
        RemoteLogger.assertTrue(RemoteFileObjectBase.DEFER_WRITES);
        String dstFileName = fo.getPath();
        LOGGER.log(Level.FINEST, "WritingQueue: adding file {0}", dstFileName);
        Object object = this.lock;
        synchronized (object) {
            Entry entry = this.entries.get(dstFileName);
            if (entry == null) {
                entry = new Entry(fo);
                this.entries.put(dstFileName, entry);
            }
            entry.scheduleUpload();
            this.progress.entryAdded(this.entries.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean entriesEmpty(Collection<FileObject> filesToWait, Collection<String> failedFiles) {
        Object object = this.lock;
        synchronized (object) {
            if (this.entries.isEmpty()) {
                failedFiles.clear();
                failedFiles.addAll(this.failed);
                return true;
            }
            if (filesToWait.isEmpty()) {
                return false;
            }
            for (FileObject fo : filesToWait) {
                if (!this.entries.containsKey(fo.getPath())) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBusy() {
        Object object = this.lock;
        synchronized (object) {
            return !this.entries.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitFinished(Collection<String> failedFiles) throws InterruptedException {
        if (failedFiles == null) {
            failedFiles = new ArrayList<String>();
        }
        while (!this.entriesEmpty(Collections.<FileObject>emptyList(), failedFiles) || !this.entries.isEmpty()) {
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.wait(100L);
            }
        }
        return failedFiles.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitFinished(Collection<FileObject> filesToWait, Collection<String> failedFiles) throws InterruptedException {
        if (failedFiles == null) {
            failedFiles = new ArrayList<String>();
        }
        while (!this.entriesEmpty(filesToWait, failedFiles)) {
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.wait(100L);
            }
        }
        return failedFiles.isEmpty();
    }

    private static class Progress {
        private ProgressHandle progressHandle;
        private int progressCurrent;
        private int progressTotal;
        private final ExecutionEnvironment env;

        public Progress(ExecutionEnvironment env) {
            this.env = env;
            String msg = NbBundle.getMessage(WritingQueue.class, (String)"WritingQueueProgressTitle", (Object)env.getDisplayName());
        }

        public synchronized void entryAdded(int entriesCount) {
            if (this.progressHandle == null) {
                this.progressHandle = this.createProgress();
                this.progressTotal = 0;
                this.progressCurrent = 0;
                this.progressHandle.start();
            } else if (this.progressTotal < entriesCount / 2) {
                if (this.progressTotal == 0) {
                    this.progressTotal = entriesCount;
                    this.progressHandle.switchToDeterminate(this.progressTotal);
                } else {
                    this.progressTotal = entriesCount;
                    this.progressHandle.finish();
                    this.progressHandle = this.createProgress();
                    this.progressHandle.start(this.progressTotal);
                }
            }
        }

        public synchronized void entryDone(int entriesCount) {
            ++this.progressCurrent;
            if (this.progressHandle != null) {
                if (this.progressTotal > 0) {
                    this.progressHandle.progress(Math.min(this.progressCurrent, this.progressTotal));
                }
                if (entriesCount == 0) {
                    this.progressHandle.finish();
                    this.progressHandle = null;
                }
            }
        }

        private ProgressHandle createProgress() {
            String msg = NbBundle.getMessage(WritingQueue.class, (String)"WritingQueueProgressTitle", (Object)this.env.getDisplayName());
            return ProgressHandleFactory.createHandle((String)msg);
        }
    }

    private class Entry
    implements ChangeListener {
        private volatile Future<CommonTasksSupport.UploadStatus> currentTask;
        private boolean reschedule = false;
        private final RemotePlainFile fo;

        public Entry(RemotePlainFile fo) {
            this.fo = fo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleUpload() {
            Object object = WritingQueue.this.lock;
            synchronized (object) {
                if (this.currentTask == null) {
                    CommonTasksSupport.UploadParameters params = new CommonTasksSupport.UploadParameters(this.fo.getCache(), WritingQueue.this.execEnv, this.fo.getPath(), -1, false, (ChangeListener)this);
                    this.currentTask = CommonTasksSupport.uploadFile((CommonTasksSupport.UploadParameters)params);
                } else {
                    RemoteLogger.getInstance().log(Level.FINE, "Will reschedule previous upload task for {0}", this.fo);
                    this.reschedule = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent e) {
            Object source = e.getSource();
            if (!(source instanceof Future)) {
                RemoteLogger.assertTrue(false, "Wrong class, should be Future<Integer>: " + (source == null ? "null" : source.getClass()), new Object[0]);
                return;
            }
            try {
                this.taskFinished((Future)source);
            }
            finally {
                Object object = WritingQueue.this.monitor;
                synchronized (object) {
                    WritingQueue.this.monitor.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void taskFinished(Future<CommonTasksSupport.UploadStatus> finishedTask) {
            FilesystemInterceptorProvider.FilesystemInterceptor interceptor;
            LOGGER.log(Level.FINEST, "WritingQueue: Task {0} at {1} finished", new Object[]{finishedTask, WritingQueue.this.execEnv});
            boolean done = false;
            Object object = WritingQueue.this.lock;
            synchronized (object) {
                if (this.currentTask != null && this.currentTask != finishedTask) {
                    return;
                }
                this.currentTask = null;
                if (this.reschedule) {
                    Object object2 = WritingQueue.this.lock;
                    synchronized (object2) {
                        this.reschedule = false;
                        this.scheduleUpload();
                    }
                    return;
                }
                try {
                    CommonTasksSupport.UploadStatus uploadStatus = finishedTask.get();
                    if (uploadStatus.isOK()) {
                        LOGGER.log(Level.FINEST, "WritingQueue: uploading {0} succeeded", this.fo);
                        WritingQueue.this.failed.remove(this.fo.getPath());
                        this.fo.getParent().updateStat(this.fo, uploadStatus.getStatInfo());
                        this.fo.getParent().getOwnerFileObject().fireFileChangedEvent(this.fo.getListenersWithParent(), new FileEvent((FileObject)this.fo.getOwnerFileObject(), (FileObject)this.fo.getOwnerFileObject(), true));
                        done = true;
                    } else {
                        LOGGER.log(Level.FINEST, "WritingQueue: uploading {0} failed", this.fo);
                        WritingQueue.this.failed.add(this.fo.getPath());
                        this.fo.setPendingRemoteDelivery(false);
                    }
                }
                catch (InterruptedException ex) {
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    WritingQueue.this.entries.remove(this.fo.getPath());
                }
                WritingQueue.this.progress.entryDone(WritingQueue.this.entries.size());
            }
            if (RemoteFileObjectBase.USE_VCS && done && (interceptor = FilesystemInterceptorProvider.getDefault().getFilesystemInterceptor(this.fo.getFileSystem())) != null) {
                interceptor.fileChanged(FilesystemInterceptorProvider.toFileProxy(this.fo.getOwnerFileObject()));
            }
        }
    }
}

