/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.net.ConnectException;
import java.util.Collections;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fileoperations.spi.FilesystemInterceptorProvider;
import org.netbeans.modules.remote.impl.fs.CachedRemoteInputStream;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.netbeans.modules.remote.impl.fs.RemoteFileObject;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.netbeans.modules.remote.impl.fs.WritingQueue;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;

public final class RemotePlainFile
extends RemoteFileObjectBase {
    private static final int LOCK_TIMEOUT = Integer.getInteger("remote.rwlock.timeout", 4);
    private final char fileTypeChar;
    private SoftReference<CachedRemoteInputStream> fileContentCache = new SoftReference<Object>(null);
    private SimpleRWLock rwl = new SimpleRWLock();

    RemotePlainFile(RemoteFileObject wrapper, RemoteFileSystem fileSystem, ExecutionEnvironment execEnv, RemoteDirectory parent, String remotePath, File cache, FileInfoProvider.StatInfo.FileType fileType) {
        super(wrapper, fileSystem, execEnv, parent, remotePath, cache);
        this.fileTypeChar = fileType.toChar();
    }

    @Override
    public final RemoteFileObject[] getChildren() {
        return new RemoteFileObject[0];
    }

    @Override
    public final boolean isFolder() {
        return false;
    }

    @Override
    public boolean isData() {
        return true;
    }

    @Override
    public final RemoteFileObject getFileObject(String name, String ext) {
        return null;
    }

    @Override
    public RemoteFileObject getFileObject(String relativePath) {
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        RemoteFileObject res = this.getOwnerFileObject();
        StringTokenizer st = new StringTokenizer(relativePath, "/");
        while (res != null && st.hasMoreTokens()) {
            String nameExt = st.nextToken();
            if (nameExt.equals("..")) {
                res = res.getParent();
                continue;
            }
            if (nameExt.equals(".")) continue;
            res = res.getFileObject(nameExt, null);
        }
        return res;
    }

    @Override
    public RemoteDirectory getParent() {
        return (RemoteDirectory)super.getParent();
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        try {
            RemoteDirectory parent;
            CachedRemoteInputStream stream = this.fileContentCache.get();
            if (stream != null) {
                CachedRemoteInputStream reuse = stream.reuse();
                if (reuse != null) {
                    return reuse;
                }
                this.fileContentCache.clear();
            }
            if ((parent = RemoteFileSystemUtils.getCanonicalParent(this)) == null) {
                return RemoteFileSystemUtils.createDummyInputStream();
            }
            InputStream newStream = parent._getInputStream(this);
            if (newStream instanceof CachedRemoteInputStream) {
                this.fileContentCache = new SoftReference<CachedRemoteInputStream>((CachedRemoteInputStream)newStream);
            } else if (stream != null) {
                this.fileContentCache.clear();
            }
            if (this.rwl.tryReadLock()) {
                return new InputStreamWrapper(newStream);
            }
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    throw new FileAlreadyLockedException("Cannot read from locked file: " + this);
                }
            };
        }
        catch (ConnectException ex) {
            return new ByteArrayInputStream(new byte[0]);
        }
        catch (IOException ex) {
            throw this.newFileNotFoundException(ex);
        }
        catch (InterruptedException ex) {
            throw this.newFileNotFoundException(ex);
        }
        catch (ExecutionException ex) {
            throw this.newFileNotFoundException(ex);
        }
        catch (CancellationException ex) {
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    private FileNotFoundException newFileNotFoundException(Exception cause) {
        FileNotFoundException ex = new FileNotFoundException("" + this.getExecutionEnvironment() + ':' + this.getPath());
        ex.initCause(cause);
        return ex;
    }

    @Override
    public RemoteFileObject createDataImpl(String name, String ext, RemoteFileObjectBase orig) throws IOException {
        throw new IOException("Plain file can not have children");
    }

    @Override
    public RemoteFileObject createFolderImpl(String name, RemoteFileObjectBase orig) throws IOException {
        throw new IOException("Plain file can not have children");
    }

    @Override
    protected FileLock lockImpl(RemoteFileObjectBase orig) throws IOException {
        FilesystemInterceptorProvider.FilesystemInterceptor interceptor = null;
        if (USE_VCS && (interceptor = FilesystemInterceptorProvider.getDefault().getFilesystemInterceptor(this.getFileSystem())) != null && !this.canWriteImpl(orig)) {
            throw new IOException("Cannot lock " + this);
        }
        FileLock lock = super.lockImpl(orig);
        if (interceptor != null) {
            try {
                interceptor.fileLocked(FilesystemInterceptorProvider.toFileProxy(orig.getOwnerFileObject()));
            }
            catch (IOException ex) {
                lock.releaseLock();
                throw ex;
            }
        }
        return lock;
    }

    @Override
    protected void postDeleteChild(FileObject child) {
        RemoteLogger.getInstance().log(Level.WARNING, "postDeleteChild is called on {0}", this.getClass().getSimpleName());
    }

    @Override
    protected boolean deleteImpl(FileLock lock) throws IOException {
        return RemoteFileSystemUtils.delete(this.getExecutionEnvironment(), this.getPath(), false);
    }

    @Override
    protected void renameChild(FileLock lock, RemoteFileObjectBase toRename, String newNameExt, RemoteFileObjectBase orig) throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        RemoteLogger.assertTrueInConsole(false, "renameChild is not supported on " + this.getClass() + " path=" + this.getPath(), new Object[0]);
    }

    @Override
    protected OutputStream getOutputStreamImpl(FileLock lock, RemoteFileObjectBase orig) throws IOException {
        try {
            if (!this.isValid()) {
                throw new FileNotFoundException("FileObject " + this + " is not valid.");
            }
            FilesystemInterceptorProvider.FilesystemInterceptor interceptor = null;
            if (USE_VCS) {
                interceptor = FilesystemInterceptorProvider.getDefault().getFilesystemInterceptor(this.getFileSystem());
            }
            if (this.rwl.tryWriteLock()) {
                return new DelegateOutputStream(interceptor, orig);
            }
            return new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    throw new FileAlreadyLockedException("Cannot write to locked file: " + this);
                }
            };
        }
        catch (InterruptedException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    protected void refreshImpl(boolean recursive, Set<String> antiLoop, boolean expected) throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        if (RemoteFileObjectBase.DEFER_WRITES) {
            WritingQueue.getInstance(this.getExecutionEnvironment()).waitFinished(Collections.singleton(this.getOwnerFileObject()), null);
        }
    }

    @Override
    public FileInfoProvider.StatInfo.FileType getType() {
        return FileInfoProvider.StatInfo.FileType.fromChar((char)this.fileTypeChar);
    }

    private class DelegateOutputStream
    extends OutputStream {
        private final FileOutputStream delegate;
        private boolean closed;

        public DelegateOutputStream(FilesystemInterceptorProvider.FilesystemInterceptor interceptor, RemoteFileObjectBase orig) throws IOException {
            if (interceptor != null) {
                interceptor.beforeChange(FilesystemInterceptorProvider.toFileProxy(orig.getOwnerFileObject()));
            }
            this.delegate = new FileOutputStream(RemotePlainFile.this.getCache());
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                this.delegate.close();
                FileEvent ev = new FileEvent((FileObject)RemotePlainFile.this.getOwnerFileObject(), (FileObject)RemotePlainFile.this.getOwnerFileObject(), true);
                RemotePlainFile.this.setPendingRemoteDelivery(true);
                if (RemoteFileObjectBase.DEFER_WRITES) {
                    RemotePlainFile.this.getOwnerFileObject().fireFileChangedEvent(RemotePlainFile.this.getListenersWithParent(), ev);
                    WritingQueue.getInstance(RemotePlainFile.this.getExecutionEnvironment()).add(RemotePlainFile.this);
                } else {
                    CommonTasksSupport.UploadParameters params = new CommonTasksSupport.UploadParameters(RemotePlainFile.this.getCache(), RemotePlainFile.this.getExecutionEnvironment(), RemotePlainFile.this.getPath(), -1, false, null);
                    Future task = CommonTasksSupport.uploadFile((CommonTasksSupport.UploadParameters)params);
                    try {
                        CommonTasksSupport.UploadStatus uploadStatus = (CommonTasksSupport.UploadStatus)task.get();
                        if (!uploadStatus.isOK()) {
                            RemoteLogger.getInstance().log(Level.FINEST, "WritingQueue: uploading {0} failed", this);
                            RemotePlainFile.this.setPendingRemoteDelivery(false);
                            throw new IOException(uploadStatus.getError() + " " + uploadStatus.getExitCode());
                        }
                        RemoteLogger.getInstance().log(Level.FINEST, "WritingQueue: uploading {0} succeeded", this);
                        RemotePlainFile.this.getParent().updateStat(RemotePlainFile.this, uploadStatus.getStatInfo());
                        RemotePlainFile.this.getOwnerFileObject().fireFileChangedEvent(RemotePlainFile.this.getListenersWithParent(), ev);
                    }
                    catch (InterruptedException ex) {
                        throw this.newIOException(ex);
                    }
                    catch (ExecutionException ex) {
                        if (!ConnectionManager.getInstance().isConnectedTo(RemotePlainFile.this.getExecutionEnvironment())) {
                            RemotePlainFile.this.getFileSystem().addPendingFile(RemotePlainFile.this);
                            throw new ConnectException(ex.getMessage());
                        }
                        if (RemoteFileSystemUtils.isFileNotFoundException(ex)) {
                            throw new FileNotFoundException(RemotePlainFile.this.getPath());
                        }
                        if (ex.getCause() instanceof IOException) {
                            throw (IOException)ex.getCause();
                        }
                        throw this.newIOException(ex);
                    }
                }
                this.closed = true;
            }
            finally {
                RemotePlainFile.this.rwl.writeUnlock();
            }
        }

        private IOException newIOException(Exception cause) {
            return new IOException("Error uploading " + RemotePlainFile.this.getPath() + " to " + RemotePlainFile.this.getExecutionEnvironment() + ':' + cause.getMessage(), cause);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }
    }

    private final class InputStreamWrapper
    extends InputStream {
        private final InputStream is;
        private boolean closed;

        public InputStreamWrapper(InputStream is) {
            this.is = is;
        }

        @Override
        public int read() throws IOException {
            return this.is.read();
        }

        @Override
        public int available() throws IOException {
            return this.is.available();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                this.is.close();
                this.closed = true;
            }
            finally {
                RemotePlainFile.this.rwl.readUnlock();
            }
        }

        protected void finalize() throws Throwable {
            this.close();
        }

        public boolean equals(Object obj) {
            return this.is.equals(obj);
        }

        public int hashCode() {
            return this.is.hashCode();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.is.mark(readlimit);
        }

        @Override
        public boolean markSupported() {
            return this.is.markSupported();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.is.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.is.read(b, off, len);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.is.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.is.skip(n);
        }
    }

    private final class SimpleRWLock {
        private int activeReaders = 0;
        private Thread writer = null;
        private final ReentrantLock lock = new ReentrantLock();
        private final Condition readable = this.lock.newCondition();
        private final Condition writtable = this.lock.newCondition();

        private SimpleRWLock() {
        }

        private boolean writeCondition() {
            return this.activeReaders == 0 && this.writer == null;
        }

        private boolean readCondition() {
            return this.writer == null || this.writer == Thread.currentThread();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryReadLock() throws InterruptedException {
            this.lock.lock();
            try {
                while (!this.readCondition()) {
                    if (this.readable.await(LOCK_TIMEOUT, TimeUnit.SECONDS)) continue;
                    boolean bl = false;
                    return bl;
                }
                ++this.activeReaders;
                if (this.writer == Thread.currentThread()) {
                    this.writer = null;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readUnlock() {
            this.lock.lock();
            try {
                if (this.activeReaders > 0) {
                    --this.activeReaders;
                    if (this.activeReaders == 0) {
                        this.writtable.signalAll();
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryWriteLock() throws InterruptedException {
            this.lock.lock();
            try {
                while (!this.writeCondition()) {
                    if (this.writtable.await(LOCK_TIMEOUT, TimeUnit.SECONDS)) continue;
                    boolean bl = false;
                    return bl;
                }
                this.writer = Thread.currentThread();
                boolean bl = true;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeUnlock() {
            this.lock.lock();
            try {
                if (this.writer != null) {
                    this.writer = null;
                    this.writtable.signal();
                    this.readable.signalAll();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

