/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fs.RemoteFileObject;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemManager;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class RemoteFileUrlMapper
extends URLMapper {
    public FileObject[] getFileObjects(URL url) {
        if (url.getProtocol().equals("rfs")) {
            ExecutionEnvironment env;
            String user = url.getUserInfo();
            if (user != null) {
                env = ExecutionEnvironmentFactory.createNew((String)user, (String)url.getHost(), (int)url.getPort());
            } else {
                RemoteLogger.assertTrue(false, "Trying to access remote file system without user name", new Object[0]);
                env = RemoteFileSystemUtils.getExecutionEnvironment(url.getHost(), url.getPort());
                if (env == null && (user = System.getProperty("user.name")) != null) {
                    env = ExecutionEnvironmentFactory.createNew((String)user, (String)url.getHost(), (int)url.getPort());
                }
            }
            if (env != null) {
                RemoteFileSystem fs = RemoteFileSystemManager.getInstance().getFileSystem(env);
                RemoteFileObject fo = fs.findResource(RemoteFileUrlMapper.unescapePath(url));
                return new FileObject[]{fo};
            }
        }
        return null;
    }

    public URL getURL(FileObject fo, int type) {
        if (fo instanceof RemoteFileObject) {
            RemoteFileObject rfo = (RemoteFileObject)fo;
            try {
                ExecutionEnvironment env = rfo.getExecutionEnvironment();
                return RemoteFileUrlMapper.getURL(env, rfo.getPath(), rfo.isFolder());
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    private static URL getURL(ExecutionEnvironment env, String path, boolean folder) throws MalformedURLException {
        StringBuilder sb = new StringBuilder("rfs");
        sb.append("://");
        sb.append(env.getUser()).append('@').append(env.getHost());
        sb.append(':').append(env.getSSHPort()).append(RemoteFileUrlMapper.escapePath(path));
        if (folder && !path.endsWith("/")) {
            sb.append('/');
        }
        return new URL(sb.toString());
    }

    private static String escapePath(String path) {
        if (path.indexOf(35) >= 0) {
            path = path.replace("#", "%23");
        }
        if (path.indexOf(63) >= 0) {
            path = path.replace("?", "%3f");
        }
        if (path.indexOf(32) >= 0) {
            path = path.replace(" ", "%20");
        }
        return path;
    }

    private static String unescapePath(URL url) {
        String path = url.getFile();
        if (path.contains("%23") || path.contains("%3f") || path.contains("%20")) {
            try {
                return url.toURI().getPath();
            }
            catch (URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return path;
    }
}

