/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;

public class RemoteFileURLConnection
extends URLConnection {
    private final ExecutionEnvironment execEnv;
    private final String path;
    private FileObject fileObject;
    private InputStream iStream = null;
    private OutputStream oStream = null;

    public RemoteFileURLConnection(URL url) throws IOException {
        super(url);
        if (!"rfs".equals(url.getProtocol())) {
            throw new IllegalArgumentException("Illegal url protocol: " + url.getProtocol());
        }
        this.execEnv = ExecutionEnvironmentFactory.createNew((String)url.getUserInfo(), (String)url.getHost(), (int)url.getPort());
        this.path = url.getFile();
    }

    @Override
    public void connect() throws IOException {
        RemoteFileSystem fs = RemoteFileSystemManager.getInstance().getFileSystem(this.execEnv);
        this.fileObject = fs.findResource(this.path);
        if (this.fileObject == null || !this.fileObject.isValid()) {
            throw this.newFileNotFoundException();
        }
    }

    private FileNotFoundException newFileNotFoundException() {
        return new FileNotFoundException(this.execEnv.getDisplayName() + ':' + this.path);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.fileObject == null) {
            this.connect();
        }
        if (this.fileObject == null) {
            throw this.newFileNotFoundException();
        }
        if (this.iStream == null) {
            this.iStream = this.fileObject.isData() ? this.fileObject.getInputStream() : new FIS(this.fileObject);
        }
        return this.iStream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.fileObject == null) {
            throw this.newFileNotFoundException();
        }
        if (this.oStream == null) {
            FileLock flock = this.fileObject.lock();
            this.oStream = new LockOS(this.fileObject.getOutputStream(flock), flock);
        }
        return this.oStream;
    }

    @Override
    public int getContentLength() {
        try {
            this.connect();
        }
        catch (IOException ex) {
            return 0;
        }
        return (int)this.fileObject.getSize();
    }

    @Override
    public Permission getPermission() throws IOException {
        this.connect();
        StringBuilder actions = new StringBuilder();
        if (this.fileObject != null && this.fileObject.isValid()) {
            if (this.fileObject.canRead()) {
                actions.append("read").append(' ');
            }
            if (this.fileObject.canWrite()) {
                actions.append("write").append(' ');
            }
        }
        return new FilePermission(this.path, actions.toString());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ' ' + this.url;
    }

    private static final class FIS
    extends InputStream {
        private StringReader reader;

        public FIS(FileObject folder) throws IOException {
            this.reader = new StringReader(this.createDocument(folder));
        }

        private String createDocument(FileObject folder) throws IOException {
            StringBuilder buff = new StringBuilder(150);
            StringBuilder lit = new StringBuilder(15);
            FileObject[] fobia = folder.getChildren();
            buff.append("<HTML>\n");
            buff.append("<BODY>\n");
            FileObject parent = folder.getParent();
            if (parent != null) {
                buff.append("<P>");
                buff.append("<A HREF=").append("..").append(">").append("..").append("</A>").append("\n");
                buff.append("</P>");
            }
            for (int i = 0; i < fobia.length; ++i) {
                lit.setLength(0);
                lit.append(fobia[i].getNameExt());
                String name = lit.toString();
                if (fobia[i].isFolder()) {
                    lit.append('/');
                }
                buff.append("<P>");
                buff.append("<A HREF=").append((Object)lit).append(">").append(name).append("</A>").append("\n");
                buff.append("</P>");
            }
            buff.append("</BODY>\n");
            buff.append("</HTML>\n");
            return buff.toString();
        }

        @Override
        public int read() throws IOException {
            return this.reader.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            char[] ch = new char[len];
            int r = this.reader.read(ch, 0, len);
            for (int i = 0; i < r; ++i) {
                b[off + i] = (byte)ch[i];
            }
            return r;
        }

        @Override
        public long skip(long skip) throws IOException {
            return this.reader.skip(skip);
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        @Override
        public void reset() throws IOException {
            this.reader.reset();
        }

        @Override
        public boolean markSupported() {
            return false;
        }
    }

    private static class LockOS
    extends BufferedOutputStream {
        private final FileLock flock;

        public LockOS(OutputStream os, FileLock lock) throws IOException {
            super(os);
            this.flock = lock;
        }

        @Override
        public void close() throws IOException {
            this.flock.releaseLock();
            super.close();
        }
    }
}

