/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import org.netbeans.modules.dlight.libs.common.DLightLibsCommonLogger;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.api.ui.FileObjectBasedFile;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fs.RemoteFileObject;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemManager;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.netbeans.modules.remote.impl.fs.WritingQueue;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.modules.remote.spi.FileSystemProviderImplementation;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;

public class RemoteFileSystemProvider
implements FileSystemProviderImplementation {
    public FileSystem getFileSystem(ExecutionEnvironment env, String root) {
        return RemoteFileSystemManager.getInstance().getFileSystem(env);
    }

    public String normalizeAbsolutePath(String absPath, ExecutionEnvironment env) {
        return RemoteFileSystemManager.getInstance().getFileSystem(env).normalizeAbsolutePath(absPath);
    }

    public String normalizeAbsolutePath(String absPath, FileSystem fileSystem) {
        RemoteLogger.assertTrue(fileSystem instanceof RemoteFileSystem);
        if (fileSystem instanceof RemoteFileSystem) {
            return ((RemoteFileSystem)fileSystem).normalizeAbsolutePath(absPath);
        }
        return absPath;
    }

    public boolean isAbsolute(String path) {
        return path.startsWith("/");
    }

    public FileObject getFileObject(FileObject baseFileObject, String relativeOrAbsolutePath) {
        if (baseFileObject instanceof RemoteFileObject) {
            ExecutionEnvironment execEnv = ((RemoteFileObject)baseFileObject).getExecutionEnvironment();
            if (RemoteFileSystemProvider.isPathAbsolute(relativeOrAbsolutePath)) {
                relativeOrAbsolutePath = RemoteFileSystemManager.getInstance().getFileSystem(execEnv).normalizeAbsolutePath(relativeOrAbsolutePath);
                try {
                    return baseFileObject.getFileSystem().findResource(relativeOrAbsolutePath);
                }
                catch (FileStateInvalidException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                return baseFileObject.getFileObject(relativeOrAbsolutePath);
            }
        }
        return null;
    }

    private static boolean isPathAbsolute(String path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        if (path.charAt(0) == '/') {
            return true;
        }
        if (path.charAt(0) == '\\') {
            return true;
        }
        return path.indexOf(58) > 0;
    }

    public boolean isMine(ExecutionEnvironment env) {
        return env.isRemote();
    }

    public boolean isMine(FileObject fileObject) {
        return fileObject instanceof RemoteFileObject;
    }

    public boolean isMine(FileSystem fileSystem) {
        return fileSystem instanceof RemoteFileSystem;
    }

    public FileObject getCanonicalFileObject(FileObject fileObject) throws IOException {
        return RemoteFileSystemUtils.getCanonicalFileObject(fileObject);
    }

    public String getCanonicalPath(FileObject fileObject) throws IOException {
        return RemoteFileSystemUtils.getCanonicalFileObject(fileObject).getPath();
    }

    public String getCanonicalPath(FileSystem fs, String absPath) throws IOException {
        FileObject fo = fs.findResource(absPath);
        if (fo != null) {
            try {
                return this.getCanonicalFileObject(fo).getPath();
            }
            catch (FileNotFoundException e) {
                RemoteLogger.finest(e);
            }
        }
        return PathUtilities.normalizeUnixPath((String)absPath);
    }

    public String getCanonicalPath(ExecutionEnvironment env, String absPath) throws IOException {
        RemoteLogger.assertTrueInConsole(env.isRemote(), this.getClass().getSimpleName() + ".getCanonicalPath is called for LOCAL env: " + env, new Object[0]);
        RemoteFileSystem fs = RemoteFileSystemManager.getInstance().getFileSystem(env);
        return this.getCanonicalPath(fs, absPath);
    }

    public ExecutionEnvironment getExecutionEnvironment(FileSystem fileSystem) {
        if (fileSystem instanceof RemoteFileSystem) {
            return ((RemoteFileSystem)fileSystem).getExecutionEnvironment();
        }
        return ExecutionEnvironmentFactory.getLocal();
    }

    public boolean isMine(String absoluteURL) {
        return absoluteURL.startsWith("rfs:");
    }

    public boolean waitWrites(ExecutionEnvironment env, Collection<String> failedFiles) throws InterruptedException {
        if (env.isRemote() && RemoteFileObjectBase.DEFER_WRITES) {
            return WritingQueue.getInstance(env).waitFinished(failedFiles);
        }
        return true;
    }

    public boolean waitWrites(ExecutionEnvironment env, Collection<FileObject> filesToWait, Collection<String> failedFiles) throws InterruptedException {
        if (env.isRemote() && RemoteFileObjectBase.DEFER_WRITES) {
            return WritingQueue.getInstance(env).waitFinished(filesToWait, failedFiles);
        }
        return true;
    }

    public FileObject urlToFileObject(String path) {
        String pathPart;
        String envPart;
        int idx;
        DLightLibsCommonLogger.assertNonUiThreadOnce((Level)Level.INFO);
        if (!path.startsWith("rfs:")) {
            return null;
        }
        String url = path.substring("rfs:".length());
        if (url.startsWith("//")) {
            url = url.substring(2);
        }
        if ((idx = url.indexOf(":/")) < 0) {
            envPart = url;
            pathPart = "/";
        } else {
            envPart = url.substring(0, idx);
            pathPart = url.substring(idx + 1);
        }
        ExecutionEnvironment env = null;
        if (envPart.indexOf(64) < 0) {
            RemoteLogger.assertTrueInConsole(false, "Trying to access remote file system without user name", new Object[0]);
            idx = envPart.lastIndexOf(58);
            String host = idx < 0 ? envPart : envPart.substring(0, idx);
            env = RemoteFileSystemUtils.getExecutionEnvironment(host, 0);
        }
        if (env == null) {
            env = ExecutionEnvironmentFactory.fromUniqueID((String)envPart);
        }
        if (env == null) {
            throw new IllegalArgumentException("Invalid path: " + path);
        }
        RemoteFileSystem fs = RemoteFileSystemManager.getInstance().getFileSystem(env);
        return fs.findResource(pathPart);
    }

    public String toURL(FileObject fileObject) {
        if (!(fileObject instanceof RemoteFileObject)) {
            return null;
        }
        ExecutionEnvironment env = ((RemoteFileObject)fileObject).getExecutionEnvironment();
        String path = fileObject.getPath();
        if (path == null || path.isEmpty()) {
            path = "/";
        }
        return "rfs:" + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env) + ':' + path;
    }

    public String toURL(FileSystem fileSystem, String absPath) {
        RemoteLogger.assertTrue(RemoteFileSystemUtils.isPathAbsolute(absPath), "Path must be absolute: " + absPath, new Object[0]);
        if (!(fileSystem instanceof RemoteFileSystem)) {
            throw new IllegalArgumentException("File system should be an istance of " + RemoteFileSystem.class.getName());
        }
        ExecutionEnvironment env = ((RemoteFileSystem)fileSystem).getExecutionEnvironment();
        return "rfs:" + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env) + ':' + absPath;
    }

    public FileObject fileToFileObject(File file) {
        if (!(file instanceof FileObjectBasedFile)) {
            return null;
        }
        return ((FileObjectBasedFile)file).getFileObject();
    }

    public boolean isMine(File file) {
        return file instanceof FileObjectBasedFile;
    }

    public void scheduleRefresh(FileObject fileObject) {
        if (fileObject instanceof RemoteFileObject) {
            RemoteFileObject fo = (RemoteFileObject)fileObject;
            fo.getFileSystem().getRefreshManager().scheduleRefresh(Arrays.asList(fo.getImplementor()), true);
        } else {
            RemoteLogger.getInstance().log(Level.WARNING, "Unexpected fileObject class: {0}", fileObject.getClass());
        }
    }

    public void scheduleRefresh(ExecutionEnvironment env, Collection<String> paths) {
        RemoteFileSystem fs = RemoteFileSystemManager.getInstance().getFileSystem(env);
        fs.getRefreshManager().scheduleRefreshExistent(paths);
    }

    public void addRecursiveListener(FileChangeListener listener, FileSystem fileSystem, String absPath) {
        RemoteLogger.assertTrue(fileSystem instanceof RemoteFileSystem, "Unexpected file system class: " + fileSystem, new Object[0]);
        FileObject fileObject = fileSystem.findResource(absPath);
        if (fileObject != null) {
            fileObject.addRecursiveListener(listener);
        }
    }

    public void removeRecursiveListener(FileChangeListener listener, FileSystem fileSystem, String absPath) {
        RemoteLogger.assertTrue(fileSystem instanceof RemoteFileSystem, "Unexpected file system class: " + fileSystem, new Object[0]);
        FileObject fileObject = fileSystem.findResource(absPath);
        if (fileObject != null) {
            fileObject.removeRecursiveListener(listener);
        }
    }

    public void addFileChangeListener(FileChangeListener listener, FileSystem fileSystem, String path) {
        RemoteLogger.assertTrue(fileSystem instanceof RemoteFileSystem, "Unexpected file system class: " + fileSystem, new Object[0]);
        ((RemoteFileSystem)fileSystem).getFactory().addFileChangeListener(path, listener);
    }

    public void addFileChangeListener(FileChangeListener listener, ExecutionEnvironment env, String path) {
        RemoteLogger.assertTrue(env.isRemote(), "Unexpected ExecutionEnvironment: should be remote", new Object[0]);
        RemoteFileSystemManager.getInstance().getFileSystem(env).getFactory().addFileChangeListener(path, listener);
    }

    public void addFileChangeListener(FileChangeListener listener) {
        RemoteFileSystemManager.getInstance().addFileChangeListener(listener);
    }

    public void removeFileChangeListener(FileChangeListener listener) {
        RemoteFileSystemManager.getInstance().removeFileChangeListener(listener);
    }

    public boolean canExecute(FileObject fileObject) {
        RemoteLogger.assertTrue(fileObject instanceof RemoteFileObject, "Unexpected file object class: " + fileObject, new Object[0]);
        if (fileObject instanceof RemoteFileObject) {
            return ((RemoteFileObject)fileObject).getImplementor().canExecute();
        }
        return false;
    }

    public char getFileSeparatorChar() {
        return '/';
    }

    public void addFileSystemProblemListener(FileSystemProvider.FileSystemProblemListener listener, FileSystem fileSystem) {
        ((RemoteFileSystem)fileSystem).addFileSystemProblemListener(listener);
    }

    public void removeFileSystemProblemListener(FileSystemProvider.FileSystemProblemListener listener, FileSystem fileSystem) {
        ((RemoteFileSystem)fileSystem).removeFileSystemProblemListener(listener);
    }
}

