/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.awt.Image;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TooManyListenersException;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionListener;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.api.ui.ConnectionNotifier;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fileoperations.spi.AnnotationProvider;
import org.netbeans.modules.remote.impl.fileoperations.spi.FileOperationsProvider;
import org.netbeans.modules.remote.impl.fileoperations.spi.FilesystemInterceptorProvider;
import org.netbeans.modules.remote.impl.fs.RefreshManager;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.netbeans.modules.remote.impl.fs.RemoteFileObject;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectFactory;
import org.netbeans.modules.remote.spi.FileSystemCacheProvider;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.io.NbObjectInputStream;
import org.openide.windows.WindowManager;

@SuppressWarnings(value={"Se"})
public final class RemoteFileSystem
extends FileSystem
implements ConnectionListener {
    private static final SystemAction[] NO_SYSTEM_ACTIONS = new SystemAction[0];
    private static final boolean ATTR_STATS = Boolean.getBoolean("remote.attr.stats");
    public static final String ATTRIBUTES_FILE_NAME = ".rfs_attr";
    public static final String CACHE_FILE_NAME = ".rfs_cache";
    public static final String RESERVED_PREFIX = ".rfs_";
    public static final String RESERVED_PREFIX_ESCAPED = "._rfs_";
    private static final String READONLY_ATTRIBUTES = "readOnlyAttrs";
    private final ExecutionEnvironment execEnv;
    private final String filePrefix;
    private final RemoteFileObject root;
    private final RemoteDirectory rootDelegate;
    private final RemoteFileSupport remoteFileSupport;
    private final RefreshManager refreshManager;
    private final File cache;
    private final RemoteFileObjectFactory factory;
    private final AtomicInteger fileCopyCount = new AtomicInteger(0);
    private final AtomicInteger dirSyncCount = new AtomicInteger(0);
    private static final Object mainLock = new Object();
    private static final Map<File, WeakReference<ReadWriteLock>> locks = new HashMap<File, WeakReference<ReadWriteLock>>();
    private AtomicBoolean readOnlyConnectNotification = new AtomicBoolean(false);
    private final List<FileSystemProvider.FileSystemProblemListener> problemListeners = new ArrayList<FileSystemProvider.FileSystemProblemListener>();
    private final transient StatusImpl status = new StatusImpl();
    private final LinkedHashSet<String> deleteOnExitFiles = new LinkedHashSet();
    private static final Map<String, AttrStat> attrStats = new TreeMap<String, AttrStat>();

    RemoteFileSystem(ExecutionEnvironment execEnv) throws IOException {
        RemoteLogger.assertTrue(execEnv.isRemote());
        this.execEnv = execEnv;
        this.remoteFileSupport = new RemoteFileSupport();
        this.factory = new RemoteFileObjectFactory(this);
        this.refreshManager = new RefreshManager(execEnv, this.factory);
        this.filePrefix = FileSystemCacheProvider.getCacheRoot((ExecutionEnvironment)execEnv);
        if (this.filePrefix == null) {
            throw new IllegalStateException("Can not find cache root for remote file system at " + execEnv);
        }
        this.cache = new File(this.filePrefix);
        if (!this.cache.exists() && !this.cache.mkdirs()) {
            throw new IOException(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ERR_CreateDir", (Object)this.cache.getAbsolutePath()));
        }
        this.root = new RemoteFileObject(this);
        this.rootDelegate = new RootFileObject(this.root, this, execEnv, this.cache);
        final WindowFocusListener windowFocusListener = new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                if (e.getOppositeWindow() == null && ConnectionManager.getInstance().isConnectedTo(RemoteFileSystem.this.execEnv)) {
                    RemoteFileSystem.this.refreshManager.scheduleRefreshOnFocusGained(RemoteFileSystem.this.factory.getCachedFileObjects());
                }
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WindowManager.getDefault().getMainWindow().addWindowFocusListener(windowFocusListener);
            }
        });
        ConnectionManager.getInstance().addConnectionListener((ConnectionListener)this);
    }

    void dispose() {
        ConnectionManager.getInstance().removeConnectionListener((ConnectionListener)this);
    }

    public void connected(ExecutionEnvironment env) {
        this.readOnlyConnectNotification.compareAndSet(true, false);
        if (this.execEnv.equals(env)) {
            Collection<RemoteFileObjectBase> cachedFileObjects = this.factory.getCachedFileObjects();
            this.refreshManager.scheduleRefreshOnConnect(cachedFileObjects);
            for (RemoteFileObjectBase fo : cachedFileObjects) {
                fo.connectionChanged();
            }
        }
    }

    public void disconnected(ExecutionEnvironment env) {
        this.readOnlyConnectNotification.compareAndSet(true, false);
        if (this.execEnv.equals(env)) {
            for (RemoteFileObjectBase fo : this.factory.getCachedFileObjects()) {
                fo.connectionChanged();
            }
        }
        if (ATTR_STATS) {
            this.dumpAttrStat();
        }
    }

    ExecutionEnvironment getExecutionEnvironment() {
        return this.execEnv;
    }

    public RemoteFileObjectFactory getFactory() {
        return this.factory;
    }

    public RefreshManager getRefreshManager() {
        return this.refreshManager;
    }

    public String normalizeAbsolutePath(String absPath) {
        return PathUtilities.normalizeUnixPath((String)absPath);
    }

    File getCache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReadWriteLock getLock(File file) {
        Object object = mainLock;
        synchronized (object) {
            ReadWriteLock result;
            WeakReference<ReadWriteLock> ref = locks.get(file);
            ReadWriteLock readWriteLock = result = ref == null ? null : (ReadWriteLock)ref.get();
            if (result == null) {
                result = new ReentrantReadWriteLock();
                locks.put(file, new WeakReference<ReadWriteLock>(result));
            }
            return result;
        }
    }

    final void resetStatistic() {
        this.dirSyncCount.set(0);
        this.fileCopyCount.set(0);
    }

    final int getDirSyncCount() {
        return this.dirSyncCount.get();
    }

    final int getFileCopyCount() {
        return this.fileCopyCount.get();
    }

    final void incrementDirSyncCount() {
        this.dirSyncCount.incrementAndGet();
    }

    final void incrementFileCopyCount() {
        this.fileCopyCount.incrementAndGet();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"RFS_DISPLAY_NAME", (Object)this.execEnv.getDisplayName());
    }

    public boolean isReadOnly() {
        return !ConnectionManager.getInstance().isConnectedTo(this.execEnv);
    }

    public RemoteFileObject getRoot() {
        return this.root;
    }

    public RemoteFileObject findResource(String name) {
        if (name.isEmpty() || name.equals("/")) {
            return this.getRoot();
        }
        return this.getRoot().getFileObject(name);
    }

    public FileObject getTempFolder() throws IOException {
        try {
            String tmpName = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.execEnv).getTempDir();
            RemoteFileObject tmpDir = this.findResource(tmpName);
            if (tmpDir != null && tmpDir.isFolder() && tmpDir.isValid()) {
                return tmpDir;
            }
        }
        catch (ConnectionManager.CancellationException cancellationException) {
            // empty catch block
        }
        throw new IOException("Cannot find temporary folder");
    }

    public FileObject createTempFile(FileObject parent, String prefix, String suffix, boolean deleteOnExit) throws IOException {
        if (parent.isFolder() && parent.isValid()) {
            while (true) {
                File tmpFile = File.createTempFile(prefix, suffix);
                String tmpName = tmpFile.getName();
                tmpFile.delete();
                try {
                    FileObject fo = parent.createData(tmpName);
                    if (fo != null && fo.isData() && fo.isValid()) {
                        if (deleteOnExit) {
                            this.addDeleteOnExit(fo.getPath());
                        }
                        return fo;
                    }
                }
                catch (IOException ex) {
                    FileObject test = parent.getFileObject(tmpName);
                    if (test != null) continue;
                    throw ex;
                }
                break;
            }
        }
        throw new IOException("Cannot create temporary file");
    }

    RemoteFileObjectBase findResource(String name, Set<String> antiloop) {
        if (name.isEmpty() || name.equals("/")) {
            return this.getRoot().getImplementor();
        }
        RemoteFileObject fo = this.rootDelegate.getFileObject(name, antiloop);
        return fo == null ? null : fo.getImplementor();
    }

    public SystemAction[] getActions() {
        return NO_SYSTEM_ACTIONS;
    }

    public void addPendingFile(RemoteFileObjectBase fo) {
        this.remoteFileSupport.addPendingFile(fo);
        this.fireProblemListeners(fo.getPath());
    }

    public String toString() {
        return this.getDisplayName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAttribute(RemoteFileObjectBase file, String attrName, Object value) {
        RemoteFileObjectBase parent = file.getParent();
        boolean hasParent = true;
        if (parent == null) {
            parent = file;
            hasParent = false;
        }
        File attr = this.getAttrFile(parent);
        Properties table = this.readProperties(attr);
        String translatedAttributeName = this.translateAttributeName(file, attrName);
        String encodedValue = this.encodeValue(value);
        Object oldValue = null;
        if (encodedValue == null) {
            table.remove(translatedAttributeName);
        } else {
            oldValue = table.setProperty(translatedAttributeName, encodedValue);
        }
        FileOutputStream fileOtputStream = null;
        try {
            fileOtputStream = new FileOutputStream(attr);
            table.store(fileOtputStream, "Set attribute " + attrName);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (fileOtputStream != null) {
                try {
                    fileOtputStream.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        if (hasParent) {
            file.fireFileAttributeChangedEvent(file.getListeners(), new FileAttributeEvent((FileObject)file.getOwnerFileObject(), (FileObject)file.getOwnerFileObject(), attrName, oldValue, value));
            parent.fireFileAttributeChangedEvent(parent.getListeners(), new FileAttributeEvent((FileObject)parent.getOwnerFileObject(), (FileObject)file.getOwnerFileObject(), attrName, oldValue, value));
        } else {
            file.fireFileAttributeChangedEvent(file.getListeners(), new FileAttributeEvent((FileObject)file.getOwnerFileObject(), (FileObject)file.getOwnerFileObject(), attrName, oldValue, value));
        }
        RemoteFileSystem.logAttrName(attrName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logAttrName(String name, boolean write) {
        Map<String, AttrStat> map = attrStats;
        synchronized (map) {
            AttrStat stat = attrStats.get(name);
            if (stat == null) {
                stat = new AttrStat(name);
                attrStats.put(name, stat);
            }
            if (write) {
                if (stat.writeCount++ == 0) {
                    stat.firstWriteStack = Thread.currentThread().getStackTrace();
                }
            } else if (stat.readCount++ == 0) {
                stat.firstReadStack = Thread.currentThread().getStackTrace();
            }
        }
        System.out.printf("%sAttribute %s\n", write ? "set" : "get", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpAttrStat() {
        TreeMap<String, AttrStat> toDump = null;
        Map<String, AttrStat> map = attrStats;
        synchronized (map) {
            toDump = new TreeMap<String, AttrStat>(attrStats);
        }
        System.out.printf("\n\nDumping attributes statistics (%d elements)\n\n", toDump.size());
        for (Map.Entry entry : toDump.entrySet()) {
            AttrStat stat = (AttrStat)entry.getValue();
            System.out.printf("%s %d %d\n", stat.name, stat.readCount, stat.writeCount);
            if (stat.firstReadStack != null) {
                System.out.printf("\t%s first read stack:\n", stat.name);
                for (StackTraceElement e : stat.firstReadStack) {
                    System.out.printf("\t\t%s\n", e);
                }
            }
            if (stat.firstWriteStack == null) continue;
            System.out.printf("\t%s first write stack:\n", stat.name);
            for (StackTraceElement e : stat.firstWriteStack) {
                System.out.printf("\t\t%s\n", e);
            }
        }
    }

    private File getAttrFile(RemoteFileObjectBase parent) {
        File attr = new File(parent.getCache(), ATTRIBUTES_FILE_NAME);
        return attr;
    }

    Object getAttribute(RemoteFileObjectBase file, String attrName) {
        FilesystemInterceptorProvider.FilesystemInterceptor interceptor;
        RemoteFileObjectBase parent = file.getParent();
        if (parent == null) {
            parent = file;
        }
        if (attrName.equals("default-line-separator")) {
            return "\n";
        }
        if (attrName.equals(READONLY_ATTRIBUTES)) {
            return Boolean.FALSE;
        }
        if (attrName.equals("isRemoteAndSlow")) {
            return Boolean.TRUE;
        }
        if (attrName.equals("FileSystem.rootPath")) {
            return this.getRoot().getPath();
        }
        if (attrName.equals("java.io.File")) {
            return null;
        }
        if (attrName.equals("ExistsParentNoPublicAPI")) {
            return true;
        }
        if (attrName.startsWith("ProvidedExtensions") && RemoteFileObjectBase.USE_VCS && (interceptor = FilesystemInterceptorProvider.getDefault().getFilesystemInterceptor(this)) != null) {
            return interceptor.getAttribute(FilesystemInterceptorProvider.toFileProxy(file.getOwnerFileObject()), attrName);
        }
        if (ATTR_STATS) {
            RemoteFileSystem.logAttrName(attrName, false);
        }
        File attr = this.getAttrFile(parent);
        Properties table = this.readProperties(attr);
        return this.decodeValue(table.getProperty(this.translateAttributeName(file, attrName)));
    }

    Enumeration<String> getAttributes(RemoteFileObjectBase file) {
        RemoteFileObjectBase parent = file.getParent();
        if (parent != null) {
            File attr = this.getAttrFile(parent);
            Properties table = this.readProperties(attr);
            ArrayList<String> res = new ArrayList<String>();
            Enumeration<Object> keys = table.keys();
            String prefix = file.getNameExt() + "[";
            while (keys.hasMoreElements()) {
                String aKey = keys.nextElement().toString();
                if (!aKey.startsWith(prefix)) continue;
                aKey = aKey.substring(prefix.length(), aKey.length() - 1);
                res.add(aKey);
            }
            return Collections.enumeration(res);
        }
        return Collections.enumeration(Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readProperties(File attr) {
        Properties table = new Properties();
        if (attr.exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(attr);
                table.load(fileInputStream);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
        return table;
    }

    private String translateAttributeName(RemoteFileObjectBase file, String attrName) {
        return file.getNameExt() + "[" + attrName + "]";
    }

    private Object decodeValue(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        byte[] bytes = new byte[value.length() / 2];
        int count = 0;
        for (int i = 0; i < value.length(); i += 2) {
            try {
                int tempI = Integer.parseInt(value.substring(i, i + 2), 16);
                if (tempI > 127) {
                    tempI -= 256;
                }
                bytes[count++] = (byte)tempI;
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes, 0, count);
        try {
            NbObjectInputStream ois = new NbObjectInputStream((InputStream)bis);
            Object ret = ois.readObject();
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String encodeValue(Object value) {
        if (value == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(value);
            oos.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        byte[] bArray = bos.toByteArray();
        StringBuilder strBuff = new StringBuilder(bArray.length * 2);
        for (int i = 0; i < bArray.length; ++i) {
            if (bArray[i] < 16 && bArray[i] >= 0) {
                strBuff.append("0");
            }
            strBuff.append(Integer.toHexString(bArray[i] < 0 ? bArray[i] + 256 : bArray[i]));
        }
        return strBuff.toString();
    }

    void addReadOnlyConnectNotification(RemoteFileObjectBase fo) {
        if (this.readOnlyConnectNotification.compareAndSet(false, true)) {
            this.remoteFileSupport.addPendingFile(fo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileSystemProblemListener(FileSystemProvider.FileSystemProblemListener listener) {
        List<FileSystemProvider.FileSystemProblemListener> list = this.problemListeners;
        synchronized (list) {
            this.problemListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileSystemProblemListener(FileSystemProvider.FileSystemProblemListener listener) {
        List<FileSystemProvider.FileSystemProblemListener> list = this.problemListeners;
        synchronized (list) {
            this.problemListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProblemListeners(String path) {
        ArrayList<FileSystemProvider.FileSystemProblemListener> listenersCopy;
        List<FileSystemProvider.FileSystemProblemListener> list = this.problemListeners;
        synchronized (list) {
            listenersCopy = new ArrayList<FileSystemProvider.FileSystemProblemListener>(this.problemListeners);
        }
        for (FileSystemProvider.FileSystemProblemListener l : listenersCopy) {
            if (path == null) {
                l.recovered((FileSystem)this);
                continue;
            }
            l.problemOccurred((FileSystem)this, path);
        }
    }

    public final SystemAction[] getActions(Set<FileObject> foSet) {
        SystemAction[] some = this.status.getActions(foSet);
        if (some != null) {
            return some;
        }
        return new SystemAction[0];
    }

    public FileSystem.Status getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDeleteOnExit(String path) {
        LinkedHashSet<String> linkedHashSet = this.deleteOnExitFiles;
        synchronized (linkedHashSet) {
            if (this.deleteOnExitFiles.isEmpty()) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        RemoteFileSystem.this.releaseResources();
                    }
                });
            }
            this.deleteOnExitFiles.add(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseResources() {
        ArrayList<String> toBeDeleted;
        LinkedHashSet<String> linkedHashSet = this.deleteOnExitFiles;
        synchronized (linkedHashSet) {
            toBeDeleted = new ArrayList<String>(this.deleteOnExitFiles);
        }
        Collections.reverse(toBeDeleted);
        for (String filename : toBeDeleted) {
            if (!ConnectionManager.getInstance().isConnectedTo(this.execEnv)) {
                return;
            }
            CommonTasksSupport.rmFile((ExecutionEnvironment)this.execEnv, (String)filename, null);
        }
    }

    private RemoteFileObjectBase vcsSafeGetFileObject(String path) {
        return this.factory.getCachedFileObject(path);
    }

    public Boolean vcsSafeIsDirectory(String path) {
        RemoteFileObjectBase fo = this.vcsSafeGetFileObject(path = PathUtilities.normalizeUnixPath((String)path));
        if (fo == null) {
            return null;
        }
        return fo.isFolder() ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean vcsSafeIsFile(String path) {
        RemoteFileObjectBase fo = this.vcsSafeGetFileObject(path = PathUtilities.normalizeUnixPath((String)path));
        if (fo == null) {
            return null;
        }
        switch (fo.getType()) {
            case Regular: {
                return true;
            }
            case SymbolicLink: {
                return fo.isData() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return false;
    }

    public Boolean vcsSafeExists(String path) {
        RemoteFileObjectBase fo = this.vcsSafeGetFileObject(path = PathUtilities.normalizeUnixPath((String)path));
        if (fo == null) {
            RemoteFileObjectBase parentFO;
            String parentPath = PathUtilities.getDirName((String)path);
            if (parentPath != null && (parentFO = this.vcsSafeGetFileObject(parentPath)) != null) {
                String childNameExt = PathUtilities.getBaseName((String)path);
                RemoteFileObject childFO = parentFO.getFileObject(childNameExt);
                return childFO != null && childFO.isValid() ? Boolean.TRUE : Boolean.FALSE;
            }
            return null;
        }
        return fo.isValid() ? Boolean.TRUE : Boolean.FALSE;
    }

    private class RemoteFileSupport
    extends ConnectionNotifier.NamedRunnable {
        public RemoteFileSupport() {
            super(NbBundle.getMessage(RemoteFileSupport.class, (String)"RemoteDownloadTask.TITLE", (Object)RemoteFileSystem.this.execEnv.getDisplayName()));
        }

        protected void runImpl() {
            try {
                this.onConnect();
            }
            catch (ConnectException ex) {
                RemoteLogger.getInstance().log(Level.INFO, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"RemoteFileSystemNotifier.ERROR", (Object)RemoteFileSystem.this.execEnv), ex);
                ConnectionNotifier.addTask((ExecutionEnvironment)RemoteFileSystem.this.execEnv, (ConnectionNotifier.NamedRunnable)this);
            }
            catch (InterruptedException ex) {
                RemoteLogger.finest(ex);
            }
            catch (InterruptedIOException ex) {
                RemoteLogger.finest(ex);
            }
            catch (IOException ex) {
                RemoteLogger.getInstance().log(Level.INFO, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"RemoteFileSystemNotifier.ERROR", (Object)RemoteFileSystem.this.execEnv), ex);
                ConnectionNotifier.addTask((ExecutionEnvironment)RemoteFileSystem.this.execEnv, (ConnectionNotifier.NamedRunnable)this);
            }
            catch (ExecutionException ex) {
                RemoteLogger.getInstance().log(Level.INFO, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"RemoteFileSystemNotifier.ERROR", (Object)RemoteFileSystem.this.execEnv), ex);
                ConnectionNotifier.addTask((ExecutionEnvironment)RemoteFileSystem.this.execEnv, (ConnectionNotifier.NamedRunnable)this);
            }
        }

        public String getName() {
            return NbBundle.getMessage(RemoteFileSupport.class, (String)(RemoteFileSystem.this.readOnlyConnectNotification.get() ? "RemoteDownloadTask.TEXT_RO" : "RemoteDownloadTask.TEXT"), (Object)RemoteFileSystem.this.execEnv.getDisplayName());
        }

        private void onConnect() throws InterruptedException, ConnectException, InterruptedIOException, IOException, ExecutionException {
            RemoteFileSystem.this.fireProblemListeners(null);
        }

        public void addPendingFile(RemoteFileObjectBase fo) {
            RemoteLogger.getInstance().log(Level.FINEST, "Adding notification for {0}:{1}", new Object[]{RemoteFileSystem.this.execEnv, fo.getPath()});
            ConnectionNotifier.addTask((ExecutionEnvironment)RemoteFileSystem.this.execEnv, (ConnectionNotifier.NamedRunnable)this);
        }
    }

    private static class RootFileObject
    extends RemoteDirectory {
        private RootFileObject(RemoteFileObject wrapper, RemoteFileSystem fileSystem, ExecutionEnvironment execEnv, File cache) {
            super(wrapper, fileSystem, execEnv, null, "", cache);
        }

        @Override
        public boolean isRoot() {
            return true;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public RemoteDirectory getParent() {
            return null;
        }

        @Override
        public Object getAttribute(String attrName) {
            if ("FileProxyOperations".equals(attrName) && USE_VCS) {
                return FileOperationsProvider.getDefault().getFileOperations(this.getFileSystem());
            }
            return super.getAttribute(attrName);
        }
    }

    private final class StatusImpl
    implements FileSystem.HtmlStatus,
    LookupListener,
    FileStatusListener {
        private Lookup.Result<AnnotationProvider> annotationProviders = Lookup.getDefault().lookupResult(AnnotationProvider.class);
        private Collection<? extends AnnotationProvider> previousProviders;

        private StatusImpl() {
            this.annotationProviders.addLookupListener((LookupListener)this);
            this.resultChanged(null);
        }

        public void resultChanged(LookupEvent ev) {
            HashSet<? extends AnnotationProvider> add;
            HashSet<? extends AnnotationProvider> now = this.annotationProviders.allInstances();
            if (this.previousProviders != null) {
                add = new HashSet<AnnotationProvider>(now);
                add.removeAll(this.previousProviders);
                HashSet<? extends AnnotationProvider> toRemove = new HashSet<AnnotationProvider>(this.previousProviders);
                toRemove.removeAll(now);
                for (AnnotationProvider annotationProvider : toRemove) {
                    annotationProvider.removeFileStatusListener(this);
                }
            } else {
                add = now;
            }
            for (AnnotationProvider annotationProvider : add) {
                try {
                    annotationProvider.addFileStatusListener(this);
                }
                catch (TooManyListenersException tooManyListenersException) {
                    Exceptions.printStackTrace((Throwable)tooManyListenersException);
                }
            }
            this.previousProviders = now;
        }

        public SystemAction[] getActions(Set<FileObject> foSet) {
            Action[] retVal = null;
            Iterator it = this.annotationProviders.allInstances().iterator();
            while (retVal == null && it.hasNext()) {
                AnnotationProvider ap = (AnnotationProvider)it.next();
                retVal = ap.actions(foSet);
            }
            if (retVal != null) {
                SystemAction[] ret = new SystemAction[retVal.length];
                for (int i = 0; i < retVal.length; ++i) {
                    if (!(retVal[i] instanceof SystemAction)) continue;
                    ret[i] = (SystemAction)retVal[i];
                }
                return ret;
            }
            return null;
        }

        public void annotationChanged(FileStatusEvent ev) {
            RemoteFileSystem.this.fireFileStatusChanged(ev);
        }

        public Image annotateIcon(Image icon, int iconType, Set<? extends FileObject> files) {
            for (AnnotationProvider ap : this.annotationProviders.allInstances()) {
                Image retVal = ap.annotateIcon(icon, iconType, files);
                if (retVal == null) continue;
                return retVal;
            }
            return icon;
        }

        public String annotateName(String name, Set<? extends FileObject> files) {
            for (AnnotationProvider ap : this.annotationProviders.allInstances()) {
                String retVal = ap.annotateName(name, files);
                if (retVal == null) continue;
                return retVal;
            }
            return name;
        }

        public String annotateNameHtml(String name, Set<? extends FileObject> files) {
            for (AnnotationProvider ap : this.annotationProviders.allInstances()) {
                String retVal = ap.annotateNameHtml(name, files);
                if (retVal == null) continue;
                return retVal;
            }
            return null;
        }
    }

    private static class AttrStat {
        public final String name;
        public int readCount = 0;
        public int writeCount = 0;
        public StackTraceElement[] firstReadStack;
        public StackTraceElement[] firstWriteStack;

        public AttrStat(String name) {
            this.name = name;
        }
    }
}

