/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fs.DirEntry;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.netbeans.modules.remote.impl.fs.RemoteFileObject;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteLink;
import org.netbeans.modules.remote.impl.fs.RemoteLinkBase;
import org.netbeans.modules.remote.impl.fs.RemoteLinkChild;
import org.netbeans.modules.remote.impl.fs.RemotePlainFile;
import org.netbeans.modules.remote.impl.fs.SpecialRemoteFileObject;
import org.netbeans.modules.remote.impl.fs.WeakCache;
import org.openide.filesystems.FileChangeListener;
import org.openide.util.RequestProcessor;

public class RemoteFileObjectFactory {
    private final ExecutionEnvironment env;
    private final RemoteFileSystem fileSystem;
    private final WeakCache<String, RemoteFileObjectBase> fileObjectsCache = new WeakCache();
    private final Object lock = new Object();
    private final Map<String, List<FileChangeListener>> pendingListeners = new HashMap<String, List<FileChangeListener>>();
    private final RequestProcessor.Task cleaningTask;
    private static RequestProcessor RP = new RequestProcessor("File objects cache dead entries cleanup", 1);
    private static final int CLEAN_INTERVAL = Integer.getInteger("rfs.cache.cleanup.interval", 10000);
    private int cacheRequests = 0;
    private int cacheHits = 0;

    public RemoteFileObjectFactory(RemoteFileSystem fileSystem) {
        this.fileSystem = fileSystem;
        this.env = fileSystem.getExecutionEnvironment();
        this.cleaningTask = RP.create(new Runnable(){

            @Override
            public void run() {
                RemoteFileObjectFactory.this.cleanDeadEntries();
            }
        });
        this.scheduleCleanDeadEntries();
    }

    Collection<RemoteFileObjectBase> getCachedFileObjects() {
        return this.fileObjectsCache.values();
    }

    public RemoteFileObjectBase getCachedFileObject(String path) {
        String normalizedPath = PathUtilities.normalizeUnixPath((String)path);
        return this.fileObjectsCache.get(normalizedPath);
    }

    private void scheduleCleanDeadEntries() {
        this.cleaningTask.schedule(CLEAN_INTERVAL);
    }

    private void cleanDeadEntries() {
        int size;
        boolean trace = RemoteLogger.getInstance().isLoggable(Level.FINEST);
        if (trace) {
            size = this.fileObjectsCache.size();
            if (RemoteLogger.getInstance().isLoggable(Level.FINEST)) {
                RemoteLogger.getInstance().log(Level.FINEST, "Cleaning file objects dead entries for {0} ... {1} entries and {2}% ({3} of {4}) hits so far", new Object[]{this.env, size, this.cacheRequests == 0 ? 0 : this.cacheHits * 100 / this.cacheRequests, this.cacheHits, this.cacheRequests});
            }
        }
        this.fileObjectsCache.cleanDeadEntries();
        if (trace) {
            size = this.fileObjectsCache.size();
            RemoteLogger.getInstance().log(Level.FINEST, "Cleaning file objects dead entries for {0} ... {1} entries left", new Object[]{this.env, size});
        }
        if (this.fileObjectsCache.size() > 0) {
            this.scheduleCleanDeadEntries();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeImplementor(RemoteDirectory parent, DirEntry oldEntry, DirEntry newEntry) {
        String path = parent.getPath() + '/' + oldEntry.getName();
        Object object = this.lock;
        synchronized (object) {
            RemoteFileObject owner = this.invalidate(path);
            RemoteFileObjectBase newImpl = this.createFileObject(parent, newEntry, owner);
        }
    }

    public RemoteFileObjectBase createFileObject(RemoteDirectory parent, DirEntry entry) {
        return this.createFileObject(parent, entry, null);
    }

    public RemoteFileObjectBase createFileObject(RemoteDirectory parent, DirEntry entry, RemoteFileObject owner) {
        File childCache = new File(parent.getCache(), entry.getCache());
        String childPath = parent.getPath() + '/' + entry.getName();
        RemoteFileObjectBase fo = entry.isDirectory() ? this.createRemoteDirectory(parent, childPath, childCache, owner) : (entry.isLink() ? this.createRemoteLink(parent, childPath, entry.getLinkTarget(), owner) : (entry.isPlainFile() ? this.createRemotePlainFile(parent, childPath, childCache, FileInfoProvider.StatInfo.FileType.Regular, owner) : this.createSpecialFile(parent, childPath, childCache, entry.getFileType(), owner)));
        return fo;
    }

    private RemoteFileObjectBase createRemoteDirectory(RemoteFileObjectBase parent, String remotePath, File cacheFile, RemoteFileObject owner) {
        RemoteFileObjectBase result;
        String normalizedRemotePath;
        RemoteFileObjectBase fo;
        ++this.cacheRequests;
        if (this.fileObjectsCache.size() == 0) {
            this.scheduleCleanDeadEntries();
        }
        if ((fo = this.fileObjectsCache.get(normalizedRemotePath = PathUtilities.normalizeUnixPath((String)remotePath))) instanceof RemoteDirectory && fo.isValid() && fo.getCache().equals(cacheFile)) {
            if (fo.getParent() == parent) {
                ++this.cacheHits;
                return (RemoteDirectory)fo;
            }
            fo = null;
        }
        if (fo != null && parent.isValid()) {
            fo.invalidate();
            this.fileObjectsCache.remove(normalizedRemotePath, fo);
        }
        if (owner == null) {
            owner = new RemoteFileObject(this.fileSystem);
        }
        if ((fo = new RemoteDirectory(owner, this.fileSystem, this.env, parent, normalizedRemotePath, cacheFile)).isValid() && (result = this.putIfAbsent(normalizedRemotePath, fo)) instanceof RemoteDirectory && result.getParent() == parent) {
            return (RemoteDirectory)result;
        }
        return fo;
    }

    private RemoteFileObjectBase createRemotePlainFile(RemoteDirectory parent, String remotePath, File cacheFile, FileInfoProvider.StatInfo.FileType fileType, RemoteFileObject owner) {
        RemoteFileObjectBase result;
        String normalizedRemotePath;
        RemoteFileObjectBase fo;
        ++this.cacheRequests;
        if (this.fileObjectsCache.size() == 0) {
            this.scheduleCleanDeadEntries();
        }
        if ((fo = this.fileObjectsCache.get(normalizedRemotePath = PathUtilities.normalizeUnixPath((String)remotePath))) instanceof RemotePlainFile && fo.isValid() && fo.getCache().equals(cacheFile)) {
            if (fo.getParent() == parent) {
                ++this.cacheHits;
                return (RemotePlainFile)fo;
            }
            fo = null;
        }
        if (fo != null && parent.isValid()) {
            fo.invalidate();
            this.fileObjectsCache.remove(normalizedRemotePath, fo);
        }
        if (owner == null) {
            owner = new RemoteFileObject(this.fileSystem);
        }
        if ((fo = new RemotePlainFile(owner, this.fileSystem, this.env, parent, normalizedRemotePath, cacheFile, fileType)).isValid() && (result = this.putIfAbsent(normalizedRemotePath, fo)) instanceof RemotePlainFile && result.getParent() == parent) {
            return (RemotePlainFile)result;
        }
        return fo;
    }

    private RemoteFileObjectBase createSpecialFile(RemoteDirectory parent, String remotePath, File cacheFile, FileInfoProvider.StatInfo.FileType fileType, RemoteFileObject owner) {
        RemoteFileObjectBase result;
        String normalizedRemotePath;
        RemoteFileObjectBase fo;
        ++this.cacheRequests;
        if (this.fileObjectsCache.size() == 0) {
            this.scheduleCleanDeadEntries();
        }
        if ((fo = this.fileObjectsCache.get(normalizedRemotePath = PathUtilities.normalizeUnixPath((String)remotePath))) instanceof SpecialRemoteFileObject && fo.isValid()) {
            if (fo.getParent() == parent) {
                ++this.cacheHits;
                return (SpecialRemoteFileObject)fo;
            }
            fo = null;
        }
        if (fo != null && parent.isValid()) {
            fo.invalidate();
            this.fileObjectsCache.remove(normalizedRemotePath, fo);
        }
        if (owner == null) {
            owner = new RemoteFileObject(this.fileSystem);
        }
        if ((fo = new SpecialRemoteFileObject(owner, this.fileSystem, this.env, parent, normalizedRemotePath, fileType)).isValid() && (result = this.putIfAbsent(normalizedRemotePath, fo)) instanceof SpecialRemoteFileObject && result.getParent() == parent) {
            return (SpecialRemoteFileObject)result;
        }
        return fo;
    }

    private RemoteFileObjectBase createRemoteLink(RemoteFileObjectBase parent, String remotePath, String link, RemoteFileObject owner) {
        RemoteLink fo;
        String normalizedRemotePath;
        RemoteFileObjectBase result;
        if (owner == null) {
            owner = new RemoteFileObject(this.fileSystem);
        }
        if ((result = this.putIfAbsent(normalizedRemotePath = PathUtilities.normalizeUnixPath((String)remotePath), fo = new RemoteLink(owner, this.fileSystem, this.env, parent, normalizedRemotePath, link))) instanceof RemoteLink && result == fo) {
            ((RemoteLink)result).initListeners(true);
        }
        return result;
    }

    public RemoteFileObjectBase createRemoteLinkChild(RemoteLinkBase parent, String remotePath, RemoteFileObjectBase delegate) {
        RemoteLinkChild fo;
        String normalizedRemotePath = PathUtilities.normalizeUnixPath((String)remotePath);
        RemoteFileObjectBase result = this.putIfAbsent(normalizedRemotePath, fo = new RemoteLinkChild(new RemoteFileObject(this.fileSystem), this.fileSystem, this.env, parent, normalizedRemotePath, delegate));
        if (result instanceof RemoteLinkChild) {
            if (result == fo) {
                ((RemoteLinkChild)result).initListeners(true);
            } else {
                RemoteFileObjectBase oldDelegate = ((RemoteLinkChild)result).getCanonicalDelegate();
                if (oldDelegate != delegate) {
                    RemoteFileObject ownerFileObject = result.getOwnerFileObject();
                    result.invalidate();
                    this.fileObjectsCache.remove(normalizedRemotePath, result);
                    fo = new RemoteLinkChild(ownerFileObject, this.fileSystem, this.env, parent, normalizedRemotePath, delegate);
                    result = this.putIfAbsent(normalizedRemotePath, fo);
                    if (result == fo) {
                        ((RemoteLinkChild)result).initListeners(true);
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteFileObjectBase putIfAbsent(String remotePath, RemoteFileObjectBase fo) {
        Object object = this.lock;
        synchronized (object) {
            RemoteFileObjectBase prev = this.fileObjectsCache.get(remotePath);
            if (prev == null) {
                List<FileChangeListener> listeners = this.pendingListeners.remove(remotePath);
                if (listeners != null) {
                    for (FileChangeListener l : listeners) {
                        fo.addFileChangeListener(l);
                    }
                }
                this.fileObjectsCache.put(remotePath, fo);
                return fo;
            }
            return prev;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileChangeListener(String path, FileChangeListener listener) {
        String normalizedPath = PathUtilities.normalizeUnixPath((String)path);
        RemoteFileObjectBase fo = this.getCachedFileObject(normalizedPath);
        if (fo == null) {
            Object object = this.lock;
            synchronized (object) {
                fo = this.getCachedFileObject(normalizedPath);
                if (fo != null) {
                    List<FileChangeListener> listeners = this.pendingListeners.get(normalizedPath);
                    if (listeners == null) {
                        listeners = new ArrayList<FileChangeListener>();
                        this.pendingListeners.put(normalizedPath, listeners);
                    }
                    listeners.add(listener);
                }
            }
        } else {
            fo.addFileChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileChangeListener(String path, FileChangeListener listener) {
        String normalizedPath = PathUtilities.normalizeUnixPath((String)path);
        RemoteFileObjectBase fo = this.getCachedFileObject(normalizedPath);
        if (fo == null) {
            Object object = this.lock;
            synchronized (object) {
                List<FileChangeListener> listeners;
                fo = this.getCachedFileObject(normalizedPath);
                if (fo != null && (listeners = this.pendingListeners.get(normalizedPath)) != null) {
                    listeners.remove(listener);
                }
            }
        } else {
            fo.removeFileChangeListener(listener);
        }
    }

    public RemoteFileObject invalidate(String remotePath) {
        String normalizedRemotePath = PathUtilities.normalizeUnixPath((String)remotePath);
        RemoteFileObjectBase fo = this.fileObjectsCache.remove(normalizedRemotePath);
        if (fo != null) {
            fo.invalidate();
            return fo.getOwnerFileObject();
        }
        return null;
    }

    public void rename(String path2Rename, String newPath, RemoteFileObjectBase fo2Rename) {
        String normalizedPath2Rename = PathUtilities.normalizeUnixPath((String)path2Rename);
        String normalizedNewPath = PathUtilities.normalizeUnixPath((String)newPath);
        HashSet<RemoteFileObjectBase> toRename = new HashSet<RemoteFileObjectBase>();
        this.addAllExistingChildren(fo2Rename, toRename);
        for (RemoteFileObjectBase fo : toRename) {
            String curPath = fo.getPath();
            String changedPath = curPath.replaceFirst(normalizedPath2Rename, normalizedNewPath);
            this.fileObjectsCache.remove(curPath, fo);
            fo.renamePath(changedPath);
            this.putIfAbsent(changedPath, fo);
        }
    }

    private void addAllExistingChildren(RemoteFileObjectBase fo, Collection<RemoteFileObjectBase> bag) {
        bag.add(fo);
        if (fo.isFolder()) {
            for (RemoteFileObjectBase child : fo.getExistentChildren()) {
                this.addAllExistingChildren(child, bag);
            }
        }
    }

    public void setLink(RemoteDirectory parent, String linkRemotePath, String linkTarget) {
        String normalizedPath = PathUtilities.normalizeUnixPath((String)linkRemotePath);
        RemoteFileObjectBase fo = this.fileObjectsCache.get(normalizedPath);
        if (fo != null) {
            if (fo instanceof RemoteLink) {
                ((RemoteLink)fo).setLink(linkTarget, parent);
            } else {
                RemoteLogger.getInstance().log(Level.FINE, "Called setLink on {0} - invalidating", fo.getClass().getSimpleName());
                fo.invalidate();
            }
        }
    }
}

