/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fileoperations.spi.FilesystemInterceptorProvider;
import org.netbeans.modules.remote.impl.fs.RecursiveListener;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.netbeans.modules.remote.impl.fs.RemoteFileObject;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;

public abstract class RemoteFileObjectBase {
    private final RemoteFileSystem fileSystem;
    private final RemoteFileObjectBase parent;
    private volatile String remotePath;
    private final File cache;
    private CopyOnWriteArrayList<FileChangeListener> listeners = new CopyOnWriteArrayList();
    private FileLock lock;
    private final Object instanceLock = new Object();
    public static final boolean USE_VCS;
    public static final boolean DEFER_WRITES;
    private volatile byte flags;
    private final RemoteFileObject fileObject;
    private static final byte MASK_VALID = 1;
    private static final byte CHECK_CAN_WRITE = 2;
    private static final byte BEING_UPLOADED = 4;
    protected static final byte CONNECTION_ISSUES = 8;

    protected RemoteFileObjectBase(RemoteFileObject wrapper, RemoteFileSystem fileSystem, ExecutionEnvironment execEnv, RemoteFileObjectBase parent, String remotePath, File cache) {
        RemoteLogger.assertTrue(execEnv.isRemote());
        this.parent = parent;
        this.remotePath = remotePath;
        this.cache = cache;
        this.setFlag((byte)1, true);
        this.fileSystem = wrapper.getFileSystem();
        this.fileObject = wrapper;
        wrapper.setImplementor(this);
    }

    public abstract boolean isFolder();

    public abstract boolean isData();

    public abstract RemoteFileObject getFileObject(String var1, String var2);

    public abstract RemoteFileObject getFileObject(String var1);

    public abstract InputStream getInputStream() throws FileNotFoundException;

    public abstract RemoteFileObject[] getChildren();

    public abstract FileInfoProvider.StatInfo.FileType getType();

    protected RemoteFileObject getOwnerFileObject() {
        return this.fileObject;
    }

    protected final void fireFileChangedEvent(Enumeration<FileChangeListener> en, FileEvent fe) {
        this.getOwnerFileObject().fireFileChangedEvent(en, fe);
    }

    protected final void fireFileDeletedEvent(Enumeration<FileChangeListener> en, FileEvent fe) {
        this.getOwnerFileObject().fireFileDeletedEvent(en, fe);
    }

    protected final void fireFileAttributeChangedEvent(Enumeration<FileChangeListener> en, FileAttributeEvent fe) {
        this.getOwnerFileObject().fireFileAttributeChangedEvent(en, fe);
    }

    protected final void fireFileDataCreatedEvent(Enumeration<FileChangeListener> en, FileEvent fe) {
        this.getOwnerFileObject().fireFileDataCreatedEvent(en, fe);
    }

    protected final void fireFileFolderCreatedEvent(Enumeration<FileChangeListener> en, FileEvent fe) {
        this.getOwnerFileObject().fireFileFolderCreatedEvent(en, fe);
    }

    protected final void fireFileRenamedEvent(Enumeration<FileChangeListener> en, FileRenameEvent fe) {
        this.getOwnerFileObject().fireFileRenamedEvent(en, fe);
    }

    protected boolean getFlag(byte mask) {
        return (this.flags & mask) == mask;
    }

    protected final void setFlag(byte mask, boolean value) {
        this.flags = value ? (byte)(this.flags | mask) : (byte)(this.flags & ~mask);
    }

    boolean isPendingRemoteDelivery() {
        return this.getFlag((byte)4);
    }

    void setPendingRemoteDelivery(boolean value) {
        this.setFlag((byte)4, value);
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.fileSystem.getExecutionEnvironment();
    }

    protected final File getCache() {
        return this.cache;
    }

    protected boolean hasCache() {
        return this.cache != null && this.cache.exists();
    }

    public String getPath() {
        return this.remotePath;
    }

    public void addFileChangeListener(FileChangeListener fcl) {
        this.listeners.add(fcl);
    }

    public void removeFileChangeListener(FileChangeListener fcl) {
        this.listeners.remove(fcl);
    }

    protected final Enumeration<FileChangeListener> getListeners() {
        return Collections.enumeration(this.listeners);
    }

    protected final Enumeration<FileChangeListener> getListenersWithParent() {
        RemoteFileObjectBase p = this.getParent();
        if (p == null) {
            return this.getListeners();
        }
        Enumeration<FileChangeListener> parentListeners = p.getListeners();
        if (!parentListeners.hasMoreElements()) {
            return this.getListeners();
        }
        ArrayList<FileChangeListener> result = new ArrayList<FileChangeListener>(this.listeners);
        while (parentListeners.hasMoreElements()) {
            result.add(parentListeners.nextElement());
        }
        return Collections.enumeration(result);
    }

    public void addRecursiveListener(FileChangeListener fcl) {
        if (this.isFolder()) {
            this.getFileSystem().addFileChangeListener(new RecursiveListener(this.getOwnerFileObject(), fcl, false));
        } else {
            this.addFileChangeListener(fcl);
        }
    }

    public void removeRecursiveListener(FileChangeListener fcl) {
        if (this.isFolder()) {
            this.getFileSystem().removeFileChangeListener(new RecursiveListener(this.getOwnerFileObject(), fcl, false));
        } else {
            this.removeFileChangeListener(fcl);
        }
    }

    public final FileObject createData(String name) throws IOException {
        return this.createDataImpl(name, "", this);
    }

    public final FileObject createData(String name, String ext) throws IOException {
        return this.createDataImpl(name, ext, this);
    }

    protected abstract RemoteFileObject createDataImpl(String var1, String var2, RemoteFileObjectBase var3) throws IOException;

    public final FileObject createFolder(String name) throws IOException {
        return this.createFolderImpl(name, this);
    }

    protected abstract RemoteFileObject createFolderImpl(String var1, RemoteFileObjectBase var2) throws IOException;

    protected abstract boolean deleteImpl(FileLock var1) throws IOException;

    protected abstract void postDeleteChild(FileObject var1);

    public final void delete(FileLock lock) throws IOException {
        this.deleteImpl(lock, this);
    }

    protected void deleteImpl(FileLock lock, RemoteFileObjectBase orig) throws IOException {
        boolean result;
        if (!this.checkLock(lock)) {
            throw new IOException("Wrong lock");
        }
        FilesystemInterceptorProvider.FilesystemInterceptor interceptor = null;
        if (USE_VCS) {
            interceptor = FilesystemInterceptorProvider.getDefault().getFilesystemInterceptor(this.fileSystem);
        }
        if (interceptor != null) {
            FilesystemInterceptorProvider.FileProxyI fileProxy = FilesystemInterceptorProvider.toFileProxy(orig.getOwnerFileObject());
            FilesystemInterceptorProvider.IOHandler deleteHandler = interceptor.getDeleteHandler(fileProxy);
            if (deleteHandler != null) {
                deleteHandler.handle();
                result = true;
            } else {
                result = this.deleteImpl(lock);
            }
            if (!result) {
                throw new IOException("Cannot delete " + this.getPath());
            }
            interceptor.deleteSuccess(fileProxy);
        } else {
            result = this.deleteImpl(lock);
            if (!result) {
                throw new IOException("Cannot delete " + this.getPath());
            }
        }
        RemoteFileObject fo = this.getOwnerFileObject();
        for (Map.Entry<String, Object> entry : this.getAttributesMap().entrySet()) {
            fo.fireFileAttributeChangedEvent(this.getListenersWithParent(), new FileAttributeEvent((FileObject)fo, (FileObject)fo, entry.getKey(), entry.getValue(), null));
        }
        FileEvent fe = new FileEvent((FileObject)fo, (FileObject)fo, true);
        for (RemoteFileObjectBase child : this.getExistentChildren(true)) {
            fo.fireFileDeletedEvent(Collections.enumeration(child.listeners), fe);
        }
        this.invalidate();
        RemoteFileObjectBase p = this.getParent();
        if (p != null) {
            p.postDeleteChild(this.getOwnerFileObject());
        }
    }

    public String getExt() {
        String nameExt = this.getNameExt();
        int pointPos = nameExt.lastIndexOf(46);
        return pointPos < 0 ? "" : nameExt.substring(pointPos + 1);
    }

    public RemoteFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public String getName() {
        String nameExt = this.getNameExt();
        int pointPos = nameExt.lastIndexOf(46);
        return pointPos < 0 ? nameExt : nameExt.substring(0, pointPos);
    }

    public String getNameExt() {
        int slashPos = this.getPath().lastIndexOf(47);
        return slashPos < 0 ? "" : this.getPath().substring(slashPos + 1);
    }

    public final OutputStream getOutputStream(FileLock lock) throws IOException {
        return this.getOutputStreamImpl(lock, this);
    }

    protected OutputStream getOutputStreamImpl(FileLock lock, RemoteFileObjectBase orig) throws IOException {
        throw new ReadOnlyException();
    }

    protected byte[] getMagic() {
        try {
            RemoteDirectory canonicalParent = RemoteFileSystemUtils.getCanonicalParent(this);
            if (canonicalParent != null) {
                return canonicalParent.getMagic(this);
            }
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
        return null;
    }

    private void populateWithChildren(RemoteFileObjectBase rfl, List<RemoteFileObjectBase> children) {
        children.add(rfl);
        for (RemoteFileObjectBase child : rfl.getExistentChildren()) {
            this.populateWithChildren(child, children);
        }
    }

    protected RemoteFileObjectBase[] getExistentChildren(boolean recursive) {
        if (!recursive) {
            return this.getExistentChildren();
        }
        LinkedList<RemoteFileObjectBase> children = new LinkedList<RemoteFileObjectBase>();
        this.populateWithChildren(this, children);
        children.remove(this);
        return children.toArray(new RemoteFileObjectBase[0]);
    }

    protected RemoteFileObjectBase[] getExistentChildren() {
        return new RemoteFileObjectBase[0];
    }

    public RemoteFileObjectBase getParent() {
        return this.parent;
    }

    public long getSize() {
        try {
            RemoteDirectory canonicalParent = RemoteFileSystemUtils.getCanonicalParent(this);
            if (canonicalParent != null) {
                return canonicalParent.getSize(this);
            }
        }
        catch (IOException ex) {
            this.reportIOException(ex);
        }
        return 0L;
    }

    @Deprecated
    public final boolean isReadOnly() {
        return this.isReadOnlyImpl(this);
    }

    protected boolean isReadOnlyImpl(RemoteFileObjectBase orig) {
        FilesystemInterceptorProvider.FilesystemInterceptor interceptor;
        if (USE_VCS && (interceptor = FilesystemInterceptorProvider.getDefault().getFilesystemInterceptor(this.fileSystem)) != null) {
            return !this.canWriteImpl(orig) && this.isValid();
        }
        return !this.canRead();
    }

    public boolean canRead() {
        try {
            RemoteDirectory canonicalParent = RemoteFileSystemUtils.getCanonicalParent(this);
            if (canonicalParent == null) {
                return true;
            }
            return canonicalParent.canRead(this.getNameExt());
        }
        catch (IOException ex) {
            this.reportIOException(ex);
            return true;
        }
    }

    public boolean canExecute() {
        try {
            RemoteDirectory canonicalParent = RemoteFileSystemUtils.getCanonicalParent(this);
            if (canonicalParent == null) {
                return true;
            }
            return canonicalParent.canExecute(this.getNameExt());
        }
        catch (IOException ex) {
            this.reportIOException(ex);
            return true;
        }
    }

    void connectionChanged() {
        if (this.getFlag((byte)2)) {
            this.setFlag((byte)2, false);
            this.fireFileAttributeChangedEvent("DataEditorSupport.read-only.refresh", null, null);
        }
    }

    final void fireFileAttributeChangedEvent(String attrName, Object oldValue, Object newValue) {
        Enumeration<FileChangeListener> pListeners = this.parent != null ? this.parent.getListeners() : null;
        this.fireFileAttributeChangedEvent(this.getListeners(), new FileAttributeEvent((FileObject)this.getOwnerFileObject(), (FileObject)this.getOwnerFileObject(), attrName, oldValue, newValue));
        if (this.parent != null && pListeners != null) {
            this.parent.fireFileAttributeChangedEvent(pListeners, new FileAttributeEvent((FileObject)this.parent.getOwnerFileObject(), (FileObject)this.getOwnerFileObject(), attrName, oldValue, newValue));
        }
    }

    public final boolean canWrite() {
        return this.canWriteImpl(this);
    }

    protected boolean canWriteImpl(RemoteFileObjectBase orig) {
        this.setFlag((byte)2, true);
        if (!ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment())) {
            this.getFileSystem().addReadOnlyConnectNotification(this);
            return false;
        }
        try {
            FilesystemInterceptorProvider.FilesystemInterceptor interceptor;
            RemoteDirectory canonicalParent = RemoteFileSystemUtils.getCanonicalParent(this);
            if (canonicalParent == null) {
                return false;
            }
            boolean result = canonicalParent.canWrite(this.getNameExt());
            if (!result && USE_VCS && (interceptor = FilesystemInterceptorProvider.getDefault().getFilesystemInterceptor(this.fileSystem)) != null) {
                result = interceptor.canWriteReadonlyFile(FilesystemInterceptorProvider.toFileProxy(orig.getOwnerFileObject()));
            }
            if (!result) {
                this.setFlag((byte)2, false);
            }
            return result;
        }
        catch (ConnectException ex) {
            return false;
        }
        catch (IOException ex) {
            this.reportIOException(ex);
            return false;
        }
    }

    protected void refreshThisFileMetadataImpl(boolean recursive, Set<String> antiLoop, boolean expected) throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
    }

    protected void refreshImpl(boolean recursive, Set<String> antiLoop, boolean expected) throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
    }

    void nonRecursiveRefresh() {
        try {
            this.refreshImpl(false, null, true);
        }
        catch (ConnectException ex) {
            RemoteLogger.finest(ex, (Object)this);
        }
        catch (IOException ex) {
            RemoteLogger.info(ex, (Object)this);
        }
        catch (InterruptedException ex) {
            RemoteLogger.finest(ex, (Object)this);
        }
        catch (CancellationException ex) {
            RemoteLogger.finest(ex, (Object)this);
        }
        catch (ExecutionException ex) {
            RemoteLogger.info(ex, (Object)this);
        }
    }

    public final void refresh(boolean expected) {
        try {
            this.refreshImpl(true, null, expected);
        }
        catch (ConnectException ex) {
            RemoteLogger.finest(ex, (Object)this);
        }
        catch (IOException ex) {
            RemoteLogger.info(ex, (Object)this);
        }
        catch (InterruptedException ex) {
            RemoteLogger.finest(ex, (Object)this);
        }
        catch (CancellationException ex) {
            RemoteLogger.finest(ex, (Object)this);
        }
        catch (ExecutionException ex) {
            RemoteLogger.info(ex, (Object)this);
        }
    }

    public final void refresh() {
        this.refresh(false);
    }

    public boolean isRoot() {
        return false;
    }

    public boolean isValid() {
        if (this.getFlag((byte)1)) {
            RemoteFileObjectBase p = this.getParent();
            return p == null || p.isValid();
        }
        return false;
    }

    void invalidate() {
        this.setFlag((byte)1, false);
    }

    public boolean isVirtual() {
        return false;
    }

    public Date lastModified() {
        if (this.isPendingRemoteDelivery()) {
            return new Date(-1L);
        }
        try {
            RemoteDirectory canonicalParent = RemoteFileSystemUtils.getCanonicalParent(this);
            if (canonicalParent != null) {
                return canonicalParent.lastModified(this);
            }
        }
        catch (IOException ex) {
            this.reportIOException(ex);
        }
        return new Date(0L);
    }

    private void reportIOException(IOException ex) {
        System.err.printf("Error in %s: %s\n", this.remotePath, ex.getMessage());
    }

    public final FileLock lock() throws IOException {
        return this.lockImpl(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileLock lockImpl(RemoteFileObjectBase orig) throws IOException {
        Object object = this.instanceLock;
        synchronized (object) {
            if (this.lock != null && this.lock.isValid()) {
                throw new FileAlreadyLockedException(this.getPath());
            }
            this.lock = new FileLock();
        }
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked() {
        boolean res = false;
        Object object = this.instanceLock;
        synchronized (object) {
            if (this.lock != null && !(res = this.lock.isValid())) {
                this.lock = null;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkLock(FileLock aLock) throws IOException {
        if (aLock != null) {
            Object object = this.instanceLock;
            synchronized (object) {
                return this.lock == aLock;
            }
        }
        return true;
    }

    public final void rename(FileLock lock, String name, String ext) throws IOException {
        this.renameImpl(lock, name, ext, this);
    }

    protected void renameImpl(FileLock lock, String name, String ext, RemoteFileObjectBase orig) throws IOException {
        if (!this.checkLock(lock)) {
            throw new IOException("Wrong lock");
        }
        RemoteFileObjectBase p = this.getParent();
        if (p != null) {
            String newNameExt = RemoteFileObjectBase.composeName(name, ext);
            if (newNameExt.equals(this.getNameExt())) {
                return;
            }
            if (!p.isValid()) {
                throw new IOException("Can not rename in " + p.getPath());
            }
            if (!p.canWrite()) {
                throw new IOException("Can not rename in read only " + p.getPath());
            }
            if (p.getOwnerFileObject().getFileObject(newNameExt) != null) {
                throw new IOException("Can not rename to " + newNameExt);
            }
            if (!ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment())) {
                throw new IOException("No connection: Can not rename in " + p.getPath());
            }
            try {
                Map<String, Object> map = this.getAttributesMap();
                p.renameChild(lock, this, newNameExt, orig);
                this.setAttributeMap(map, this.getOwnerFileObject());
            }
            catch (ConnectException ex) {
                throw new IOException("No connection: Can not rename in " + p.getPath(), ex);
            }
            catch (InterruptedException ex) {
                InterruptedIOException outEx = new InterruptedIOException("interrupted: Can not rename in " + p.getPath());
                outEx.initCause(ex);
                throw outEx;
            }
            catch (CancellationException ex) {
                throw new IOException("cancelled: Can not rename in " + p.getPath(), ex);
            }
            catch (ExecutionException ex) {
                throw new IOException("Can not rename to " + newNameExt + ": exception occurred", ex);
            }
        }
    }

    public FileObject copy(FileObject target, String name, String ext) throws IOException {
        return this.copyImpl(target, name, ext, this);
    }

    protected FileObject copyImpl(FileObject target, String name, String ext, RemoteFileObjectBase orig) throws IOException {
        FilesystemInterceptorProvider.FilesystemInterceptor interceptor;
        if (USE_VCS && (interceptor = FilesystemInterceptorProvider.getDefault().getFilesystemInterceptor(this.fileSystem)) != null) {
            FilesystemInterceptorProvider.FileProxyI to = FilesystemInterceptorProvider.toFileProxy(target, name, ext);
            FilesystemInterceptorProvider.FileProxyI from = FilesystemInterceptorProvider.toFileProxy(orig.getOwnerFileObject());
            interceptor.beforeCopy(from, to);
            FileObject result = null;
            FilesystemInterceptorProvider.IOHandler copyHandler = interceptor.getCopyHandler(from, to);
            if (copyHandler != null) {
                copyHandler.handle();
                this.refresh(true);
                target.refresh(true);
                result = target.getFileObject(name, ext);
                assert (result != null) : "Cannot find " + target + " with " + name + "." + ext;
                FileUtil.copyAttributes((FileObject)this.getOwnerFileObject(), (FileObject)result);
            } else {
                result = RemoteFileSystemUtils.copy(this.getOwnerFileObject(), target, name, ext);
            }
            interceptor.copySuccess(from, to);
            return result;
        }
        return RemoteFileSystemUtils.copy(this.getOwnerFileObject(), target, name, ext);
    }

    public final FileObject move(FileLock lock, FileObject target, String name, String ext) throws IOException {
        return this.moveImpl(lock, target, name, ext, this);
    }

    protected FileObject moveImpl(FileLock lock, FileObject target, String name, String ext, RemoteFileObjectBase orig) throws IOException {
        FilesystemInterceptorProvider.FilesystemInterceptor interceptor;
        if (!this.checkLock(lock)) {
            throw new IOException("Wrong lock");
        }
        if (USE_VCS && (interceptor = FilesystemInterceptorProvider.getDefault().getFilesystemInterceptor(this.fileSystem)) != null) {
            FilesystemInterceptorProvider.FileProxyI to = FilesystemInterceptorProvider.toFileProxy(target, name, ext);
            FilesystemInterceptorProvider.FileProxyI from = FilesystemInterceptorProvider.toFileProxy(orig.getOwnerFileObject());
            FileObject result = null;
            FilesystemInterceptorProvider.IOHandler moveHandler = interceptor.getMoveHandler(from, to);
            if (moveHandler != null) {
                Map<String, Object> attr = this.getAttributesMap();
                moveHandler.handle();
                this.refresh(true);
                target.refresh(true);
                result = target.getFileObject(name, ext);
                assert (result != null) : "Cannot find " + target + " with " + name + "." + ext;
                if (result instanceof RemoteFileObject) {
                    this.setAttributeMap(attr, (RemoteFileObject)result);
                }
            } else {
                result = this.superMove(lock, target, name, ext);
            }
            interceptor.afterMove(from, to);
            return result;
        }
        return this.superMove(lock, target, name, ext);
    }

    private FileObject superMove(FileLock lock, FileObject target, String name, String ext) throws IOException {
        if (this.getOwnerFileObject().getParent().equals(target)) {
            this.rename(lock, name, ext);
            return this.getOwnerFileObject();
        }
        FileObject dest = this.getOwnerFileObject().copy(target, name, ext);
        this.delete(lock);
        return dest;
    }

    private Map<String, Object> getAttributesMap() throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration<String> attributes = this.getAttributes();
        while (attributes.hasMoreElements()) {
            String attr = attributes.nextElement();
            map.put(attr, this.getAttribute(attr));
        }
        return map;
    }

    private void setAttributeMap(Map<String, Object> map, RemoteFileObject to) throws IOException {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            to.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public Object getAttribute(String attrName) {
        return this.getFileSystem().getAttribute(this, attrName);
    }

    public Enumeration<String> getAttributes() {
        return this.getFileSystem().getAttributes(this);
    }

    public void setAttribute(String attrName, Object value) throws IOException {
        this.getFileSystem().setAttribute(this, attrName, value);
    }

    @Deprecated
    public void setImportant(boolean b) {
    }

    protected abstract void renameChild(FileLock var1, RemoteFileObjectBase var2, String var3, RemoteFileObjectBase var4) throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException;

    final void renamePath(String newPath) {
        this.remotePath = newPath;
    }

    public String toString() {
        String validity = this.isValid() ? " [valid]" : (this.getFlag((byte)1) ? " [invalid] (flagged)" : " [invalid]");
        return this.getExecutionEnvironment().toString() + ":" + this.getPath() + validity;
    }

    public boolean equals(Object obj) {
        String otherPath;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteFileObjectBase other = (RemoteFileObjectBase)obj;
        if (this.flags != other.flags) {
            return false;
        }
        if (!(this.getFileSystem() == other.getFileSystem() || this.getFileSystem() != null && ((Object)((Object)this.fileSystem)).equals((Object)other.fileSystem))) {
            return false;
        }
        if (!(this.getExecutionEnvironment() == other.getExecutionEnvironment() || this.getExecutionEnvironment() != null && this.getExecutionEnvironment().equals(other.getExecutionEnvironment()))) {
            return false;
        }
        String thisPath = this.getPath();
        return thisPath == (otherPath = other.getPath()) || thisPath != null && thisPath.equals(otherPath);
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    protected static String composeName(String name, String ext) {
        return ext != null && ext.length() > 0 ? name + "." + ext : name;
    }

    static {
        DEFER_WRITES = Boolean.getBoolean("cnd.remote.defer.writes");
        USE_VCS = !"false".equals(System.getProperty("remote.vcs.suport"));
    }

    private static class ReadOnlyException
    extends IOException {
        public ReadOnlyException() {
            super("The remote file system is read-only");
        }
    }
}

