/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.netbeans.modules.dlight.libs.common.InvalidFileObjectSupport;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;

public final class RemoteFileObject
extends FileObject
implements Serializable {
    static final long serialVersionUID = 1931650016889811086L;
    private final RemoteFileSystem fileSystem;
    private RemoteFileObjectBase implementor;
    private transient ThreadLocal<AtomicInteger> magic = new ThreadLocal<AtomicInteger>(){

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger(0);
        }
    };

    RemoteFileObject(RemoteFileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    void setImplementor(RemoteFileObjectBase implementor) {
        boolean assertions = false;
        if (!$assertionsDisabled) {
            assertions = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertions) {
            RemoteFileObject newWrapper = implementor.getOwnerFileObject();
            if (newWrapper != null && newWrapper != this) {
                RemoteLogger.assertTrue(false, "RFS inconsistency in {0}: delegate wrapper differs", this);
            }
            if (this.implementor != null && this.implementor.isValid()) {
                RemoteLogger.assertTrue(false, "RFS inconsistency in {0}: replacing valid delegate", this);
            }
        }
        this.implementor = implementor;
    }

    public RemoteFileObjectBase getImplementor() {
        if (this.implementor == null) {
            String errMsg = "Null delegate";
            RemoteLogger.getInstance().log(Level.WARNING, errMsg, new NullPointerException(errMsg));
        }
        return this.implementor;
    }

    public RemoteFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.fileSystem.getExecutionEnvironment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMIMEType() {
        this.magic.get().incrementAndGet();
        try {
            String string = super.getMIMEType();
            return string;
        }
        finally {
            this.magic.get().decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMIMEType(String ... withinMIMETypes) {
        this.magic.get().incrementAndGet();
        try {
            String string = super.getMIMEType(withinMIMETypes);
            return string;
        }
        finally {
            this.magic.get().decrementAndGet();
        }
    }

    protected boolean isMimeResolving() {
        if (this.magic.get().intValue() > 0) {
            return true;
        }
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if ((!"org.openide.filesystems.MIMESupport".equals(element.getClassName()) || !"findMIMEType".equals(element.getMethodName())) && (!"org.openide.loaders.DefaultDataObject".equals(element.getClassName()) || !"fixCookieSet".equals(element.getMethodName()))) continue;
            return true;
        }
        return false;
    }

    protected void fireFileChangedEvent(Enumeration<FileChangeListener> en, FileEvent fe) {
        super.fireFileChangedEvent(en, fe);
    }

    protected void fireFileDeletedEvent(Enumeration<FileChangeListener> en, FileEvent fe) {
        super.fireFileDeletedEvent(en, fe);
    }

    protected void fireFileAttributeChangedEvent(Enumeration<FileChangeListener> en, FileAttributeEvent fe) {
        super.fireFileAttributeChangedEvent(en, fe);
    }

    protected void fireFileDataCreatedEvent(Enumeration<FileChangeListener> en, FileEvent fe) {
        super.fireFileDataCreatedEvent(en, fe);
    }

    protected void fireFileFolderCreatedEvent(Enumeration<FileChangeListener> en, FileEvent fe) {
        super.fireFileFolderCreatedEvent(en, fe);
    }

    protected void fireFileRenamedEvent(Enumeration<FileChangeListener> en, FileRenameEvent fe) {
        super.fireFileRenamedEvent(en, fe);
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object obj) {
        String otherPath;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteFileObject other = (RemoteFileObject)obj;
        if (!(this.getFileSystem() == other.getFileSystem() || this.getFileSystem() != null && ((Object)((Object)this.fileSystem)).equals((Object)other.fileSystem))) {
            return false;
        }
        if (!(this.getExecutionEnvironment() == other.getExecutionEnvironment() || this.getExecutionEnvironment() != null && this.getExecutionEnvironment().equals(other.getExecutionEnvironment()))) {
            return false;
        }
        String thisPath = this.getPath();
        return thisPath == (otherPath = other.getPath()) || thisPath != null && thisPath.equals(otherPath);
    }

    public String toString() {
        return this.getImplementor().toString();
    }

    public void setImportant(boolean b) {
        this.getImplementor().setImportant(b);
    }

    public void setAttribute(String attrName, Object value) throws IOException {
        this.getImplementor().setAttribute(attrName, value);
    }

    public void rename(FileLock lock, String name, String ext) throws IOException {
        this.getImplementor().rename(lock, name, ext);
    }

    public void removeRecursiveListener(FileChangeListener fcl) {
        this.getImplementor().removeRecursiveListener(fcl);
    }

    public void removeFileChangeListener(FileChangeListener fcl) {
        this.getImplementor().removeFileChangeListener(fcl);
    }

    public void refresh() {
        this.getImplementor().refresh();
    }

    void nonRecursiveRefresh() {
        this.getImplementor().nonRecursiveRefresh();
    }

    public void refresh(boolean expected) {
        this.getImplementor().refresh(expected);
    }

    public FileObject copy(FileObject target, String name, String ext) throws IOException {
        return this.getImplementor().copy(target, name, ext);
    }

    public FileObject move(FileLock lock, FileObject target, String name, String ext) throws IOException {
        FileObject result = this.getImplementor().move(lock, target, name, ext);
        RemoteFileObject.reassignLkp(this, result);
        return result;
    }

    public static void reassignLkp(FileObject from, FileObject to) {
        try {
            Class<?> c = Class.forName("org.openide.filesystems.FileObjectLkp");
            Method m = c.getDeclaredMethod("reassign", FileObject.class, FileObject.class);
            m.setAccessible(true);
            m.invoke(null, from, to);
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            if (ex.getCause() instanceof Error) {
                throw (Error)ex.getCause();
            }
            throw new IllegalStateException(ex);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public FileLock lock() throws IOException {
        return this.getImplementor().lock();
    }

    public Date lastModified() {
        return this.getImplementor().lastModified();
    }

    public boolean isVirtual() {
        return this.getImplementor().isVirtual();
    }

    public boolean isValid() {
        return this.getImplementor().isValid();
    }

    public boolean isRoot() {
        return this.getImplementor().isRoot();
    }

    public boolean isReadOnly() {
        return this.getImplementor().isReadOnly();
    }

    public boolean isLocked() {
        return this.getImplementor().isLocked();
    }

    public boolean isFolder() {
        return this.getImplementor().isFolder();
    }

    public boolean isData() {
        return this.getImplementor().isData();
    }

    public long getSize() {
        return this.getImplementor().getSize();
    }

    public String getPath() {
        return this.getImplementor().getPath();
    }

    public RemoteFileObject getParent() {
        RemoteFileObjectBase parent = this.getImplementor().getParent();
        return parent == null ? null : parent.getOwnerFileObject();
    }

    public OutputStream getOutputStream(FileLock lock) throws IOException {
        return this.getImplementor().getOutputStream(lock);
    }

    public String getNameExt() {
        return this.getImplementor().getNameExt();
    }

    public String getName() {
        return this.getImplementor().getName();
    }

    public InputStream getInputStream() throws FileNotFoundException {
        byte[] b;
        if (!this.getImplementor().hasCache() && this.isMimeResolving() && (b = this.getImplementor().getMagic()) != null) {
            return new ByteArrayInputStream(b);
        }
        return this.getImplementor().getInputStream();
    }

    public RemoteFileObject getFileObject(String relativePath) {
        return this.getImplementor().getFileObject(relativePath);
    }

    public RemoteFileObject getFileObject(String name, String ext) {
        return this.getImplementor().getFileObject(name, ext);
    }

    public String getExt() {
        return this.getImplementor().getExt();
    }

    public RemoteFileObject[] getChildren() {
        return this.getImplementor().getChildren();
    }

    public Enumeration<String> getAttributes() {
        return this.getImplementor().getAttributes();
    }

    public Object getAttribute(String attrName) {
        return this.getImplementor().getAttribute(attrName);
    }

    public void delete(FileLock lock) throws IOException {
        this.getImplementor().delete(lock);
    }

    public FileObject createFolder(String name) throws IOException {
        return this.getImplementor().createFolder(name);
    }

    public FileObject createData(String name) throws IOException {
        return this.getImplementor().createData(name);
    }

    public FileObject createData(String name, String ext) throws IOException {
        return this.getImplementor().createData(name, ext);
    }

    public boolean canWrite() {
        return this.getImplementor().canWrite();
    }

    public boolean canRead() {
        return this.getImplementor().canRead();
    }

    public void addRecursiveListener(FileChangeListener fcl) {
        this.getImplementor().addRecursiveListener(fcl);
    }

    public void addFileChangeListener(FileChangeListener fcl) {
        this.getImplementor().addFileChangeListener(fcl);
    }

    Object writeReplace() throws ObjectStreamException {
        return new SerializedForm(this.getExecutionEnvironment(), this.getPath());
    }

    private static class SerializedForm
    implements Serializable {
        static final long serialVersionUID = -1L;
        private final ExecutionEnvironment env;
        private final String remotePath;

        public SerializedForm(ExecutionEnvironment env, String remotePath) {
            this.env = env;
            this.remotePath = remotePath;
        }

        Object readResolve() throws ObjectStreamException {
            RemoteFileSystem fs = RemoteFileSystemManager.getInstance().getFileSystem(this.env);
            RemoteFileObject fo = fs.findResource(this.remotePath);
            if (fo == null) {
                fo = InvalidFileObjectSupport.getInvalidFileObject((FileSystem)fs, (CharSequence)this.remotePath);
            }
            return fo;
        }
    }
}

