/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fileoperations.spi.FilesystemInterceptorProvider;
import org.netbeans.modules.remote.impl.fs.CachedRemoteInputStream;
import org.netbeans.modules.remote.impl.fs.DirEntry;
import org.netbeans.modules.remote.impl.fs.DirEntryInvalid;
import org.netbeans.modules.remote.impl.fs.DirEntrySftp;
import org.netbeans.modules.remote.impl.fs.DirectoryReaderSftp;
import org.netbeans.modules.remote.impl.fs.DirectoryStorage;
import org.netbeans.modules.remote.impl.fs.FormatException;
import org.netbeans.modules.remote.impl.fs.MagicCache;
import org.netbeans.modules.remote.impl.fs.RefreshManager;
import org.netbeans.modules.remote.impl.fs.RemoteFileObject;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.netbeans.modules.remote.impl.fs.RemotePlainFile;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.util.Exceptions;

public class RemoteDirectory
extends RemoteFileObjectBase {
    private static final boolean trace = Boolean.getBoolean("cnd.remote.directory.trace");
    private Reference<DirectoryStorage> storageRef = new SoftReference<Object>(null);
    private Reference<MagicCache> magicCache = new SoftReference<Object>(null);
    private final Object refLock = new RefLock();
    private final Object magicLock = new MagicLock();
    private static final Collection<String> AUTO_MOUNTS = Arrays.asList("/net", "/set", "/import", "/shared", "/home", "/ade_autofs", "/ade");

    RemoteDirectory(RemoteFileObject wrapper, RemoteFileSystem fileSystem, ExecutionEnvironment execEnv, RemoteFileObjectBase parent, String remotePath, File cache) {
        super(wrapper, fileSystem, execEnv, parent, remotePath, cache);
        if (RefreshManager.REFRESH_ON_CONNECT && cache.exists() && ConnectionManager.getInstance().isConnectedTo(execEnv)) {
            fileSystem.getRefreshManager().scheduleRefresh(Arrays.asList(this), false);
        }
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public boolean isData() {
        return false;
    }

    @Override
    public RemoteFileObject getFileObject(String name, String ext) {
        return this.getFileObject(RemoteDirectory.composeName(name, ext), (Set<String>)null);
    }

    private DirEntry getEntry(String childNameExt) throws IOException {
        try {
            DirectoryStorage storage = this.getDirectoryStorage(childNameExt);
            DirEntry entry = storage.getValidEntry(childNameExt);
            return entry;
        }
        catch (ConnectException ex) {
            throw ex;
        }
        catch (InterruptedIOException ex) {
            RemoteLogger.finest(ex, (Object)this);
            return null;
        }
        catch (ExecutionException ex) {
            RemoteLogger.finest(ex, (Object)this);
            return null;
        }
        catch (InterruptedException ex) {
            RemoteLogger.finest(ex, (Object)this);
            return null;
        }
        catch (CancellationException ex) {
            return null;
        }
    }

    boolean canWrite(String childNameExt) throws IOException, ConnectException {
        DirEntry entry = this.getEntry(childNameExt);
        return entry != null && entry.canWrite(this.getExecutionEnvironment());
    }

    boolean canRead(String childNameExt) throws IOException {
        DirEntry entry = this.getEntry(childNameExt);
        return entry != null && entry.canRead(this.getExecutionEnvironment());
    }

    boolean canExecute(String childNameExt) throws IOException {
        DirEntry entry = this.getEntry(childNameExt);
        return entry != null && entry.canExecute(this.getExecutionEnvironment());
    }

    @Override
    public RemoteFileObject createDataImpl(String name, String ext, RemoteFileObjectBase orig) throws IOException {
        return this.create(RemoteDirectory.composeName(name, ext), false, orig);
    }

    @Override
    public RemoteFileObject createFolderImpl(String name, RemoteFileObjectBase orig) throws IOException {
        return this.create(name, true, orig);
    }

    @Override
    protected void postDeleteChild(FileObject child) {
        try {
            DirectoryStorage ds = this.refreshDirectoryStorage(child.getNameExt(), false);
        }
        catch (ConnectException ex) {
            RemoteLogger.getInstance().log(Level.INFO, "Error post removing child " + child, ex);
        }
        catch (IOException ex) {
            RemoteLogger.finest(ex, (Object)this);
        }
        catch (ExecutionException ex) {
            RemoteLogger.finest(ex, (Object)this);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            RemoteLogger.finest(ex, (Object)this);
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    @Override
    protected boolean deleteImpl(FileLock lock) throws IOException {
        return RemoteFileSystemUtils.delete(this.getExecutionEnvironment(), this.getPath(), true);
    }

    private RemoteFileObject create(String name, boolean directory, RemoteFileObjectBase orig) throws IOException {
        ProcessUtils.ExitStatus res;
        FilesystemInterceptorProvider.FilesystemInterceptor interceptor;
        String path = this.getPath() + '/' + name;
        if (name.contains("\\") || name.contains("/")) {
            throw new IOException("Cannot create file " + path);
        }
        if (!ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment())) {
            throw new ConnectException("Can not create " + this.getUrlToReport(path) + ": connection required");
        }
        if (USE_VCS && (interceptor = FilesystemInterceptorProvider.getDefault().getFilesystemInterceptor(this.getFileSystem())) != null) {
            interceptor.beforeCreate(FilesystemInterceptorProvider.toFileProxy(orig.getOwnerFileObject()), name, directory);
        }
        if (directory) {
            res = ProcessUtils.execute((ExecutionEnvironment)this.getExecutionEnvironment(), (String)"mkdir", (String[])new String[]{path});
        } else {
            String script = String.format("ls \"%s\" || touch \"%s\"", name, name);
            res = ProcessUtils.executeInDir((String)this.getPath(), (ExecutionEnvironment)this.getExecutionEnvironment(), (String)"sh", (String[])new String[]{"-c", script});
            if (res.isOK() && res.error.length() == 0) {
                this.creationFalure(name, directory, orig);
                throw new IOException("Already exists: " + this.getUrlToReport(path));
            }
        }
        if (res.isOK()) {
            try {
                FilesystemInterceptorProvider.FilesystemInterceptor interceptor2;
                this.refreshDirectoryStorage(name, false);
                RemoteFileObject fo = this.getFileObject(name);
                if (fo == null) {
                    this.creationFalure(name, directory, orig);
                    throw new FileNotFoundException("Can not create FileObject " + this.getUrlToReport(path));
                }
                if (USE_VCS && (interceptor2 = FilesystemInterceptorProvider.getDefault().getFilesystemInterceptor(this.getFileSystem())) != null) {
                    if (this == orig) {
                        interceptor2.createSuccess(FilesystemInterceptorProvider.toFileProxy(fo));
                    } else {
                        RemoteFileObject originalFO = orig.getFileObject(name);
                        if (originalFO == null) {
                            throw new FileNotFoundException("Can not create FileObject " + this.getUrlToReport(path));
                        }
                        interceptor2.createSuccess(FilesystemInterceptorProvider.toFileProxy(originalFO));
                    }
                }
                return fo;
            }
            catch (ConnectException ex) {
                this.creationFalure(name, directory, orig);
                throw new IOException("Can not create " + path + ": not connected", ex);
            }
            catch (InterruptedIOException ex) {
                this.creationFalure(name, directory, orig);
                throw new IOException("Can not create " + path + ": interrupted", ex);
            }
            catch (IOException ex) {
                this.creationFalure(name, directory, orig);
                throw ex;
            }
            catch (ExecutionException ex) {
                this.creationFalure(name, directory, orig);
                throw new IOException("Can not create " + path + ": exception occurred", ex);
            }
            catch (InterruptedException ex) {
                this.creationFalure(name, directory, orig);
                throw new IOException("Can not create " + path + ": interrupted", ex);
            }
            catch (CancellationException ex) {
                this.creationFalure(name, directory, orig);
                throw new IOException("Can not create " + path + ": cancelled", ex);
            }
        }
        this.creationFalure(name, directory, orig);
        throw new IOException("Can not create " + this.getUrlToReport(path) + ": " + res.error);
    }

    private void creationFalure(String name, boolean directory, RemoteFileObjectBase orig) {
        FilesystemInterceptorProvider.FilesystemInterceptor interceptor;
        if (USE_VCS && (interceptor = FilesystemInterceptorProvider.getDefault().getFilesystemInterceptor(this.getFileSystem())) != null) {
            interceptor.createFailure(FilesystemInterceptorProvider.toFileProxy(this.getOwnerFileObject()), name, directory);
        }
    }

    private String getUrlToReport(String path) {
        return this.getExecutionEnvironment().getDisplayName() + ':' + path;
    }

    @Override
    public RemoteFileObject getFileObject(String relativePath) {
        RemoteFileObject result = this.getFileObject(relativePath, (Set<String>)null);
        return result;
    }

    RemoteFileObject getFileObject(String relativePath, Set<String> antiLoop) {
        int slashPos;
        if ("".equals(relativePath = PathUtilities.normalizeUnixPath((String)relativePath))) {
            return this.getOwnerFileObject();
        }
        if (relativePath.startsWith("..")) {
            String absPath = this.getPath() + '/' + relativePath;
            absPath = PathUtilities.normalizeUnixPath((String)absPath);
            return this.getFileSystem().findResource(absPath);
        }
        if (relativePath != null && relativePath.length() > 0 && relativePath.charAt(0) == '/') {
            relativePath = relativePath.substring(1);
        }
        if (relativePath.endsWith("/")) {
            relativePath = relativePath.substring(0, relativePath.length() - 1);
        }
        if ((slashPos = relativePath.lastIndexOf(47)) > 0) {
            String parentRemotePath = this.getPath() + '/' + relativePath.substring(0, slashPos);
            if (antiLoop != null) {
                String absPath = this.getPath() + '/' + relativePath;
                if (antiLoop.contains(absPath)) {
                    return null;
                }
                antiLoop.add(absPath);
            }
            String childNameExt = relativePath.substring(slashPos + 1);
            RemoteFileObject parentFileObject = this.getFileSystem().findResource(parentRemotePath);
            if (parentFileObject != null && parentFileObject.isFolder()) {
                RemoteFileObject result = parentFileObject.getFileObject(childNameExt);
                return result;
            }
            return null;
        }
        RemoteLogger.assertTrue(slashPos == -1);
        try {
            DirectoryStorage storage = this.getDirectoryStorage(relativePath);
            DirEntry entry = storage.getValidEntry(relativePath);
            if (entry == null) {
                return null;
            }
            return this.getFileSystem().getFactory().createFileObject(this, entry).getOwnerFileObject();
        }
        catch (InterruptedException ex) {
            RemoteLogger.finest(ex, (Object)this);
            return null;
        }
        catch (InterruptedIOException ex) {
            RemoteLogger.finest(ex, (Object)this);
            return null;
        }
        catch (CancellationException ex) {
            RemoteLogger.finest(ex, (Object)this);
            return null;
        }
        catch (ExecutionException ex) {
            RemoteLogger.finest(ex, (Object)this);
            return null;
        }
        catch (ConnectException ex) {
            this.setFlag((byte)8, true);
            RemoteLogger.finest(ex, (Object)this);
            return null;
        }
        catch (FileNotFoundException ex) {
            RemoteLogger.finest(ex, (Object)this);
            return null;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private void fireRemoteFileObjectCreated(RemoteFileObject fo) {
        FileEvent e = new FileEvent((FileObject)this.getOwnerFileObject(), (FileObject)fo);
        RemoteFileObjectBase delegate = fo.getImplementor();
        if (delegate instanceof RemoteDirectory) {
            this.fireFileFolderCreatedEvent(this.getListeners(), e);
        } else if (delegate instanceof RemotePlainFile) {
            this.fireFileDataCreatedEvent(this.getListeners(), e);
        } else {
            RemoteLogger.getInstance().warning("firing fireFileDataCreatedEvent for a link");
            this.fireFileDataCreatedEvent(this.getListeners(), e);
        }
    }

    @Override
    protected RemoteFileObjectBase[] getExistentChildren() {
        return this.getExistentChildren(this.getExistingDirectoryStorage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectoryStorage getExistingDirectoryStorage() {
        File storageFile;
        DirectoryStorage storage;
        Object object = this.refLock;
        synchronized (object) {
            storage = this.storageRef.get();
        }
        if (storage == null && (storageFile = this.getStorageFile()).exists()) {
            Lock readLock = RemoteFileSystem.getLock(this.getCache()).readLock();
            readLock.lock();
            try {
                storage = DirectoryStorage.load(storageFile);
            }
            catch (FormatException e) {
                Level level = e.isExpected() ? Level.FINE : Level.WARNING;
                RemoteLogger.getInstance().log(level, "Error reading directory cache", e);
                storageFile.delete();
            }
            catch (InterruptedIOException e) {
            }
            catch (FileNotFoundException e) {
                RemoteLogger.finest(e, (Object)this);
            }
            catch (IOException e) {
                RemoteLogger.finest(e, (Object)this);
            }
            finally {
                readLock.unlock();
            }
        }
        return storage == null ? DirectoryStorage.EMPTY : storage;
    }

    private RemoteFileObjectBase[] getExistentChildren(DirectoryStorage storage) {
        List<DirEntry> entries = storage.listValid();
        ArrayList<RemoteFileObjectBase> result = new ArrayList<RemoteFileObjectBase>(entries.size());
        for (DirEntry entry : entries) {
            String path = this.getPath() + '/' + entry.getName();
            RemoteFileObjectBase fo = this.getFileSystem().getFactory().getCachedFileObject(path);
            if (fo == null) continue;
            result.add(fo);
        }
        return result.toArray(new RemoteFileObjectBase[result.size()]);
    }

    @Override
    public RemoteFileObject[] getChildren() {
        try {
            DirectoryStorage storage = this.getDirectoryStorage(null);
            List<DirEntry> entries = storage.listValid();
            RemoteFileObject[] childrenFO = new RemoteFileObject[entries.size()];
            for (int i = 0; i < entries.size(); ++i) {
                DirEntry entry = entries.get(i);
                childrenFO[i] = this.getFileSystem().getFactory().createFileObject(this, entry).getOwnerFileObject();
            }
            return childrenFO;
        }
        catch (InterruptedException ex) {
            RemoteLogger.finest(ex, (Object)this);
        }
        catch (InterruptedIOException ex) {
            RemoteLogger.finest(ex, (Object)this);
        }
        catch (ExecutionException ex) {
            RemoteLogger.finest(ex, (Object)this);
        }
        catch (ConnectException ex) {
            this.setFlag((byte)8, true);
            RemoteLogger.finest(ex, (Object)this);
        }
        catch (FileNotFoundException ex) {
            RemoteLogger.finest(ex, (Object)this);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (CancellationException ex) {
            RemoteLogger.finest(ex, (Object)this);
        }
        return new RemoteFileObject[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectoryStorage getDirectoryStorage(String childName) throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        DirectoryStorage directoryStorage;
        block3: {
            long time = System.currentTimeMillis();
            try {
                directoryStorage = this.getDirectoryStorageImpl(false, null, childName, false);
                if (!trace) break block3;
            }
            catch (Throwable throwable) {
                if (trace) {
                    this.trace("getDirectoryStorage for {1} took {0} ms", this, System.currentTimeMillis() - time);
                }
                throw throwable;
            }
            this.trace("getDirectoryStorage for {1} took {0} ms", this, System.currentTimeMillis() - time);
        }
        return directoryStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectoryStorage refreshDirectoryStorage(String expectedName, boolean expected) throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        DirectoryStorage directoryStorage;
        block3: {
            long time = System.currentTimeMillis();
            try {
                directoryStorage = this.getDirectoryStorageImpl(true, expectedName, null, expected);
                if (!trace) break block3;
            }
            catch (Throwable throwable) {
                if (trace) {
                    this.trace("refreshDirectoryStorage for {1} took {0} ms", this, System.currentTimeMillis() - time);
                }
                throw throwable;
            }
            this.trace("refreshDirectoryStorage for {1} took {0} ms", this, System.currentTimeMillis() - time);
        }
        return directoryStorage;
    }

    private boolean isProhibited() {
        return this.getPath().equals("/proc");
    }

    private Map<String, DirEntry> readEntries(DirectoryStorage oldStorage, boolean forceRefresh, String childName) throws IOException, InterruptedException, ExecutionException, CancellationException {
        if (this.isProhibited()) {
            return Collections.emptyMap();
        }
        HashMap<String, DirEntry> newEntries = new HashMap<String, DirEntry>();
        boolean canLs = this.canLs();
        if (canLs) {
            DirectoryReaderSftp directoryReader = new DirectoryReaderSftp(this.getExecutionEnvironment(), this.getPath());
            directoryReader.readDirectory();
            for (DirEntry entry : directoryReader.getEntries()) {
                newEntries.put(entry.getName(), entry);
            }
        }
        if (canLs && !this.isAutoMount()) {
            return newEntries;
        }
        if (childName != null) {
            String absPath = this.getPath() + '/' + childName;
            RemoteLogger.assertTrueInConsole(!oldStorage.isKnown(childName) || forceRefresh, "should not get here: " + absPath, new Object[0]);
            if (!newEntries.containsKey(childName)) {
                DirEntry entry = this.getSpecialDirChildEntry(absPath, childName);
                newEntries.put(entry.getName(), entry);
            }
        }
        for (DirEntry oldEntry : oldStorage.listAll()) {
            String oldChildName = oldEntry.getName();
            if (newEntries.containsKey(oldChildName)) continue;
            if (forceRefresh) {
                if (!oldEntry.isValid()) continue;
                String absPath = this.getPath() + '/' + oldChildName;
                DirEntry newEntry = this.getSpecialDirChildEntry(absPath, oldChildName);
                newEntries.put(oldChildName, newEntry);
                continue;
            }
            newEntries.put(oldChildName, oldEntry);
        }
        return newEntries;
    }

    private DirEntry getSpecialDirChildEntry(String absPath, String childName) throws InterruptedException, ExecutionException {
        FileInfoProvider.StatInfo statInfo;
        try {
            statInfo = (FileInfoProvider.StatInfo)FileInfoProvider.stat((ExecutionEnvironment)this.getExecutionEnvironment(), (String)absPath, (Writer)new PrintWriter(System.err)).get();
        }
        catch (ExecutionException e) {
            if (RemoteFileSystemUtils.isFileNotFoundException(e)) {
                statInfo = null;
            }
            throw e;
        }
        DirEntry entry = statInfo == null ? new DirEntryInvalid(childName) : new DirEntrySftp(statInfo, statInfo.getName());
        return entry;
    }

    private boolean isAutoMount() {
        String path = this.getPath();
        return AUTO_MOUNTS.contains(path);
    }

    private boolean canLs() {
        return this.canRead();
    }

    private boolean isSpecialDirectory() {
        return this.isAutoMount() || !this.canLs();
    }

    private boolean isAlreadyKnownChild(DirectoryStorage storage, String childName) {
        return childName == null || storage == null || storage.isKnown(childName) || !ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment()) || !this.isSpecialDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void renameChild(FileLock lock, RemoteFileObjectBase directChild2Rename, String newNameExt, RemoteFileObjectBase orig) throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        String nameExt2Rename = directChild2Rename.getNameExt();
        String name2Rename = directChild2Rename.getName();
        String ext2Rename = directChild2Rename.getExt();
        String path2Rename = directChild2Rename.getPath();
        this.checkConnection(this, true);
        Lock writeLock = RemoteFileSystem.getLock(this.getCache()).writeLock();
        if (trace) {
            this.trace("waiting for lock", new Object[0]);
        }
        writeLock.lock();
        try {
            ProcessUtils.ExitStatus ret;
            FilesystemInterceptorProvider.IOHandler renameHandler;
            FilesystemInterceptorProvider.FilesystemInterceptor interceptor;
            DirectoryStorage storage = this.getExistingDirectoryStorage();
            if (storage.getValidEntry(nameExt2Rename) == null) {
                throw new IOException(nameExt2Rename + " is not an existing child of " + this);
            }
            if (!this.getCache().exists()) {
                this.getCache().mkdirs();
                if (!this.getCache().exists()) {
                    throw new IOException("Can not create cache directory " + this.getCache());
                }
            }
            if (trace) {
                this.trace("renaming", new Object[0]);
            }
            boolean isRenamed = false;
            if (USE_VCS && (interceptor = FilesystemInterceptorProvider.getDefault().getFilesystemInterceptor(this.getFileSystem())) != null && (renameHandler = interceptor.getRenameHandler(FilesystemInterceptorProvider.toFileProxy(orig.getOwnerFileObject()), newNameExt)) != null) {
                renameHandler.handle();
                isRenamed = true;
            }
            if (!isRenamed && !(ret = ProcessUtils.executeInDir((String)this.getPath(), (ExecutionEnvironment)this.getExecutionEnvironment(), (String)"mv", (String[])new String[]{nameExt2Rename, newNameExt})).isOK()) {
                throw new IOException(ret.error);
            }
            if (trace) {
                this.trace("synchronizing", new Object[0]);
            }
            Exception problem = null;
            Map<Object, Object> newEntries = Collections.emptyMap();
            try {
                newEntries = this.readEntries(storage, true, newNameExt);
            }
            catch (FileNotFoundException ex) {
                throw ex;
            }
            catch (IOException ex) {
                problem = ex;
            }
            catch (ExecutionException ex) {
                problem = ex;
            }
            if (problem != null) {
                if (!ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment())) {
                    this.getFileSystem().addPendingFile(this);
                    throw new ConnectException(problem.getMessage());
                }
                boolean fileNotFoundException = RemoteFileSystemUtils.isFileNotFoundException(problem);
                if (fileNotFoundException) {
                    this.invalidate();
                    Object object = this.refLock;
                    synchronized (object) {
                        this.storageRef = new SoftReference<DirectoryStorage>(DirectoryStorage.EMPTY);
                    }
                }
                if (!fileNotFoundException) {
                    if (problem instanceof IOException) {
                        throw (IOException)problem;
                    }
                    if (problem instanceof ExecutionException) {
                        throw (ExecutionException)problem;
                    }
                    throw new IllegalStateException("Unexpected exception class: " + problem.getClass().getName(), problem);
                }
            }
            this.getFileSystem().incrementDirSyncCount();
            HashMap<String, List<DirEntry>> dupLowerNames = new HashMap<String, List<DirEntry>>();
            boolean hasDups = false;
            boolean changed = true;
            HashSet<DirEntry> keepCacheNames = new HashSet<DirEntry>();
            ArrayList<DirEntry> entriesToFireChanged = new ArrayList<DirEntry>();
            ArrayList<DirEntry> entriesToFireCreated = new ArrayList<DirEntry>();
            ArrayList<RemoteFileObject> filesToFireDeleted = new ArrayList<RemoteFileObject>();
            for (DirEntry dirEntry : newEntries.values()) {
                if (dirEntry.isValid()) {
                    String lowerCacheName;
                    ArrayList<DirEntry> dupEntries;
                    String cacheName;
                    DirEntry oldEntry = storage.getValidEntry(dirEntry.getName());
                    if (oldEntry == null) {
                        cacheName = RemoteFileSystemUtils.escapeFileName(dirEntry.getName());
                        if (dirEntry.getName().equals(newNameExt)) {
                            DirEntry renamedEntry = storage.getValidEntry(nameExt2Rename);
                            RemoteLogger.assertTrueInConsole(renamedEntry != null, "original DirEntry is absent for " + path2Rename + " in " + this, new Object[0]);
                            if (renamedEntry != null) {
                                cacheName = renamedEntry.getCache();
                                dirEntry.setCache(cacheName);
                                keepCacheNames.add(dirEntry);
                            }
                        } else {
                            entriesToFireCreated.add(dirEntry);
                        }
                    } else if (oldEntry.isSameType(dirEntry)) {
                        cacheName = oldEntry.getCache();
                        keepCacheNames.add(dirEntry);
                        boolean fire = false;
                        if ((!dirEntry.isSameLastModified(oldEntry) || dirEntry.getSize() != oldEntry.getSize()) && dirEntry.isPlainFile()) {
                            fire = true;
                            changed = true;
                            File entryCache = new File(this.getCache(), oldEntry.getCache());
                            if (entryCache.exists()) {
                                if (trace) {
                                    this.trace("removing cache for updated file {0}", entryCache.getAbsolutePath());
                                }
                                entryCache.delete();
                            }
                        }
                        if (!RemoteDirectory.equals(dirEntry.getLinkTarget(), oldEntry.getLinkTarget())) {
                            fire = true;
                            changed = true;
                            this.getFileSystem().getFactory().setLink(this, this.getPath() + '/' + dirEntry.getName(), dirEntry.getLinkTarget());
                        }
                        if (!dirEntry.getAccessAsString().equals(oldEntry.getAccessAsString())) {
                            fire = true;
                            changed = true;
                        }
                        if (!dirEntry.isSameUser(oldEntry)) {
                            fire = true;
                            changed = true;
                        }
                        if (!dirEntry.isSameGroup(oldEntry)) {
                            fire = true;
                            changed = true;
                        }
                        if (!dirEntry.isDirectory() && dirEntry.getSize() != oldEntry.getSize()) {
                            fire = true;
                            changed = true;
                        }
                        if (fire) {
                            entriesToFireChanged.add(dirEntry);
                        }
                    } else {
                        changed = true;
                        this.getFileSystem().getFactory().changeImplementor(this, oldEntry, dirEntry);
                        entriesToFireChanged.add(dirEntry);
                        cacheName = null;
                    }
                    if (cacheName != null) {
                        dirEntry.setCache(cacheName);
                    }
                    if ((dupEntries = (ArrayList<DirEntry>)dupLowerNames.get(lowerCacheName = RemoteFileSystemUtils.isSystemCaseSensitive() ? dirEntry.getCache() : dirEntry.getCache().toLowerCase())) == null) {
                        dupEntries = new ArrayList<DirEntry>();
                        dupLowerNames.put(lowerCacheName, dupEntries);
                    } else {
                        hasDups = true;
                    }
                    dupEntries.add(dirEntry);
                    continue;
                }
                changed = true;
            }
            if (changed) {
                for (DirEntry dirEntry : storage.listValid()) {
                    RemoteFileObject removedFO;
                    DirEntry newEntry;
                    if (dirEntry.getName().equals(nameExt2Rename) || (newEntry = (DirEntry)newEntries.get(dirEntry.getName())) != null && newEntry.isValid() || (removedFO = this.invalidate(dirEntry)) == null) continue;
                    filesToFireDeleted.add(removedFO);
                }
                if (hasDups) {
                    for (Map.Entry entry : new ArrayList(dupLowerNames.entrySet())) {
                        List dupEntries = (List)entry.getValue();
                        if (dupEntries.size() <= 1) continue;
                        block16: for (int i = 0; i < dupEntries.size(); ++i) {
                            DirEntry entry2 = (DirEntry)dupEntries.get(i);
                            if (keepCacheNames.contains(entry2)) continue;
                            for (int j = 0; j < Integer.MAX_VALUE; ++j) {
                                String cacheName = (String)entry.getKey() + '_' + j;
                                String lowerCacheName = cacheName.toLowerCase();
                                if (dupLowerNames.containsKey(lowerCacheName)) continue;
                                if (trace) {
                                    this.trace("resolving cache names conflict in {0}: {1} -> {2}", this.getCache().getAbsolutePath(), entry2.getCache(), cacheName);
                                }
                                entry2.setCache(cacheName);
                                dupLowerNames.put(lowerCacheName, Collections.singletonList(entry2));
                                continue block16;
                            }
                        }
                    }
                }
                storage = new DirectoryStorage(this.getStorageFile(), newEntries.values());
                storage.store();
            } else {
                storage.touch();
            }
            Iterator i$ = this.refLock;
            synchronized (i$) {
                this.storageRef = new SoftReference<DirectoryStorage>(storage);
            }
            if (changed) {
                RemoteFileObjectBase fo;
                this.dropMagic();
                for (RemoteFileObject remoteFileObject : filesToFireDeleted) {
                    this.fireFileDeletedEvent(this.getListeners(), new FileEvent((FileObject)this.getOwnerFileObject(), (FileObject)remoteFileObject));
                }
                for (DirEntry dirEntry : entriesToFireCreated) {
                    fo = this.getFileSystem().getFactory().createFileObject(this, dirEntry);
                    this.fireRemoteFileObjectCreated(fo.getOwnerFileObject());
                }
                for (DirEntry dirEntry : entriesToFireChanged) {
                    fo = this.getFileSystem().getFactory().getCachedFileObject(this.getPath() + '/' + dirEntry.getName());
                    if (fo == null) continue;
                    this.fireFileChangedEvent(this.getListeners(), new FileEvent((FileObject)fo.getOwnerFileObject()));
                }
                String newPath = this.getPath() + '/' + newNameExt;
                this.getFileSystem().getFactory().rename(path2Rename, newPath, directChild2Rename);
                this.fireFileRenamedEvent(directChild2Rename.getListeners(), new FileRenameEvent((FileObject)directChild2Rename.getOwnerFileObject(), (FileObject)directChild2Rename.getOwnerFileObject(), name2Rename, ext2Rename));
                this.fireFileRenamedEvent(this.getListeners(), new FileRenameEvent((FileObject)this.getOwnerFileObject(), (FileObject)directChild2Rename.getOwnerFileObject(), name2Rename, ext2Rename));
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStat(RemotePlainFile fo, FileInfoProvider.StatInfo statInfo) {
        block10: {
            RemoteLogger.assertTrue(fo.getNameExt().equals(statInfo.getName()));
            RemoteLogger.assertFalse(statInfo.isDirectory());
            RemoteLogger.assertFalse(statInfo.isLink());
            Lock writeLock = RemoteFileSystem.getLock(this.getCache()).writeLock();
            if (trace) {
                this.trace("waiting for lock", new Object[0]);
            }
            writeLock.lock();
            try {
                DirectoryStorage storage = this.getExistingDirectoryStorage();
                if (storage == DirectoryStorage.EMPTY) {
                    Exceptions.printStackTrace((Throwable)new IllegalStateException("Update stat is called but remote directory cache does not exist"));
                    break block10;
                }
                List<DirEntry> entries = storage.listValid(fo.getNameExt());
                DirEntrySftp entry = new DirEntrySftp(statInfo, fo.getCache().getName());
                entries.add(entry);
                DirectoryStorage newStorage = new DirectoryStorage(this.getStorageFile(), entries);
                try {
                    newStorage.store();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                Object object = this.refLock;
                synchronized (object) {
                    this.storageRef = new SoftReference<DirectoryStorage>(newStorage);
                }
                fo.setPendingRemoteDelivery(false);
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private DirectoryStorage getDirectoryStorageImpl(boolean forceRefresh, String expectedName, String childName, boolean expected) throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        DirectoryStorage s;
        boolean fromMemOrDiskCache;
        if (forceRefresh && !ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment())) {
            throw new ConnectException();
        }
        DirectoryStorage storage = null;
        File storageFile = this.getStorageFile();
        Object object = this.refLock;
        // MONITORENTER : object
        storage = this.storageRef.get();
        // MONITOREXIT : object
        if (storage == null) {
            fromMemOrDiskCache = false;
            storage = DirectoryStorage.EMPTY;
            if (storageFile.exists()) {
                Lock readLock = RemoteFileSystem.getLock(this.getCache()).readLock();
                try {
                    readLock.lock();
                    try {
                        storage = DirectoryStorage.load(storageFile);
                        fromMemOrDiskCache = true;
                        Object object2 = this.refLock;
                        // MONITORENTER : object2
                        s = this.storageRef.get();
                        if (s != null) {
                            if (trace) {
                                this.trace("using storage that was kept by other thread", new Object[0]);
                            }
                            storage = s;
                        } else {
                            this.storageRef = new SoftReference<DirectoryStorage>(storage);
                        }
                        // MONITOREXIT : object2
                    }
                    catch (FormatException e) {
                        Level level = e.isExpected() ? Level.FINE : Level.WARNING;
                        RemoteLogger.getInstance().log(level, "Error reading directory cache", e);
                        storageFile.delete();
                    }
                    catch (InterruptedIOException e) {
                        throw e;
                    }
                    catch (FileNotFoundException e) {
                        RemoteLogger.finest(e, (Object)this);
                    }
                    catch (IOException e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                }
                finally {
                    readLock.unlock();
                }
            }
        } else {
            if (trace) {
                this.trace("use memory cached storage", new Object[0]);
            }
            fromMemOrDiskCache = true;
        }
        if (fromMemOrDiskCache && !forceRefresh && this.isAlreadyKnownChild(storage, childName)) {
            RemoteLogger.assertTrue(storage != null);
            if (!trace) return storage;
            this.trace("returning cached storage", new Object[0]);
            return storage;
        }
        this.checkConnection(this, true);
        Lock writeLock = RemoteFileSystem.getLock(this.getCache()).writeLock();
        if (trace) {
            this.trace("waiting for lock", new Object[0]);
        }
        writeLock.lock();
        try {
            Object fo;
            Iterator i$;
            ArrayList<RemoteFileObject> filesToFireDeleted;
            DirEntry expectedCreated;
            ArrayList<DirEntry> entriesToFireCreated;
            ArrayList<DirEntry> entriesToFireChangedRO;
            ArrayList<DirEntry> entriesToFireChanged;
            boolean changed;
            block85: {
                Map<Object, Object> newEntries;
                block83: {
                    HashSet<DirEntry> keepCacheNames;
                    HashMap<String, List<DirEntry>> dupLowerNames;
                    block84: {
                        block82: {
                            Object e = this.refLock;
                            // MONITORENTER : e
                            s = this.storageRef.get();
                            if (s != null) {
                                if (trace) {
                                    this.trace("got storage from mem cache after waiting on writeLock: {0} expectedName={1}", this.getPath(), expectedName);
                                }
                                if (!forceRefresh && this.isAlreadyKnownChild(s, childName)) {
                                    DirectoryStorage directoryStorage = s;
                                    // MONITOREXIT : e
                                    return directoryStorage;
                                }
                                storage = s;
                            }
                            // MONITOREXIT : e
                            if (!this.getCache().exists()) {
                                this.getCache().mkdirs();
                                if (!this.getCache().exists()) {
                                    throw new IOException("Can not create cache directory " + this.getCache());
                                }
                            }
                            if (trace) {
                                this.trace("synchronizing", new Object[0]);
                            }
                            Exception problem = null;
                            newEntries = Collections.emptyMap();
                            try {
                                newEntries = this.readEntries(storage, forceRefresh, childName);
                            }
                            catch (FileNotFoundException ex) {
                                throw ex;
                            }
                            catch (IOException ex) {
                                problem = ex;
                            }
                            catch (ExecutionException ex) {
                                problem = ex;
                            }
                            if (problem != null) {
                                if (!ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment())) {
                                    this.getFileSystem().addPendingFile(this);
                                    throw new ConnectException(problem.getMessage());
                                }
                                boolean fileNotFoundException = RemoteFileSystemUtils.isFileNotFoundException(problem);
                                if (fileNotFoundException) {
                                    Object object3 = this.refLock;
                                    // MONITORENTER : object3
                                    this.storageRef = new SoftReference<DirectoryStorage>(DirectoryStorage.EMPTY);
                                    // MONITOREXIT : object3
                                }
                                if (!fileNotFoundException) {
                                    if (problem instanceof IOException) {
                                        throw (IOException)problem;
                                    }
                                    if (!(problem instanceof ExecutionException)) throw new IllegalStateException("Unexpected exception class: " + problem.getClass().getName(), problem);
                                    throw (ExecutionException)problem;
                                }
                            }
                            this.getFileSystem().incrementDirSyncCount();
                            dupLowerNames = new HashMap<String, List<DirEntry>>();
                            boolean hasDups = false;
                            changed = newEntries.size() != storage.listAll().size() || storage == DirectoryStorage.EMPTY;
                            keepCacheNames = new HashSet<DirEntry>();
                            entriesToFireChanged = new ArrayList<DirEntry>();
                            entriesToFireChangedRO = new ArrayList<DirEntry>();
                            entriesToFireCreated = new ArrayList<DirEntry>();
                            expectedCreated = null;
                            filesToFireDeleted = new ArrayList<RemoteFileObject>();
                            for (DirEntry dirEntry : newEntries.values()) {
                                if (dirEntry.isValid()) {
                                    String lowerCacheName;
                                    ArrayList<DirEntry> dupEntries;
                                    String cacheName;
                                    DirEntry oldEntry = storage.getValidEntry(dirEntry.getName());
                                    if (oldEntry == null || !oldEntry.isValid()) {
                                        changed = true;
                                        cacheName = RemoteFileSystemUtils.escapeFileName(dirEntry.getName());
                                        if (fromMemOrDiskCache || dirEntry.getName().equals(expectedName) || this.getFlag((byte)8)) {
                                            entriesToFireCreated.add(dirEntry);
                                            expectedCreated = dirEntry;
                                        }
                                    } else if (oldEntry.isSameType(dirEntry)) {
                                        cacheName = oldEntry.getCache();
                                        keepCacheNames.add(dirEntry);
                                        boolean fire = false;
                                        if ((!dirEntry.isSameLastModified(oldEntry) || dirEntry.getSize() != oldEntry.getSize()) && dirEntry.isPlainFile()) {
                                            fire = true;
                                            changed = true;
                                            File entryCache = new File(this.getCache(), oldEntry.getCache());
                                            if (entryCache.exists()) {
                                                if (trace) {
                                                    this.trace("removing cache for updated file {0}", entryCache.getAbsolutePath());
                                                }
                                                entryCache.delete();
                                            }
                                        }
                                        if (!RemoteDirectory.equals(dirEntry.getLinkTarget(), oldEntry.getLinkTarget())) {
                                            fire = true;
                                            changed = true;
                                            this.getFileSystem().getFactory().setLink(this, this.getPath() + '/' + dirEntry.getName(), dirEntry.getLinkTarget());
                                        }
                                        if (!dirEntry.getAccessAsString().equals(oldEntry.getAccessAsString())) {
                                            fire = true;
                                            changed = true;
                                        }
                                        if (!dirEntry.isSameUser(oldEntry)) {
                                            fire = true;
                                            changed = true;
                                        }
                                        if (!dirEntry.isSameGroup(oldEntry)) {
                                            fire = true;
                                            changed = true;
                                        }
                                        if (!dirEntry.isDirectory() && dirEntry.getSize() != oldEntry.getSize()) {
                                            fire = true;
                                            changed = true;
                                        }
                                        if (fire) {
                                            entriesToFireChanged.add(dirEntry);
                                        }
                                    } else {
                                        changed = true;
                                        this.getFileSystem().getFactory().changeImplementor(this, oldEntry, dirEntry);
                                        if (oldEntry.isLink() && dirEntry.isPlainFile() && dirEntry.canWrite(this.getExecutionEnvironment())) {
                                            entriesToFireChangedRO.add(dirEntry);
                                        } else {
                                            entriesToFireChanged.add(dirEntry);
                                        }
                                        cacheName = null;
                                    }
                                    if (cacheName != null) {
                                        dirEntry.setCache(cacheName);
                                    }
                                    if ((dupEntries = (ArrayList<DirEntry>)dupLowerNames.get(lowerCacheName = RemoteFileSystemUtils.isSystemCaseSensitive() ? dirEntry.getCache() : dirEntry.getCache().toLowerCase())) == null) {
                                        dupEntries = new ArrayList<DirEntry>();
                                        dupLowerNames.put(lowerCacheName, dupEntries);
                                    } else {
                                        hasDups = true;
                                    }
                                    dupEntries.add(dirEntry);
                                    continue;
                                }
                                if (storage.isKnown(childName)) continue;
                                changed = true;
                            }
                            if (!changed) break block82;
                            for (DirEntry dirEntry : storage.listValid()) {
                                RemoteFileObject removedFO;
                                DirEntry newEntry = (DirEntry)newEntries.get(dirEntry.getName());
                                if (newEntry != null && newEntry.isValid() || (removedFO = this.invalidate(dirEntry)) == null) continue;
                                filesToFireDeleted.add(removedFO);
                            }
                            if (!hasDups) break block83;
                            i$ = new ArrayList(dupLowerNames.entrySet()).iterator();
                            break block84;
                        }
                        storage.touch();
                        break block85;
                    }
                    while (i$.hasNext()) {
                        Map.Entry entry = i$.next();
                        List dupEntries = (List)entry.getValue();
                        if (dupEntries.size() <= 1) continue;
                        block30: for (int i = 0; i < dupEntries.size(); ++i) {
                            DirEntry entry2 = (DirEntry)dupEntries.get(i);
                            if (keepCacheNames.contains(entry2)) continue;
                            for (int j = 0; j < Integer.MAX_VALUE; ++j) {
                                String cacheName = (String)entry.getKey() + '_' + j;
                                String lowerCacheName = cacheName.toLowerCase();
                                if (dupLowerNames.containsKey(lowerCacheName)) continue;
                                if (trace) {
                                    this.trace("resolving cache names conflict in {0}: {1} -> {2}", this.getCache().getAbsolutePath(), entry2.getCache(), cacheName);
                                }
                                entry2.setCache(cacheName);
                                dupLowerNames.put(lowerCacheName, Collections.singletonList(entry2));
                                continue block30;
                            }
                        }
                    }
                }
                storage = new DirectoryStorage(storageFile, newEntries.values());
                storage.store();
            }
            this.setFlag((byte)8, false);
            i$ = this.refLock;
            // MONITORENTER : i$
            this.storageRef = new SoftReference<DirectoryStorage>(storage);
            // MONITOREXIT : i$
            if (!changed) return storage;
            this.dropMagic();
            FilesystemInterceptorProvider.FilesystemInterceptor interceptor = null;
            if (USE_VCS) {
                interceptor = FilesystemInterceptorProvider.getDefault().getFilesystemInterceptor(this.getFileSystem());
            }
            for (RemoteFileObject deleted : filesToFireDeleted) {
                this.fireDeletedEvent(this.getOwnerFileObject(), deleted, interceptor, expected);
            }
            for (DirEntry entry : entriesToFireCreated) {
                fo = this.getFileSystem().getFactory().createFileObject(this, entry).getOwnerFileObject();
                if (interceptor != null && expectedCreated != null && !expectedCreated.equals(entry)) {
                    interceptor.createdExternally(FilesystemInterceptorProvider.toFileProxy((FileObject)fo));
                }
                this.fireRemoteFileObjectCreated((RemoteFileObject)fo);
            }
            for (DirEntry entry : entriesToFireChanged) {
                fo = this.getFileSystem().getFactory().getCachedFileObject(this.getPath() + '/' + entry.getName());
                if (fo == null) continue;
                if (((RemoteFileObjectBase)fo).isPendingRemoteDelivery()) {
                    RemoteLogger.getInstance().log(Level.FINE, "Skipping change event for pending file {0}", fo);
                    continue;
                }
                this.fireFileChangedEvent(this.getListeners(), new FileEvent((FileObject)((RemoteFileObjectBase)fo).getOwnerFileObject(), (FileObject)((RemoteFileObjectBase)fo).getOwnerFileObject(), expected));
            }
            Iterator iterator = entriesToFireChangedRO.iterator();
            while (iterator.hasNext()) {
                DirEntry entry;
                entry = (DirEntry)iterator.next();
                fo = this.getFileSystem().getFactory().getCachedFileObject(this.getPath() + '/' + entry.getName());
                if (fo == null) continue;
                if (((RemoteFileObjectBase)fo).isPendingRemoteDelivery()) {
                    RemoteLogger.getInstance().log(Level.FINE, "Skipping change event for pending file {0}", fo);
                    continue;
                }
                ((RemoteFileObjectBase)fo).fireFileAttributeChangedEvent("DataEditorSupport.read-only.refresh", null, null);
            }
            return storage;
        }
        finally {
            writeLock.unlock();
        }
    }

    private void fireDeletedEvent(RemoteFileObject parent, RemoteFileObject fo, FilesystemInterceptorProvider.FilesystemInterceptor interceptor, boolean expected) {
        if (interceptor != null) {
            interceptor.deletedExternally(FilesystemInterceptorProvider.toFileProxy(fo));
        }
        fo.fireFileDeletedEvent(fo.getImplementor().getListeners(), new FileEvent((FileObject)fo, (FileObject)fo, expected));
        parent.fireFileDeletedEvent(parent.getImplementor().getListeners(), new FileEvent((FileObject)parent, (FileObject)fo, expected));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream _getInputStream(RemotePlainFile child) throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        Lock lock = RemoteFileSystem.getLock(child.getCache()).readLock();
        lock.lock();
        try {
            if (child.getCache().exists()) {
                FileInputStream fileInputStream = new FileInputStream(child.getCache());
                return fileInputStream;
            }
        }
        finally {
            lock.unlock();
        }
        this.checkConnection(child, true);
        DirectoryStorage storage = this.getDirectoryStorage(child.getNameExt());
        return new CachedRemoteInputStream(child, this.getExecutionEnvironment());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureChildSync(RemotePlainFile child) throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        block16: {
            Lock lock = RemoteFileSystem.getLock(child.getCache()).readLock();
            lock.lock();
            try {
                if (child.getCache().exists()) {
                    return;
                }
            }
            finally {
                lock.unlock();
            }
            this.checkConnection(child, true);
            DirectoryStorage storage = this.getDirectoryStorage(child.getNameExt());
            lock = RemoteFileSystem.getLock(child.getCache()).writeLock();
            lock.lock();
            try {
                Future task;
                int rc;
                if (child.getCache().exists()) {
                    return;
                }
                File cacheParentFile = child.getCache().getParentFile();
                if (!cacheParentFile.exists()) {
                    cacheParentFile.mkdirs();
                    if (!cacheParentFile.exists()) {
                        throw new IOException("Unable to create parent firectory " + cacheParentFile.getAbsolutePath());
                    }
                }
                if ((rc = ((Integer)(task = CommonTasksSupport.downloadFile((String)child.getPath(), (ExecutionEnvironment)this.getExecutionEnvironment(), (String)child.getCache().getAbsolutePath(), null)).get()).intValue()) == 0) {
                    this.getFileSystem().incrementFileCopyCount();
                    break block16;
                }
                throw new IOException("Can't copy file " + child.getCache().getAbsolutePath() + " from " + this.getExecutionEnvironment() + ':' + this.getPath() + ": rc=" + rc);
            }
            catch (InterruptedException ex) {
                child.getCache().delete();
                throw ex;
            }
            catch (ExecutionException ex) {
                child.getCache().delete();
                throw ex;
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void checkConnection(RemoteFileObjectBase fo, boolean throwConnectException) throws ConnectException {
        if (!ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment())) {
            this.getFileSystem().addPendingFile(fo);
            if (throwConnectException) {
                throw new ConnectException();
            }
        }
    }

    @Override
    public FileInfoProvider.StatInfo.FileType getType() {
        return FileInfoProvider.StatInfo.FileType.Directory;
    }

    @Override
    public final InputStream getInputStream() throws FileNotFoundException {
        throw new FileNotFoundException(this.getPath());
    }

    public byte[] getMagic(RemoteFileObjectBase file) {
        return this.getMagicCache().get(file.getNameExt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MagicCache getMagicCache() {
        MagicCache magic;
        Object object = this.magicLock;
        synchronized (object) {
            magic = this.magicCache.get();
            if (magic == null) {
                magic = new MagicCache(this);
                this.magicCache = new SoftReference<MagicCache>(magic);
            }
        }
        return magic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropMagic() {
        Object object = this.magicLock;
        synchronized (object) {
            MagicCache magic = this.magicCache.get();
            if (magic != null) {
                magic.clean(null);
            } else {
                new MagicCache(this).clean(null);
            }
        }
    }

    @Override
    protected final OutputStream getOutputStreamImpl(FileLock lock, RemoteFileObjectBase orig) throws IOException {
        throw new IOException(this.getPath());
    }

    private RemoteFileObject invalidate(DirEntry oldEntry) {
        RemoteFileObject fo = this.getFileSystem().getFactory().invalidate(this.getPath() + '/' + oldEntry.getName());
        File oldEntryCache = new File(this.getCache(), oldEntry.getCache());
        this.removeFile(oldEntryCache);
        return fo;
    }

    private void removeFile(File cache) {
        if (cache.isDirectory()) {
            for (File child : cache.listFiles()) {
                this.removeFile(child);
            }
        }
        cache.delete();
    }

    private static void setStorageTimestamp(File cache, final long timestamp, boolean recursive) {
        cache.setLastModified(timestamp);
        if (recursive && cache.exists()) {
            cache.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    if (pathname.isDirectory()) {
                        File childCache = new File(pathname, ".rfs_cache");
                        RemoteDirectory.setStorageTimestamp(childCache, timestamp, true);
                    }
                    return false;
                }
            });
        }
    }

    @Override
    protected void refreshImpl(boolean recursive, Set<String> antiLoop, boolean expected) throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        DirectoryStorage storage;
        if (antiLoop != null) {
            if (antiLoop.contains(this.getPath())) {
                return;
            }
            antiLoop.add(this.getPath());
        }
        if ((storage = this.getExistingDirectoryStorage()) == null || storage == DirectoryStorage.EMPTY) {
            return;
        }
        DirectoryStorage refreshedStorage = this.refreshDirectoryStorage(null, expected);
        if (recursive) {
            for (RemoteFileObjectBase child : this.getExistentChildren(refreshedStorage)) {
                child.refreshImpl(true, antiLoop, expected);
            }
        }
    }

    private void trace(String message, Object ... args) {
        if (trace) {
            message = "SYNC [" + this.getPath() + "][" + System.identityHashCode(this) + "][" + Thread.currentThread().getId() + "]: " + message;
            RemoteLogger.getInstance().log(Level.FINEST, message, args);
        }
    }

    private static boolean equals(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    private DirEntry getChildEntry(RemoteFileObjectBase child) {
        try {
            DirectoryStorage directoryStorage = this.getDirectoryStorage(child.getNameExt());
            if (directoryStorage != null) {
                DirEntry entry = directoryStorage.getValidEntry(child.getNameExt());
                if (entry != null) {
                    return entry;
                }
                RemoteLogger.getInstance().log(Level.INFO, "Not found entry for file {0}", child);
            }
        }
        catch (ConnectException ex) {
            RemoteLogger.finest(ex, (Object)this);
        }
        catch (IOException ex) {
            RemoteLogger.finest(ex, (Object)this);
        }
        catch (ExecutionException ex) {
            RemoteLogger.finest(ex, (Object)this);
        }
        catch (InterruptedException ex) {
            RemoteLogger.finest(ex, (Object)this);
        }
        catch (CancellationException ex) {
            RemoteLogger.finest(ex, (Object)this);
        }
        return null;
    }

    long getSize(RemoteFileObjectBase child) {
        DirEntry childEntry = this.getChildEntry(child);
        if (childEntry != null) {
            return childEntry.getSize();
        }
        return 0L;
    }

    Date lastModified(RemoteFileObjectBase child) {
        DirEntry childEntry = this.getChildEntry(child);
        if (childEntry != null) {
            return childEntry.getLastModified();
        }
        return new Date(0L);
    }

    DirectoryStorage testGetExistingDirectoryStorage() {
        return this.getExistingDirectoryStorage();
    }

    private File getStorageFile() {
        return new File(this.getCache(), ".rfs_cache");
    }

    private static final class MagicLock {
        private MagicLock() {
        }
    }

    private static final class RefLock {
        private RefLock() {
        }
    }
}

