/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectFactory;
import org.openide.util.RequestProcessor;

public class RefreshManager {
    private final ExecutionEnvironment env;
    private final RemoteFileObjectFactory factory;
    private final RequestProcessor.Task updateTask;
    private final LinkedList<RemoteFileObjectBase> queue = new LinkedList();
    private final Set<RemoteFileObjectBase> set = new HashSet<RemoteFileObjectBase>();
    private final Object queueLock = new Object();
    private static final boolean REFRESH_ON_FOCUS = RefreshManager.getBoolean("cnd.remote.refresh.on.focus", true);
    public static final boolean REFRESH_ON_CONNECT = RefreshManager.getBoolean("cnd.remote.refresh.on.connect", true);

    private boolean permissionDenied(ExecutionException e) {
        for (Throwable ex = e; ex != null; ex = ex.getCause()) {
            if (!(ex instanceof FileInfoProvider.SftpIOException)) continue;
            switch (((FileInfoProvider.SftpIOException)ex).getId()) {
                case 3: {
                    return true;
                }
            }
            break;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        Object object = this.queueLock;
        synchronized (object) {
            this.queue.clear();
            this.set.clear();
        }
    }

    public RefreshManager(ExecutionEnvironment env, RemoteFileObjectFactory factory) {
        this.env = env;
        this.factory = factory;
        this.updateTask = new RequestProcessor("Remote File System RefreshManager " + env.getDisplayName(), 1).create((Runnable)new RefreshWorker(false));
    }

    public void scheduleRefreshOnFocusGained(Collection<RemoteFileObjectBase> fileObjects) {
        if (REFRESH_ON_FOCUS) {
            RemoteLogger.getInstance().log(Level.FINE, "Refresh on focus gained schedulled for {0} directories on {1}", new Object[]{fileObjects.size(), this.env});
            this.scheduleRefreshImpl(this.filterDirectories(fileObjects), false);
        }
    }

    public void scheduleRefreshOnConnect(Collection<RemoteFileObjectBase> fileObjects) {
        if (REFRESH_ON_CONNECT) {
            RemoteLogger.getInstance().log(Level.FINE, "Refresh on connect schedulled for {0} directories on {1}", new Object[]{fileObjects.size(), this.env});
            this.scheduleRefreshImpl(this.filterDirectories(fileObjects), false);
        }
    }

    private Collection<RemoteFileObjectBase> filterDirectories(Collection<RemoteFileObjectBase> fileObjects) {
        TreeSet<RemoteFileObjectBase> result = new TreeSet<RemoteFileObjectBase>(new PathComparator(true));
        for (RemoteFileObjectBase fo : fileObjects) {
            if (!RefreshManager.isDirectory(fo)) continue;
            result.add(fo);
        }
        return result;
    }

    private static boolean isDirectory(RemoteFileObjectBase fo) {
        return fo != null && fo instanceof RemoteDirectory;
    }

    public void scheduleRefreshExistent(Collection<String> paths) {
        ArrayList<RemoteFileObjectBase> fileObjects = new ArrayList<RemoteFileObjectBase>(paths.size());
        for (String path : paths) {
            RemoteFileObjectBase fo = this.factory.getCachedFileObject(path);
            if (fo == null) continue;
            fileObjects.add(fo);
        }
        this.scheduleRefresh(fileObjects, true);
    }

    public void scheduleRefresh(Collection<RemoteFileObjectBase> fileObjects, boolean addExistingChildren) {
        if (addExistingChildren) {
            TreeSet<RemoteFileObjectBase> toRefresh = new TreeSet<RemoteFileObjectBase>(new PathComparator(false));
            for (RemoteFileObjectBase fo : fileObjects) {
                this.addExistingChildren(fo, toRefresh);
            }
            this.scheduleRefreshImpl(toRefresh, true);
        } else {
            this.scheduleRefreshImpl(fileObjects, true);
        }
    }

    private void addExistingChildren(RemoteFileObjectBase fo, Collection<RemoteFileObjectBase> bag) {
        if (RefreshManager.isDirectory(fo)) {
            bag.add(fo);
            for (RemoteFileObjectBase child : fo.getExistentChildren()) {
                this.addExistingChildren(child, bag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRefreshImpl(Collection<RemoteFileObjectBase> fileObjects, boolean toTheHead) {
        if (!ConnectionManager.getInstance().isConnectedTo(this.env)) {
            RemoteLogger.getInstance().warning("scheduleRefresh(Collection<FileObject>) is called while host is not connected");
        }
        Object object = this.queueLock;
        synchronized (object) {
            for (RemoteFileObjectBase fo : fileObjects) {
                if (this.set.contains(fo)) {
                    this.queue.remove(fo);
                } else {
                    this.set.add(fo);
                }
                this.queue.add(toTheHead ? 0 : this.queue.size(), fo);
            }
        }
        this.updateTask.schedule(0);
    }

    private static boolean getBoolean(String name, boolean result) {
        String text = System.getProperty(name);
        if (text != null) {
            result = Boolean.parseBoolean(text);
        }
        return result;
    }

    void testWaitLastRefreshFinished() {
        this.updateTask.waitFinished();
    }

    private static class PathComparator
    implements Comparator<RemoteFileObjectBase> {
        private final boolean childrenFirst;

        public PathComparator(boolean childrenFirst) {
            this.childrenFirst = childrenFirst;
        }

        @Override
        public int compare(RemoteFileObjectBase o1, RemoteFileObjectBase o2) {
            int result = o1.getPath().compareTo(o2.getPath());
            return this.childrenFirst ? -result : result;
        }
    }

    private final class RefreshWorker
    implements Runnable {
        private final boolean expected;

        private RefreshWorker(boolean expected) {
            this.expected = expected;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long time = System.currentTimeMillis();
            int cnt = 0;
            while (true) {
                RemoteFileObjectBase fo;
                Object object = RefreshManager.this.queueLock;
                synchronized (object) {
                    fo = (RemoteFileObjectBase)RefreshManager.this.queue.poll();
                    if (fo == null) {
                        break;
                    }
                    ++cnt;
                    RefreshManager.this.set.remove(fo);
                }
                try {
                    fo.refreshImpl(false, null, this.expected);
                    continue;
                }
                catch (ConnectException ex) {
                    RefreshManager.this.clear();
                }
                catch (InterruptedException ex) {
                    RemoteLogger.finest(ex, (Object)fo);
                }
                catch (CancellationException ex) {
                    RemoteLogger.finest(ex, (Object)fo);
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                    continue;
                }
                catch (ExecutionException ex) {
                    if (RefreshManager.this.permissionDenied(ex)) continue;
                    System.err.println("Exception on file " + fo.getPath());
                    ex.printStackTrace(System.err);
                    continue;
                }
                break;
            }
            time = System.currentTimeMillis() - time;
            RemoteLogger.getInstance().log(Level.FINE, "RefreshManager: refreshing {0} directories took {1} ms on {2}", new Object[]{cnt, time, RefreshManager.this.env});
        }
    }
}

