/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fileoperations.spi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.api.extexecution.ProcessBuilder;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.remote.impl.fs.RemoteFileObject;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemManager;
import org.netbeans.spi.extexecution.ProcessBuilderFactory;
import org.netbeans.spi.extexecution.ProcessBuilderImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public abstract class FileOperationsProvider {
    public static final String ATTRIBUTE = "FileProxyOperations";
    private static final int LINK_DEPTH = 5;
    private static FileOperationsProvider defaultProvider;

    protected FileOperationsProvider() {
    }

    public abstract FileOperations getFileOperations(FileSystem var1);

    public static FileProxyO toFileProxy(String path) {
        return new FileProxyOImpl(path);
    }

    public static FileOperationsProvider getDefault() {
        if (defaultProvider != null) {
            return defaultProvider;
        }
        defaultProvider = (FileOperationsProvider)Lookup.getDefault().lookup(FileOperationsProvider.class);
        return defaultProvider;
    }

    private static final class FileProxyOImpl
    implements FileProxyO {
        private final String path;

        private FileProxyOImpl(String path) {
            this.path = path;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        public String toString() {
            return this.path;
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileProxyOImpl other = (FileProxyOImpl)obj;
            return !(this.path == null ? other.path != null : !this.path.equals(other.path));
        }
    }

    public static interface FileProxyO {
        public String getPath();
    }

    private static final class ProcessBuilderImplementationImpl
    implements ProcessBuilderImplementation {
        private final ExecutionEnvironment env;

        private ProcessBuilderImplementationImpl(ExecutionEnvironment env) {
            this.env = env;
        }

        public Process createProcess(String executable, String workingDirectory, List<String> arguments, List<String> paths, Map<String, String> environment, boolean redirectErrorStream) throws IOException {
            NativeProcessBuilder pb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.env);
            pb.setExecutable(executable).setWorkingDirectory(workingDirectory).setArguments(arguments.toArray(new String[arguments.size()]));
            MacroMap mm = MacroMap.forExecEnv((ExecutionEnvironment)this.env);
            mm.putAll(environment);
            pb.getEnvironment().putAll(mm);
            for (String path : paths) {
                pb.getEnvironment().appendPathVariable("PATH", path);
            }
            if (redirectErrorStream) {
                pb.redirectError();
            }
            return pb.call();
        }

        public String toString() {
            return this.env.getDisplayName();
        }
    }

    public static abstract class FileOperations {
        private final ExecutionEnvironment env;
        private final RemoteFileSystem fileSystem;
        private final RequestProcessor RP;
        private static final boolean USE_CACHE;

        protected FileOperations(FileSystem fs) {
            FileObject root = fs.getRoot();
            if (!(root instanceof RemoteFileObject)) {
                throw new IllegalArgumentException();
            }
            this.env = ((RemoteFileObject)root).getExecutionEnvironment();
            this.fileSystem = (RemoteFileSystem)fs;
            this.RP = new RequestProcessor("Refresh for " + this.env);
        }

        protected String getName(FileProxyO file) {
            return PathUtilities.getBaseName((String)file.getPath());
        }

        protected String getDir(FileProxyO file) {
            return PathUtilities.getDirName((String)file.getPath());
        }

        protected String normalizeUnixPath(FileProxyO file) {
            String path = PathUtilities.normalizeUnixPath((String)file.getPath());
            if (path.isEmpty() && file.getPath().startsWith("/") || path.equals("/..")) {
                return "/";
            }
            return path;
        }

        protected boolean isDirectory(FileProxyO file) {
            Boolean res;
            if (USE_CACHE && (res = this.fileSystem.vcsSafeIsDirectory(file.getPath())) != null) {
                return res;
            }
            return this.isDirectory(file, 5);
        }

        private boolean isDirectory(FileProxyO file, int deep) {
            if (!ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment())) {
                return false;
            }
            if (deep > 0) {
                --deep;
                Future stat = FileInfoProvider.stat((ExecutionEnvironment)this.getExecutionEnvironment(), (String)file.getPath());
                try {
                    FileInfoProvider.StatInfo statInfo = (FileInfoProvider.StatInfo)stat.get();
                    switch (statInfo.getFileType()) {
                        case Directory: {
                            return true;
                        }
                        case SymbolicLink: {
                            String linkTarget = statInfo.getLinkTarget();
                            if (linkTarget.startsWith("/")) {
                                return this.isDirectory(FileOperationsProvider.toFileProxy(linkTarget), deep);
                            }
                            String path = PathUtilities.getDirName((String)file.getPath()) + "/" + linkTarget;
                            path = PathUtilities.normalizeUnixPath((String)path);
                            return this.isDirectory(FileOperationsProvider.toFileProxy(path), deep);
                        }
                    }
                    return false;
                }
                catch (InterruptedException ex) {
                }
                catch (ExecutionException ex) {
                    if (this.notExist(ex)) {
                        return false;
                    }
                    ex.printStackTrace(System.err);
                }
            }
            return false;
        }

        protected boolean isFile(FileProxyO file) {
            Boolean res;
            if (USE_CACHE && (res = this.fileSystem.vcsSafeIsFile(file.getPath())) != null) {
                return res;
            }
            return this.isFile(file, 5);
        }

        private boolean isFile(FileProxyO file, int deep) {
            if (!ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment())) {
                return false;
            }
            if (deep > 0) {
                --deep;
                Future stat = FileInfoProvider.stat((ExecutionEnvironment)this.getExecutionEnvironment(), (String)file.getPath());
                try {
                    FileInfoProvider.StatInfo statInfo = (FileInfoProvider.StatInfo)stat.get();
                    switch (statInfo.getFileType()) {
                        case Regular: {
                            return true;
                        }
                        case SymbolicLink: {
                            String linkTarget = statInfo.getLinkTarget();
                            if (linkTarget.startsWith("/")) {
                                return this.isFile(FileOperationsProvider.toFileProxy(linkTarget), deep);
                            }
                            String path = PathUtilities.getDirName((String)file.getPath()) + "/" + linkTarget;
                            path = PathUtilities.normalizeUnixPath((String)path);
                            return this.isFile(FileOperationsProvider.toFileProxy(path), deep);
                        }
                    }
                    return false;
                }
                catch (InterruptedException ex) {
                }
                catch (ExecutionException ex) {
                    if (this.notExist(ex)) {
                        return false;
                    }
                    ex.printStackTrace(System.err);
                }
            }
            return false;
        }

        private boolean notExist(ExecutionException e) {
            for (Throwable ex = e; ex != null; ex = ex.getCause()) {
                if (!(ex instanceof FileInfoProvider.SftpIOException)) continue;
                switch (((FileInfoProvider.SftpIOException)ex).getId()) {
                    case 2: 
                    case 3: {
                        return true;
                    }
                }
                break;
            }
            return false;
        }

        protected boolean canWrite(FileProxyO file) {
            return this.canWrite(file, 5);
        }

        private boolean canWrite(FileProxyO file, int deep) {
            if (!ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment())) {
                return false;
            }
            if (deep > 0) {
                --deep;
                Future stat = FileInfoProvider.stat((ExecutionEnvironment)this.getExecutionEnvironment(), (String)file.getPath());
                try {
                    FileInfoProvider.StatInfo statInfo = (FileInfoProvider.StatInfo)stat.get();
                    switch (statInfo.getFileType()) {
                        case SymbolicLink: {
                            String linkTarget = statInfo.getLinkTarget();
                            if (linkTarget.startsWith("/")) {
                                return this.canWrite(FileOperationsProvider.toFileProxy(linkTarget), deep);
                            }
                            String path = PathUtilities.getDirName((String)file.getPath()) + "/" + linkTarget;
                            path = PathUtilities.normalizeUnixPath((String)path);
                            return this.canWrite(FileOperationsProvider.toFileProxy(path), deep);
                        }
                    }
                    return statInfo.canWrite(this.env);
                }
                catch (InterruptedException ex) {
                }
                catch (ExecutionException ex) {
                    if (this.notExist(ex)) {
                        return false;
                    }
                    ex.printStackTrace(System.err);
                }
            }
            return false;
        }

        protected FileObject getRoot() {
            RemoteFileSystem fs = RemoteFileSystemManager.getInstance().getFileSystem(this.env);
            return fs.getRoot();
        }

        protected String getPath(FileProxyO file) {
            return file.getPath();
        }

        protected boolean exists(FileProxyO file) {
            Boolean res;
            if (USE_CACHE && (res = this.fileSystem.vcsSafeExists(file.getPath())) != null) {
                return res;
            }
            if (!ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment())) {
                return false;
            }
            Future stat = FileInfoProvider.stat((ExecutionEnvironment)this.getExecutionEnvironment(), (String)file.getPath());
            try {
                FileInfoProvider.StatInfo statInfo = (FileInfoProvider.StatInfo)stat.get();
                return statInfo != null;
            }
            catch (InterruptedException ex) {
            }
            catch (ExecutionException ex) {
                if (this.notExist(ex)) {
                    return false;
                }
                System.err.println("Exception on file " + file.getPath());
                ex.printStackTrace(System.err);
            }
            return false;
        }

        protected FileObject toFileObject(FileProxyO path) {
            FileObject root = this.getRoot();
            return root.getFileObject(path.getPath());
        }

        protected String[] list(FileProxyO file) {
            if (this.isDirectory(file)) {
                Future stat = FileInfoProvider.ls((ExecutionEnvironment)this.env, (String)file.getPath());
                try {
                    FileInfoProvider.StatInfo[] statInfo = (FileInfoProvider.StatInfo[])stat.get();
                    if (statInfo != null) {
                        String[] res = new String[statInfo.length];
                        for (int i = 0; i < statInfo.length; ++i) {
                            res[i] = statInfo[i].getName();
                        }
                        return res;
                    }
                }
                catch (InterruptedException ex) {
                }
                catch (ExecutionException ex) {
                    if (this.notExist(ex)) {
                        return null;
                    }
                    ex.printStackTrace(System.err);
                }
            }
            return null;
        }

        protected ProcessBuilder createProcessBuilder(FileProxyO file) {
            return ProcessBuilderFactory.createProcessBuilder((ProcessBuilderImplementation)new ProcessBuilderImplementationImpl(this.env), (String)"RFS Process Builder");
        }

        protected void refreshFor(FileProxyO ... files) {
            ArrayList<RemoteFileObjectBase> roots = new ArrayList<RemoteFileObjectBase>();
            for (FileProxyO f : files) {
                RemoteFileObjectBase fo = this.findExistingParent(f.getPath());
                if (fo == null) continue;
                roots.add(fo);
            }
            for (RemoteFileObjectBase fo : roots) {
                if (!fo.isValid()) continue;
                fo.refresh(true);
            }
        }

        private RemoteFileObjectBase findExistingParent(String path) {
            do {
                RemoteFileObject fo;
                if ((fo = RemoteFileSystemManager.getInstance().getFileSystem(this.env).findResource(path)) == null) continue;
                return fo.getImplementor();
            } while ((path = PathUtilities.getDirName((String)path)) != null);
            return null;
        }

        private ExecutionEnvironment getExecutionEnvironment() {
            return this.env;
        }

        public String toString() {
            return this.env.getDisplayName();
        }

        public int hashCode() {
            int hash = 7;
            hash = 17 * hash + (this.env != null ? this.env.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileOperations other = (FileOperations)obj;
            return this.env == other.env || this.env != null && this.env.equals(other.env);
        }

        static {
            String text = System.getProperty("rfs.vcs.cache");
            USE_CACHE = text == null ? true : Boolean.parseBoolean(text);
        }
    }
}

