/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl;

import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class RemoteLogger {
    private static final Logger instance = Logger.getLogger("remote.support.logger");
    private static boolean assertionsEnabled = false;
    private static final boolean THROW_ASSERTIONS = Boolean.getBoolean("remote.throw.assertions");
    private static volatile AssertionError lastAssertion;

    public static AssertionError getLastAssertion() {
        return lastAssertion;
    }

    public static boolean isDebugMode() {
        return assertionsEnabled;
    }

    private RemoteLogger() {
    }

    public static Logger getInstance() {
        return instance;
    }

    public static void assertTrueInConsole(boolean value, String message, Object ... params) {
        if (assertionsEnabled && !value) {
            instance.log(Level.INFO, RemoteLogger.format(message, params));
        }
    }

    public static void assertTrue(boolean value) {
        RemoteLogger.assertTrue(value, "AssertionError", new Object[0]);
    }

    public static void assertTrue(boolean value, String message, Object ... params) {
        if (assertionsEnabled && !value) {
            message = RemoteLogger.format(message, params);
            lastAssertion = new AssertionError((Object)message);
            if (THROW_ASSERTIONS) {
                throw lastAssertion;
            }
            instance.log(Level.SEVERE, message, (Throwable)((Object)lastAssertion));
        }
    }

    public static void assertNotNull(Object value, String message, Object ... params) {
        RemoteLogger.assertTrue(value != null, message, params);
    }

    public static void assertNull(Object value, String message, Object ... params) {
        RemoteLogger.assertTrue(value == null, message, params);
    }

    public static void assertFalse(boolean value) {
        RemoteLogger.assertTrue(!value, "Assertion error", new Object[0]);
    }

    public static void assertFalse(boolean value, String message, Object ... params) {
        RemoteLogger.assertTrue(!value, message, params);
    }

    public static void assertNonUiThread(String message) {
        RemoteLogger.assertFalse(SwingUtilities.isEventDispatchThread());
    }

    public static void assertNonUiThread() {
        RemoteLogger.assertNonUiThread("Should not be called from UI thread");
    }

    public static void log(Level level, String message, Object arg1) {
        if (instance.isLoggable(level)) {
            instance.log(level, message, arg1);
        }
    }

    public static void log(Level level, String message, Object arg1, Object arg2) {
        if (instance.isLoggable(level)) {
            instance.log(level, message, new Object[]{arg1, arg2});
        }
    }

    public static void finest(Exception exception) {
        instance.log(Level.FINEST, "FYI:", exception);
    }

    public static void finest(Exception exception, Object source) {
        if (instance.isLoggable(Level.FINEST)) {
            instance.log(Level.FINEST, "FYI " + source, exception);
        }
    }

    public static void fine(Exception exception) {
        instance.log(Level.FINE, "FYI:", exception);
    }

    public static void info(Exception exception) {
        if (instance.isLoggable(Level.INFO)) {
            instance.log(Level.INFO, "Exception occurred:", exception);
        }
    }

    public static void info(Exception exception, Object source) {
        if (instance.isLoggable(Level.INFO)) {
            instance.log(Level.INFO, "Exception from " + source, exception);
        }
    }

    public static void warning(Exception exception) {
        if (instance.isLoggable(Level.WARNING)) {
            instance.log(Level.WARNING, "Exception occurred:", exception);
        }
    }

    private static String format(String message, Object ... params) {
        try {
            return MessageFormat.format(message, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            return message;
        }
    }

    public static void logException(Level level, String msg, Object ... params) {
        if (instance.isLoggable(level)) {
            String formattedMessage = RemoteLogger.format(msg, params);
            Exception ex = new Exception(formattedMessage);
            instance.log(level, formattedMessage, ex);
        }
    }

    public static void severeException(String msg, Object ... params) {
        RemoteLogger.logException(Level.SEVERE, msg, params);
    }

    public static void warningException(String msg, Object ... params) {
        RemoteLogger.logException(Level.WARNING, msg, params);
    }

    public static void innfoException(String msg, Object ... params) {
        RemoteLogger.logException(Level.INFO, msg, params);
    }

    public static void severe(String msg, Object ... params) {
        RemoteLogger.log(Level.SEVERE, msg, params);
    }

    public static void warning(String msg, Object ... params) {
        RemoteLogger.log(Level.WARNING, msg, params);
    }

    public static void info(String msg, Object ... params) {
        RemoteLogger.log(Level.INFO, msg, params);
    }

    public static void fine(String msg, Object ... params) {
        RemoteLogger.log(Level.FINE, msg, params);
    }

    public static void finer(String msg, Object ... params) {
        RemoteLogger.log(Level.FINER, msg, params);
    }

    public static void finest(String msg, Object ... params) {
        RemoteLogger.log(Level.FINER, msg, params);
    }

    static {
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
    }
}

