/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis.analyzer;

import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;

public final class AnnotationUtil {
    public static final String ANY = "javax.enterprise.inject.Any";
    public static final String VALUE = "value";
    public static final String INJECT = "Inject";
    public static final String INJECT_FQN = "javax.inject.Inject";
    public static final String DECORATOR = "javax.decorator.Decorator";
    public static final String PRODUCES = "Produces";
    public static final String PRODUCES_FQN = "javax.enterprise.inject.Produces";
    public static final String INTERCEPTOR_BINDING = "InterceptorBinding";
    public static final String INTERCEPTOR_BINDING_FQN = "javax.interceptor.InterceptorBinding";
    public static final String INTERCEPTOR = "javax.interceptor.Interceptor";
    public static final String NORMAL_SCOPE = "NormalScope";
    public static final String NORMAL_SCOPE_FQN = "javax.enterprise.context.NormalScope";
    public static final String SCOPE = "Scope";
    public static final String SCOPE_FQN = "javax.inject.Scope";
    public static final String DISPOSES = "Disposes";
    public static final String DISPOSES_FQN = "javax.enterprise.inject.Disposes";
    public static final String OBSERVES = "Observes";
    public static final String OBSERVES_FQN = "javax.enterprise.event.Observes";
    public static final String STATELESS = "javax.ejb.Stateless";
    public static final String STATEFUL = "javax.ejb.Stateful";
    public static final String SINGLETON = "javax.ejb.Singleton";
    public static final String APPLICATION_SCOPED = "javax.enterprise.context.ApplicationScoped";
    public static final String DEPENDENT = "javax.enterprise.context.Dependent";
    public static final String STEREOTYPE = "Stereotype";
    public static final String STEREOTYPE_FQN = "javax.enterprise.inject.Stereotype";
    public static final String NAMED = "javax.inject.Named";
    public static final String QUALIFIER = "Qualifier";
    public static final String QUALIFIER_FQN = "javax.inject.Qualifier";
    public static final String DELEGATE_FQN = "javax.decorator.Delegate";
    public static final String SPECIALIZES = "javax.enterprise.inject.Specializes";
    public static final String INJECTION_POINT = "javax.enterprise.inject.spi.InjectionPoint";
    public static final String DEFAULT_FQN = "javax.enterprise.inject.Default";
    public static final String POST_CONSTRUCT = "javax.annotation.PostConstruct";
    public static final String PRE_DESTROY = "javax.annotation.PreDestroy";
    public static final String POST_ACTIVATE = "javax.ejb.PostActivate";
    public static final String PRE_PASSIVATE = "javax.ejb.PrePassivate";
    public static final String CONTEXT = "javax.enterprise.context.spi.Context";
    public static final String CONVERSATION = "javax.enterprise.context.Conversation";
    public static final String ALTERNATVE = "javax.enterprise.inject.Alternative";
    public static final String TYPED = "javax.enterprise.inject.Typed";
    public static final String NON_BINDING = "javax.enterprise.util.Nonbinding";
    public static final String PASSIVATING = "passivating";

    private AnnotationUtil() {
    }

    public static boolean hasAnnotation(Element element, String annotation, CompilationInfo info) {
        return AnnotationUtil.getAnnotationMirror(element, annotation, info) != null;
    }

    public static AnnotationMirror getAnnotationMirror(Element element, String annotation, CompilationInfo info) {
        return AnnotationUtil.getAnnotationMirror(element, info, annotation);
    }

    /*
     * WARNING - void declaration
     */
    public static AnnotationMirror getAnnotationMirror(Element element, CompilationInfo info, String ... annotationFqns) {
        void var6_8;
        HashSet<TypeElement> set = new HashSet<TypeElement>();
        String[] arr$ = annotationFqns;
        int len$ = arr$.length;
        boolean bl = false;
        while (var6_8 < len$) {
            String annotation = arr$[var6_8];
            TypeElement annotationElement = info.getElements().getTypeElement(annotation);
            if (annotationElement != null) {
                set.add(annotationElement);
            }
            ++var6_8;
        }
        List<? extends AnnotationMirror> annotations = info.getElements().getAllAnnotationMirrors(element);
        for (AnnotationMirror annotationMirror : annotations) {
            Element declaredAnnotation = info.getTypes().asElement(annotationMirror.getAnnotationType());
            if (!set.contains(declaredAnnotation)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean isSessionBean(Element element, CompilationInfo compInfo) {
        return AnnotationUtil.getAnnotationMirror(element, compInfo, STATEFUL, STATELESS, SINGLETON) != null;
    }

    public static boolean isDelegate(Element element, TypeElement parent, WebBeansModel model) {
        return AnnotationUtil.hasAnnotation(element, DELEGATE_FQN, (CompilationInfo)model.getCompilationController()) && AnnotationUtil.hasAnnotation(parent, DECORATOR, (CompilationInfo)model.getCompilationController());
    }

    public static boolean isLifecycleCallback(ExecutableElement element, CompilationInfo info) {
        AnnotationMirror annotationMirror = AnnotationUtil.getAnnotationMirror((Element)element, info, POST_ACTIVATE, POST_CONSTRUCT, PRE_DESTROY, PRE_PASSIVATE);
        return annotationMirror != null;
    }
}

