/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.actions;

import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.web.beans.actions.InterceptorGenerator;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class InterceptorPanel
extends JPanel {
    private static final long serialVersionUID = 984990919698645497L;
    private static final String JAVA = "java";
    private JTextField myInterceptorName;
    private JLabel myInterceptorNameLbl;
    private JLabel myStatusLbl;
    private String myBindingName;
    private FileObject myBindingFileObject;

    public InterceptorPanel(JButton approveButton, String bindingName, FileObject bindingFileObject) {
        block2: {
            this.initComponents();
            this.myBindingName = bindingName;
            this.myBindingFileObject = bindingFileObject;
            this.myInterceptorName.getDocument().addDocumentListener(this.createValidationListener(approveButton));
            this.myInterceptorName.setText(this.getProposedName());
            try {
                URL errorUrl = new URL("nbresloc:/org/netbeans/modules/dialogs/error.gif");
                this.myStatusLbl.setIcon(new ImageIcon(errorUrl));
            }
            catch (MalformedURLException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.myStatusLbl.setVisible(false);
    }

    String getInterceptorName() {
        return this.myInterceptorName.getText();
    }

    private DocumentListener createValidationListener(final JButton button) {
        DocumentListener listener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.checkName(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.checkName(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.checkName(e);
            }

            private void checkName(DocumentEvent e) {
                block5: {
                    try {
                        String text = e.getDocument().getText(0, e.getDocument().getLength());
                        if (text == null || text.trim().length() == 0 || !Utilities.isJavaIdentifier((String)text)) {
                            InterceptorPanel.this.myStatusLbl.setText(NbBundle.getMessage(InterceptorGenerator.class, (String)"LBL_InvalidInterceptorName", (Object)text));
                            InterceptorPanel.this.myStatusLbl.setVisible(true);
                            button.setEnabled(false);
                            return;
                        }
                        FileObject packageFolder = InterceptorPanel.this.myBindingFileObject.getParent();
                        if (packageFolder == null) {
                            return;
                        }
                        FileObject file = packageFolder.getFileObject(text, InterceptorPanel.JAVA);
                        if (file != null) {
                            InterceptorPanel.this.myStatusLbl.setText(NbBundle.getMessage(InterceptorGenerator.class, (String)"LBL_FileExists", (Object)file.getNameExt()));
                            InterceptorPanel.this.myStatusLbl.setVisible(true);
                            button.setEnabled(false);
                            return;
                        }
                        InterceptorPanel.this.myStatusLbl.setText("");
                        InterceptorPanel.this.myStatusLbl.setVisible(false);
                        button.setEnabled(true);
                    }
                    catch (BadLocationException ex) {
                        if ($assertionsDisabled) break block5;
                        throw new AssertionError();
                    }
                }
            }
        };
        return listener;
    }

    private String getProposedName() {
        StringBuilder result = new StringBuilder();
        if (this.myBindingName.endsWith("InterceptorBinding")) {
            result.append(this.myBindingName.substring(0, this.myBindingName.length() - "InterceptorBinding".length()));
        } else {
            result.append(this.myBindingName);
        }
        result.append("Interceptor");
        FileObject packageFolder = this.myBindingFileObject.getParent();
        if (packageFolder == null) {
            return result.toString();
        }
        int index = 1;
        String next = result.toString();
        while (packageFolder.getFileObject(next, JAVA) != null) {
            next = result.toString() + index;
            ++index;
        }
        return result.toString();
    }

    private void initComponents() {
        this.myInterceptorNameLbl = new JLabel();
        this.myInterceptorName = new JTextField();
        this.myStatusLbl = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.myInterceptorNameLbl, (String)NbBundle.getMessage(InterceptorPanel.class, (String)"LBL_InterceptorName"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.myInterceptorNameLbl).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.myInterceptorName, -1, 244, Short.MAX_VALUE)).addComponent(this.myStatusLbl)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.myInterceptorNameLbl).addComponent(this.myInterceptorName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 20, Short.MAX_VALUE).addComponent(this.myStatusLbl).addContainerGap()));
        this.myInterceptorNameLbl.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InterceptorPanel.class, (String)"ACSN_InterceptorName"));
        this.myInterceptorNameLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InterceptorPanel.class, (String)"ACSD_InterceptorName"));
        this.myInterceptorName.getAccessibleContext().setAccessibleName(this.myInterceptorNameLbl.getAccessibleContext().getAccessibleName());
        this.myInterceptorName.getAccessibleContext().setAccessibleDescription(this.getAccessibleContext().getAccessibleDescription());
    }
}

