/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.SourceGroupModifier;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.beans.analysis.CdiAnalysisResult;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class CdiUtil {
    private static final Logger LOG = Logger.getLogger("org.netbeans.ui.metrics.cdi");
    public static final String BEANS = "beans";
    public static final String BEANS_XML = "beans.xml";
    private static final String META_INF = "META-INF";
    public static final String WEB_INF = "WEB-INF";
    private WeakReference<Project> myProject;
    private Set<String> myMessages;

    public CdiUtil(Project project) {
        this.myProject = new WeakReference<Project>(project);
        this.myMessages = new CopyOnWriteArraySet<String>();
    }

    public void log(String message, Class<?> clazz, Object[] params) {
        this.log(message, clazz, params, false);
    }

    public void log(String message, Class<?> clazz, Object[] params, boolean once) {
        if (!once) {
            if (this.myMessages.contains(message)) {
                return;
            }
            this.myMessages.add(message);
        }
        LogRecord logRecord = new LogRecord(Level.INFO, message);
        logRecord.setLoggerName(LOG.getName());
        logRecord.setResourceBundle(NbBundle.getBundle(clazz));
        logRecord.setResourceBundleName(clazz.getPackage().getName() + ".Bundle");
        if (params != null) {
            logRecord.setParameters(params);
        }
        LOG.log(logRecord);
    }

    public boolean isCdiEnabled() {
        Project project = this.getProject();
        if (project == null) {
            return false;
        }
        return this.isCdiEnabled(project);
    }

    public boolean isCdiEnabled(Project project) {
        Collection<FileObject> beansTargetFolder = this.getBeansTargetFolder(false);
        for (FileObject fileObject : beansTargetFolder) {
            if (fileObject == null || fileObject.getFileObject(BEANS_XML) == null) continue;
            return true;
        }
        return false;
    }

    public Collection<FileObject> getBeansTargetFolder(boolean create) {
        Project project = this.getProject();
        if (project == null) {
            return Collections.emptyList();
        }
        return CdiUtil.getBeansTargetFolder(project, create);
    }

    protected Project getProject() {
        return (Project)this.myProject.get();
    }

    public static boolean hasBeansXml(Project project) {
        Collection<FileObject> beansTargetFolder = CdiUtil.getBeansTargetFolder(project, false);
        for (FileObject fileObject : beansTargetFolder) {
            if (fileObject == null || fileObject.getFileObject(BEANS_XML) == null) continue;
            return true;
        }
        return false;
    }

    public static Collection<FileObject> getBeansTargetFolder(Project project, boolean create) {
        FileObject fileObject;
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        ArrayList<FileObject> result = new ArrayList<FileObject>(2);
        SourceGroup[] sourceGroups = sources.getSourceGroups("resources");
        if (sourceGroups != null && sourceGroups.length > 0) {
            fileObject = CdiUtil.getDefaultBeansTargetFolder(sourceGroups, false);
            if (fileObject != null) {
                result.add(fileObject);
            }
        } else {
            sourceGroups = sources.getSourceGroups("java");
            fileObject = CdiUtil.getDefaultBeansTargetFolder(sourceGroups, false);
            if (fileObject != null) {
                result.add(fileObject);
            }
        }
        if (result.size() == 0 && create) {
            SourceGroup resourcesSourceGroup = SourceGroupModifier.createSourceGroup((Project)project, (String)"resources", (String)"main");
            if (resourcesSourceGroup != null) {
                sourceGroups = new SourceGroup[]{resourcesSourceGroup};
            }
            FileObject fileObject2 = CdiUtil.getDefaultBeansTargetFolder(sourceGroups, true);
            result.add(fileObject2);
        }
        return result;
    }

    private static FileObject getDefaultBeansTargetFolder(SourceGroup[] sourceGroups, boolean create) {
        if (sourceGroups.length > 0) {
            FileObject metaInf = sourceGroups[0].getRootFolder().getFileObject(META_INF);
            if (metaInf == null && create) {
                try {
                    metaInf = FileUtil.createFolder((FileObject)sourceGroups[0].getRootFolder(), (String)META_INF);
                }
                catch (IOException e) {
                    Logger.getLogger(CdiAnalysisResult.class.getName()).log(Level.WARNING, null, e);
                }
            }
            return metaInf;
        }
        return null;
    }
}

