/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.zend;

import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import org.netbeans.modules.php.api.framework.BadgeIcon;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.phpmodule.PhpModuleProperties;
import org.netbeans.modules.php.spi.editor.EditorExtender;
import org.netbeans.modules.php.spi.framework.PhpFrameworkProvider;
import org.netbeans.modules.php.spi.framework.PhpModuleActionsExtender;
import org.netbeans.modules.php.spi.framework.PhpModuleExtender;
import org.netbeans.modules.php.spi.framework.PhpModuleIgnoredFilesExtender;
import org.netbeans.modules.php.zend.ZendPhpModuleActionsExtender;
import org.netbeans.modules.php.zend.ZendPhpModuleExtender;
import org.netbeans.modules.php.zend.commands.ZendCommandSupport;
import org.netbeans.modules.php.zend.editor.ZendEditorExtender;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public final class ZendPhpFrameworkProvider
extends PhpFrameworkProvider {
    private static final String ICON_PATH = "org/netbeans/modules/php/zend/ui/resources/zend_badge_8.png";
    private static final ZendPhpFrameworkProvider INSTANCE = new ZendPhpFrameworkProvider();
    private final BadgeIcon badgeIcon = new BadgeIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/php/zend/ui/resources/zend_badge_8.png"), ZendPhpFrameworkProvider.class.getResource("/org/netbeans/modules/php/zend/ui/resources/zend_badge_8.png"));

    public static ZendPhpFrameworkProvider getInstance() {
        return INSTANCE;
    }

    private ZendPhpFrameworkProvider() {
        super("Zend PHP Web Framework", NbBundle.getMessage(ZendPhpFrameworkProvider.class, (String)"LBL_FrameworkName"), NbBundle.getMessage(ZendPhpFrameworkProvider.class, (String)"LBL_FrameworkDescription"));
    }

    public BadgeIcon getBadgeIcon() {
        return this.badgeIcon;
    }

    public boolean isInPhpModule(PhpModule phpModule) {
        FileObject sourceDirectory = phpModule.getSourceDirectory();
        if (sourceDirectory == null) {
            return false;
        }
        FileObject zfProject = sourceDirectory.getFileObject(".zfproject.xml");
        return zfProject != null && zfProject.isData() && zfProject.isValid();
    }

    public File[] getConfigurationFiles(PhpModule phpModule) {
        FileObject bootstrap;
        FileObject sourceDirectory = phpModule.getSourceDirectory();
        if (sourceDirectory == null) {
            return new File[0];
        }
        LinkedList<File> files = new LinkedList<File>();
        FileObject appConfig = sourceDirectory.getFileObject("application/configs");
        if (appConfig != null) {
            for (FileObject child : appConfig.getChildren()) {
                if (!child.isData()) continue;
                files.add(FileUtil.toFile((FileObject)child));
            }
            Collections.sort(files);
        }
        if ((bootstrap = sourceDirectory.getFileObject("application/Bootstrap.php")) != null) {
            files.add(FileUtil.toFile((FileObject)bootstrap));
        }
        return files.toArray(new File[files.size()]);
    }

    public PhpModuleExtender createPhpModuleExtender(PhpModule phpModule) {
        return new ZendPhpModuleExtender();
    }

    public PhpModuleProperties getPhpModuleProperties(PhpModule phpModule) {
        FileObject tests;
        PhpModuleProperties properties = new PhpModuleProperties();
        FileObject sourceDirectory = phpModule.getSourceDirectory();
        if (sourceDirectory == null) {
            return properties;
        }
        FileObject web = sourceDirectory.getFileObject("public");
        if (web != null) {
            properties = properties.setWebRoot(web);
        }
        if ((tests = sourceDirectory.getFileObject("tests")) != null) {
            properties = properties.setTests(tests);
        }
        return properties;
    }

    public PhpModuleActionsExtender getActionsExtender(PhpModule phpModule) {
        return new ZendPhpModuleActionsExtender();
    }

    public PhpModuleIgnoredFilesExtender getIgnoredFilesExtender(PhpModule phpModule) {
        return null;
    }

    public ZendCommandSupport getFrameworkCommandSupport(PhpModule phpModule) {
        return new ZendCommandSupport(phpModule);
    }

    public EditorExtender getEditorExtender(PhpModule phpModule) {
        return new ZendEditorExtender();
    }
}

