/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.target.iterator.api;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.target.iterator.api.TargetChooserPanelGUI;
import org.netbeans.modules.target.iterator.spi.TargetPanelProvider;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.TemplateWizard;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class TargetChooserPanel<T>
implements WizardDescriptor.Panel {
    private static final Logger LOG = Logger.getLogger(TargetChooserPanel.class.getName());
    private static final Pattern INVALID_FILENAME_CHARACTERS = Pattern.compile("[`~!@%^&*()=+\\|{};:'\",<>/?]");
    private static final Pattern INVALID_FOLDERNAME_CHARACTERS = Pattern.compile("\\.$|[`~!@%^&*()=+|{};'\",<>?]", 8);
    private ChangeSupport myChangeSupport = new ChangeSupport((Object)this);
    private TargetChooserPanelGUI<T> myGui;
    private T myId;
    private Project myProject;
    private SourceGroup[] myFolders;
    private TemplateWizard myTemplateWizard;
    private TargetPanelProvider<T> myProvider;

    public TargetChooserPanel(Project project, SourceGroup[] folders, T id) {
        this.myFolders = folders;
        this.myProject = project;
        this.myId = id;
        this.loadProvider();
        this.getProvider().init(this);
    }

    public T getId() {
        return this.myId;
    }

    public TargetChooserPanelGUI<T> getComponent() {
        if (this.myGui == null) {
            this.myGui = new TargetChooserPanelGUI(this);
        }
        return this.myGui;
    }

    public Project getProject() {
        return this.myProject;
    }

    public SourceGroup[] getSourceGroups() {
        return this.myFolders;
    }

    public HelpCtx getHelp() {
        return null;
    }

    public boolean isValid() {
        return this.getProvider().isValid(this);
    }

    public boolean checkValid() {
        boolean valid;
        boolean ok;
        boolean bl = ok = this.myGui != null && this.myGui.getTargetName() != null;
        if (!ok) {
            this.myTemplateWizard.putProperty("WizardPanel_errorMessage", null);
            return false;
        }
        String filename = this.myGui.getTargetName();
        if (INVALID_FILENAME_CHARACTERS.matcher(filename).find()) {
            this.myTemplateWizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(TargetChooserPanel.class, (String)"MSG_invalid_filename"));
            return false;
        }
        String folderName = this.myGui.getNormalizedFolder();
        if (INVALID_FOLDERNAME_CHARACTERS.matcher(folderName).find()) {
            this.myTemplateWizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(TargetChooserPanel.class, (String)"MSG_invalid_foldername"));
            return false;
        }
        String targetName = this.myGui.getTargetName();
        File file = this.myGui.getTargetFile();
        String ext = this.getProvider().getResultExtension(this);
        String errorMessage = this.canUseFileName(file, this.myGui.getRelativeTargetFolder(), targetName, ext);
        if (errorMessage != null) {
            this.myTemplateWizard.putProperty("WizardPanel_errorMessage", (Object)errorMessage);
        } else {
            this.myTemplateWizard.putProperty("WizardPanel_errorMessage", (Object)this.myGui.getErrorMessage());
        }
        boolean bl2 = valid = this.myGui.isPanelValid() && errorMessage == null;
        if (valid && targetName.indexOf(46) >= 0) {
            this.myTemplateWizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(TargetChooserPanel.class, (String)"MSG_dotsInName", (Object)(targetName + "." + ext)));
        }
        return valid;
    }

    public void addChangeListener(ChangeListener listener) {
        this.myChangeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.myChangeSupport.removeChangeListener(listener);
    }

    public TemplateWizard getTemplateWizard() {
        return this.myTemplateWizard;
    }

    public void readSettings(Object settings) {
        this.myTemplateWizard = (TemplateWizard)settings;
        if (this.myGui != null) {
            this.myGui.initValues();
            String wizardTitle = this.getProvider().getWizardTitle();
            if (wizardTitle != null && null == this.getTemplateWizard().getProperty("NewFileWizard_Title")) {
                this.getTemplateWizard().putProperty("NewFileWizard_Title", (Object)wizardTitle);
            }
            this.getProvider().readSettings(this);
        }
    }

    public void storeSettings(Object settings) {
        if (WizardDescriptor.PREVIOUS_OPTION.equals(((WizardDescriptor)settings).getValue())) {
            return;
        }
        if (WizardDescriptor.CANCEL_OPTION.equals(((WizardDescriptor)settings).getValue())) {
            return;
        }
        if (this.isValid()) {
            File f = new File(this.myGui.getCreatedFilePath());
            File ff = new File(f.getParentFile().getPath());
            if (!ff.exists()) {
                try {
                    FileUtil.createFolder((File)ff);
                }
                catch (IOException exc) {
                    LOG.log(Level.INFO, null, exc);
                }
            }
            FileObject folder = FileUtil.toFileObject((File)ff);
            Templates.setTargetFolder((WizardDescriptor)((WizardDescriptor)settings), (FileObject)folder);
            Templates.setTargetName((WizardDescriptor)((WizardDescriptor)settings), (String)this.myGui.getTargetName());
            this.getProvider().storeSettings(this);
        }
        ((WizardDescriptor)settings).putProperty("NewFileWizard_Title", null);
    }

    public void fireChange() {
        this.myChangeSupport.fireChange();
    }

    TargetPanelProvider<T> getProvider() {
        return this.myProvider;
    }

    private void loadProvider() {
        Collection providers = Lookup.getDefault().lookupAll(TargetPanelProvider.class);
        for (TargetPanelProvider targetPanelProvider : providers) {
            if (!targetPanelProvider.isApplicable(this.myId)) continue;
            this.myProvider = targetPanelProvider;
            break;
        }
        if (this.myProvider == null) {
            throw new IllegalStateException("No provider for id '" + this.myId + "'  is found ");
        }
    }

    private String canUseFileName(File dir, String relativePath, String objectName, String extension) {
        String newObjectName = objectName;
        if (extension != null && extension.length() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(objectName);
            sb.append('.');
            sb.append(extension);
            newObjectName = sb.toString();
        }
        if (!this.checkFileName(objectName)) {
            return NbBundle.getMessage(TargetChooserPanel.class, (String)"MSG_invalid_filename", (Object)newObjectName);
        }
        FileObject folder = null;
        if (dir != null) {
            try {
                folder = FileUtil.toFileObject((File)dir);
            }
            catch (IllegalArgumentException ex) {
                return NbBundle.getMessage(TargetChooserPanel.class, (String)"MSG_invalid_path", (Object)relativePath);
            }
        }
        if (folder != null) {
            if (!folder.canWrite()) {
                return NbBundle.getMessage(TargetChooserPanel.class, (String)"MSG_fs_is_readonly");
            }
            if (folder.getFileObject(newObjectName) != null) {
                return NbBundle.getMessage(TargetChooserPanel.class, (String)"MSG_file_already_exist", (Object)newObjectName);
            }
            if (Utilities.isWindows() && this.checkCaseInsensitiveName(folder, newObjectName)) {
                return NbBundle.getMessage(TargetChooserPanel.class, (String)"MSG_file_already_exist", (Object)newObjectName);
            }
        }
        return null;
    }

    private boolean checkCaseInsensitiveName(FileObject folder, String name) {
        Enumeration children = folder.getChildren(false);
        while (children.hasMoreElements()) {
            FileObject fo = (FileObject)children.nextElement();
            if (!name.equalsIgnoreCase(fo.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean checkFileName(String str) {
        char[] c = str.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '\\') {
                return false;
            }
            if (c[i] != '/') continue;
            return false;
        }
        return true;
    }
}

