/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javawebstart.ui.customizer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.modules.javawebstart.ui.customizer.JWSCustomizerPanel;
import org.netbeans.modules.javawebstart.ui.customizer.JWSProjectProperties;
import org.netbeans.modules.javawebstart.ui.customizer.JWSProjectPropertiesUtils;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class JWSCompositeCategoryProvider
implements ProjectCustomizer.CompositeCategoryProvider {
    private static final String CAT_WEBSTART = "WebStart";
    private static final Map<String, JWSProjectProperties> projectProperties = new HashMap<String, JWSProjectProperties>();

    public ProjectCustomizer.Category createCategory(Lookup context) {
        boolean fxOverride = false;
        final Project project = (Project)context.lookup(Project.class);
        if (project != null) {
            J2SEPropertyEvaluator j2sepe = (J2SEPropertyEvaluator)project.getLookup().lookup(J2SEPropertyEvaluator.class);
            fxOverride = JWSProjectProperties.isTrue(j2sepe.evaluator().getProperty("javafx.enabled"));
        }
        if (!fxOverride) {
            ProjectCustomizer.Category c = ProjectCustomizer.Category.create((String)CAT_WEBSTART, (String)NbBundle.getMessage(JWSCompositeCategoryProvider.class, (String)"LBL_Category_WebStart"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
            c.setOkButtonListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JWSProjectProperties prop;
                    if (project != null && (prop = JWSProjectProperties.getInstanceIfExists(project.getLookup())) != null) {
                        projectProperties.put(project.getProjectDirectory().getPath(), prop);
                    }
                }
            });
            c.setStoreListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (project != null) {
                        JWSProjectProperties prop = (JWSProjectProperties)projectProperties.get(project.getProjectDirectory().getPath());
                        if (prop != null) {
                            JWSProjectPropertiesUtils.updateMasterFiles(prop, project);
                            JWSProjectPropertiesUtils.savePropsAndUpdateMetaFiles(prop, project);
                        }
                        projectProperties.remove(project.getProjectDirectory().getPath());
                    }
                }
            });
            c.setCloseListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (project != null) {
                        JWSProjectProperties.cleanup(project.getLookup());
                    }
                }
            });
            return c;
        }
        return null;
    }

    public JComponent createComponent(ProjectCustomizer.Category category, Lookup context) {
        return new JWSCustomizerPanel(JWSProjectProperties.getInstance(context));
    }
}

