/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.drilldown;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.ui.LiveResultsWindowContributor;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.cpu.LiveFlatProfilePanel;
import org.netbeans.lib.profiler.ui.cpu.statistics.StatisticalModule;
import org.netbeans.lib.profiler.ui.cpu.statistics.StatisticalModuleContainer;
import org.netbeans.modules.profiler.categorization.api.Category;
import org.netbeans.modules.profiler.categorization.api.ProjectAwareStatisticalModule;
import org.netbeans.modules.profiler.drilldown.DrillDown;
import org.netbeans.modules.profiler.drilldown.DrillDownFactory;
import org.netbeans.modules.profiler.drilldown.DrillDownListener;
import org.netbeans.modules.profiler.drilldown.DrillDownWindow;
import org.openide.util.Lookup;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;

public class DrilldownContributor
extends LiveResultsWindowContributor.Adapter {
    private static final Logger LOGGER = Logger.getLogger(DrilldownContributor.class.getName());
    private DrillDown dd;
    private volatile boolean drillDownGroupOpened;
    private volatile boolean toolBarInitialized = false;

    public void addToCpuResults(final LiveFlatProfilePanel cpuPanel, ProfilerToolbar toolBar, ProfilerClient client, Lookup.Provider project) {
        final ArrayList additionalStats = new ArrayList();
        this.dd = ((DrillDownFactory)Lookup.getDefault().lookup(DrillDownFactory.class)).createDrillDown(project, client);
        if (this.dd != null) {
            StatisticalModuleContainer container = (StatisticalModuleContainer)Lookup.getDefault().lookup(StatisticalModuleContainer.class);
            additionalStats.addAll(container.getAllModules());
            for (StatisticalModule sm : additionalStats) {
                if (!(sm instanceof ProjectAwareStatisticalModule)) continue;
                ((ProjectAwareStatisticalModule)sm).setProject(project);
            }
            DrillDownWindow.getDefault().setDrillDown(this.dd, additionalStats);
            this.showDrillDown();
        } else {
            this.hideDrillDown();
        }
        if (this.dd != null) {
            this.dd.addListener(new DrillDownListener(){

                @Override
                public void dataChanged() {
                }

                @Override
                public void drillDownPathChanged(List<Category> list) {
                    Mark m = list.get(list.size() - 1).getAssignedMark();
                    for (StatisticalModule s : additionalStats) {
                        s.setSelectedMark(m);
                    }
                    cpuPanel.updateLiveResults();
                }
            });
        }
        cpuPanel.setAdditionalStats(additionalStats);
        final DrillDownWindow drillDownWin = DrillDownWindow.getDefault();
        DrillDownWindow.closeIfOpened();
        drillDownWin.getPresenter().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (drillDownWin.getPresenter().isSelected()) {
                    drillDownWin.open();
                } else {
                    drillDownWin.close();
                }
            }
        });
        if (!this.toolBarInitialized) {
            toolBar.addFiller();
            toolBar.add((Component)drillDownWin.getPresenter());
            this.toolBarInitialized = true;
        }
    }

    public void reset() {
        if (this.dd != null) {
            this.dd.reset();
        }
    }

    public void hide() {
        if (this.drillDownGroupOpened) {
            this.hideDrillDown();
        }
    }

    public void refresh() {
        if (this.dd != null) {
            this.dd.refresh();
        }
        if (TargetAppRunner.getDefault().getProfilerClient().getCurrentInstrType() == 2) {
            this.hideDrillDown();
        }
    }

    public void show() {
        if (this.dd != null && this.dd.isValid() && !this.drillDownGroupOpened) {
            this.showDrillDown();
        }
    }

    private void showDrillDown() {
        if (TargetAppRunner.getDefault().getProfilerClient().getCurrentInstrType() == 2) {
            return;
        }
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                TopComponentGroup group = WindowManager.getDefault().findTopComponentGroup("LiveResultsGroup");
                if (group != null) {
                    group.open();
                    DrilldownContributor.this.drillDownGroupOpened = true;
                    DrillDownWindow.getDefault().getPresenter().setEnabled(true);
                } else {
                    LOGGER.severe("LiveResultsGroup not existing!");
                }
            }
        });
    }

    private void hideDrillDown() {
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                TopComponentGroup group = WindowManager.getDefault().findTopComponentGroup("LiveResultsGroup");
                if (group != null) {
                    group.close();
                }
                DrilldownContributor.this.drillDownGroupOpened = false;
                DrillDownWindow.getDefault().getPresenter().setEnabled(false);
            }
        });
    }
}

