/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.uid;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.netbeans.modules.cnd.api.model.CsmBuiltIn;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmTracer;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelimpl.csm.ForwardClass;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.KeyBasedUID;
import org.netbeans.modules.cnd.modelimpl.uid.UIDManager;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDProviderIml;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;

public class UIDUtilities {
    private static final AtomicInteger UnnamedID = new AtomicInteger(0);

    private UIDUtilities() {
    }

    public static CsmUID<CsmProject> createProjectUID(ProjectBase prj) {
        return UIDUtilities.getCachedUID(new ProjectUID(prj), prj);
    }

    public static CsmUID<CsmFile> createFileUID(FileImpl file) {
        return UIDUtilities.getCachedUID(new FileUID(file), file);
    }

    public static CsmUID<CsmNamespace> createNamespaceUID(CsmNamespace ns) {
        return UIDUtilities.getCachedUID(new NamespaceUID(ns), ns);
    }

    public static <T extends CsmOffsetableDeclaration> CsmUID<T> createDeclarationUID(T declaration) {
        assert (!(declaration instanceof CsmBuiltIn)) : "built-in have own UIDs";
        CachedUID uid = !UIDUtilities.namedDeclaration(declaration) ? UIDUtilities.handleUnnamedDeclaration(declaration) : (declaration instanceof CsmTypedef ? new TypedefUID<T>(declaration) : (ForwardClass.isForwardClass(declaration) ? new ForwardClassUID<T>(declaration) : (declaration instanceof CsmClassifier ? new ClassifierUID<T>(declaration) : new DeclarationUID<T>(declaration))));
        return UIDUtilities.updateCachedUIDIfNeeded(uid, declaration);
    }

    public static <T extends CsmInstantiation> CsmUID<T> createInstantiationUID(T inst) {
        InstantiationUID<T> uid = new InstantiationUID<T>(inst);
        return UIDUtilities.updateCachedUIDIfNeeded(uid, inst);
    }

    private static <T extends CsmOffsetableDeclaration> boolean namedDeclaration(T declaration) {
        assert (declaration != null);
        assert (declaration.getName() != null);
        return declaration.getName().length() > 0;
    }

    public static CsmUID<CsmMacro> createMacroUID(CsmMacro macro) {
        return UIDUtilities.getCachedUID(new MacroUID(macro), macro);
    }

    public static CsmUID<CsmInclude> createIncludeUID(CsmInclude incl) {
        return UIDUtilities.getCachedUID(new IncludeUID(incl), incl);
    }

    public static CsmUID<CsmInheritance> createInheritanceUID(CsmInheritance inh) {
        return UIDUtilities.getCachedUID(new InheritanceUID(inh), inh);
    }

    public static CsmUID<CsmClass> createUnresolvedClassUID(String name, CsmProject project) {
        CsmUID<CsmClass> sharedUID = UIDManager.instance().getSharedUID(new UnresolvedClassUID(name, project));
        assert (!(sharedUID instanceof CachedUID));
        return sharedUID;
    }

    public static CsmUID<CsmFile> createUnresolvedFileUID(CsmProject project) {
        CsmUID<CsmFile> sharedUID = UIDManager.instance().getSharedUID(new UnresolvedFileUID(project));
        assert (!(sharedUID instanceof CachedUID));
        return sharedUID;
    }

    public static CsmUID<CsmNamespace> createUnresolvedNamespaceUID(CsmProject project) {
        CsmUID<CsmNamespace> sharedUID = UIDManager.instance().getSharedUID(new UnresolvedNamespaceUID(project));
        assert (!(sharedUID instanceof CachedUID));
        return sharedUID;
    }

    private static <T extends CsmObject> CsmUID<T> getCachedUID(CachedUID<T> uid, T obj) {
        return UIDUtilities.updateCachedUID(uid, obj);
    }

    public static int getProjectID(CsmUID<?> uid) {
        if (uid instanceof KeyBasedUID) {
            return KeyUtilities.getProjectIndex(((KeyBasedUID)uid).getKey());
        }
        return -1;
    }

    public static boolean isProjectFile(CsmUID<CsmProject> uid1, CsmUID<CsmFile> uid2) {
        if (uid1 instanceof KeyBasedUID && uid2 instanceof KeyBasedUID) {
            int i1 = KeyUtilities.getProjectIndex(((KeyBasedUID)uid1).getKey());
            int i2 = KeyUtilities.getProjectIndex(((KeyBasedUID)uid2).getKey());
            if (i1 >= 0 && i2 >= 0) {
                return i1 == i2;
            }
        }
        return false;
    }

    public static boolean isSameProject(CsmUID<CsmFile> uid1, CsmUID<CsmFile> uid2) {
        if (uid1 instanceof KeyBasedUID && uid2 instanceof KeyBasedUID) {
            int i1 = KeyUtilities.getProjectIndex(((KeyBasedUID)uid1).getKey());
            int i2 = KeyUtilities.getProjectIndex(((KeyBasedUID)uid2).getKey());
            if (i1 >= 0 && i2 >= 0) {
                return i1 == i2;
            }
        }
        return false;
    }

    public static boolean isSameFile(CsmUID<CsmOffsetableDeclaration> uid1, CsmUID<CsmOffsetableDeclaration> uid2) {
        if (uid1 instanceof KeyBasedUID && uid2 instanceof KeyBasedUID) {
            int i1 = KeyUtilities.getProjectFileIndex(((KeyBasedUID)uid1).getKey());
            int i2 = KeyUtilities.getProjectFileIndex(((KeyBasedUID)uid2).getKey());
            if (i1 >= 0 && i2 >= 0) {
                return i1 == i2;
            }
        }
        return UIDUtilities.isSameFile((CsmOffsetableDeclaration)uid1.getObject(), (CsmOffsetableDeclaration)uid2.getObject());
    }

    public static boolean isForwardClass(CsmUID<?> uid) {
        return uid instanceof ForwardClassUID;
    }

    public static int getFileID(CsmUID<?> uid) {
        if (uid instanceof KeyBasedUID) {
            return KeyUtilities.getProjectFileIndex(((KeyBasedUID)uid).getKey());
        }
        return -1;
    }

    private static boolean isSameFile(CsmOffsetableDeclaration decl1, CsmOffsetableDeclaration decl2) {
        if (decl1 != null && decl2 != null) {
            CsmFile file1 = decl1.getContainingFile();
            CsmFile file2 = decl2.getContainingFile();
            if (file1 != null && file2 != null) {
                return file1.equals(file2);
            }
        }
        return false;
    }

    public static CsmDeclaration.Kind getKind(CsmUID<?> uid) {
        CsmObject object;
        if (uid instanceof KeyBasedUID) {
            Key key = ((KeyBasedUID)uid).getKey();
            return KeyUtilities.getKeyKind(key);
        }
        if (UIDProviderIml.isSelfUID(uid) && CsmKindUtilities.isDeclaration((CsmObject)(object = (CsmObject)uid.getObject()))) {
            return ((CsmDeclaration)object).getKind();
        }
        return null;
    }

    public static CsmVisibility getVisibility(CsmUID<CsmInheritance> uid) {
        if (uid instanceof KeyBasedUID) {
            Key key = ((KeyBasedUID)uid).getKey();
            return KeyUtilities.getKeyVisibility(key);
        }
        return null;
    }

    public static char getKindChar(CsmUID<?> uid) {
        if (uid instanceof KeyBasedUID) {
            Key key = ((KeyBasedUID)uid).getKey();
            return KeyUtilities.getKeyChar(key);
        }
        return '\u0000';
    }

    public static CharSequence getFileName(CsmUID<CsmFile> uid) {
        if (uid instanceof KeyBasedUID) {
            Key key = ((KeyBasedUID)uid).getKey();
            return KeyUtilities.getKeyName(key);
        }
        return null;
    }

    public static CharSequence getProjectName(CsmUID<CsmProject> uid) {
        if (uid instanceof KeyBasedUID) {
            Key key = ((KeyBasedUID)uid).getKey();
            return KeyUtilities.getKeyName(key);
        }
        return null;
    }

    public static CharSequence getName(CsmUID<?> uid) {
        Object object;
        if (uid instanceof KeyBasedUID) {
            Key key = ((KeyBasedUID)uid).getKey();
            return KeyUtilities.getKeyName(key);
        }
        if (UIDProviderIml.isSelfUID(uid) && CsmKindUtilities.isNamedElement((Object)(object = uid.getObject()))) {
            return ((CsmNamedElement)object).getName();
        }
        return null;
    }

    public static int getStartOffset(CsmUID<?> uid) {
        Object object;
        if (uid instanceof KeyBasedUID) {
            Key key = ((KeyBasedUID)uid).getKey();
            return KeyUtilities.getKeyStartOffset(key);
        }
        if (UIDProviderIml.isSelfUID(uid) && CsmKindUtilities.isOffsetable((Object)(object = uid.getObject()))) {
            return ((CsmOffsetable)object).getStartOffset();
        }
        return -1;
    }

    public static int getEndOffset(CsmUID<?> uid) {
        Object object;
        if (uid instanceof KeyBasedUID) {
            Object object2;
            Key key = ((KeyBasedUID)uid).getKey();
            int out = KeyUtilities.getKeyEndOffset(key);
            if (out == -2147483647 && CsmKindUtilities.isOffsetable((Object)(object2 = uid.getObject()))) {
                out = ((CsmOffsetable)object2).getEndOffset();
                KeyUtilities.cacheKeyEndOffset(key, out);
            }
            return out;
        }
        if (UIDProviderIml.isSelfUID(uid) && CsmKindUtilities.isOffsetable((Object)(object = uid.getObject()))) {
            return ((CsmOffsetable)object).getEndOffset();
        }
        return -1;
    }

    public static <T extends CsmOffsetable> int compareWithinFile(CsmUID<T> d1, CsmUID<T> d2) {
        int offset2;
        int offset1 = UIDUtilities.getStartOffset(d1);
        if (offset1 != (offset2 = UIDUtilities.getStartOffset(d2))) {
            return offset1 - offset2;
        }
        offset1 = UIDUtilities.getEndOffset(d1);
        if (offset1 != (offset2 = UIDUtilities.getEndOffset(d2))) {
            return offset1 - offset2;
        }
        CharSequence name1 = UIDUtilities.getName(d1);
        CharSequence name2 = UIDUtilities.getName(d2);
        if (name1 instanceof Comparable) {
            Comparable o1 = (Comparable)((Object)name1);
            int i = o1.compareTo(name2);
            if (i == 0) {
                char i1 = UIDUtilities.getKindChar(d1);
                char i2 = UIDUtilities.getKindChar(d2);
                return i1 - i2;
            }
            return i;
        }
        if (name1 != null) {
            return name2 == null ? 1 : 0;
        }
        return name2 == null ? 0 : -1;
    }

    public static <T extends CsmOffsetableDeclaration> CsmUID<T> findExistingUIDInList(List<CsmUID<T>> list, int start, int end, CharSequence name) {
        CsmUID<T> out = null;
        for (int i = list.size() - 1; i >= 0; --i) {
            CsmUID<T> csmUID = list.get(i);
            int startOffset = UIDUtilities.getStartOffset(csmUID);
            if (startOffset == start && end == UIDUtilities.getEndOffset(csmUID) && name.equals(UIDUtilities.getName(csmUID))) {
                out = csmUID;
                break;
            }
            if (startOffset < start) break;
        }
        return out;
    }

    public static <T extends CsmOffsetableDeclaration> CsmUID<T> findExistingUIDInList(List<CsmUID<T>> list, int start, CharSequence name, CsmDeclaration.Kind kind) {
        CsmUID<T> out = null;
        for (int i = list.size() - 1; i >= 0; --i) {
            CsmUID<T> csmUID = list.get(i);
            int startOffset = UIDUtilities.getStartOffset(csmUID);
            if (startOffset == start && name.equals(UIDUtilities.getName(csmUID)) && kind.equals((Object)UIDUtilities.getKind(csmUID))) {
                out = csmUID;
                break;
            }
            if (startOffset < start) break;
        }
        return out;
    }

    public static <T extends CsmOffsetable> void insertIntoSortedUIDList(CsmUID<T> uid, List<CsmUID<T>> list) {
        int start = UIDUtilities.getStartOffset(uid);
        boolean lessThanOthers = false;
        for (int pos = list.size() - 1; pos >= 0; --pos) {
            CsmUID<T> currUID = list.get(pos);
            int i = UIDUtilities.compareWithinFile(currUID, uid);
            if (i <= 0) {
                if (i == 0) {
                    list.set(pos, uid);
                } else {
                    list.add(pos + 1, uid);
                }
                return;
            }
            if (UIDUtilities.getStartOffset(currUID) < start) break;
            lessThanOthers = true;
        }
        if (!list.isEmpty() && lessThanOthers) {
            list.add(0, uid);
        } else {
            list.add(uid);
        }
    }

    private static <T extends CsmOffsetableDeclaration> CsmUID<T> handleUnnamedDeclaration(T decl) {
        if (TraceFlags.TRACE_UNNAMED_DECLARATIONS) {
            System.err.print("\n\ndeclaration with empty name '" + decl.getUniqueName() + "'");
            new CsmTracer().dumpModel(decl);
        }
        if (decl instanceof CsmClassifier) {
            return new UnnamedClassifierUID<T>(decl, UnnamedID.incrementAndGet());
        }
        return new UnnamedOffsetableDeclarationUID<T>(decl, UnnamedID.incrementAndGet());
    }

    private static <T extends CsmOffsetableDeclaration> CsmUID<T> handleUnnamedDeclaration(CsmDeclaration.Kind kind, FileImpl containingFile, int startOffset) {
        Key key = KeyUtilities.createUnnamedOffsetableDeclarationKey(containingFile, startOffset, Utils.getCsmDeclarationKindkey(kind), UnnamedID.incrementAndGet());
        if (kind == CsmDeclaration.Kind.CLASS) {
            return new UnnamedClassifierUID(key);
        }
        return new UnnamedOffsetableDeclarationUID(key);
    }

    public static void disposeUnresolved(CsmUID<?> uid) {
        if (uid instanceof UnresolvedFileUID) {
            UnresolvedFileUID fileUID = (UnresolvedFileUID)uid;
            fileUID.dispose();
        }
    }

    private static <T extends CsmObject> CsmUID<T> updateCachedUIDIfNeeded(CsmUID<T> uid, T declaration) {
        CsmUID<T> sharedUID = UIDManager.instance().getSharedUID(uid);
        if (sharedUID instanceof CachedUID) {
            ((CachedUID)sharedUID).update(declaration);
        }
        return sharedUID;
    }

    private static <T extends CsmObject> CsmUID<T> updateCachedUID(CachedUID<T> uid, T obj) {
        CachedUID cachedUid = (CachedUID)UIDManager.instance().getSharedUID(uid);
        cachedUid.update(obj);
        return cachedUid;
    }

    static final class UnresolvedFileUID
    extends UnresolvedUIDBase<CsmFile>
    implements Disposable {
        private ProjectBase prjRef = null;

        public UnresolvedFileUID(CsmProject project) {
            super(project);
            this.prjRef = (ProjectBase)project;
        }

        public UnresolvedFileUID(RepositoryDataInput input) throws IOException {
            super(input);
        }

        @Override
        public CsmFile getObject() {
            return this.getProject().getUnresolvedFile();
        }

        @Override
        protected ProjectBase getProject() {
            ProjectBase prj = this.prjRef;
            if (prj == null) {
                prj = super.getProject();
            }
            return prj;
        }

        @Override
        public void dispose() {
            this.prjRef = this.getProject();
        }
    }

    static final class UnresolvedNamespaceUID
    extends UnresolvedUIDBase<CsmNamespace> {
        public UnresolvedNamespaceUID(CsmProject project) {
            super(project);
        }

        public UnresolvedNamespaceUID(RepositoryDataInput input) throws IOException {
            super(input);
        }

        @Override
        public CsmNamespace getObject() {
            return this.getProject().getUnresolvedNamespace();
        }
    }

    static final class UnresolvedClassUID
    extends UnresolvedUIDBase<CsmClass> {
        private final CharSequence name;

        public UnresolvedClassUID(String name, CsmProject project) {
            super(project);
            this.name = NameCache.getManager().getString((CharSequence)name);
        }

        @Override
        public CsmClass getObject() {
            return this.getProject().getDummyForUnresolved(this.name);
        }

        public UnresolvedClassUID(RepositoryDataInput input) throws IOException {
            super(input);
            this.name = PersistentUtils.readUTF(input, NameCache.getManager());
        }

        @Override
        public void write(RepositoryDataOutput output) throws IOException {
            super.write(output);
            PersistentUtils.writeUTF(this.name, output);
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            UnresolvedClassUID other = (UnresolvedClassUID)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        @Override
        public int hashCode() {
            int hash = super.hashCode();
            hash = 53 * hash + (this.name != null ? this.name.hashCode() : 0);
            return hash;
        }
    }

    static abstract class UnresolvedUIDBase<T>
    implements CsmUID<T>,
    SelfPersistent {
        private final CsmUID<CsmProject> projectUID;

        public UnresolvedUIDBase(CsmProject project) {
            assert (project != null) : "how to create UID without project?";
            this.projectUID = UIDs.get((Object)project);
        }

        protected ProjectBase getProject() {
            return (ProjectBase)this.projectUID.getObject();
        }

        UnresolvedUIDBase(RepositoryDataInput aStream) throws IOException {
            this.projectUID = UIDObjectFactory.getDefaultFactory().readUID(aStream);
        }

        public abstract T getObject();

        public void write(RepositoryDataOutput output) throws IOException {
            UIDObjectFactory.getDefaultFactory().writeUID(this.projectUID, output);
        }

        protected String getToStringPrefix() {
            return "<UNRESOLVED UID>";
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnresolvedUIDBase other = (UnresolvedUIDBase)obj;
            return this.projectUID == other.projectUID || this.projectUID != null && this.projectUID.equals(other.projectUID);
        }

        public int hashCode() {
            int hash = 3;
            hash = 43 * hash + (this.projectUID != null ? this.projectUID.hashCode() : 0);
            return hash;
        }
    }

    static final class InstantiationUID<T extends CsmInstantiation>
    extends CachedUID<T> {
        public InstantiationUID(T inst) {
            this(KeyUtilities.createInstantiationKey(inst), inst);
        }

        protected InstantiationUID(Key key, T obj) {
            super(key, obj);
        }

        InstantiationUID(RepositoryDataInput aStream) throws IOException {
            super(aStream);
        }

        @Override
        public String toString() {
            String retValue = this.getToStringPrefix() + ":" + super.toString();
            return retValue;
        }

        protected String getToStringPrefix() {
            return "UID for Instantiation";
        }
    }

    static final class UnnamedOffsetableDeclarationUID<T extends CsmOffsetableDeclaration>
    extends OffsetableDeclarationUIDBase<T> {
        public UnnamedOffsetableDeclarationUID(T decl, int index) {
            super(KeyUtilities.createUnnamedOffsetableDeclarationKey((OffsetableDeclarationBase)decl, index), decl);
        }

        public UnnamedOffsetableDeclarationUID(Key key) {
            super(key);
        }

        UnnamedOffsetableDeclarationUID(RepositoryDataInput aStream) throws IOException {
            super(aStream);
        }

        @Override
        protected String getToStringPrefix() {
            return "<UNNAMED OFFS-DECL UID>";
        }
    }

    static final class UnnamedClassifierUID<T extends CsmOffsetableDeclaration>
    extends OffsetableDeclarationUIDBase<T> {
        public UnnamedClassifierUID(T classifier, int index) {
            super(KeyUtilities.createUnnamedOffsetableDeclarationKey((OffsetableDeclarationBase)classifier, index), classifier);
        }

        public UnnamedClassifierUID(Key key) {
            super(key);
        }

        UnnamedClassifierUID(RepositoryDataInput aStream) throws IOException {
            super(aStream);
        }

        @Override
        protected String getToStringPrefix() {
            return "<UNNAMED CLASSIFIER UID>";
        }
    }

    static final class ForwardClassUID<T extends CsmOffsetableDeclaration>
    extends OffsetableDeclarationUIDBaseCached<T> {
        public ForwardClassUID(T classifier) {
            super(classifier);
        }

        public ForwardClassUID(Key key) {
            super(key);
        }

        ForwardClassUID(RepositoryDataInput aStream) throws IOException {
            super(aStream);
        }

        @Override
        protected String getToStringPrefix() {
            return "ForwardClassUID";
        }
    }

    static final class ClassifierUID<T extends CsmOffsetableDeclaration>
    extends OffsetableDeclarationUIDBaseCached<T> {
        public ClassifierUID(T classifier) {
            super(classifier);
        }

        public ClassifierUID(Key key) {
            super(key);
        }

        ClassifierUID(RepositoryDataInput aStream) throws IOException {
            super(aStream);
        }

        @Override
        protected String getToStringPrefix() {
            return "ClassifierUID";
        }
    }

    static final class DeclarationUID<T extends CsmOffsetableDeclaration>
    extends OffsetableDeclarationUIDBase<T> {
        public DeclarationUID(T decl) {
            super(decl);
        }

        public DeclarationUID(Key key) {
            super(key);
        }

        DeclarationUID(RepositoryDataInput aStream) throws IOException {
            super(aStream);
        }

        @Override
        protected String getToStringPrefix() {
            return "DeclarationUID";
        }
    }

    static final class InheritanceUID
    extends CachedUID<CsmInheritance> {
        public InheritanceUID(CsmInheritance inh) {
            super(KeyUtilities.createInheritanceKey(inh), inh);
        }

        InheritanceUID(RepositoryDataInput aStream) throws IOException {
            super(aStream);
        }
    }

    static final class IncludeUID
    extends CachedUID<CsmInclude> {
        public IncludeUID(CsmInclude incl) {
            super(KeyUtilities.createIncludeKey(incl), incl);
        }

        IncludeUID(RepositoryDataInput aStream) throws IOException {
            super(aStream);
        }
    }

    static final class MacroUID
    extends CachedUID<CsmMacro> {
        public MacroUID(CsmMacro macro) {
            super(KeyUtilities.createMacroKey(macro), macro);
        }

        MacroUID(RepositoryDataInput aStream) throws IOException {
            super(aStream);
        }
    }

    static final class TypedefUID<T extends CsmOffsetableDeclaration>
    extends OffsetableDeclarationUIDBase<T> {
        public TypedefUID(T typedef) {
            super(typedef);
        }

        public TypedefUID(Key key) {
            super(key);
        }

        TypedefUID(RepositoryDataInput aStream) throws IOException {
            super(aStream);
        }

        @Override
        protected String getToStringPrefix() {
            return "TypedefUID";
        }
    }

    private static abstract class OffsetableDeclarationUIDBaseCached<T extends CsmOffsetableDeclaration>
    extends CachedUID<T> {
        public OffsetableDeclarationUIDBaseCached(T declaration) {
            this(KeyUtilities.createOffsetableDeclarationKey((OffsetableDeclarationBase)declaration), declaration);
        }

        protected OffsetableDeclarationUIDBaseCached(Key key, T obj) {
            super(key, obj);
        }

        protected OffsetableDeclarationUIDBaseCached(Key key) {
            super(key);
        }

        OffsetableDeclarationUIDBaseCached(RepositoryDataInput aStream) throws IOException {
            super(aStream);
        }

        @Override
        public String toString() {
            String retValue = this.getToStringPrefix() + ":" + super.toString();
            return retValue;
        }

        protected String getToStringPrefix() {
            return "UID for OffsDecl";
        }
    }

    private static abstract class OffsetableDeclarationUIDBase<T extends CsmOffsetableDeclaration>
    extends CachedUID<T> {
        public OffsetableDeclarationUIDBase(T declaration) {
            this(KeyUtilities.createOffsetableDeclarationKey((OffsetableDeclarationBase)declaration), declaration);
        }

        protected OffsetableDeclarationUIDBase(Key key, T obj) {
            super(key, obj);
        }

        protected OffsetableDeclarationUIDBase(Key key) {
            super(key);
        }

        OffsetableDeclarationUIDBase(RepositoryDataInput aStream) throws IOException {
            super(aStream);
        }

        @Override
        public String toString() {
            String retValue = this.getToStringPrefix() + ":" + super.toString();
            return retValue;
        }

        protected String getToStringPrefix() {
            return "UID for OffsDecl";
        }
    }

    static final class FileUID
    extends CachedUID<CsmFile> {
        public FileUID(FileImpl file) {
            super(KeyUtilities.createFileKey(file), file);
        }

        FileUID(RepositoryDataInput aStream) throws IOException {
            super(aStream);
        }
    }

    static final class NamespaceUID
    extends CachedUID<CsmNamespace> {
        public NamespaceUID(CsmNamespace ns) {
            super(KeyUtilities.createNamespaceKey(ns), ns);
        }

        NamespaceUID(RepositoryDataInput aStream) throws IOException {
            super(aStream);
        }
    }

    static final class ProjectUID
    extends CachedUID<CsmProject> {
        public ProjectUID(ProjectBase project) {
            super(KeyUtilities.createProjectKey(project), project);
        }

        ProjectUID(RepositoryDataInput aStream) throws IOException {
            super(aStream);
        }
    }

    static class CachedUID<T>
    extends KeyBasedUID<T> {
        private static final SoftReference<Object> DUMMY = new SoftReference<Object>(null);
        private Reference<Object> weakT;

        protected CachedUID(Key key, T obj) {
            super(key);
            this.weakT = TraceFlags.USE_WEAK_MEMORY_CACHE && key.hasCache() ? new WeakReference<T>(obj) : DUMMY;
        }

        protected CachedUID(Key key) {
            super(key);
            this.weakT = DUMMY;
        }

        CachedUID(RepositoryDataInput aStream) throws IOException {
            super(aStream);
            this.weakT = TraceFlags.USE_WEAK_MEMORY_CACHE && this.getKey().hasCache() ? new WeakReference<Object>(null) : DUMMY;
        }

        @Override
        public T getObject() {
            Object out = null;
            Reference<Object> weak = this.weakT;
            if (weak != DUMMY && (out = weak.get()) != null) {
                return (T)out;
            }
            out = RepositoryUtils.get(this);
            if (out != null && weak != DUMMY) {
                this.weakT = new WeakReference<Object>(out);
            }
            return (T)out;
        }

        @Override
        public void dispose(T obj) {
            this.weakT = obj == null ? DUMMY : new SoftReference<Object>(obj);
        }

        public void update(T obj) {
            if (this.weakT.get() != obj) {
                this.weakT = new WeakReference<Object>(obj);
            }
        }

        public void clear() {
            if (TraceFlags.USE_WEAK_MEMORY_CACHE && this.getKey().hasCache()) {
                this.weakT = new WeakReference<Object>(null);
            }
        }
    }
}

