/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.trace;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class LineDiff {
    public static final int CONTEXT = 3;
    private final boolean ignoreCase;
    private final boolean ignoreEmptyLines;
    private final int contextLines;

    public static List<String> diff(List<? extends CharSequence> first, List<? extends CharSequence> second) {
        LineDiff diff = new LineDiff(false);
        return diff.diffLines(first, second);
    }

    public LineDiff() {
        this(false, false);
    }

    public LineDiff(boolean ignoreCase) {
        this(ignoreCase, false);
    }

    public LineDiff(boolean ignoreCase, boolean ignoreEmptyLines) {
        this.ignoreCase = ignoreCase;
        this.ignoreEmptyLines = ignoreEmptyLines;
        String value = System.getProperty("nbjunit.linediff.context");
        int number = -1;
        if (value != null) {
            try {
                number = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace(System.err);
            }
        }
        if (number < 0) {
            number = 3;
        }
        this.contextLines = number;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    protected boolean compareLines(CharSequence l1, CharSequence l2) {
        return this.getIgnoreCase() ? ((Object)l1).toString().equalsIgnoreCase(((Object)l2).toString()) : ((Object)l1).toString().contentEquals(l2);
    }

    public int getNContextLines() {
        return this.contextLines;
    }

    public List<String> diffLines(List<? extends CharSequence> ref, List<? extends CharSequence> pass) {
        CharSequence[] refLines;
        CharSequence[] passLines = pass.toArray(new CharSequence[pass.size()]);
        List<Result> results = this.findDifferences(passLines, refLines = ref.toArray(new CharSequence[ref.size()]));
        if (results.isEmpty()) {
            return Collections.emptyList();
        }
        this.merge(results);
        try {
            File tmpDiffFile = File.createTempFile("cnd_diff_lines", ".diff");
            this.printResults(passLines, refLines, results, tmpDiffFile);
            FileObject fo = FileUtil.toFileObject((File)tmpDiffFile);
            ArrayList<String> asLines = new ArrayList<String>(fo.asLines());
            try {
                tmpDiffFile.delete();
            }
            catch (Exception e) {
                // empty catch block
            }
            return asLines;
        }
        catch (IOException e) {
            return Collections.singletonList("ERROR ON DIFF LINES " + e.getLocalizedMessage());
        }
    }

    public boolean diffFiles(String ref, String pass, String diff) throws IOException {
        File fFirst = new File(ref);
        File fSecond = new File(pass);
        File fDiff = null != diff ? new File(diff) : null;
        return this.diffFiles(fFirst, fSecond, fDiff);
    }

    public boolean diffFiles(File refFile, File passFile, File diffFile) throws IOException {
        String line;
        LineNumberReader first = new LineNumberReader(new FileReader(refFile));
        LineNumberReader second = new LineNumberReader(new FileReader(passFile));
        ArrayList<String> tmp = new ArrayList<String>(64);
        while ((line = second.readLine()) != null) {
            if (this.ignoreEmptyLines && line.trim().length() == 0) continue;
            tmp.add(line);
        }
        CharSequence[] passLines = tmp.toArray(new String[tmp.size()]);
        tmp.clear();
        second.close();
        tmp = new ArrayList(64);
        while ((line = first.readLine()) != null) {
            if (this.ignoreEmptyLines && line.trim().length() == 0) continue;
            tmp.add(line);
        }
        CharSequence[] refLines = tmp.toArray(new String[tmp.size()]);
        tmp.clear();
        first.close();
        List<Result> results = this.findDifferences(passLines, refLines);
        if (results.isEmpty()) {
            return false;
        }
        if (diffFile == null) {
            return results.size() > 0;
        }
        this.merge(results);
        this.printResults(passLines, refLines, results, diffFile);
        return results.size() > 0;
    }

    private List<Result> findDifferences(CharSequence[] passLines, CharSequence[] refLines) {
        int stepLeft = 0;
        int stepRight = 0;
        boolean jump = false;
        ArrayList<Result> results = new ArrayList<Result>(64);
        boolean right = true;
        while (stepRight < passLines.length || stepLeft < refLines.length) {
            int found;
            CharSequence v;
            if (right) {
                if (stepRight >= passLines.length) {
                    if (stepLeft >= refLines.length) break;
                    results.add(new Result(stepLeft, refLines.length, stepRight, true));
                    break;
                }
                v = passLines[stepRight];
                found = this.find(v, refLines, stepLeft);
                if (found >= 0) {
                    if (found > stepLeft) {
                        if (!jump && found - stepLeft >= 2) {
                            jump = true;
                            right = false;
                            continue;
                        }
                        results.add(new Result(stepLeft, found, stepRight, true));
                    }
                    stepLeft = found + 1;
                } else {
                    results.add(new Result(stepRight, stepRight + 1, false));
                    right = false;
                }
                ++stepRight;
            } else {
                if (stepLeft >= refLines.length) {
                    if (stepRight >= passLines.length) break;
                    results.add(new Result(stepRight, passLines.length - 1, false));
                    break;
                }
                v = refLines[stepLeft];
                found = this.find(v, passLines, stepRight);
                if (found >= 0) {
                    if (!jump && found - stepRight >= 2) {
                        jump = true;
                        right = true;
                        continue;
                    }
                    if (found > stepRight) {
                        results.add(new Result(stepRight, found, false));
                    }
                    stepRight = found + 1;
                    right = true;
                } else {
                    results.add(new Result(stepLeft, stepLeft + 1, stepRight, true));
                    right = true;
                }
                ++stepLeft;
            }
            jump = false;
        }
        return results;
    }

    private void printResults(CharSequence[] passLines, CharSequence[] refLines, List<Result> results, File diffFile) throws IOException {
        int numLength = refLines.length > passLines.length ? String.valueOf(refLines.length).length() : String.valueOf(passLines.length).length();
        PrintStream ps = new PrintStream(new FileOutputStream(diffFile));
        boolean precontext = false;
        for (int i = 0; i < results.size(); ++i) {
            Result rs = results.get(i);
            if (!precontext) {
                int si = rs.passIndex - this.contextLines;
                if (si < 0) {
                    si = 0;
                }
                for (int j = si; j < rs.passIndex; ++j) {
                    this.printContext(passLines, ps, j, numLength);
                }
            } else {
                precontext = false;
            }
            results.get(i).print(passLines, refLines, ps, numLength);
            int e1 = rs.newLine ? rs.passIndex : rs.end;
            int e2 = e1 + this.contextLines;
            if (i < results.size() - 1 && results.get((int)(i + 1)).passIndex < e2) {
                e2 = results.get((int)(i + 1)).passIndex;
                precontext = true;
            } else if (e2 > passLines.length) {
                e2 = passLines.length;
            }
            for (int j = e1; j < e2; ++j) {
                this.printContext(passLines, ps, j, numLength);
            }
        }
        ps.close();
    }

    private int find(CharSequence value, CharSequence[] lines, int startIndex) {
        for (int i = startIndex; i < lines.length; ++i) {
            if (!this.compareLines(value, lines[i])) continue;
            return i;
        }
        return -1;
    }

    private void merge(List<Result> results) {
        for (int i = 0; i < results.size() - 1; ++i) {
            if (!results.get((int)i).newLine || !results.get((int)(i + 1)).newLine || results.get((int)i).end != results.get((int)(i + 1)).start) continue;
            results.get((int)i).end = results.get((int)(i + 1)).end;
            results.remove(i + 1);
            --i;
        }
    }

    private void printContext(CharSequence[] passLines, PrintStream ps, int lineNumber, int numLength) {
        String num = String.valueOf(lineNumber + 1);
        int rem = numLength + 1 - num.length();
        for (int j = 0; j < rem; ++j) {
            ps.print(' ');
        }
        ps.print(num);
        ps.print("   ");
        ps.println(passLines[lineNumber]);
    }

    static class Result {
        boolean newLine = false;
        int start;
        int end;
        int passIndex;

        public Result(int start, int end, int passIndex, boolean newLine) {
            this.start = start;
            this.end = end;
            this.passIndex = passIndex;
            this.newLine = newLine;
        }

        public Result(int start, int end, boolean newLine) {
            this.passIndex = start;
            this.start = start;
            this.end = end;
            this.newLine = newLine;
        }

        public void print(CharSequence[] passLines, CharSequence[] refLines, PrintStream ps, int numLength) {
            for (int i = this.start; i < this.end; ++i) {
                if (this.newLine) {
                    for (int j = 0; j < numLength + 2; ++j) {
                        ps.print(' ');
                    }
                    ps.print("+ ");
                    ps.println(refLines[i]);
                    continue;
                }
                String num = String.valueOf(i + 1);
                int rem = numLength + 1 - num.length();
                for (int j = 0; j < rem; ++j) {
                    ps.print(' ');
                }
                ps.print(num);
                ps.print(" - ");
                ps.println(passLines[i]);
            }
        }
    }
}

